/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctor.basedata.api.vo.BusinessDoctorPageReqVo;
import com.doctor.basedata.api.vo.DepartmentDetailVo;
import com.doctor.basedata.api.vo.DoctorBasicRespVO;
import com.doctor.basedata.api.vo.ServiceCheckReqVo;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.family.doctor.common.dto.DoctorListForScheduleReqDTO;
import com.ebaiyihui.family.doctor.common.dto.DoctorSchedDTO;
import com.ebaiyihui.family.doctor.common.dto.QueryDoctorsDTO;
import com.ebaiyihui.family.doctor.common.dto.ScheduleForWeekReqDTO;
import com.ebaiyihui.family.doctor.common.dto.SearchDoctorDayScheduleReqDTO;
import com.ebaiyihui.family.doctor.common.vo.DoctorListForScheduleResVo;
import com.ebaiyihui.family.doctor.common.vo.DoctorListVo;
import com.ebaiyihui.family.doctor.common.vo.DoctorSchedVo;
import com.ebaiyihui.family.doctor.common.vo.DoctorScheduleInfoResVo;
import com.ebaiyihui.family.doctor.common.vo.ScheduleForWeekResVo;
import com.ebaiyihui.family.doctor.server.common.enums.SignStatus;
import com.ebaiyihui.family.doctor.server.common.enums.StatusEnum;
import com.ebaiyihui.family.doctor.server.entity.PatientEntity;
import com.ebaiyihui.family.doctor.server.entity.PatientSignEntity;
import com.ebaiyihui.family.doctor.server.entity.ServiceConfigEntity;
import com.ebaiyihui.family.doctor.server.feign.DepartmentFeignClient;
import com.ebaiyihui.family.doctor.server.feign.DoctorInfofeignClient;
import com.ebaiyihui.family.doctor.server.feign.DoctorWorkingServiceClient;
import com.ebaiyihui.family.doctor.server.mapper.PatientMapper;
import com.ebaiyihui.family.doctor.server.mapper.PatientSignMapper;
import com.ebaiyihui.family.doctor.server.mapper.ServiceConfigMapper;
import com.ebaiyihui.family.doctor.server.service.DoctorService;
import com.ebaiyihui.family.doctor.server.service.ScheduleRecordService;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DoctorServiceImpl
implements DoctorService {
    private static final Logger log = LoggerFactory.getLogger(DoctorServiceImpl.class);
    @Autowired
    private PatientSignMapper patientSignMapper;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private ServiceConfigMapper serviceConfigMapper;
    @Autowired
    private ScheduleRecordService scheduleRecordService;
    @Autowired
    private DepartmentFeignClient departmentInfoApi;
    @Autowired
    private DoctorInfofeignClient doctorCilent;
    @Autowired
    private DoctorWorkingServiceClient doctorWorkingServiceClient;

    public BaseResponse<PageResult<DoctorListVo>> getSignedDoctorList(QueryDoctorsDTO reqVo) {
        log.info("\u67e5\u8be2\u533b\u751f\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)reqVo));
        String wOrganId = reqVo.getOrganId().toString();
        QueryWrapper wrapper = new QueryWrapper();
        PatientSignEntity patientSignEntity = new PatientSignEntity();
        patientSignEntity.setPatientId(reqVo.getPatientId());
        patientSignEntity.setOrganId(reqVo.getOrganId());
        patientSignEntity.setSignStatus(SignStatus.SIGNED.getValue());
        patientSignEntity.setPackageOrderId(reqVo.getPackageOrderId());
        QueryWrapper pWrapper = new QueryWrapper();
        PatientEntity patient = new PatientEntity();
        patient.setId(reqVo.getPatientId());
        pWrapper.setEntity((Object)patient);
        PatientEntity patientEntity = (PatientEntity)this.patientMapper.selectOne((Wrapper)pWrapper);
        if (Objects.nonNull(patientEntity)) {
            patientSignEntity.setPatientPhone(patientEntity.getPhone());
        }
        wrapper.setEntity((Object)patientSignEntity);
        wrapper.orderByDesc((Object)"create_time");
        wrapper.last("limit 1");
        PatientSignEntity entity = (PatientSignEntity)this.patientSignMapper.selectOne((Wrapper)wrapper);
        boolean LastSignFlag = false;
        log.info("\u60a3\u8005\u4e0a\u6b21\u7ed1\u5b9a-\u7528\u6765\u5904\u7406\u4e0a\u6b21\u9009\u62e9\u7684\u533b\u751f\uff1aentity{}", (Object)JSON.toJSONString((Object)entity));
        PageResult pageResult = new PageResult();
        List docBaseList = this.getDoctors(reqVo);
        if (CollectionUtils.isEmpty((Collection)docBaseList)) {
            pageResult.setContent(new ArrayList());
            pageResult.setPageNum(reqVo.getPageNum().intValue());
            pageResult.setPageSize(reqVo.getPageSize().intValue());
            return BaseResponse.success((Object)pageResult);
        }
        log.info("\u7528\u4e8e\u5faa\u73af\u7684\u96c6\u5408{}", (Object)JSON.toJSONString((Object)docBaseList));
        List<Object> doctorListVos = new ArrayList<DoctorListVo>();
        for (DoctorBasicRespVO dto : docBaseList) {
            Integer doctorId = dto.getXId().intValue();
            DoctorListVo doctorListVo2 = new DoctorListVo();
            BeanUtils.copyProperties((Object)dto, (Object)doctorListVo2);
            doctorListVo2.setIntroduction(dto.getProfile());
            doctorListVo2.setTitle(dto.getStandardTitle());
            doctorListVo2.setDoctorId(doctorId.toString());
            doctorListVo2.setOrganId(Integer.valueOf(wOrganId));
            doctorListVo2.setDeptId(Integer.valueOf(dto.getDeptId().intValue()));
            doctorListVo2.setPhoneNum(dto.getTelephone());
            doctorListVo2.setLastSign(Integer.valueOf(0));
            if (null != entity && String.valueOf(entity.getDoctorId()).equals(dto.getXId().toString())) {
                log.info("\u8fdb\u5165\u4e0a\u6b21\u9009\u62e9\u533b\u751f\u4fe1\u606f");
                doctorListVo2.setLastSign(Integer.valueOf(1));
                doctorListVos.add(0, doctorListVo2);
                continue;
            }
            doctorListVos.add(doctorListVo2);
        }
        if (Objects.isNull(reqVo.getSignSeqId()) && Objects.nonNull(reqVo.getPackageOrderId())) {
            QueryWrapper psWrapper = new QueryWrapper();
            PatientSignEntity patientSign = new PatientSignEntity();
            patientSign.setPatientId(reqVo.getPatientId());
            patientSign.setStatus(StatusEnum.IN_CONSULTATION.getValue());
            patientSign.setSignStatus(SignStatus.SIGNED.getValue());
            psWrapper.setEntity((Object)patientSign);
            psWrapper.notIn((Object)"package_order_id", new Object[]{reqVo.getPackageOrderId()});
            List patientSignEntities = this.patientSignMapper.selectList((Wrapper)psWrapper);
            log.info("patientSignEntities={}", (Object)patientSignEntities);
            if (!patientSignEntities.isEmpty()) {
                List patientDoctorIds = patientSignEntities.stream().map(PatientSignEntity::getDoctorId).collect(Collectors.toList());
                log.info("patientDoctorIds={}", patientDoctorIds);
                doctorListVos = doctorListVos.stream().filter(doctorListVo -> !patientDoctorIds.contains(Long.valueOf(doctorListVo.getDoctorId()))).collect(Collectors.toList());
            }
        }
        pageResult.setPageNum(reqVo.getPageNum().intValue());
        pageResult.setPageSize(doctorListVos.size());
        pageResult.setContent(doctorListVos);
        return BaseResponse.success((Object)pageResult);
    }

    public BaseResponse<List<DoctorListForScheduleResVo>> getDoctorListForSchedule(DoctorListForScheduleReqDTO req) {
        BusinessDoctorPageReqVo businessDoctorPageReqVo = new BusinessDoctorPageReqVo();
        businessDoctorPageReqVo.setSeq(1);
        businessDoctorPageReqVo.setStatus(1);
        businessDoctorPageReqVo.setOrganId(req.getHospitalId());
        businessDoctorPageReqVo.setPageNum(1);
        businessDoctorPageReqVo.setPageSize(9999);
        businessDoctorPageReqVo.setServiceCode("jtys");
        BaseResponse result = this.doctorWorkingServiceClient.getBusinessDoctorBaseInfoPage(businessDoctorPageReqVo);
        if (!result.isSuccess()) {
            return BaseResponse.error((String)"\u533b\u751f\u67e5\u8be2\u5931\u8d25");
        }
        if (null == result || null == result.getData()) {
            return BaseResponse.error((String)"\u65e0\u5f00\u901a\u5bb6\u5ead\u533b\u751f\u7684\u533b\u751f");
        }
        log.info("\u67e5\u8be2\u5f00\u901a\u5bb6\u5ead\u533b\u751f\u533b\u751f\u5217\u8868{}", (Object)JSON.toJSONString((Object)((PageResult)result.getData()).getContent()));
        ArrayList listForScheduleVos = new ArrayList();
        for (DoctorBasicRespVO doctorBasicRespVO : ((PageResult)result.getData()).getContent()) {
            QueryWrapper queryWrapper = new QueryWrapper();
            ServiceConfigEntity serviceConfig = new ServiceConfigEntity();
            serviceConfig.setServiceCode("jtys");
            serviceConfig.setDeptId(doctorBasicRespVO.getDeptId());
            serviceConfig.setDoctorId(doctorBasicRespVO.getXId().toString());
            serviceConfig.setOrganId(doctorBasicRespVO.getOrganId().toString());
            serviceConfig.setIsSchedule(Integer.valueOf(1));
            serviceConfig.setStatus(Integer.valueOf(1));
            queryWrapper.setEntity((Object)serviceConfig);
            List serviceConfigEntities = this.serviceConfigMapper.selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isEmpty((Collection)serviceConfigEntities)) {
                log.info("\u672a\u67e5\u8be2\u5230\u533b\u751f\u670d\u52a1\u4fe1\u606f,\u6216\u6b64\u533b\u751f\u672a\u5f00\u901a\u6392\u73ed");
                continue;
            }
            serviceConfigEntities.stream().forEach(one -> {
                ServiceCheckReqVo serviceCheckReqVo = new ServiceCheckReqVo();
                serviceCheckReqVo.setDoctorId(doctorBasicRespVO.getXId());
                serviceCheckReqVo.setOrganId(doctorBasicRespVO.getOrganId());
                serviceCheckReqVo.setDeptId(one.getDeptId());
                serviceCheckReqVo.setServiceCode(serviceConfig.getServiceCode());
                BaseResponse response = this.doctorWorkingServiceClient.checkDoctorServiceByCode(serviceCheckReqVo);
                if (!response.isSuccess() || !((Boolean)response.getData()).booleanValue()) {
                    log.info("\u533b\u751f\u8be5\u79d1\u5ba4\u672a\u5f00\u901a\u5bb6\u5ead\u533b\u751f\u670d\u52a1:{}", (Object)one.getDeptId());
                    return;
                }
                if (StringUtils.isEmpty((String)one.getDoctorPortrait()) || StringUtils.isEmpty((String)one.getDoctorProfession())) {
                    ServiceConfigEntity serviceUpdate = new ServiceConfigEntity();
                    serviceUpdate.setDoctorPortrait(doctorBasicRespVO.getPortrait());
                    serviceUpdate.setDoctorProfession(doctorBasicRespVO.getStandardTitle());
                    serviceUpdate.setId(one.getId());
                    this.serviceConfigMapper.updateById((Object)serviceUpdate);
                }
                DoctorListForScheduleResVo doctorForScheduleVo = new DoctorListForScheduleResVo();
                doctorForScheduleVo.setDoctorId(doctorBasicRespVO.getXId().toString());
                doctorForScheduleVo.setDoctorName(doctorBasicRespVO.getDoctorName());
                BaseResponse departmentDetail = this.departmentInfoApi.getDepartmentDetail(Long.valueOf(one.getDeptId()));
                doctorForScheduleVo.setDeptName(((DepartmentDetailVo)departmentDetail.getData()).getDeptName());
                doctorForScheduleVo.setDeptId(one.getDeptId().toString());
                listForScheduleVos.add(doctorForScheduleVo);
            });
        }
        return BaseResponse.success(listForScheduleVos);
    }

    public BaseResponse<DoctorScheduleInfoResVo> searchDoctorDaySchedule(SearchDoctorDayScheduleReqDTO reqDTO) {
        BaseResponse pageResultBaseResponse;
        DoctorScheduleInfoResVo doctorScheduleInfoResVo = new DoctorScheduleInfoResVo();
        doctorScheduleInfoResVo.setScheduleTime(reqDTO.getScheduleTime());
        ScheduleForWeekReqDTO scheduleForWeek = new ScheduleForWeekReqDTO();
        scheduleForWeek.setHospitalId(reqDTO.getHospitalId());
        scheduleForWeek.setServType(reqDTO.getServType());
        scheduleForWeek.setWeek(reqDTO.getWeek());
        if (StringUtils.isNotEmpty((String)reqDTO.getDoctorName())) {
            scheduleForWeek.setDoctorName(reqDTO.getDoctorName());
        }
        if (!(pageResultBaseResponse = this.scheduleRecordService.scheduleForWeekNew(scheduleForWeek)).isSuccess()) {
            return BaseResponse.error((String)"\u5355\u5468\u6392\u73ed\u8c03\u7528\u5931\u8d25");
        }
        List content = (List)pageResultBaseResponse.getData();
        if (CollectionUtils.isEmpty((Collection)content)) {
            return BaseResponse.success();
        }
        if (CollectionUtils.isEmpty(content = content.stream().filter(scheduleForWeekNew -> scheduleForWeekNew.getScheduleTime().compareTo(reqDTO.getScheduleTime()) == 0).collect(Collectors.toList()))) {
            return BaseResponse.success();
        }
        log.info("\u8fc7\u6ee4\u51fa\u5f53\u524d\u9009\u62e9\u65e5\u671f\u7684content\u53ea\u6709\u4e00\u6761{}", (Object)content.toString());
        ArrayList scheduleInfos = new ArrayList();
        ((ScheduleForWeekResVo)content.get(0)).getScheduleInfos().stream().forEach(schedule -> scheduleInfos.add(schedule));
        doctorScheduleInfoResVo.setScheduleInfos(scheduleInfos);
        return BaseResponse.success((Object)doctorScheduleInfoResVo);
    }

    public BaseResponse<DoctorSchedVo> getDoctorSched(DoctorSchedDTO reqVo) {
        DoctorSchedVo doctorSchedVo = new DoctorSchedVo();
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(reqVo.getDoctorId());
        BaseResponse res = this.doctorCilent.queryPersonnelInfo(queryPersonnelInfoReq);
        if (res.isSuccess()) {
            doctorSchedVo.setDoctorId(Long.valueOf(reqVo.getDoctorId()));
            doctorSchedVo.setDoctorName(((PersonnelInfo)res.getData()).getDoctorName());
            doctorSchedVo.setDeptId(Long.valueOf(((PersonnelInfo)res.getData()).getDeptId().intValue()));
            doctorSchedVo.setDeptName(((PersonnelInfo)res.getData()).getDeptName());
            doctorSchedVo.setOrganId(Long.valueOf(((PersonnelInfo)res.getData()).getOrganId().intValue()));
            doctorSchedVo.setOrganName(((PersonnelInfo)res.getData()).getOrganName());
            doctorSchedVo.setDoctorPortrait(((PersonnelInfo)res.getData()).getPortrait());
            doctorSchedVo.setDoctorProfession(((PersonnelInfo)res.getData()).getProfession());
            doctorSchedVo.setDoctorTitle(((PersonnelInfo)res.getData()).getTitle());
            doctorSchedVo.setIntroduction(((PersonnelInfo)res.getData()).getIntroduction());
        }
        return BaseResponse.success((Object)doctorSchedVo);
    }

    private List<DoctorBasicRespVO> getDoctors(QueryDoctorsDTO reqVo) {
        ArrayList<DoctorBasicRespVO> docBaseList = new ArrayList<DoctorBasicRespVO>();
        ArrayList resultData = new ArrayList();
        List depts = reqVo.getDepts();
        if (!CollectionUtils.isEmpty((Collection)depts)) {
            log.info("\u591a\u79d1\u5ba4\u663e\u793a");
            depts.stream().forEach(i -> {
                BusinessDoctorPageReqVo businessDoctorPageReqVo = new BusinessDoctorPageReqVo();
                reqVo.setSeq(Integer.valueOf(1));
                reqVo.setStatus(Integer.valueOf(1));
                BeanUtils.copyProperties((Object)reqVo, (Object)businessDoctorPageReqVo);
                businessDoctorPageReqVo.setOrganDeptId(i);
                businessDoctorPageReqVo.setServiceCode(reqVo.getServiceCodes());
                BaseResponse doctors = this.doctorWorkingServiceClient.getBusinessDoctorBaseInfoPage(businessDoctorPageReqVo);
                if (!CollectionUtils.isEmpty((Collection)((PageResult)doctors.getData()).getContent())) {
                    List vos = ((PageResult)doctors.getData()).getContent();
                    resultData.addAll(vos);
                }
            });
        } else {
            BusinessDoctorPageReqVo businessDoctorPageReqVo = new BusinessDoctorPageReqVo();
            reqVo.setSeq(Integer.valueOf(1));
            reqVo.setStatus(Integer.valueOf(1));
            BeanUtils.copyProperties((Object)reqVo, (Object)businessDoctorPageReqVo);
            businessDoctorPageReqVo.setServiceCode(reqVo.getServiceCodes());
            log.info("\u533b\u751f\u6570\u636e\u5165\u53c2" + JSON.toJSONString((Object)businessDoctorPageReqVo));
            BaseResponse businessDoctorPage = this.doctorWorkingServiceClient.getBusinessDoctorBaseInfoPage(businessDoctorPageReqVo);
            log.info("\u533b\u751f\u6570\u636e\u51fa\u53c2" + JSON.toJSONString((Object)businessDoctorPage.getData()));
            if (null == businessDoctorPage.getData()) {
                return new ArrayList<DoctorBasicRespVO>();
            }
            resultData.addAll(((PageResult)businessDoctorPage.getData()).getContent());
            if (CollectionUtils.isEmpty(resultData)) {
                return new ArrayList<DoctorBasicRespVO>();
            }
            List collect = resultData.stream().filter(vo -> "5".equals(vo.getAduitStatus())).collect(Collectors.toList());
            docBaseList.addAll(collect);
        }
        return docBaseList;
    }
}

