/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.card.common.CardServiceApi;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.card.common.vo.RegisterCardReqVO;
import com.ebaiyihui.family.doctor.common.bo.MobileBenefitRes;
import com.ebaiyihui.family.doctor.common.bo.Result;
import com.ebaiyihui.family.doctor.common.dto.IMUpdateOnlineStatusReqDTO;
import com.ebaiyihui.family.doctor.common.dto.MobileBenefitPackageDTO;
import com.ebaiyihui.family.doctor.common.vo.RegisterPatientVo;
import com.ebaiyihui.family.doctor.server.common.constants.CommonConstants;
import com.ebaiyihui.family.doctor.server.common.enums.SignStatus;
import com.ebaiyihui.family.doctor.server.common.enums.StatusEnum;
import com.ebaiyihui.family.doctor.server.entity.MobileBenefitPackageEntity;
import com.ebaiyihui.family.doctor.server.entity.PatientEntity;
import com.ebaiyihui.family.doctor.server.entity.PatientSignEntity;
import com.ebaiyihui.family.doctor.server.mapper.MobileBenefitPackageMapper;
import com.ebaiyihui.family.doctor.server.mapper.PatientMapper;
import com.ebaiyihui.family.doctor.server.mapper.PatientSignMapper;
import com.ebaiyihui.family.doctor.server.service.MobileBenefitPackageService;
import com.ebaiyihui.family.doctor.server.util.DESUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class MobileBenefitPackageServiceImpl
implements MobileBenefitPackageService {
    private static final Logger log = LoggerFactory.getLogger(MobileBenefitPackageServiceImpl.class);
    @Autowired
    private CardServiceApi cardServiceFeignClient;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private PatientSignMapper patientSignMapper;
    @Autowired
    private MobileBenefitPackageMapper mobileBenefitPackageMapper;

    public BaseResponse<RegisterPatientVo> register(String token) {
        token = token.replace(" ", "+");
        Map map = (Map)JSONObject.parseObject((String)DESUtils.decrypt((String)token, (String)"zk26rdgfsg23j42fewegfr234h23423g44323"), Map.class);
        log.info("\u89e3\u6790token\u7ed3\u679c\uff1a{}", (Object)map);
        RegisterPatientVo registerPatientVo = new RegisterPatientVo();
        MobileBenefitPackageEntity entity = new MobileBenefitPackageEntity();
        if (Objects.nonNull(map.get("activateOrderId")) && ObjectUtils.isEmpty((Object)(entity = this.mobileBenefitPackageMapper.queryByPhone((String)map.get("mobile"), (String)map.get("activateOrderId"), null)))) {
            return BaseResponse.error((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u6709\u5173\u6743\u76ca");
        }
        RegisterCardReqVO registerCardReqVO = new RegisterCardReqVO();
        registerCardReqVO.setAppCode("NCZK");
        registerCardReqVO.setChannelCode("PATIENT_WX");
        registerCardReqVO.setChannelName("PATIENT_WX");
        registerCardReqVO.setPatientName((String)map.get("patientName"));
        registerCardReqVO.setCredNo((String)map.get("card_no"));
        registerCardReqVO.setCredTypeCode("01");
        registerCardReqVO.setCredTypeName("\u5c45\u6c11\u8eab\u4efd\u8bc1");
        registerCardReqVO.setCardTypeCode("1703");
        registerCardReqVO.setCardTypeName("\u865a\u62df\u5c31\u8bca\u5361");
        registerCardReqVO.setOrganCode("130188");
        registerCardReqVO.setOrganName("\u5357\u660c\u4f17\u5eb7\u533b\u9662");
        registerCardReqVO.setTel((String)map.get("mobile"));
        log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u8bf7\u6c42:{}", (Object)registerCardReqVO);
        BaseResponse response = this.cardServiceFeignClient.registerOrBindCard(registerCardReqVO);
        log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u7ed3\u679c:{}", (Object)response);
        if (!response.isSuccess() || StringUtils.isEmpty((Object)response)) {
            return BaseResponse.error((String)"\u6ce8\u518c\u5c31\u8bca\u5361\u5931\u8d25");
        }
        CardDetailsInfoRespVO data = (CardDetailsInfoRespVO)response.getData();
        registerPatientVo.setPatientInfo(data);
        registerPatientVo.setActivateOrderId((String)map.get("activateOrderId"));
        if (Objects.nonNull(map.get("admId"))) {
            registerPatientVo.setAdmId((String)map.get("admId"));
            QueryWrapper psWrapper = new QueryWrapper();
            PatientSignEntity patientSign = new PatientSignEntity();
            patientSign.setAdmId((String)map.get("admId"));
            psWrapper.setEntity((Object)patientSign);
            PatientSignEntity patientSignEntity = (PatientSignEntity)this.patientSignMapper.selectOne((Wrapper)psWrapper);
            if (Objects.nonNull(patientSignEntity)) {
                entity.setDoctorId(String.valueOf(patientSignEntity.getDoctorId()));
                this.mobileBenefitPackageMapper.updateDoctorId(entity);
            }
        }
        if (Objects.nonNull(map.get("scheduleFlag"))) {
            registerPatientVo.setScheduleFlag(Integer.valueOf((String)map.get("scheduleFlag")));
        }
        if (Objects.nonNull(map.get("msgPushType"))) {
            registerPatientVo.setMsgPushType(Integer.valueOf((String)map.get("msgPushType")));
        }
        if (Objects.nonNull(map.get("abnormalId"))) {
            registerPatientVo.setAbnormalId((String)map.get("abnormalId"));
        }
        if (Objects.nonNull(map.get("intention"))) {
            registerPatientVo.setIntention((String)map.get("intention"));
        }
        if (Objects.nonNull(map.get("doctorId"))) {
            registerPatientVo.setDoctorId((String)map.get("doctorId"));
        }
        if (Objects.nonNull(map.get("thirdId"))) {
            registerPatientVo.setThirdId((String)map.get("thirdId"));
        }
        if (Objects.nonNull(map.get("signSeqId"))) {
            registerPatientVo.setSignSeqId((String)map.get("signSeqId"));
            PatientSignEntity patientSignEntity = (PatientSignEntity)this.patientSignMapper.selectById((Serializable)Long.valueOf((String)map.get("signSeqId")));
            registerPatientVo.setAdmId(patientSignEntity.getAdmId());
            if (StatusEnum.FINISH_APPLY.getValue().equals(patientSignEntity.getStatus()) && SignStatus.CANCEL.getValue().equals(patientSignEntity.getSignStatus())) {
                QueryWrapper psWrapper = new QueryWrapper();
                PatientSignEntity patientSign = new PatientSignEntity();
                patientSign.setSignId(patientSignEntity.getId());
                patientSign.setStatus(StatusEnum.IN_CONSULTATION.getValue());
                patientSign.setSignStatus(SignStatus.SIGNED.getValue());
                psWrapper.setEntity((Object)patientSign);
                patientSignEntity = (PatientSignEntity)this.patientSignMapper.selectOne((Wrapper)psWrapper);
                registerPatientVo.setAdmId(patientSignEntity.getAdmId());
            }
            if (Objects.nonNull(patientSignEntity)) {
                entity.setDoctorId(String.valueOf(patientSignEntity.getDoctorId()));
                this.mobileBenefitPackageMapper.updateDoctorId(entity);
            }
        }
        String patientId = (String)map.get("patient_id");
        if (Objects.nonNull(map.get("activateOrderId")) && !StringUtils.isEmpty((Object)patientId)) {
            QueryWrapper wrapper = new QueryWrapper();
            PatientEntity patient = new PatientEntity();
            patient.setId(data.getPatientId());
            wrapper.setEntity((Object)patient);
            PatientEntity patientEntity = (PatientEntity)this.patientMapper.selectOne((Wrapper)wrapper);
            if (Objects.isNull(patientEntity)) {
                patientEntity = new PatientEntity();
                patientEntity.setId(data.getPatientId());
                patientEntity.setPatientName(data.getPatientName());
                patientEntity.setPhone(data.getTel());
                patientEntity.setPatientType(CommonConstants.PATIENT_TYPE);
                patientEntity.setGender(Integer.valueOf(data.getGender().shortValue()));
                patientEntity.setBirthDates(data.getBirth());
                patientEntity.setCredNo(data.getCredNo());
                patientEntity.setUserId(patientId);
                log.info("\u6570\u636e\u5e93\u4e0d\u5b58\u5728\u6dfb\u52a0\u60a3\u8005: {}", (Object)JSON.toJSONString((Object)patientEntity));
                this.patientMapper.insert((Object)patientEntity);
            } else if (!((String)map.get("mobile")).equals(patientEntity.getPhone()) || !patientId.equals(patientEntity.getUserId())) {
                patientEntity.setPhone((String)map.get("mobile"));
                patientEntity.setUserId(patientId);
                this.patientMapper.updateById((Object)patientEntity);
            }
            entity.setUserId(patientId);
            log.info("MobileBenefitPackageEntity={}", (Object)entity);
            this.mobileBenefitPackageMapper.update(entity);
        }
        registerPatientVo.setUserId(entity.getUserId());
        return BaseResponse.success((Object)registerPatientVo);
    }

    public Result<MobileBenefitRes> addBenefitPackage(List<MobileBenefitPackageDTO> vos) {
        log.info("\u63a8\u9001\u8ba2\u5355\u4fe1\u606f:{}", vos);
        try {
            vos.forEach(vo -> {
                MobileBenefitPackageEntity entity = new MobileBenefitPackageEntity();
                BeanUtils.copyProperties((Object)vo, (Object)entity);
                this.mobileBenefitPackageMapper.insert(entity);
            });
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u6743\u76ca\u5305\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            return Result.error((Object)this.failed());
        }
        return Result.success((Object)this.success());
    }

    public BaseResponse<String> updateOnlineStatus(IMUpdateOnlineStatusReqDTO reqDTO) {
        QueryWrapper wrapper = new QueryWrapper();
        PatientEntity patient = new PatientEntity();
        patient.setPhone(reqDTO.getPhone());
        patient.setUserId(reqDTO.getPatientUserId());
        wrapper.setEntity((Object)patient);
        PatientEntity patientEntity = (PatientEntity)this.patientMapper.selectOne((Wrapper)wrapper);
        if (Objects.nonNull(patientEntity)) {
            patientEntity.setOnOfflineStatus(reqDTO.getStatus());
            patientEntity.setOffLineTime(reqDTO.getOffLineTime());
            this.patientMapper.updateById((Object)patientEntity);
        }
        return BaseResponse.success();
    }

    private MobileBenefitRes success() {
        MobileBenefitRes resp = new MobileBenefitRes();
        resp.setOrderStatus("OOS");
        resp.setOrderDesc("\u6210\u529f");
        return resp;
    }

    private MobileBenefitRes failed() {
        MobileBenefitRes resp = new MobileBenefitRes();
        resp.setOrderStatus("OOF");
        resp.setOrderDesc("\u5931\u8d25");
        return resp;
    }
}

