/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ebaiyihui.family.doctor.common.dto.InsertPatientMedicalRecordDTO;
import com.ebaiyihui.family.doctor.common.dto.InvalidMedicalRecordDTO;
import com.ebaiyihui.family.doctor.common.dto.UpdatePatientMedicalRecordDTO;
import com.ebaiyihui.family.doctor.common.vo.InsertPatientMedicalRecordVO;
import com.ebaiyihui.family.doctor.common.vo.PatientMedicalRecordVO;
import com.ebaiyihui.family.doctor.server.entity.PatientEntity;
import com.ebaiyihui.family.doctor.server.entity.PatientMedicalRecordEntity;
import com.ebaiyihui.family.doctor.server.entity.PatientSignEntity;
import com.ebaiyihui.family.doctor.server.exception.BusinessException;
import com.ebaiyihui.family.doctor.server.mapper.PatientMapper;
import com.ebaiyihui.family.doctor.server.mapper.PatientMedicalRecordMapper;
import com.ebaiyihui.family.doctor.server.mapper.PatientSignMapper;
import com.ebaiyihui.family.doctor.server.service.PatientMedicalRecordService;
import com.ebaiyihui.family.doctor.server.util.UUIDUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PatientMedicalRecordServiceImpl
implements PatientMedicalRecordService {
    private static final Logger log = LoggerFactory.getLogger(PatientMedicalRecordServiceImpl.class);
    @Autowired
    private PatientMedicalRecordMapper patientMedicalRecordMapper;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private PatientSignMapper patientSignMapper;

    public BaseResponse<InsertPatientMedicalRecordVO> insertPatientMedicalRecord(InsertPatientMedicalRecordDTO dto) {
        log.info("\u533b\u751f\u5f00\u5177\u590d\u8bca\u75c5\u5386\u5165\u53c2:{}", (Object)dto.toString());
        PatientMedicalRecordEntity entity = new PatientMedicalRecordEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        entity.setId(UUIDUtil.getUUID());
        entity.setRecordStatus(Integer.valueOf(1));
        this.patientMedicalRecordMapper.insert((Object)entity);
        InsertPatientMedicalRecordVO vo = new InsertPatientMedicalRecordVO();
        vo.setRecordId(String.valueOf(entity.getId()));
        return BaseResponse.success((Object)vo);
    }

    public BaseResponse<InsertPatientMedicalRecordVO> updatePatientMedicalRecord(UpdatePatientMedicalRecordDTO dto) {
        log.info("\u533b\u751f\u4fee\u6539\u590d\u8bca\u75c5\u5386\u5165\u53c2:{}", (Object)dto.toString());
        if (StringUtils.isEmpty((CharSequence)dto.getId())) {
            throw new BusinessException("\u4fee\u6539xid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PatientMedicalRecordEntity recordEntity = this.patientMedicalRecordMapper.getByIdAndStatus(dto.getId(), 1);
        if (ObjectUtil.isNull((Object)recordEntity)) {
            throw new BusinessException("\u672a\u627e\u5230\u8be5\u75c5\u5386\uff0c\u6216\u75c5\u4f8b\u5931\u6548");
        }
        PatientMedicalRecordEntity entity = new PatientMedicalRecordEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        this.patientMedicalRecordMapper.updateById((Object)entity);
        InsertPatientMedicalRecordVO vo = new InsertPatientMedicalRecordVO();
        vo.setRecordId(String.valueOf(entity.getId()));
        return BaseResponse.success((Object)vo);
    }

    public BaseResponse<Objects> invalidMedicalRecord(InvalidMedicalRecordDTO dto) {
        log.info("\u5f00\u5177\u5904\u65b9\u5931\u6548\u75c5\u5386\u5165\u53c2:{}", (Object)dto.toString());
        if (StringUtils.isEmpty((CharSequence)dto.getId())) {
            throw new BusinessException("\u75c5\u5386id\u4e0d\u80fd\u672a\u7a7a");
        }
        PatientMedicalRecordEntity recordEntity = this.patientMedicalRecordMapper.getByIdAndStatus(dto.getId(), 1);
        if (ObjectUtil.isNull((Object)recordEntity)) {
            throw new BusinessException("\u672a\u627e\u5230\u8be5\u75c5\u5386\uff0c\u6216\u75c5\u4f8b\u5931\u6548");
        }
        PatientMedicalRecordEntity entity = new PatientMedicalRecordEntity();
        entity.setId(dto.getId());
        entity.setRecordStatus(Integer.valueOf(0));
        this.patientMedicalRecordMapper.updateById((Object)entity);
        return BaseResponse.success();
    }

    public BaseResponse<PatientMedicalRecordVO> detailMedicalRecord(InvalidMedicalRecordDTO dto) {
        PatientSignEntity patientSignEntity;
        log.info("\u75c5\u5386\u8be6\u60c5\u5165\u53c2:{}", (Object)dto.toString());
        if (StringUtils.isEmpty((CharSequence)dto.getId())) {
            throw new BusinessException("\u75c5\u5386id\u4e0d\u80fd\u672a\u7a7a");
        }
        PatientMedicalRecordEntity entity = this.patientMedicalRecordMapper.getByIdAndStatus(dto.getId(), 1);
        if (ObjectUtil.isNull((Object)entity)) {
            throw new BusinessException("\u672a\u627e\u5230\u8be5\u75c5\u5386\uff0c\u6216\u75c5\u4f8b\u5931\u6548");
        }
        PatientMedicalRecordVO vo = new PatientMedicalRecordVO();
        BeanUtils.copyProperties((Object)entity, (Object)vo);
        PatientMedicalRecordVO.InfoVo infoVo = new PatientMedicalRecordVO.InfoVo();
        PatientEntity patientEntity = (PatientEntity)this.patientMapper.selectById((Serializable)((Object)entity.getPatientId()));
        if (ObjectUtil.isNotNull((Object)patientEntity)) {
            infoVo.setPatientName(patientEntity.getPatientName());
            infoVo.setPatientGender(String.valueOf(patientEntity.getGender()));
            infoVo.setPatientNo(patientEntity.getCredNo());
            infoVo.setPatientPhone(patientEntity.getPhone());
            infoVo.setPatientUserId(patientEntity.getUserId());
            infoVo.setPatientCredNo(patientEntity.getCredNo());
        }
        if (ObjectUtil.isNotNull((Object)(patientSignEntity = this.patientSignMapper.queryByAdmId(entity.getAdmId())))) {
            infoVo.setDeptId(String.valueOf(patientSignEntity.getDeptId()));
            infoVo.setDeptName(patientSignEntity.getDeptName());
            infoVo.setDoctorId(String.valueOf(patientSignEntity.getDoctorId()));
            infoVo.setDoctorName(patientSignEntity.getDoctorName());
        }
        vo.setInfoVo(infoVo);
        return BaseResponse.success((Object)vo);
    }
}

