/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.family.doctor.common.bo.Result;
import com.ebaiyihui.family.doctor.common.dto.ImAccountReqDTO;
import com.ebaiyihui.family.doctor.common.dto.ImInfoDetailDocReqDTO;
import com.ebaiyihui.family.doctor.common.dto.ImInfoListDocReqDTO;
import com.ebaiyihui.family.doctor.common.dto.MasterUrlDTO;
import com.ebaiyihui.family.doctor.common.dto.UserInfoDTO;
import com.ebaiyihui.family.doctor.common.vo.IMMsgResultVo;
import com.ebaiyihui.family.doctor.common.vo.ImAccountVo;
import com.ebaiyihui.family.doctor.common.vo.ImInfoDetailDocResVo;
import com.ebaiyihui.family.doctor.common.vo.ImInfoListResVo;
import com.ebaiyihui.family.doctor.common.vo.ImInfoResVo;
import com.ebaiyihui.family.doctor.common.vo.PatientInfoVo;
import com.ebaiyihui.family.doctor.server.common.enums.SignStatus;
import com.ebaiyihui.family.doctor.server.common.enums.StatusEnum;
import com.ebaiyihui.family.doctor.server.entity.PatientEntity;
import com.ebaiyihui.family.doctor.server.entity.PatientSignEntity;
import com.ebaiyihui.family.doctor.server.feign.DoctorInfofeignClient;
import com.ebaiyihui.family.doctor.server.feign.IMSyncMsgClient;
import com.ebaiyihui.family.doctor.server.feign.ImApiFeignClient;
import com.ebaiyihui.family.doctor.server.mapper.PatientMapper;
import com.ebaiyihui.family.doctor.server.mapper.PatientSignMapper;
import com.ebaiyihui.family.doctor.server.service.ImChatTemplate;
import com.ebaiyihui.family.doctor.server.service.PatientSignService;
import com.ebaiyihui.family.doctor.server.util.IDCardUtil;
import com.ebaiyihui.family.doctor.server.util.PageUtil;
import com.ebaiyihui.family.doctor.server.util.ThirdOrderPushUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.imforward.client.vo.IMQueryMsgReqVO;
import com.ebaiyihui.imforward.client.vo.IMQueryTargetSdkAccountRspVO;
import com.ebaiyihui.imforward.client.vo.IMQueryUserLoginReqVO;
import com.ebaiyihui.imforward.client.vo.IMQueryUserLoginRspVO;
import com.ebaiyihui.imforward.client.vo.IMSingleMsgResultVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PatientSignServiceImpl
implements PatientSignService {
    private static final Logger log = LoggerFactory.getLogger(PatientSignServiceImpl.class);
    @Autowired
    private IMSyncMsgClient imSyncMsgClient;
    @Autowired
    private ImApiFeignClient imApiFeignClient;
    @Autowired
    private DoctorInfofeignClient doctorCilent;
    @Autowired
    private PatientSignMapper patientSignMapper;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private ImChatTemplate imChatTemplate;
    @Autowired
    private ThirdOrderPushUtil thirdOrderPushUtil;

    public BaseResponse<List<IMSingleMsgResultVO>> getAllMsgContent(IMQueryMsgReqVO reqVO) {
        log.info("\u540c\u6b65\u4f1a\u8bdd\u6d88\u606f\u5165\u53c2" + JSON.toJSONString((Object)reqVO));
        BaseResponse listBaseResponse = this.imSyncMsgClient.queryImMsg(reqVO);
        log.info("\u540c\u6b65\u4f1a\u8bdd\u6d88\u606f\u51fa\u53c2" + JSON.toJSONString((Object)listBaseResponse));
        if (!listBaseResponse.isSuccess()) {
            log.info("imSyncMsgClient.queryImMsg: " + listBaseResponse.toString());
            return BaseResponse.error((String)listBaseResponse.getMsg());
        }
        if (listBaseResponse.getData() == null) {
            return BaseResponse.success(new ArrayList());
        }
        List imMsgResultVOList = (List)listBaseResponse.getData();
        for (IMSingleMsgResultVO imSingleMsgResultVO : imMsgResultVOList) {
            try {
                JSONObject jsonObject = JSONObject.parseObject((String)imSingleMsgResultVO.getMsgContent());
                if (jsonObject.get((Object)"msgId") == null || !StringUtils.isNotEmpty((String)jsonObject.get((Object)"msgId").toString())) continue;
                String msgId = jsonObject.get((Object)"msgId").toString();
                imSingleMsgResultVO.setMsgId(msgId);
            }
            catch (Exception e) {}
        }
        log.info("\u67e5\u8be2\u5230\u7ed3\u679c\u4e3a:{}" + imMsgResultVOList.toString());
        return BaseResponse.success((Object)imMsgResultVOList);
    }

    public BaseResponse<ImInfoResVo> queryImInfo(String admId) {
        Result upResult;
        QueryWrapper wrapper = new QueryWrapper();
        PatientSignEntity patientSign = new PatientSignEntity();
        patientSign.setAdmId(admId);
        wrapper.setEntity((Object)patientSign);
        PatientSignEntity patientSignEntity = (PatientSignEntity)this.patientSignMapper.selectOne((Wrapper)wrapper);
        IMQueryTargetSdkAccountRspVO docImAccount = this.imChatTemplate.queryImAccount(admId, "EHOS_DOCTOR", String.valueOf(patientSignEntity.getDoctorId()));
        IMQueryTargetSdkAccountRspVO patImAccount = this.imChatTemplate.queryImAccount(admId, "EHOS_PATIENT", String.valueOf(patientSignEntity.getDoctorId()));
        IMQueryUserLoginReqVO reqVO = new IMQueryUserLoginReqVO();
        reqVO.setAppCode("EHOS_PATIENT");
        reqVO.setUserId(patientSignEntity.getPatientUserId());
        BaseResponse imSysResult = this.imApiFeignClient.queryUserLogin(reqVO);
        log.info("\u83b7\u53d6IM\u767b\u5f55\u4fe1\u606f:{}", (Object)imSysResult);
        IMQueryMsgReqVO imQueryMsgReqVO = new IMQueryMsgReqVO();
        imQueryMsgReqVO.setAppCode("EHOS_PATIENT");
        imQueryMsgReqVO.setUserId(patientSignEntity.getPatientUserId());
        imQueryMsgReqVO.setBusinessCode("jtys");
        imQueryMsgReqVO.setMsgType("1");
        imQueryMsgReqVO.setPageSize(Integer.valueOf(999));
        imQueryMsgReqVO.setSortOrder("ASC");
        ImInfoResVo resVo = ImInfoResVo.builder().docImAccount(docImAccount.getSdkAccount()).patImAccount(patImAccount.getSdkAccount()).roomNum(Long.valueOf(docImAccount.getRoomNum())).sig(((IMQueryUserLoginRspVO)imSysResult.getData()).getSig()).doctorName(patientSignEntity.getDoctorName()).build();
        resVo.setPatientName(patientSignEntity.getPatientName());
        resVo.setPatientPortrait("");
        UserInfoDTO userInfoDTO = new UserInfoDTO();
        userInfoDTO.setPhone(patientSignEntity.getPatientPhone());
        String userPicResult = this.thirdOrderPushUtil.getUserPic(userInfoDTO);
        if (StringUtils.isNotEmpty((String)userPicResult) && (upResult = (Result)JSON.parseObject((String)userPicResult, Result.class)).isSuccess()) {
            resVo.setPatientPortrait((String)upResult.getData());
        }
        resVo.setSignSeqId(String.valueOf(patientSignEntity.getId()));
        resVo.setDoctorId(patientSignEntity.getDoctorId());
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(String.valueOf(patientSignEntity.getDoctorId()));
        BaseResponse res = this.doctorCilent.queryPersonnelInfo(queryPersonnelInfoReq);
        if (res.isSuccess()) {
            resVo.setDoctorPortrait(((PersonnelInfo)res.getData()).getPortrait());
            resVo.setDeptId(String.valueOf(((PersonnelInfo)res.getData()).getDeptId()));
        }
        ArrayList<String> appointmentId = new ArrayList<String>();
        appointmentId.add(admId);
        imQueryMsgReqVO.setAppointmentId(appointmentId);
        BaseResponse allMsgContent = this.getAllMsgContent(imQueryMsgReqVO);
        if (allMsgContent.isSuccess() && Objects.nonNull(allMsgContent.getData())) {
            ArrayList imMsgResultVos = new ArrayList();
            List msgResultVOS = (List)allMsgContent.getData();
            msgResultVOS.forEach(msgResultVO -> {
                IMMsgResultVo imMsgResultVo = new IMMsgResultVo();
                BeanUtils.copyProperties((Object)msgResultVO, (Object)imMsgResultVo);
                imMsgResultVos.add(imMsgResultVo);
            });
            resVo.setIMMsgVo(imMsgResultVos);
        }
        return BaseResponse.success((Object)resVo);
    }

    public BaseResponse<PageUtil<ImInfoListResVo>> queryImInfoList(ImInfoListDocReqDTO param) {
        param.setPageNum(Integer.valueOf((param.getPageNum() - 1) * param.getPageSize()));
        List records = this.patientSignMapper.queryImInfoList(param);
        List<Object> resVo = new ArrayList();
        for (ImInfoListResVo imInfoListResVo : records) {
            Integer age = IDCardUtil.getAge((String)imInfoListResVo.getCredNo());
            Integer gender = IDCardUtil.getGenderForInteger((String)imInfoListResVo.getCredNo());
            imInfoListResVo.setAge(age);
            imInfoListResVo.setGender(gender);
            String statusDesc = StatusEnum.getDesc((Integer)imInfoListResVo.getStatus());
            imInfoListResVo.setStatusDesc(statusDesc);
            ArrayList<String> admIds = new ArrayList<String>();
            admIds.add(imInfoListResVo.getAdmId());
            imInfoListResVo.setAdmIds(admIds);
            imInfoListResVo.setStatus(imInfoListResVo.getStatus());
            resVo.add(imInfoListResVo);
        }
        resVo = resVo.stream().sorted(Comparator.comparing(ImInfoListResVo::getUpdateTime)).collect(Collectors.toList());
        PageUtil pageUtil = new PageUtil();
        pageUtil.setList(resVo);
        return BaseResponse.success((Object)pageUtil);
    }

    public BaseResponse<ImInfoDetailDocResVo> queryImInfoDetail(ImInfoDetailDocReqDTO param) {
        Result upResult;
        ImInfoDetailDocResVo resVo = new ImInfoDetailDocResVo();
        QueryWrapper psWrapper = new QueryWrapper();
        PatientSignEntity patientSign = new PatientSignEntity();
        patientSign.setAdmId(param.getAdmissionId());
        psWrapper.setEntity((Object)patientSign);
        PatientSignEntity patientSignEntity = (PatientSignEntity)this.patientSignMapper.selectOne((Wrapper)psWrapper);
        if (Objects.isNull(patientSignEntity) || Objects.isNull(patientSignEntity)) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u7b7e\u7ea6\u533b\u751f\u4fe1\u606f");
        }
        resVo.setDoctorId(String.valueOf(patientSignEntity.getDoctorId()));
        resVo.setAdmId(patientSignEntity.getAdmId());
        resVo.setStatus(patientSignEntity.getStatus());
        resVo.setDeptId(patientSignEntity.getDeptId().toString());
        resVo.setDeptName(patientSignEntity.getDeptName());
        resVo.setSignEndTime(patientSignEntity.getSignEndTime());
        PatientEntity patientEntity = (PatientEntity)this.patientMapper.selectById((Serializable)((Object)patientSignEntity.getPatientId()));
        PatientInfoVo patientInfoVo = new PatientInfoVo();
        patientInfoVo.setPatientName(patientEntity.getPatientName());
        patientInfoVo.setPatientId(patientEntity.getId());
        patientInfoVo.setGender(IDCardUtil.getGenderForInteger((String)patientEntity.getCredNo()));
        patientInfoVo.setAge(IDCardUtil.getAge((String)patientEntity.getCredNo()));
        patientInfoVo.setCredNo(patientEntity.getCredNo());
        patientInfoVo.setPatientUserId(patientSignEntity.getPatientUserId());
        patientInfoVo.setPortrait("");
        UserInfoDTO userInfoDTO = new UserInfoDTO();
        userInfoDTO.setPhone(patientSignEntity.getPatientPhone());
        String userPicResult = this.thirdOrderPushUtil.getUserPic(userInfoDTO);
        if (StringUtils.isNotEmpty((String)userPicResult) && (upResult = (Result)JSON.parseObject((String)userPicResult, Result.class)).isSuccess()) {
            patientInfoVo.setPortrait((String)upResult.getData());
        }
        resVo.setPatientInfo(patientInfoVo);
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(String.valueOf(patientSignEntity.getDoctorId()));
        BaseResponse res = this.doctorCilent.queryPersonnelInfo(queryPersonnelInfoReq);
        if (null != res && res.isSuccess()) {
            resVo.setDoctorName(((PersonnelInfo)res.getData()).getDoctorName());
            resVo.setDoctorPortrait(((PersonnelInfo)res.getData()).getPortrait());
        }
        return BaseResponse.success((Object)resVo);
    }

    public BaseResponse<ImAccountVo> queryImAccount(ImAccountReqDTO param) {
        if ("EHOS_DOCTOR".equals(param.getImAppCode())) {
            param.setImAppCode("EHOS_PATIENT");
        } else if ("EHOS_PATIENT".equals(param.getImAppCode())) {
            param.setImAppCode("EHOS_DOCTOR");
        }
        String admissionId = param.getAdmissionId();
        QueryWrapper psWrapper = new QueryWrapper();
        PatientSignEntity patientSign = new PatientSignEntity();
        patientSign.setAdmId(param.getAdmissionId());
        psWrapper.setEntity((Object)patientSign);
        PatientSignEntity patientSignEntity = (PatientSignEntity)this.patientSignMapper.selectOne((Wrapper)psWrapper);
        if (StringUtils.isEmpty((String)param.getDoctorId())) {
            param.setDoctorId(String.valueOf(patientSignEntity.getDoctorId()));
        }
        return BaseResponse.success((Object)this.getImAccounts(patientSignEntity, admissionId, param.getImAppCode(), param.getDoctorId()));
    }

    public BaseResponse<IMQueryUserLoginRspVO> querySdkLogin(IMQueryUserLoginReqVO reqVO) {
        BaseResponse imSysResult = this.imApiFeignClient.queryUserLogin(reqVO);
        if (imSysResult == null) {
            return BaseResponse.error((String)imSysResult.getMsg());
        }
        if ("0".equals(imSysResult.getCode())) {
            return BaseResponse.error((String)imSysResult.getMsg());
        }
        return BaseResponse.success((Object)imSysResult.getData());
    }

    public List<PatientSignEntity> selectList(PatientSignEntity patientSignEntity) {
        QueryWrapper listWrapper = new QueryWrapper();
        patientSignEntity.setStatus(StatusEnum.IN_CONSULTATION.getValue());
        patientSignEntity.setSignStatus(SignStatus.SIGNED.getValue());
        listWrapper.setEntity((Object)patientSignEntity);
        List patientSignEntities = this.patientSignMapper.selectList((Wrapper)listWrapper);
        return patientSignEntities;
    }

    public List<PatientSignEntity> getListByPhone(String phone, String activateOrderId) {
        QueryWrapper psWrapper = new QueryWrapper();
        PatientSignEntity patientSign = new PatientSignEntity();
        patientSign.setPatientPhone(phone);
        patientSign.setPackageOrderId(activateOrderId);
        psWrapper.setEntity((Object)patientSign);
        List pse = this.patientSignMapper.selectList((Wrapper)psWrapper);
        return pse;
    }

    public int updateById(PatientSignEntity patientSignEntity) {
        return this.patientSignMapper.updateById((Object)patientSignEntity);
    }

    public BaseResponse<String> queryMasterUrl(MasterUrlDTO reqVo) {
        Result muResult;
        String resulStr = "";
        String result = this.thirdOrderPushUtil.getMasterUrl(reqVo);
        if (StringUtils.isNotEmpty((String)result) && (muResult = (Result)JSON.parseObject((String)result, Result.class)).isSuccess()) {
            resulStr = (String)muResult.getData();
        }
        return BaseResponse.success((Object)resulStr);
    }

    public ImAccountVo getImAccounts(PatientSignEntity patientSignEntity, String admId, String imAppCode, String doctorId) {
        ImAccountVo admission = new ImAccountVo();
        IMQueryTargetSdkAccountRspVO imAccountRes = this.imChatTemplate.queryImAccount(admId, imAppCode, doctorId);
        if (imAccountRes == null) {
            this.imChatTemplate.createImSession(patientSignEntity);
            IMQueryTargetSdkAccountRspVO imAccountRes1 = this.imChatTemplate.queryImAccount(admId, imAppCode, doctorId);
            if (imAccountRes1 == null) {
                log.info("IM ERROR \u6ca1\u6709\u67e5\u8be2\u5230IM\u8d26\u6237-admId:{}", (Object)admId);
                return admission;
            }
            log.info("imAccountRes1:{}" + JSON.toJSONString((Object)imAccountRes1));
            if ("EHOS_DOCTOR".equals(imAppCode)) {
                admission.setDocImAccount(imAccountRes1.getSdkAccount());
            } else if ("EHOS_PATIENT".equals(imAppCode)) {
                admission.setPatImAccount(imAccountRes1.getSdkAccount());
            }
            admission.setRoomNum(Long.valueOf(imAccountRes1.getRoomNum()));
            return admission;
        }
        log.info("imAccountRes:{}" + JSON.toJSONString((Object)imAccountRes));
        if ("EHOS_DOCTOR".equals(imAppCode)) {
            admission.setDocImAccount(imAccountRes.getSdkAccount());
        } else if ("EHOS_PATIENT".equals(imAppCode)) {
            admission.setPatImAccount(imAccountRes.getSdkAccount());
        }
        admission.setRoomNum(Long.valueOf(imAccountRes.getRoomNum()));
        return admission;
    }
}

