/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.family.doctor.common.bo.DoctorInfo;
import com.ebaiyihui.family.doctor.common.dto.DoctorInfoForScheduleDTO;
import com.ebaiyihui.family.doctor.common.dto.InsertScheduleRecordReqDTO;
import com.ebaiyihui.family.doctor.common.dto.RequestGetScheduleForWeekDTO;
import com.ebaiyihui.family.doctor.common.dto.RequestUpdateScheduleStatusDTO;
import com.ebaiyihui.family.doctor.common.dto.ScheduleForWeekReqDTO;
import com.ebaiyihui.family.doctor.common.dto.ScheduleRangeAndTimeDTO;
import com.ebaiyihui.family.doctor.common.vo.ResponseGetScheduleForWeekVo;
import com.ebaiyihui.family.doctor.common.vo.ScheduleForWeekResVo;
import com.ebaiyihui.family.doctor.common.vo.ScheduleInfoVo;
import com.ebaiyihui.family.doctor.common.vo.ScheduleOfDayVo;
import com.ebaiyihui.family.doctor.common.vo.ScheduleRangeAndCountVo;
import com.ebaiyihui.family.doctor.common.vo.ScheduleTimeSaveListVo;
import com.ebaiyihui.family.doctor.server.common.constants.CommonConstants;
import com.ebaiyihui.family.doctor.server.common.enums.WhetherEnum;
import com.ebaiyihui.family.doctor.server.entity.ScheduleRecordEntity;
import com.ebaiyihui.family.doctor.server.feign.DoctorInfofeignClient;
import com.ebaiyihui.family.doctor.server.mapper.ScheduleRecordMapper;
import com.ebaiyihui.family.doctor.server.service.ScheduleRecordService;
import com.ebaiyihui.family.doctor.server.util.DateUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ScheduleRecordServiceImpl
implements ScheduleRecordService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleRecordServiceImpl.class);
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private DoctorInfofeignClient doctorCilent;

    public BaseResponse<String> insert(InsertScheduleRecordReqDTO record) {
        String currentDate = DateUtils.getCurrentDateSimpleToString();
        Date dateNow = null;
        Date startRes = null;
        Date endRes = null;
        try {
            dateNow = DateUtils.strToDate((String)currentDate, (String)"yyyy-MM-dd");
            startRes = DateUtils.strToDate((String)record.getScheduleDate(), (String)"yyyy-MM-dd");
            endRes = DateUtils.strToDate((String)record.getScheduleDateEnd(), (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (dateNow.after(startRes)) {
            return BaseResponse.error((String)"\u65b0\u589e\u6392\u73ed\u65e5\u671f\u9700\u5927\u4e8e\u7b49\u4e8e\u5f53\u524d\u65e5\u671f");
        }
        List doctorInfoForScheduleList = record.getDoctorInfoForSchedule();
        List scheduleRangeTimeList = record.getScheduleRangeAndTime();
        ArrayList dates = new ArrayList();
        List dateReq = DateUtils.getDateRange((Date)startRes, (Date)endRes);
        log.info("dateReq{}", (Object)JSON.toJSONString((Object)dateReq));
        List allDates = DateUtils.getOneDayNextWeek((List)dateReq, (Integer)3);
        log.info("allDates{}", (Object)JSON.toJSONString((Object)allDates));
        if (WhetherEnum.ALLOW.getValue().equals(record.getIsCycleSchedule())) {
            dates.addAll(allDates);
        } else {
            dates.addAll(dateReq);
        }
        log.info("dates{}", (Object)JSON.toJSONString(dates));
        for (DoctorInfoForScheduleDTO doctorInfo : doctorInfoForScheduleList) {
            QueryWrapper scheduleRecordWrapper = new QueryWrapper();
            ScheduleRecordEntity scheduleRecordEntity = new ScheduleRecordEntity();
            scheduleRecordEntity.setDoctorId(doctorInfo.getDoctorId());
            scheduleRecordEntity.setHospitalId(record.getHospitalId());
            scheduleRecordEntity.setDeptId(doctorInfo.getDeptId());
            scheduleRecordEntity.setStatus(WhetherEnum.ALLOW.getValue());
            scheduleRecordEntity.setServType(record.getServType());
            for (String oneDay : dates) {
                scheduleRecordEntity.setScheduleDate(DateUtils.strToDateNoTry((String)oneDay));
                scheduleRecordWrapper.setEntity((Object)scheduleRecordEntity);
                log.info("\u533b\u751f\u67d0\u79d1\u5ba4\u67d0\u5929\u6709\u6392\u73ed\u7684\u5165\u53c2:" + scheduleRecordEntity);
                List list = this.scheduleRecordMapper.selectList((Wrapper)scheduleRecordWrapper);
                if (CollectionUtils.isEmpty((Collection)list)) continue;
                log.info("list{}", (Object)list.toString());
                for (ScheduleRangeAndTimeDTO rangeReq : scheduleRangeTimeList) {
                    for (ScheduleRecordEntity rangeRes : list) {
                        Boolean aBoolean = DateUtils.rangeCompare((Date)DateUtils.strToDateNoTryForMinute((String)rangeReq.getStartTime()), (Date)DateUtils.strToDateNoTryForMinute((String)rangeReq.getEndTime()), (Date)DateUtils.strToDateNoTryForMinute((String)rangeRes.getStartTime()), (Date)DateUtils.strToDateNoTryForMinute((String)rangeRes.getEndTime()));
                        if (!aBoolean.booleanValue()) continue;
                        return BaseResponse.error((String)"\u6392\u73ed\u65f6\u6bb5\u4e0e\u5df2\u6dfb\u52a0\u6392\u73ed\u65f6\u95f4\u51b2\u7a81\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e");
                    }
                }
            }
        }
        for (DoctorInfoForScheduleDTO doctorInfo : doctorInfoForScheduleList) {
            for (String oneDay : dates) {
                scheduleRangeTimeList.stream().forEach(rangeVo -> this.getInsertSchedule(record, doctorInfo, rangeVo, oneDay));
            }
        }
        return BaseResponse.success((Object)"\u65b0\u589e\u6392\u73ed\u6210\u529f");
    }

    public BaseResponse<List<ResponseGetScheduleForWeekVo>> getScheduleForWeek(RequestGetScheduleForWeekDTO requestGetScheduleForWeekDTO) {
        Date intStartDate = DateUtils.dateToDateAsFormat((Date)DateUtils.getBeginDayOfWeek());
        Date intEndDate = DateUtils.dateToDateAsFormat((Date)DateUtils.getEndDayOfWeek());
        Integer[] weeks = requestGetScheduleForWeekDTO.getWeeks();
        ArrayList<ResponseGetScheduleForWeekVo> list = new ArrayList<ResponseGetScheduleForWeekVo>();
        for (Integer week : weeks) {
            Date startDate = null;
            Date endDate = null;
            startDate = DateUtils.getDateAfter((Date)intStartDate, (int)(7 * week));
            endDate = DateUtils.getDateAfter((Date)intEndDate, (int)(7 * week));
            QueryWrapper wrapper = new QueryWrapper();
            ScheduleRecordEntity entity = new ScheduleRecordEntity();
            entity.setDoctorId(requestGetScheduleForWeekDTO.getDoctorId());
            entity.setDeptId(String.valueOf(requestGetScheduleForWeekDTO.getDeptId()));
            entity.setHospitalId(String.valueOf(requestGetScheduleForWeekDTO.getHospitalId()));
            wrapper.setEntity((Object)entity);
            wrapper.between((Object)"schedule_date", (Object)startDate, (Object)endDate);
            List recordEntityList = this.scheduleRecordMapper.selectList((Wrapper)wrapper);
            log.info("\u67e5\u8be2\u6392\u73ed\u7ed3\u679c{}", (Object)recordEntityList.toString());
            for (int i = 0; i < 7; ++i) {
                ResponseGetScheduleForWeekVo scheduleForWeekVo = new ResponseGetScheduleForWeekVo();
                Date weekDay = DateUtils.getDateAfter((Date)startDate, (int)i);
                scheduleForWeekVo.setScheduleDate(weekDay);
                ArrayList<ScheduleOfDayVo> scheduleOfDayVoList = new ArrayList<ScheduleOfDayVo>();
                ScheduleOfDayVo scheduleOfDayVo = new ScheduleOfDayVo();
                QueryWrapper queryWrapper = new QueryWrapper();
                ScheduleRecordEntity timeIntervalEntity = new ScheduleRecordEntity();
                timeIntervalEntity.setHospitalId(String.valueOf(requestGetScheduleForWeekDTO.getHospitalId()));
                timeIntervalEntity.setDoctorId(requestGetScheduleForWeekDTO.getDoctorId());
                timeIntervalEntity.setDeptId(String.valueOf(requestGetScheduleForWeekDTO.getDeptId()));
                timeIntervalEntity.setScheduleDate(weekDay);
                timeIntervalEntity.setScheduleRange(CommonConstants.STATUS_VALID);
                timeIntervalEntity.setStatus(CommonConstants.STATUS_VALID);
                queryWrapper.setEntity((Object)timeIntervalEntity);
                List scheduleTimeIntervalEntities = this.scheduleRecordMapper.selectList((Wrapper)queryWrapper);
                ArrayList scheduleTimeSaveListVos = new ArrayList();
                if (null != scheduleTimeIntervalEntities) {
                    scheduleTimeIntervalEntities.forEach(scheduleTimeIntervalEntitie -> {
                        ScheduleTimeSaveListVo saveListVo = new ScheduleTimeSaveListVo();
                        BeanUtils.copyProperties((Object)scheduleTimeIntervalEntitie, (Object)saveListVo);
                        scheduleTimeSaveListVos.add(saveListVo);
                    });
                }
                scheduleOfDayVo.setScheduleTimeSaveListVo(scheduleTimeSaveListVos);
                scheduleOfDayVoList.add(scheduleOfDayVo);
                scheduleForWeekVo.setScheduleOfDayVoList(scheduleOfDayVoList);
                list.add(scheduleForWeekVo);
            }
        }
        return BaseResponse.success(list);
    }

    public BaseResponse<List<ScheduleForWeekResVo>> scheduleForWeekNew(ScheduleForWeekReqDTO scheduleForWeekReqDTO) {
        Date intStartDate = DateUtils.dateToDateAsFormat((Date)DateUtils.getBeginDayOfWeek());
        Date intEndDate = DateUtils.dateToDateAsFormat((Date)DateUtils.getEndDayOfWeek());
        Integer week = scheduleForWeekReqDTO.getWeek();
        Date startDate = DateUtils.getDateAfter((Date)intStartDate, (int)(7 * week));
        Date endDate = DateUtils.getDateAfter((Date)intEndDate, (int)(7 * week));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList list = new ArrayList();
        List scheduleRecordEList = this.getScheduleRecordEntities(scheduleForWeekReqDTO);
        if (CollectionUtils.isEmpty((Collection)scheduleRecordEList)) {
            list = this.noScheduleRes(startDate);
            return BaseResponse.success((Object)list);
        }
        log.info("\u67e5\u8be2\u6392\u73ed\u7ed3\u679c{}", (Object)scheduleRecordEList.size());
        ArrayList<ScheduleRecordEntity> recordEntityList = new ArrayList<ScheduleRecordEntity>();
        for (ScheduleRecordEntity scheduleRecord : scheduleRecordEList) {
            boolean overlap = DateUtils.overlap((Date)scheduleRecord.getScheduleDate(), (Date)scheduleRecord.getScheduleDate(), (Date)startDate, (Date)endDate);
            if (!overlap) continue;
            recordEntityList.add(scheduleRecord);
        }
        if (CollectionUtils.isEmpty(recordEntityList)) {
            log.info("\u6b64\u65f6\u6bb5\u65e0\u6392\u73ed");
            list = this.noScheduleRes(startDate);
            return BaseResponse.success((Object)list);
        }
        log.info("scheduleRecordfilterList:" + recordEntityList.toString());
        int i = 0;
        for (i = 0; i < 7; ++i) {
            ScheduleForWeekResVo scheduleTimeRes = new ScheduleForWeekResVo();
            Date dateAfter = DateUtils.getDateAfter((Date)startDate, (int)i);
            String format = simpleDateFormat.format(dateAfter);
            log.info("\u7b2c\u51e0\u5929:" + format);
            scheduleTimeRes.setScheduleTime(format);
            ArrayList scheduleOneDayList = new ArrayList();
            recordEntityList.stream().forEach(record -> {
                boolean overlap = DateUtils.overlap((Date)record.getScheduleDate(), (Date)record.getScheduleDate(), (Date)dateAfter, (Date)dateAfter);
                if (overlap) {
                    scheduleOneDayList.add(record);
                }
            });
            if (CollectionUtils.isEmpty(scheduleOneDayList)) {
                scheduleTimeRes.setScheduleInfos(new ArrayList());
                list.add(scheduleTimeRes);
                continue;
            }
            log.info("\u67d0\u5929\u7684\u6392\u73ed{}", (Object)scheduleOneDayList.toString());
            Map<String, List<ScheduleRecordEntity>> collect = scheduleOneDayList.stream().collect(Collectors.groupingBy(ScheduleRecordEntity::getDoctorId));
            ArrayList<ScheduleInfoVo> scheduleInfos = new ArrayList<ScheduleInfoVo>();
            for (String key : collect.keySet()) {
                List<ScheduleRecordEntity> scheduleRecordEntities = collect.get(key);
                Map<String, List<ScheduleRecordEntity>> collectDept = scheduleRecordEntities.stream().collect(Collectors.groupingBy(ScheduleRecordEntity::getDeptId));
                for (String keyDept : collectDept.keySet()) {
                    ScheduleInfoVo scheduleInfo = new ScheduleInfoVo();
                    List<ScheduleRecordEntity> scheduleRecord = collectDept.get(keyDept);
                    DoctorInfo doctorInfo = new DoctorInfo();
                    log.info("\u533b\u751f\u4fe1\u606f\u5165\u53c2{}", (Object)JSON.toJSONString(scheduleRecord));
                    QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
                    queryPersonnelInfoReq.setDoctorId(scheduleRecord.get(0).getDoctorId());
                    BaseResponse response = this.doctorCilent.queryPersonnelInfo(queryPersonnelInfoReq);
                    doctorInfo.setDeptId(keyDept);
                    doctorInfo.setDeptName(scheduleRecord.get(0).getDeptName());
                    doctorInfo.setDoctorId(scheduleRecord.get(0).getDoctorId());
                    doctorInfo.setDoctorName(scheduleRecord.get(0).getDoctorName());
                    doctorInfo.setDoctorProfession(((PersonnelInfo)response.getData()).getTitle());
                    doctorInfo.setDoctorPortrait(((PersonnelInfo)response.getData()).getPortrait());
                    ArrayList scheduleRangeAndCounts = new ArrayList();
                    List scheduleRecordCountEntities = this.getScheduleRecordEntities(scheduleForWeekReqDTO, format, doctorInfo);
                    scheduleRecordCountEntities.sort(Comparator.comparing(ScheduleRecordEntity::getStartTime));
                    scheduleRecordCountEntities.stream().forEach(scheduleRecordCount -> {
                        ScheduleRangeAndCountVo scheduleRangeAndCount = new ScheduleRangeAndCountVo();
                        BeanUtils.copyProperties((Object)scheduleRecordCount, (Object)scheduleRangeAndCount);
                        scheduleRangeAndCounts.add(scheduleRangeAndCount);
                    });
                    scheduleRecordCountEntities.sort(Comparator.comparing(ScheduleRecordEntity::getCreateTime));
                    BeanUtils.copyProperties((Object)doctorInfo, (Object)scheduleInfo);
                    scheduleInfo.setCreateEarliestTime(((ScheduleRecordEntity)scheduleRecordCountEntities.get(0)).getCreateTime());
                    scheduleInfo.setScheduleRangeAndCountList(scheduleRangeAndCounts);
                    scheduleInfos.add(scheduleInfo);
                    scheduleInfos.sort(Comparator.comparing(ScheduleInfoVo::getCreateEarliestTime).reversed());
                    scheduleTimeRes.setScheduleInfos(scheduleInfos);
                }
            }
            list.add(scheduleTimeRes);
            log.info("list{}", (Object)list.toString());
        }
        return BaseResponse.success((Object)list);
    }

    public BaseResponse<String> updateStatus(RequestUpdateScheduleStatusDTO updateScheduleStatusDTO) {
        ScheduleRecordEntity entity = (ScheduleRecordEntity)this.scheduleRecordMapper.selectById((Serializable)updateScheduleStatusDTO.getId());
        if (null == entity) {
            return BaseResponse.error((String)"\u6392\u73ed\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (null != updateScheduleStatusDTO.getIsCycleSchedule()) {
            this.closeCycle(updateScheduleStatusDTO, entity);
            log.info("======\u5faa\u73af\u6392\u73ed\u64cd\u4f5c\u6210\u529f======");
            return BaseResponse.success();
        }
        BaseResponse baseResponse = this.closeSchedule(updateScheduleStatusDTO, entity);
        return baseResponse;
    }

    private void closeCycle(RequestUpdateScheduleStatusDTO updateScheduleStatusDTO, ScheduleRecordEntity entity) {
        ScheduleRecordEntity entityUpdate = new ScheduleRecordEntity();
        entityUpdate.setIsCycleSchedule(updateScheduleStatusDTO.getIsCycleSchedule());
        entityUpdate.setId(updateScheduleStatusDTO.getId());
        this.scheduleRecordMapper.updateById((Object)entityUpdate);
        String date = DateUtils.dateToSimpleString((Date)entity.getScheduleDate());
        List nextDays = DateUtils.getOneDayNextWeekTwo((List)new /* Unavailable Anonymous Inner Class!! */, (Integer)5);
        List list = this.scheduleRecordMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(ScheduleRecordEntity::getDeptId, (Object)entity.getDeptId())).eq(ScheduleRecordEntity::getDoctorId, (Object)entity.getDoctorId())).eq(ScheduleRecordEntity::getHospitalId, (Object)entity.getHospitalId())).eq(ScheduleRecordEntity::getServType, (Object)entity.getServType())).eq(ScheduleRecordEntity::getStartTime, (Object)entity.getStartTime())).eq(ScheduleRecordEntity::getEndTime, (Object)entity.getEndTime())).in(ScheduleRecordEntity::getScheduleDate, (Collection)nextDays));
        for (ScheduleRecordEntity scheduleRecordEntity : list) {
            if (scheduleRecordEntity.getId().equals(entity.getId())) continue;
            this.closeSchedule(updateScheduleStatusDTO, scheduleRecordEntity);
        }
    }

    private BaseResponse<String> closeSchedule(RequestUpdateScheduleStatusDTO updateScheduleStatusDTO, ScheduleRecordEntity entity) {
        BaseResponse x = this.getStringBaseResponse(entity);
        if (x != null) {
            return x;
        }
        ScheduleRecordEntity entityUpdate = new ScheduleRecordEntity();
        entityUpdate.setStatus(Integer.valueOf(-1));
        if (Objects.nonNull(updateScheduleStatusDTO.getIsCycleSchedule())) {
            entityUpdate.setIsCycleSchedule(updateScheduleStatusDTO.getIsCycleSchedule());
        }
        entityUpdate.setId(entity.getId());
        this.scheduleRecordMapper.updateById((Object)entityUpdate);
        return BaseResponse.success((Object)"\u533b\u751f\u6392\u73ed\u505c\u8bca\u6210\u529f");
    }

    private BaseResponse<String> getStringBaseResponse(ScheduleRecordEntity entity) {
        String nowDateStr = DateUtils.getCurrentDateSimpleToString();
        log.info("nowDateStr{}", (Object)nowDateStr);
        String hourAndSecond = DateUtils.getHourAndSecond();
        log.info("hourAndSecond{}", (Object)hourAndSecond);
        Date now = null;
        Date endEntity = null;
        Date hourAndSec = null;
        try {
            now = DateUtils.strToDate((String)nowDateStr, (String)"yyyy-MM-dd");
            endEntity = DateUtils.strToDate((String)entity.getEndTime(), (String)"HH:mm");
            hourAndSec = DateUtils.strToDate((String)hourAndSecond, (String)"HH:mm");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (entity.getStatus().equals(WhetherEnum.FORBID.getValue())) {
            return BaseResponse.error((String)"\u5df2\u505c\u8bca,\u8bf7\u52ff\u91cd\u590d\u505c\u8bca");
        }
        if (this.isBoolean(entity, now, endEntity, hourAndSec)) {
            return BaseResponse.error((String)"\u8d85\u65f6\u4e0d\u80fd\u505c\u8bca");
        }
        return null;
    }

    private boolean isBoolean(ScheduleRecordEntity entity, Date now, Date endEntity, Date hourAndSec) {
        return entity.getScheduleDate().equals(now) && hourAndSec.after(endEntity) || entity.getScheduleDate().before(now);
    }

    private void getInsertSchedule(InsertScheduleRecordReqDTO record, DoctorInfoForScheduleDTO doctorInfo, ScheduleRangeAndTimeDTO rangeRes, String s) {
        ScheduleRecordEntity schedule = new ScheduleRecordEntity();
        BeanUtils.copyProperties((Object)record, (Object)schedule);
        BeanUtils.copyProperties((Object)doctorInfo, (Object)schedule);
        BeanUtils.copyProperties((Object)rangeRes, (Object)schedule);
        schedule.setAvailableCount(rangeRes.getTotalCount());
        Date date = null;
        try {
            date = DateUtils.strToDate((String)s, (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        schedule.setScheduleDate(date);
        log.info("\u6392\u73ed\u65b0\u589e\u5165\u53c2:" + schedule.toString());
        this.scheduleRecordMapper.insert((Object)schedule);
    }

    private ArrayList<ScheduleForWeekResVo> noScheduleRes(Date startDate) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<ScheduleForWeekResVo> list = new ArrayList<ScheduleForWeekResVo>();
        for (int i = 0; i < 7; ++i) {
            ScheduleForWeekResVo scheduleTimeRes = new ScheduleForWeekResVo();
            Date dateAfter = DateUtils.getDateAfter((Date)startDate, (int)i);
            String format = simpleDateFormat.format(dateAfter);
            log.info("\u7b2c\u51e0\u5929:" + format);
            scheduleTimeRes.setScheduleTime(format);
            scheduleTimeRes.setScheduleInfos(new ArrayList());
            list.add(scheduleTimeRes);
        }
        return list;
    }

    private List<ScheduleRecordEntity> getScheduleRecordEntities(ScheduleForWeekReqDTO scheduleForWeekReqDTO, String format, DoctorInfo doctorInfo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ScheduleRecordEntity scheduleRecordCountEntity = new ScheduleRecordEntity();
        scheduleRecordCountEntity.setHospitalId(scheduleForWeekReqDTO.getHospitalId().toString());
        scheduleRecordCountEntity.setDeptId(doctorInfo.getDeptId());
        scheduleRecordCountEntity.setDoctorId(doctorInfo.getDoctorId());
        try {
            scheduleRecordCountEntity.setScheduleDate(DateUtils.strToDate((String)format, (String)"yyyy-MM-dd"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        scheduleRecordCountEntity.setStatus(WhetherEnum.ALLOW.getValue());
        scheduleRecordCountEntity.setServType(scheduleForWeekReqDTO.getServType());
        queryWrapper.setEntity((Object)scheduleRecordCountEntity);
        return this.scheduleRecordMapper.selectList((Wrapper)queryWrapper);
    }

    private List<ScheduleRecordEntity> getScheduleRecordEntities(ScheduleForWeekReqDTO scheduleForWeekReqDTO) {
        QueryWrapper wrapper = new QueryWrapper();
        ScheduleRecordEntity entity = new ScheduleRecordEntity();
        entity.setHospitalId(JSON.toJSONString((Object)scheduleForWeekReqDTO.getHospitalId()));
        entity.setServType(scheduleForWeekReqDTO.getServType());
        entity.setStatus(WhetherEnum.ALLOW.getValue());
        wrapper.setEntity((Object)entity);
        wrapper.like(StringUtils.isNotEmpty((String)scheduleForWeekReqDTO.getDoctorName()), (Object)"doctor_name", (Object)scheduleForWeekReqDTO.getDoctorName());
        log.info("\u67e5\u8be2\u5165\u53c2:" + entity.toString());
        return this.scheduleRecordMapper.selectList((Wrapper)wrapper);
    }
}

