/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.family.doctor.common.dto.RequestGetDoctorOfficeStatusDTO;
import com.ebaiyihui.family.doctor.common.dto.RequestServiceConfigDTO;
import com.ebaiyihui.family.doctor.common.vo.RequestOnlineOrOfflineVo;
import com.ebaiyihui.family.doctor.server.common.constants.CommonConstants;
import com.ebaiyihui.family.doctor.server.entity.ServiceConfigEntity;
import com.ebaiyihui.family.doctor.server.exception.BusinessException;
import com.ebaiyihui.family.doctor.server.mapper.ScheduleRecordMapper;
import com.ebaiyihui.family.doctor.server.mapper.ServiceConfigMapper;
import com.ebaiyihui.family.doctor.server.service.ServiceConfigService;
import com.ebaiyihui.family.doctor.server.util.DateUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceConfigServiceImpl
implements ServiceConfigService {
    private static final Logger log = LoggerFactory.getLogger(ServiceConfigServiceImpl.class);
    @Autowired
    private ServiceConfigMapper serviceConfigMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;

    public RequestOnlineOrOfflineVo getDoctorOfficeStatus(RequestGetDoctorOfficeStatusDTO requestGetDoctorOfficeStatusDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ServiceConfigEntity wrapperEntity = new ServiceConfigEntity();
        wrapperEntity.setOrganId(requestGetDoctorOfficeStatusDTO.getHospitalId());
        wrapperEntity.setAppCode(requestGetDoctorOfficeStatusDTO.getAppCode());
        wrapperEntity.setDoctorId(requestGetDoctorOfficeStatusDTO.getDoctorId());
        wrapperEntity.setStatus(Integer.valueOf(1));
        queryWrapper.setEntity((Object)wrapperEntity);
        queryWrapper.last("limit 1");
        ServiceConfigEntity serviceConfigEntity = (ServiceConfigEntity)this.serviceConfigMapper.selectOne((Wrapper)queryWrapper);
        if (null == serviceConfigEntity) {
            throw new BusinessException("\u5f53\u524d\u533b\u751f\u672a\u5f00\u901a\u5bb6\u5ead\u533b\u751f\u670d\u52a1\u6216\u6570\u636e\u4e0d\u540c\u6b65\uff01");
        }
        RequestOnlineOrOfflineVo requestOnlineOrOfflineVo = new RequestOnlineOrOfflineVo();
        requestOnlineOrOfflineVo.setAppCode(serviceConfigEntity.getAppCode());
        requestOnlineOrOfflineVo.setDoctorId(serviceConfigEntity.getDoctorId());
        requestOnlineOrOfflineVo.setHospitalId(serviceConfigEntity.getOrganId());
        requestOnlineOrOfflineVo.setDeptId(String.valueOf(serviceConfigEntity.getDeptId()));
        requestOnlineOrOfflineVo.setOfficeStatus(serviceConfigEntity.getOfficeStatus());
        return requestOnlineOrOfflineVo;
    }

    public RequestOnlineOrOfflineVo officeOnlineOrOffline(RequestOnlineOrOfflineVo requestOnlineOrOfflineVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ServiceConfigEntity wrapperEntity = new ServiceConfigEntity();
        wrapperEntity.setOrganId(requestOnlineOrOfflineVo.getHospitalId());
        wrapperEntity.setAppCode(requestOnlineOrOfflineVo.getAppCode());
        wrapperEntity.setDeptId(Long.valueOf(requestOnlineOrOfflineVo.getDeptId()));
        wrapperEntity.setDoctorId(requestOnlineOrOfflineVo.getDoctorId());
        queryWrapper.setEntity((Object)wrapperEntity);
        queryWrapper.last("limit 1");
        ServiceConfigEntity serviceConfigEntity = (ServiceConfigEntity)this.serviceConfigMapper.selectOne((Wrapper)queryWrapper);
        if (null == serviceConfigEntity) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u533b\u751f\u4e0a\u4e0b\u7ebf\u914d\u7f6e\u4fe1\u606f\uff01");
        }
        if (requestOnlineOrOfflineVo.getOfficeStatus().equals(-1)) {
            String date = DateUtils.dateToSimpleString((Date)new Date());
            String hourAndSecond = DateUtils.getHourAndSecond();
            List scheduleRecordEntities = this.scheduleRecordMapper.selectByDate(String.valueOf(CommonConstants.ORGAN_CODE), Integer.valueOf(5), date, Integer.valueOf(1), hourAndSecond, serviceConfigEntity.getDoctorId());
            if (!scheduleRecordEntities.isEmpty()) {
                throw new BusinessException("\u4e0d\u80fd\u4e0a\u4e0b\u7ebf\uff0c\u60a8\u4eca\u5929\u6709\u503c\u73ed\uff01");
            }
        }
        serviceConfigEntity.setOfficeStatus(requestOnlineOrOfflineVo.getOfficeStatus());
        int flag = this.serviceConfigMapper.updateById((Object)serviceConfigEntity);
        if (flag <= 0) {
            if (requestOnlineOrOfflineVo.getOfficeStatus().equals(1)) {
                throw new BusinessException("\u4e0a\u7ebf\u5931\u8d25");
            }
            throw new BusinessException("\u4e0a\u7ebf\u5931\u8d25");
        }
        return requestOnlineOrOfflineVo;
    }

    public BaseResponse<Object> saveServiceInfo(RequestServiceConfigDTO serviceConfigDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ServiceConfigEntity wrapperEntity = new ServiceConfigEntity();
        wrapperEntity.setOrganId(serviceConfigDTO.getOrganId());
        wrapperEntity.setAppCode(serviceConfigDTO.getAppCode());
        wrapperEntity.setDeptId(serviceConfigDTO.getDeptId());
        wrapperEntity.setDoctorId(serviceConfigDTO.getDoctorId());
        wrapperEntity.setServiceCode(serviceConfigDTO.getServiceCode());
        queryWrapper.setEntity((Object)wrapperEntity);
        queryWrapper.last("limit 1");
        ServiceConfigEntity serviceConfigEntity = (ServiceConfigEntity)this.serviceConfigMapper.selectOne((Wrapper)queryWrapper);
        ServiceConfigEntity entity = new ServiceConfigEntity();
        if (null == serviceConfigEntity) {
            BeanUtils.copyProperties((Object)serviceConfigDTO, (Object)entity);
            entity.setOfficeStatus(Integer.valueOf(1));
            log.info("\u6dfb\u52a0\u5bb6\u5ead\u533b\u751f\u670d\u52a1\u4fe1\u606fentity: {}", (Object)entity);
            this.serviceConfigMapper.insert((Object)entity);
            return BaseResponse.success((Object)"\u65b0\u589e\u5bb6\u5ead\u533b\u751f\u670d\u52a1\u4fe1\u606f\u6210\u529f");
        }
        BeanUtils.copyProperties((Object)serviceConfigDTO, (Object)entity);
        log.info("\u67e5\u8be2\u5230\u670d\u52a1\u4fe1\u606fid\uff1a" + serviceConfigEntity.getId());
        entity.setId(serviceConfigEntity.getId());
        entity.setStatus(serviceConfigDTO.getStatus());
        log.info("\u4fee\u6539\u5bb6\u5ead\u533b\u751f\u670d\u52a1\u4fe1\u606fentity: {}", (Object)entity);
        this.serviceConfigMapper.updateById((Object)entity);
        return BaseResponse.success((Object)"\u4fee\u6539\u5bb6\u5ead\u533b\u751f\u670d\u52a1\u4fe1\u606f\u6210\u529f");
    }
}

