/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.aspect;

import com.alibaba.fastjson.JSON;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    Long time = 0L;

    @Pointcut(value="execution(public * com.ebaiyihui.family.doctor.server.controller.*.*(..))")
    public void LogAspect() {
    }

    @Before(value="LogAspect()")
    public void doBefore(JoinPoint joinPoint) throws Throwable {
        this.time = System.currentTimeMillis();
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        Method targetMethod = ((MethodSignature)joinPoint.getSignature()).getMethod();
        Method realMethod = joinPoint.getTarget().getClass().getDeclaredMethod(joinPoint.getSignature().getName(), targetMethod.getParameterTypes());
        ApiOperation operation = realMethod.getAnnotation(ApiOperation.class);
        if (Objects.nonNull(operation)) {
            log.info("\u8bf7\u6c42\u5f00\u59cb===\u65b9\u6cd5\u63cf\u8ff0:{},\n\u8bf7\u6c42\u65b9\u6cd5:{},\n\u8bf7\u6c42\u5730\u5740:{},\n\u8bf7\u6c42ip:{},\n\u8bf7\u6c42\u7c7b\u578b:{},\n\u8bf7\u6c42\u53c2\u6570:{}", new Object[]{operation.value(), joinPoint.getSignature().getName(), request.getRequestURL().toString(), request.getRemoteAddr(), request.getMethod(), JSON.toJSONString((Object)Arrays.toString(joinPoint.getArgs()))});
        }
    }

    @AfterReturning(returning="ret", pointcut="LogAspect()")
    public void doAfterReturning(Object ret) throws Throwable {
        log.info("\u8bf7\u6c42\u7ed3\u675f===\u8fd4\u56de\u503c==>{}", (Object)JSON.toJSONString((Object)ret));
        log.info("=======\u8bf7\u6c42\u63a5\u53e3\u6240\u9700\u65f6\u95f4====>{}", (Object)JSON.toJSONString((Object)(System.currentTimeMillis() - this.time)));
    }
}

