/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.rabbitmq;

import com.ebaiyihui.family.doctor.server.vo.OrderTaskVo;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RabbitProduct {
    private static final Logger log = LoggerFactory.getLogger(RabbitProduct.class);
    private static final long EXPIRE_TIME_MAX = 86400000L;
    @Autowired
    private AmqpTemplate rabbitTemplate;

    public void sendDelay(OrderTaskVo orderTaskVo) {
        if (orderTaskVo.getType() == 1) {
            long time = 86400000L;
            if (Objects.nonNull(orderTaskVo.getExpireTime())) {
                time = orderTaskVo.getExpireTime().intValue();
            }
            log.info("\u8fc7\u671f\u65f6\u95f4:{}", (Object)time);
            long finalTime = time;
            this.rabbitTemplate.convertAndSend("byh-family-doctor-delay-exchange", "family-doctor-order-key", (Object)orderTaskVo, message -> {
                message.getMessageProperties().setHeader("x-delay", (Object)finalTime);
                message.getMessageProperties().setDeliveryMode(MessageDeliveryMode.PERSISTENT);
                return message;
            });
        }
    }
}

