/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.doctoruser.api.pojo.vo.UserInfoByDoctorIdRespVO;
import com.doctoruser.api.pojo.vo.UserInfoByUserIdRespVO;
import com.ebaiyihui.family.doctor.common.bo.Components;
import com.ebaiyihui.family.doctor.common.bo.ImAccountCreateReq;
import com.ebaiyihui.family.doctor.common.bo.Message;
import com.ebaiyihui.family.doctor.common.bo.MessageInfo;
import com.ebaiyihui.family.doctor.common.bo.PatientSignInfo;
import com.ebaiyihui.family.doctor.common.bo.PersonImInformReq;
import com.ebaiyihui.family.doctor.common.bo.Result;
import com.ebaiyihui.family.doctor.common.dto.DoctorIdDTO;
import com.ebaiyihui.family.doctor.common.dto.HealthInfoDTO;
import com.ebaiyihui.family.doctor.common.dto.MasterUrlDTO;
import com.ebaiyihui.family.doctor.common.dto.ReportDetailDTO;
import com.ebaiyihui.family.doctor.common.dto.SendImMsgDTO;
import com.ebaiyihui.family.doctor.common.vo.ReportDetailItemVo;
import com.ebaiyihui.family.doctor.common.vo.ReportDetailVo;
import com.ebaiyihui.family.doctor.server.common.constants.CommonConstants;
import com.ebaiyihui.family.doctor.server.common.constants.IMInformConstants;
import com.ebaiyihui.family.doctor.server.common.enums.MsgTempTypeEnum;
import com.ebaiyihui.family.doctor.server.common.enums.ReportTypeEnum;
import com.ebaiyihui.family.doctor.server.common.enums.SenderEnum;
import com.ebaiyihui.family.doctor.server.entity.PatientSignEntity;
import com.ebaiyihui.family.doctor.server.exception.BusinessException;
import com.ebaiyihui.family.doctor.server.feign.DoctorInfofeignClient;
import com.ebaiyihui.family.doctor.server.feign.IMPushMsgFeignClient;
import com.ebaiyihui.family.doctor.server.feign.ImApiFeignClient;
import com.ebaiyihui.family.doctor.server.feign.UserApiFeignClient;
import com.ebaiyihui.family.doctor.server.mapper.PatientSignMapper;
import com.ebaiyihui.family.doctor.server.service.ImChatTemplate;
import com.ebaiyihui.family.doctor.server.util.JsonUtil;
import com.ebaiyihui.family.doctor.server.util.ThirdOrderPushUtil;
import com.ebaiyihui.family.doctor.server.util.UUIDUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.imforward.client.vo.AccountVO;
import com.ebaiyihui.imforward.client.vo.IMQueryTargetSdkAccountReqVO;
import com.ebaiyihui.imforward.client.vo.IMQueryTargetSdkAccountRspVO;
import com.ebaiyihui.imforward.client.vo.IMSaveSessionReqVO;
import com.ebaiyihui.imforward.client.vo.IMSessionMemberVO;
import com.ebaiyihui.imforward.client.vo.PushSingleMsgDataVO;
import com.ebaiyihui.imforward.client.vo.PushSingleMsgReqVO;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ImChatTemplateImpl
implements ImChatTemplate {
    private static final Logger log = LoggerFactory.getLogger(ImChatTemplateImpl.class);
    @Autowired
    private UserApiFeignClient userApiFeignClient;
    @Autowired
    private DoctorInfofeignClient doctorInfofeignClient;
    @Autowired
    private ImApiFeignClient imApiFeignClient;
    @Autowired
    private IMPushMsgFeignClient imPushMsgFeignClient;
    @Autowired
    private PatientSignMapper patientSignMapper;
    @Autowired
    private ThirdOrderPushUtil thirdOrderPushUtil;

    public BaseResponse createImSession(PatientSignEntity patientSignEntity) {
        log.info("=======\u521b\u5efa\u4f1a\u8bdd\u5f00\u59cb=====");
        log.info("\u521b\u5efa\u4f1a\u8bdd\u5f00\u59cb\u65f6\u95f4\uff1a{}" + System.currentTimeMillis());
        log.info("patientSignEntity :{}", (Object)patientSignEntity);
        BaseResponse response = this.createPersonalImSession(patientSignEntity);
        log.info("\u521b\u5efa\u4f1a\u8bdd\u8fd4\u56de:{}" + JSON.toJSONString((Object)response));
        log.info("=======\u521b\u5efa\u4f1a\u8bdd\u7ed3\u675f=====");
        log.info("\u521b\u5efa\u4f1a\u8bdd\u7ed3\u675f\u65f6\u95f4\uff1a{}" + System.currentTimeMillis());
        return response;
    }

    public IMQueryTargetSdkAccountRspVO queryImAccount(String admId, String imAppCode, String doctorId) {
        BaseResponse response;
        log.info("admId:" + admId);
        log.info("imAppCode:" + imAppCode);
        if (StringUtils.isEmpty((Object)admId)) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        PatientSignEntity patientSign = new PatientSignEntity();
        patientSign.setAdmId(admId);
        wrapper.setEntity((Object)patientSign);
        PatientSignEntity patientSignEntity = (PatientSignEntity)this.patientSignMapper.selectOne((Wrapper)wrapper);
        if (patientSignEntity == null) {
            return null;
        }
        log.info("patientSignEntity:" + patientSignEntity.toString());
        IMQueryTargetSdkAccountReqVO imQueryTargetSdkAccountReqVO = new IMQueryTargetSdkAccountReqVO();
        if ("EHOS_DOCTOR".equals(imAppCode)) {
            response = this.userApiFeignClient.getUserInfoByDoctorId(doctorId);
            log.info("response:{}", (Object)JsonUtil.convertObject((Object)response));
            if (response.isSuccess()) {
                UserInfoByDoctorIdRespVO userInfoByDoctorIdRespVO = (UserInfoByDoctorIdRespVO)response.getData();
                log.info("userInfoByDoctorIdRespVO:{}" + JSONObject.toJSONString((Object)userInfoByDoctorIdRespVO));
                imQueryTargetSdkAccountReqVO.setUserId(userInfoByDoctorIdRespVO.getUserId());
            }
        } else if ("EHOS_PATIENT".equals(imAppCode)) {
            imQueryTargetSdkAccountReqVO.setUserId(patientSignEntity.getPatientUserId());
        }
        imQueryTargetSdkAccountReqVO.setBusiCode("jtys");
        imQueryTargetSdkAccountReqVO.setAppCode(imAppCode);
        imQueryTargetSdkAccountReqVO.setTreatmentId(admId);
        log.info("imQueryTargetSdkAccountReqVO:{}" + JSONObject.toJSONString((Object)imQueryTargetSdkAccountReqVO));
        response = this.imApiFeignClient.qeuryTagetSdkAccount(imQueryTargetSdkAccountReqVO);
        log.info("imApiFeignClient-response{}", (Object)JSON.toJSONString((Object)response));
        if (response.isSuccess()) {
            return (IMQueryTargetSdkAccountRspVO)response.getData();
        }
        log.warn("IM\u8d26\u53f7\u67e5\u8be2 - \u67e5\u8be2\u5931\u8d25 - response:{}", (Object)JsonUtil.convertObject((Object)response));
        return null;
    }

    public void doctorPrompted(String admId) {
        String content = "";
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        PatientSignInfo patientSignInfo = this.getPatientSignInfo(admId);
        messageInfos.add(this.getDoctorInformRefreshPatientParam(patientSignInfo, IMInformConstants.REFRESH));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admId);
        parameter.setBusiCode("jtys");
        log.info("\u63a8\u9001\u5bb6\u5ead\u533b\u751f\u63d0\u793a\u8bed\u63a8\u9001\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
        if (this.personUserImInform(parameter, content, null, null)) {
            log.info("\u63a8\u9001\u5bb6\u5ead\u533b\u751f\u63d0\u793a\u8bed\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admId);
        }
    }

    public Boolean sendMsg(List<Components> componentsList, SendImMsgDTO sendImMsgDTO) {
        Boolean flag = false;
        if (!componentsList.isEmpty()) {
            log.info("componentsList={}", componentsList);
            String reportResult = "";
            if (MsgTempTypeEnum.REP_INTER.getValue().equals(sendImMsgDTO.getType())) {
                ReportDetailDTO reportDetailDTO = new ReportDetailDTO();
                reportDetailDTO.setThirdId(sendImMsgDTO.getThirdId());
                reportResult = this.thirdOrderPushUtil.getReportDetail(reportDetailDTO);
            }
            for (int i = 0; i < componentsList.size(); ++i) {
                Result muResult;
                String masterResult;
                MasterUrlDTO masterUrlDTO;
                String content = componentsList.get(i).getContent();
                ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
                PatientSignInfo patientSignInfo = this.getPatientSignInfo(sendImMsgDTO.getAdmId());
                MessageInfo messageInfo = new MessageInfo();
                String msgType = null;
                if (MsgTempTypeEnum.REP_INTER.getValue().equals(sendImMsgDTO.getType())) {
                    Result rrResult;
                    if (!StringUtils.isEmpty((Object)reportResult) && (rrResult = (Result)JSON.parseObject((String)reportResult, Result.class)).isSuccess()) {
                        ReportDetailVo reportDetailVo = (ReportDetailVo)JSON.parseObject((String)JSONObject.toJSONString((Object)rrResult.getData()), ReportDetailVo.class);
                        List reportDetailItemVos = reportDetailVo.getReportFileList();
                        if (i == 0) {
                            if (Objects.nonNull(reportDetailVo)) {
                                content = MessageFormat.format(content, patientSignInfo.getDoctorName(), ReportTypeEnum.getDesc((Integer)reportDetailVo.getReportType()));
                            }
                        } else if (i == 1) {
                            HashMap<String, Object> imageMap = new HashMap<String, Object>();
                            imageMap.put("UserAction", "2000");
                            imageMap.put("applicationCode", "jtys");
                            imageMap.put("appointmentId", sendImMsgDTO.getAdmId());
                            imageMap.put("attacheUrl", ((ReportDetailItemVo)reportDetailItemVos.get(0)).getFileUrl());
                            imageMap.put("businessCode", "jtys");
                            imageMap.put("doctorHeadUrl", patientSignInfo.getDoctorHeadPortrait());
                            imageMap.put("doctorName", patientSignInfo.getDoctorName());
                            imageMap.put("msgId", UUIDUtil.getUUID());
                            imageMap.put("msgType", "PICTURE");
                            imageMap.put("senderName", patientSignInfo.getDoctorName());
                            imageMap.put("senderProfessional", patientSignInfo.getDoctorProfessional());
                            imageMap.put("team", false);
                            imageMap.put("teamFlag", 0);
                            imageMap.put("toApplicationCode", "jtys");
                            msgType = "TIMCustomElem";
                            content = JSONObject.toJSONString(imageMap);
                        } else if (i == 2 && Objects.nonNull(reportDetailVo)) {
                            content = MessageFormat.format(content, ReportTypeEnum.getDesc((Integer)reportDetailVo.getReportType()));
                        }
                    }
                } else if (MsgTempTypeEnum.REP_ANO.getValue().equals(sendImMsgDTO.getType())) {
                    content = MessageFormat.format(content, patientSignInfo.getDoctorName(), sendImMsgDTO.getIntention());
                } else if (MsgTempTypeEnum.AFTER_HEAL_ASSE.getValue().equals(sendImMsgDTO.getType())) {
                    masterUrlDTO = new MasterUrlDTO();
                    masterUrlDTO.setPhone(patientSignInfo.getPatientPhone());
                    masterUrlDTO.setSignSeqId(String.valueOf(patientSignInfo.getSignedId()));
                    masterUrlDTO.setType("2");
                    masterResult = this.thirdOrderPushUtil.getMasterUrl(masterUrlDTO);
                    if (!StringUtils.isEmpty((Object)masterResult) && (muResult = (Result)JSON.parseObject((String)masterResult, Result.class)).isSuccess()) {
                        content = MessageFormat.format(content, muResult.getData());
                    }
                } else if (!StringUtils.isEmpty((Object)sendImMsgDTO.getOldAdmId())) {
                    if (MsgTempTypeEnum.UP_SUC.getValue().equals(sendImMsgDTO.getType())) {
                        content = MessageFormat.format(content, patientSignInfo.getDoctorName());
                        if (!Objects.nonNull(componentsList.get(i).getConditionFlag()) && CommonConstants.STATUS_VALID.equals(componentsList.get(i).getConditionFlag())) {
                            HealthInfoDTO healthInfoDTO = new HealthInfoDTO();
                            healthInfoDTO.setPhone(patientSignInfo.getPatientPhone());
                            String result = this.thirdOrderPushUtil.getHealthSchStatus(healthInfoDTO);
                            if (!StringUtils.isEmpty((Object)result)) {
                                Result muResult2;
                                Result hssResult = (Result)JSON.parseObject((String)result, Result.class);
                                if (hssResult.isSuccess() && CommonConstants.STATUS_VALID.equals(hssResult.getData())) continue;
                                MasterUrlDTO masterUrlDTO2 = new MasterUrlDTO();
                                masterUrlDTO2.setPhone(patientSignInfo.getPatientPhone());
                                masterUrlDTO2.setSignSeqId(String.valueOf(patientSignInfo.getSignedId()));
                                masterUrlDTO2.setType("3");
                                String masterResult2 = this.thirdOrderPushUtil.getMasterUrl(masterUrlDTO2);
                                if (!StringUtils.isEmpty((Object)masterResult2) && (muResult2 = (Result)JSON.parseObject((String)masterResult2, Result.class)).isSuccess()) {
                                    content = MessageFormat.format(content, muResult2.getData());
                                }
                            }
                        }
                    } else if (MsgTempTypeEnum.SIG_SUC.getValue().equals(sendImMsgDTO.getType())) {
                        content = MessageFormat.format(content, patientSignInfo.getDoctorName());
                        if (!Objects.nonNull(componentsList.get(i).getConditionFlag()) && CommonConstants.STATUS_VALID.equals(componentsList.get(i).getConditionFlag())) {
                            masterUrlDTO = new MasterUrlDTO();
                            masterUrlDTO.setPhone(patientSignInfo.getPatientPhone());
                            masterUrlDTO.setSignSeqId(String.valueOf(patientSignInfo.getSignedId()));
                            masterUrlDTO.setType("3");
                            masterResult = this.thirdOrderPushUtil.getMasterUrl(masterUrlDTO);
                            if (!StringUtils.isEmpty((Object)masterResult) && (muResult = (Result)JSON.parseObject((String)masterResult, Result.class)).isSuccess()) {
                                content = MessageFormat.format(content, muResult.getData());
                            }
                        }
                    } else {
                        PatientSignInfo oldPatientSignInfo = this.getPatientSignInfo(sendImMsgDTO.getOldAdmId());
                        log.info("\u4e4b\u524d\u7684doctorName={}", (Object)oldPatientSignInfo.getDoctorName());
                        log.info("\u6765\u6e90\u7684doctorName={}", (Object)oldPatientSignInfo.getDoctorName());
                        content = MessageFormat.format(content, oldPatientSignInfo.getDoctorName(), patientSignInfo.getDoctorName());
                    }
                } else {
                    content = MessageFormat.format(content, patientSignInfo.getDoctorName());
                }
                if (SenderEnum.DOCTOR.getDesc().equals(componentsList.get(i).getSender())) {
                    messageInfo = this.getDoctorInformRefreshPatientParam(patientSignInfo, IMInformConstants.REFRESH);
                } else {
                    log.info("msgType={}", msgType);
                    messageInfo = this.getInformRefreshPatientParam(patientSignInfo, IMInformConstants.REFRESH, msgType);
                }
                messageInfos.add(messageInfo);
                PersonImInformReq parameter = new PersonImInformReq();
                parameter.setMessageInfos(messageInfos);
                parameter.setAdmissionId(sendImMsgDTO.getAdmId());
                parameter.setBusiCode("jtys");
                log.info("\u63a8\u9001\u5bb6\u5ead\u533b\u751f\u63d0\u793a\u8bed\u63a8\u9001\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
                Long syncFlag = (long)i * 100L;
                if (!this.personUserImInform(parameter, content, syncFlag, msgType)) continue;
                log.info("\u63a8\u9001\u5bb6\u5ead\u533b\u751f\u63d0\u793a\u8bed\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)sendImMsgDTO.getAdmId());
                flag = true;
            }
        }
        return flag;
    }

    private PatientSignInfo getPatientSignInfo(String admId) {
        QueryWrapper wrapper = new QueryWrapper();
        PatientSignEntity patientSign = new PatientSignEntity();
        patientSign.setAdmId(admId);
        wrapper.setEntity((Object)patientSign);
        PatientSignEntity patientSignEntity = (PatientSignEntity)this.patientSignMapper.selectOne((Wrapper)wrapper);
        if (patientSignEntity == null) {
            log.error("IM INFORM ERROR : \u6ca1\u6709\u67e5\u8be2\u5230\u5c31\u8bca\u4fe1\u606f\uff0cadmId:{}", (Object)admId);
            return new PatientSignInfo();
        }
        PatientSignInfo patientSignInfo = new PatientSignInfo();
        BeanUtils.copyProperties((Object)patientSignEntity, (Object)patientSignInfo);
        patientSignInfo.setSignedId(patientSignEntity.getId());
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(String.valueOf(patientSignEntity.getDoctorId()));
        BaseResponse doctorInfo = this.doctorInfofeignClient.queryPersonnelInfo(queryPersonnelInfoReq);
        UserInfoByUserIdRespVO userInfoByUserIdRespVO = this.queryDocAccountInfo(String.valueOf(patientSignEntity.getDoctorId()));
        if (userInfoByUserIdRespVO == null) {
            log.error("IM INFORM ERROR : \u83b7\u53d6\u533b\u751f\u4fe1\u606f\u5931\u8d25 doctorId\uff1a{}", (Object)String.valueOf(patientSignEntity.getDoctorId()));
            return new PatientSignInfo();
        }
        if (null == doctorInfo && !doctorInfo.isSuccess()) {
            log.error("IM INFORM ERROR : \u83b7\u53d6\u533b\u751f\u4fe1\u606f\u5931\u8d25 doctorId\uff1a{}", (Object)String.valueOf(patientSignEntity.getDoctorId()));
            return new PatientSignInfo();
        }
        patientSignInfo.setDoctorUserId(userInfoByUserIdRespVO.getUserId());
        patientSignInfo.setDoctorHeadPortrait(((PersonnelInfo)doctorInfo.getData()).getPortrait());
        patientSignInfo.setDoctorProfessional(((PersonnelInfo)doctorInfo.getData()).getTitle());
        log.info("patientSignInfo:{}" + JSON.toJSONString((Object)patientSignInfo));
        return patientSignInfo;
    }

    private <T> MessageInfo getDoctorInformRefreshPatientParam(PatientSignInfo patientSignInfo, Integer isRefresh) {
        String patientUserId = patientSignInfo.getPatientUserId();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)patientUserId)) {
            log.error("IM INFORM ERROR : \u65e0\u6cd5\u67e5\u8be2\u5230\u63a5\u6536\u4eba\u4fe1\u606f");
            return new MessageInfo();
        }
        MessageInfo messageInfo = new MessageInfo();
        Message message = new Message();
        message.setApplicationCode("jtys");
        messageInfo.setSingleAccount(this.newAccount("EHOS_PATIENT", patientUserId));
        messageInfo.setSelfAccount(this.newAccount("EHOS_DOCTOR", patientSignInfo.getDoctorUserId()));
        messageInfo.setMessage(message);
        return messageInfo;
    }

    private <T> MessageInfo getInformRefreshPatientParam(PatientSignInfo patientSignInfo, Integer isRefresh, String msgType) {
        String doctorUserId = patientSignInfo.getDoctorUserId();
        if (StringUtils.isEmpty((Object)doctorUserId)) {
            log.error("IM INFORM ERROR : \u65e0\u6cd5\u67e5\u8be2\u5230\u63a5\u6536\u4eba\u4fe1\u606f");
            return new MessageInfo();
        }
        MessageInfo messageInfo = new MessageInfo();
        Message message = new Message();
        message.setApplicationCode("jtys");
        messageInfo.setSingleAccount(this.newAccount("EHOS_DOCTOR", doctorUserId));
        messageInfo.setSelfAccount(this.newAccount("EHOS_PATIENT", patientSignInfo.getPatientUserId()));
        messageInfo.setMsgType(msgType);
        messageInfo.setMessage(message);
        log.info("messageInfo={}", (Object)messageInfo);
        return messageInfo;
    }

    private AccountVO newAccount(String appCode, String userId) {
        AccountVO accountVO = new AccountVO();
        accountVO.setAppCode(appCode);
        accountVO.setUserId(userId);
        return accountVO;
    }

    private boolean personUserImInform(PersonImInformReq param, String content, Long syncFlag, String msgType) {
        List messageInfos = param.getMessageInfos();
        if (messageInfos == null || messageInfos.isEmpty()) {
            log.error("IM INFORM ERROR : \u6ca1\u6709\u53ef\u53d1\u9001\u7684\u6d88\u606f");
            return false;
        }
        ArrayList msgSingleDatas = new ArrayList();
        messageInfos.forEach(e -> {
            PushSingleMsgDataVO msgsingleData = new PushSingleMsgDataVO();
            msgsingleData.setActionType("user");
            msgsingleData.setFromAccount(e.getSelfAccount());
            msgsingleData.setToAccount(e.getSingleAccount());
            if (Objects.nonNull(syncFlag)) {
                msgsingleData.setSyncFlag(syncFlag);
            }
            if (Objects.nonNull(msgType)) {
                msgsingleData.setMsgType(msgType);
            }
            msgsingleData.setMessage(content);
            msgSingleDatas.add(msgsingleData);
        });
        PushSingleMsgReqVO parameter = new PushSingleMsgReqVO();
        parameter.setBusiCode(param.getBusiCode());
        parameter.setUniqueId(param.getAdmissionId());
        parameter.setMsgData(msgSingleDatas);
        log.info("\u63a8\u9001\u5165\u53c2:{}" + JSON.toJSONString((Object)parameter));
        boolean pushFlag = this.pushSingleIm(parameter);
        if (!pushFlag) {
            log.info("IM INFORM ERROR : im \u8c03\u7528im\u7cfb\u7edf\u63a8\u9001\u5931\u8d25");
            return false;
        }
        return true;
    }

    private boolean pushSingleIm(PushSingleMsgReqVO reqVO) {
        log.info("\u8c03\u7528IM\u7b2c\u4e09\u65b9reqVO:{}" + JSON.toJSONString((Object)reqVO));
        BaseResponse response = this.imPushMsgFeignClient.pushSingleMsg(reqVO);
        log.info("\u53d1\u9001IM\u5355\u4eba\u63a8\u9001:{}", (Object)response.toString());
        return response.isSuccess();
    }

    private BaseResponse createPersonalImSession(PatientSignEntity patientSignEntity) {
        BaseResponse baseResponse = new BaseResponse();
        String doctorId = String.valueOf(patientSignEntity.getDoctorId());
        log.info("DoctorId:{}" + doctorId);
        UserInfoByUserIdRespVO docAccountInfo = this.queryDocAccountInfo(doctorId);
        if (docAccountInfo == null) {
            // empty if block
        }
        log.info("\u5f00\u59cb\u521b\u5efa\u5355\u4ebaim\u8d26\u53f7");
        DoctorIdDTO doctorIdVo = new DoctorIdDTO();
        doctorIdVo.setDoctorId(doctorId);
        ImAccountCreateReq imAccountCreateReq = new ImAccountCreateReq(patientSignEntity.getAdmId(), doctorId, patientSignEntity.getPatientId(), docAccountInfo.getUserId(), patientSignEntity.getPatientUserId(), patientSignEntity.getAppCode());
        IMSaveSessionReqVO imSaveSessionReqVO = this.createImSessionParam(imAccountCreateReq);
        log.info("\u521b\u5efaim\u5165\u53c2{}", (Object)JSONObject.toJSONString((Object)imSaveSessionReqVO));
        BaseResponse imResponse = null;
        if (null == imSaveSessionReqVO) {
            throw new BusinessException("createImSession fail!");
        }
        log.info("\u521b\u5efaim\u8bf7\u6c42\u5f00\u59cb");
        imResponse = this.imApiFeignClient.saveIMSession(imSaveSessionReqVO);
        log.info("\u521b\u5efaim\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)JsonUtil.convertObject((Object)imResponse));
        return imResponse;
    }

    private UserInfoByUserIdRespVO queryDocAccountInfo(String doctorId) {
        BaseResponse response = this.userApiFeignClient.getUserInfoByDoctorId(doctorId);
        log.info("response:{}", (Object)JsonUtil.convertObject((Object)response));
        UserInfoByUserIdRespVO userInfoByUserIdRespVO = new UserInfoByUserIdRespVO();
        if (response.isSuccess()) {
            userInfoByUserIdRespVO.setUserId(((UserInfoByDoctorIdRespVO)response.getData()).getUserId());
            log.info("UserInfoByUserIdRespVO===>{}", (Object)JSON.toJSONString((Object)userInfoByUserIdRespVO));
            return userInfoByUserIdRespVO;
        }
        return null;
    }

    private IMSaveSessionReqVO createImSessionParam(ImAccountCreateReq req) {
        IMSaveSessionReqVO reqVO = new IMSaveSessionReqVO();
        reqVO.setBusiCode("jtys");
        reqVO.setSdkType(Short.valueOf((short)2));
        reqVO.setTreatmentId(req.getAdmId());
        reqVO.setBusiNodeCode(req.getAppCode());
        reqVO.setSaveType(true);
        IMSessionMemberVO memberOfDoc = new IMSessionMemberVO();
        ArrayList<IMSessionMemberVO> datas = new ArrayList<IMSessionMemberVO>();
        memberOfDoc.setAppCode("EHOS_DOCTOR");
        memberOfDoc.setDoctorId(CommonConstants.DOCTOR_TYPE.toString());
        memberOfDoc.setPatientId(CommonConstants.STATUS_INVALID.toString());
        memberOfDoc.setUserId(req.getDoctorUserId());
        datas.add(memberOfDoc);
        IMSessionMemberVO memberOfPatient = new IMSessionMemberVO();
        memberOfPatient.setAppCode("EHOS_PATIENT");
        memberOfPatient.setDoctorId(CommonConstants.STATUS_INVALID.toString());
        memberOfPatient.setPatientId(CommonConstants.PATIENT_TYPE.toString());
        memberOfPatient.setUserId(req.getPatientUserId());
        datas.add(memberOfPatient);
        reqVO.setMemberList(datas);
        return reqVO;
    }

    public static void main(String[] args) {
        String s = "";
        JSONObject.parseObject((String)s);
    }
}

