/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.vo.UserInfoByDoctorIdRespVO;
import com.doctoruser.api.pojo.vo.UserInfoByUserIdRespVO;
import com.ebaiyihui.family.doctor.common.bo.Components;
import com.ebaiyihui.family.doctor.common.bo.ImMessageDTO;
import com.ebaiyihui.family.doctor.common.bo.MsgContent;
import com.ebaiyihui.family.doctor.common.dto.InfoListDTO;
import com.ebaiyihui.family.doctor.common.dto.SendImMsgDTO;
import com.ebaiyihui.family.doctor.common.dto.UnReadMsgDTO;
import com.ebaiyihui.family.doctor.server.common.enums.SignStatus;
import com.ebaiyihui.family.doctor.server.common.enums.StatusEnum;
import com.ebaiyihui.family.doctor.server.entity.ImMsgTemplateEntity;
import com.ebaiyihui.family.doctor.server.entity.PatientEntity;
import com.ebaiyihui.family.doctor.server.entity.PatientSignEntity;
import com.ebaiyihui.family.doctor.server.exception.BusinessException;
import com.ebaiyihui.family.doctor.server.feign.DoctorInfofeignClient;
import com.ebaiyihui.family.doctor.server.feign.UserApiFeignClient;
import com.ebaiyihui.family.doctor.server.mapper.ImMsgTemplateMapper;
import com.ebaiyihui.family.doctor.server.mapper.PatientMapper;
import com.ebaiyihui.family.doctor.server.mapper.PatientSignMapper;
import com.ebaiyihui.family.doctor.server.service.ImChatTemplate;
import com.ebaiyihui.family.doctor.server.service.ImMsgTemplateService;
import com.ebaiyihui.family.doctor.server.util.DateUtils;
import com.ebaiyihui.family.doctor.server.util.JsonUtil;
import com.ebaiyihui.family.doctor.server.util.ThirdOrderPushUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ImMsgTemplateServiceImpl
implements ImMsgTemplateService {
    private static final Logger log = LoggerFactory.getLogger(ImMsgTemplateServiceImpl.class);
    @Autowired
    private UserApiFeignClient userApiFeignClient;
    @Autowired
    private DoctorInfofeignClient doctorInfofeignClient;
    @Autowired
    private ImChatTemplate imChatTemplate;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private ImMsgTemplateMapper imMsgTemplateMapper;
    @Autowired
    private PatientSignMapper patientSignMapper;
    @Autowired
    private ThirdOrderPushUtil thirdOrderPushUtil;

    @Async
    public String sendImMsg(SendImMsgDTO sendImMsgDTO) {
        QueryWrapper wrapper = new QueryWrapper();
        ImMsgTemplateEntity imMsgTemplate = new ImMsgTemplateEntity();
        imMsgTemplate.setAppCode(sendImMsgDTO.getAppCode());
        imMsgTemplate.setOrganId(sendImMsgDTO.getOrganId());
        imMsgTemplate.setType(sendImMsgDTO.getType());
        wrapper.setEntity((Object)imMsgTemplate);
        ImMsgTemplateEntity imMsgTemplateEntity = (ImMsgTemplateEntity)this.imMsgTemplateMapper.selectOne((Wrapper)wrapper);
        String components = imMsgTemplateEntity.getContent();
        MsgContent msgContent = (MsgContent)JSON.parseObject((String)components, MsgContent.class);
        List componentsList = msgContent.getComponents().stream().sorted(Comparator.comparing(Components::getSort)).collect(Collectors.toList());
        Boolean flag = this.imChatTemplate.sendMsg(componentsList, sendImMsgDTO);
        if (!flag.booleanValue()) {
            throw new BusinessException("\u6d88\u606f\u63a8\u9001\u5931\u8d25");
        }
        return "\u6d88\u606f\u63a8\u9001\u6210\u529f";
    }

    public BaseResponse<String> unReadMsgCount(ImMessageDTO imMessageDTO) {
        log.info("unReadMsgCount\u8bf7\u6c42\u5165\u53c2={}", (Object)imMessageDTO);
        QueryWrapper psWrapper = new QueryWrapper();
        PatientSignEntity patientSign = new PatientSignEntity();
        patientSign.setAdmId(imMessageDTO.getTreatmentId());
        patientSign.setSignStatus(SignStatus.SIGNED.getValue());
        patientSign.setStatus(StatusEnum.IN_CONSULTATION.getValue());
        psWrapper.setEntity((Object)patientSign);
        PatientSignEntity patientSignEntity = (PatientSignEntity)this.patientSignMapper.selectOne((Wrapper)psWrapper);
        if (Objects.nonNull(patientSignEntity)) {
            PatientEntity patientEntity;
            QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
            queryPersonnelInfoReq.setDoctorId(String.valueOf(patientSignEntity.getDoctorId()));
            BaseResponse doctorInfo = this.doctorInfofeignClient.queryPersonnelInfo(queryPersonnelInfoReq);
            UserInfoByUserIdRespVO userInfoByUserIdRespVO = this.queryDocAccountInfo(String.valueOf(patientSignEntity.getDoctorId()));
            if (userInfoByUserIdRespVO == null) {
                log.error("IM INFORM ERROR : \u83b7\u53d6\u533b\u751f\u4fe1\u606f\u5931\u8d25 doctorId\uff1a{}", (Object)String.valueOf(patientSignEntity.getDoctorId()));
                return BaseResponse.error((String)"\u83b7\u53d6im\u533b\u751f\u8d26\u53f7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (null == doctorInfo && !doctorInfo.isSuccess()) {
                log.error("IM INFORM ERROR : \u83b7\u53d6\u533b\u751f\u4fe1\u606f\u5931\u8d25 doctorId\uff1a{}", (Object)String.valueOf(patientSignEntity.getDoctorId()));
                return BaseResponse.error((String)"\u83b7\u53d6im\u533b\u751f\u8d26\u53f7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            String doctorUserId = userInfoByUserIdRespVO.getUserId();
            if (imMessageDTO.getSenderUserId().equals(doctorUserId) && Objects.nonNull(patientEntity = (PatientEntity)this.patientMapper.selectById((Serializable)((Object)patientSignEntity.getPatientId())))) {
                if (patientEntity.getOnOfflineStatus().equals(-1)) {
                    patientEntity.setUnReadCount(Integer.valueOf(patientEntity.getUnReadCount() + 1));
                } else {
                    patientEntity.setUnReadCount(Integer.valueOf(0));
                }
                this.patientMapper.updateById((Object)patientEntity);
                UnReadMsgDTO unReadMsgDTO = new UnReadMsgDTO();
                unReadMsgDTO.setPhone(patientSignEntity.getPatientPhone());
                ArrayList<InfoListDTO> infoList = new ArrayList<InfoListDTO>();
                InfoListDTO infoListDTO = new InfoListDTO();
                infoListDTO.setUserName(patientSignEntity.getPatientName());
                infoListDTO.setDoctorId(String.valueOf(patientSignEntity.getDoctorId()));
                infoListDTO.setMessageNum(String.valueOf(patientEntity.getUnReadCount()));
                infoListDTO.setGroupId(imMessageDTO.getRoomNum());
                String timestamp = "";
                try {
                    Date timestampDate = DateUtils.parseDate((String)imMessageDTO.getMsgTime(), (String)"yyyy-MM-dd HH:mm:ss");
                    timestamp = String.valueOf(timestampDate.getTime());
                }
                catch (Exception e) {
                    log.error("\u65e5\u5fd7\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                }
                infoListDTO.setTimestamp(timestamp);
                infoList.add(infoListDTO);
                unReadMsgDTO.setInfoList(infoList);
                this.thirdOrderPushUtil.syncUnReadMsgCount(unReadMsgDTO);
            }
        }
        return BaseResponse.success();
    }

    private UserInfoByUserIdRespVO queryDocAccountInfo(String doctorId) {
        BaseResponse response = this.userApiFeignClient.getUserInfoByDoctorId(doctorId);
        log.info("response:{}", (Object)JsonUtil.convertObject((Object)response));
        UserInfoByUserIdRespVO userInfoByUserIdRespVO = new UserInfoByUserIdRespVO();
        if (response.isSuccess()) {
            userInfoByUserIdRespVO.setUserId(((UserInfoByDoctorIdRespVO)response.getData()).getUserId());
            log.info("UserInfoByUserIdRespVO===>{}", (Object)JSON.toJSONString((Object)userInfoByUserIdRespVO));
            return userInfoByUserIdRespVO;
        }
        return null;
    }
}

