/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.family.doctor.common.dto.OrderDetailResDTO;
import com.ebaiyihui.family.doctor.common.dto.OrderListReqDTO;
import com.ebaiyihui.family.doctor.common.vo.GetPresListReqVO;
import com.ebaiyihui.family.doctor.common.vo.GetPresListResVO;
import com.ebaiyihui.family.doctor.common.vo.OrderDetailsResVo;
import com.ebaiyihui.family.doctor.common.vo.OrderInfo;
import com.ebaiyihui.family.doctor.common.vo.OrderListResVo;
import com.ebaiyihui.family.doctor.common.vo.QueryOrderTotalVo;
import com.ebaiyihui.family.doctor.server.common.constants.ProjProperties;
import com.ebaiyihui.family.doctor.server.entity.PatientEntity;
import com.ebaiyihui.family.doctor.server.entity.PatientSignEntity;
import com.ebaiyihui.family.doctor.server.feign.DoctorInfofeignClient;
import com.ebaiyihui.family.doctor.server.feign.IMSyncMsgClient;
import com.ebaiyihui.family.doctor.server.mapper.PatientMapper;
import com.ebaiyihui.family.doctor.server.mapper.PatientSignMapper;
import com.ebaiyihui.family.doctor.server.service.OrderManagementService;
import com.ebaiyihui.family.doctor.server.util.IDCardUtil;
import com.ebaiyihui.family.doctor.server.util.PageUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.HttpKit;
import com.ebaiyihui.imforward.client.vo.IMQueryMsgReqVO;
import com.ebaiyihui.imforward.client.vo.IMSingleMsgResultVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderManagementServiceImpl
implements OrderManagementService {
    private static final Logger log = LoggerFactory.getLogger(OrderManagementServiceImpl.class);
    @Autowired
    private PatientSignMapper patientSignMapper;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private DoctorInfofeignClient doctorInfofeignClient;
    @Autowired
    private IMSyncMsgClient imSyncMsgClient;

    public BaseResponse<PageUtil<OrderListResVo>> orderList(OrderListReqDTO param) {
        log.info("\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)param));
        param.setPageNum(Integer.valueOf((param.getPageNum() - 1) * param.getPageSize()));
        List records = this.patientSignMapper.orderList(param);
        PageUtil pageUtil = new PageUtil();
        pageUtil.setList(records);
        QueryOrderTotalVo totalVo = this.patientSignMapper.countSumOrder();
        pageUtil.setObject((Object)totalVo);
        return BaseResponse.success((Object)pageUtil);
    }

    public BaseResponse<OrderDetailsResVo> getOrderDetails(OrderDetailResDTO param) {
        log.info("\u67e5\u8be2\u8ba2\u5355\u8be6\u60c5\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)param));
        OrderDetailsResVo resVo = new OrderDetailsResVo();
        String orderId = param.getOrderId();
        PatientSignEntity patientSignEntity = (PatientSignEntity)this.patientSignMapper.selectById((Serializable)((Object)orderId));
        if (Objects.isNull(patientSignEntity)) {
            return BaseResponse.error((String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        resVo.setPresListResVOS(this.getPresList(patientSignEntity.getAdmId()));
        resVo.setOrderInfo(this.buildOrderInfo(patientSignEntity));
        resVo.setImSingleMsgResultVOS(this.queryImMsg(patientSignEntity));
        return BaseResponse.success((Object)resVo);
    }

    private List<IMSingleMsgResultVO> queryImMsg(PatientSignEntity patientSignEntity) {
        List<Object> imSingleMsgResultVOS = new ArrayList<IMSingleMsgResultVO>();
        IMQueryMsgReqVO reqVO = new IMQueryMsgReqVO();
        ArrayList<String> admIdList = new ArrayList<String>();
        admIdList.add(patientSignEntity.getAdmId());
        reqVO.setAppointmentId(admIdList);
        reqVO.setBusinessCode("jtys");
        reqVO.setPage(Integer.valueOf(0));
        reqVO.setPageSize(Integer.valueOf(9999));
        reqVO.setMsgType("1");
        reqVO.setUserId(patientSignEntity.getPatientUserId());
        BaseResponse listBaseResponse = this.imSyncMsgClient.queryImMsg(reqVO);
        List imSingleMsgResultVoS = (List)listBaseResponse.getData();
        if (null != imSingleMsgResultVoS) {
            Iterator it = imSingleMsgResultVoS.iterator();
            while (it.hasNext()) {
                IMSingleMsgResultVO x = (IMSingleMsgResultVO)it.next();
                if ("administrator".equals(x.getSender())) {
                    it.remove();
                    continue;
                }
                if (x.getSender().contains("EHOS_PATIENT")) {
                    x.setSender("EHOS_PATIENT");
                    continue;
                }
                if (!x.getSender().contains("EHOS_DOCTOR")) continue;
                x.setSender("EHOS_DOCTOR");
            }
            imSingleMsgResultVOS = imSingleMsgResultVoS.stream().sorted(Comparator.comparing(IMSingleMsgResultVO::getSendTime)).collect(Collectors.toList());
        }
        return imSingleMsgResultVOS;
    }

    private OrderInfo buildOrderInfo(PatientSignEntity patientSignEntity) {
        log.info("buildOrderInfo\uff1a{}", (Object)JSON.toJSONString((Object)patientSignEntity));
        PatientEntity patient = (PatientEntity)this.patientMapper.selectById((Serializable)((Object)patientSignEntity.getPatientId()));
        log.info("patient\uff1a{}", (Object)JSON.toJSONString((Object)patient));
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(String.valueOf(patientSignEntity.getDoctorId()));
        BaseResponse doctorInfo = this.doctorInfofeignClient.queryPersonnelInfo(queryPersonnelInfoReq);
        if (null == doctorInfo && !doctorInfo.isSuccess()) {
            log.error("IM INFORM ERROR : \u83b7\u53d6\u533b\u751f\u4fe1\u606f\u5931\u8d25 doctorId\uff1a{}", (Object)String.valueOf(patientSignEntity.getDoctorId()));
        }
        log.info("doctorInfo\uff1a{}", (Object)JSON.toJSONString((Object)doctorInfo));
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setOrderNo(patientSignEntity.getId());
        orderInfo.setPatientPhone(patientSignEntity.getPatientPhone());
        orderInfo.setPatientSex(patient.getGender());
        orderInfo.setPatientName(patient.getPatientName());
        orderInfo.setPatientAge(IDCardUtil.getAge((String)patient.getCredNo()));
        orderInfo.setDoctorPhone(((PersonnelInfo)doctorInfo.getData()).getPhoneNum());
        orderInfo.setDoctorName(patientSignEntity.getDoctorName());
        orderInfo.setDoctorTitle(((PersonnelInfo)doctorInfo.getData()).getTitle());
        orderInfo.setHospital(patientSignEntity.getOrganName());
        orderInfo.setFirstDepartment(patientSignEntity.getDeptName());
        log.info("orderInfo\uff1a{}", (Object)JSON.toJSONString((Object)orderInfo));
        return orderInfo;
    }

    private List<GetPresListResVO> getPresList(String admId) {
        GetPresListReqVO reqVo = new GetPresListReqVO();
        reqVo.setAdmId(admId);
        try {
            log.info("\u67e5\u8be2\u5904\u65b9\u5217\u8868URL:{},\u5165\u53c2{}, ", (Object)this.projProperties.getPresListByAdmId(), (Object)JSON.toJSONString((Object)reqVo));
            String body = HttpKit.jsonPost((String)this.projProperties.getPresListByAdmId(), (String)JSON.toJSONString((Object)reqVo));
            BaseResponse baseResponse = (BaseResponse)JSON.parseObject((String)body, BaseResponse.class);
            log.info("baseResponse:{} ", (Object)baseResponse);
            if (baseResponse.getData() == null) {
                return null;
            }
            List resVOList = (List)baseResponse.getData();
            log.info("\u67e5\u8be2\u5904\u65b9\u5217\u8868\u8fd4\u56de\u503c:{} ", (Object)resVOList);
            return resVOList;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5904\u65b9\u5217\u8868\u8c03\u7528\u5931\u8d25{}", (Object)e.getMessage());
            return null;
        }
    }
}

