/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.doctoruser.api.pojo.vo.UserInfoByDoctorIdRespVO;
import com.doctoruser.api.pojo.vo.UserInfoByUserIdRespVO;
import com.ebaiyihui.family.doctor.common.bo.Message;
import com.ebaiyihui.family.doctor.common.bo.MessageInfo;
import com.ebaiyihui.family.doctor.common.bo.PatientSignInfo;
import com.ebaiyihui.family.doctor.common.bo.PersonImInformReq;
import com.ebaiyihui.family.doctor.common.vo.BaseInfoByAdmIdVO;
import com.ebaiyihui.family.doctor.common.vo.PatientCaseDetail;
import com.ebaiyihui.family.doctor.common.vo.TreatmentCard;
import com.ebaiyihui.family.doctor.common.vo.cloudHis.DiagnosticDetailReqDTO;
import com.ebaiyihui.family.doctor.common.vo.cloudHis.DiagnosticReqDTO;
import com.ebaiyihui.family.doctor.common.vo.cloudHis.HisDeptAndDocCodeVo;
import com.ebaiyihui.family.doctor.common.vo.cloudHis.ICDSearchNameReqVO;
import com.ebaiyihui.family.doctor.common.vo.cloudHis.ICDSearchNameResVO;
import com.ebaiyihui.family.doctor.common.vo.cloudHis.PatientDynamicMedicalVo;
import com.ebaiyihui.family.doctor.server.common.constants.IMInformConstants;
import com.ebaiyihui.family.doctor.server.common.constants.ProjProperties;
import com.ebaiyihui.family.doctor.server.entity.PatientEntity;
import com.ebaiyihui.family.doctor.server.entity.PatientSignEntity;
import com.ebaiyihui.family.doctor.server.exception.BusinessException;
import com.ebaiyihui.family.doctor.server.feign.DoctorInfofeignClient;
import com.ebaiyihui.family.doctor.server.feign.IMPushMsgFeignClient;
import com.ebaiyihui.family.doctor.server.feign.UserApiFeignClient;
import com.ebaiyihui.family.doctor.server.mapper.PatientMapper;
import com.ebaiyihui.family.doctor.server.mapper.PatientSignMapper;
import com.ebaiyihui.family.doctor.server.service.HisTemplateService;
import com.ebaiyihui.family.doctor.server.service.PatientMedicalRecordService;
import com.ebaiyihui.family.doctor.server.util.JsonUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.HttpKit;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.imforward.client.vo.AccountVO;
import com.ebaiyihui.imforward.client.vo.PushSingleMsgDataVO;
import com.ebaiyihui.imforward.client.vo.PushSingleMsgReqVO;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.MedicalSortReqVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.MedicalSortVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalEntityVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalIdByAdmIdVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PatientMedicalRecordServiceImpl
implements PatientMedicalRecordService {
    private static final Logger log = LoggerFactory.getLogger(PatientMedicalRecordServiceImpl.class);
    @Autowired
    private PatientSignMapper patientSignMapper;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private DoctorInfofeignClient doctorInfofeignClient;
    @Autowired
    private UserApiFeignClient userApiFeignClient;
    @Autowired
    private IMPushMsgFeignClient imPushMsgFeignClient;
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private HisTemplateService hisTemplateService;

    public PatientCaseDetail getMedicalInfoByAdmId(String admId) {
        log.info("\u6839\u636e\u5c31\u8bcaid\u67e5\u75c5\u4f8b\u8be6\u60c5\u5165\u53c2:{} ", (Object)admId);
        try {
            PatientDynamicMedicalIdByAdmIdVo patientDynamicMedicalIdByAdmIdVo = new PatientDynamicMedicalIdByAdmIdVo();
            patientDynamicMedicalIdByAdmIdVo.setAdmId(admId);
            log.info("\u67e5\u8be2\u75c5\u4f8b\u8be6\u60c5URL:{}, ", (Object)this.projProperties.getMedicalInfoByAdmId());
            String body = HttpKit.jsonPost((String)this.projProperties.getMedicalInfoByAdmId(), (String)JSON.toJSONString((Object)patientDynamicMedicalIdByAdmIdVo));
            BaseResponse baseResponse = (BaseResponse)JSON.parseObject((String)body, BaseResponse.class);
            if (baseResponse.getData() == null) {
                return null;
            }
            PatientDynamicMedicalEntityVo patientDynamicMedicalEntityVo = (PatientDynamicMedicalEntityVo)JSON.parseObject((String)JSON.toJSONString((Object)baseResponse.getData()), PatientDynamicMedicalEntityVo.class);
            log.info("\u6839\u636e\u5c31\u8bcaid\u67e5\u75c5\u4f8b\u8be6\u60c5\u8fd4\u56de\u503c:{} ", (Object)patientDynamicMedicalEntityVo.toString());
            PatientCaseDetail patientCaseDetail = new PatientCaseDetail();
            BeanUtils.copyProperties((Object)patientDynamicMedicalEntityVo, (Object)patientCaseDetail);
            return patientCaseDetail;
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u5c31\u8bcaid\u67e5\u75c5\u4f8b\u8be6\u60c5\u8c03\u7528\u5931\u8d25{}", (Object)e.getMessage());
            return null;
        }
    }

    public BaseResponse<Object> treatmentCard(String admissionId) {
        PatientSignInfo patientSignInfo = this.getPatientSignInfo(admissionId);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        messageInfos.add(this.getInformCustomPersonDocParam(patientSignInfo, (Object)this.getTreatmentCard(admissionId), "treatmentCard"));
        messageInfos.add(this.getInformCustomPerPatientParam(patientSignInfo, (Object)this.getTreatmentCard(admissionId), "treatmentCard"));
        if (this.pushImInform(messageInfos, admissionId)) {
            log.info("IM INFORM COMPLETE \u533b\u751f\u5f00\u5177\u590d\u8bca\u75c5\u4f8b\u63a8\u9001\u5361\u7247\uff0cadmissionId:{}", (Object)admissionId);
        }
        this.nczkSaveDiagnosToHis(patientSignInfo, admissionId);
        return BaseResponse.success();
    }

    private String[] primaryDiagnoToArray(String primaryDiagno) {
        if (StringUtils.isEmpty((CharSequence)primaryDiagno)) {
            return null;
        }
        primaryDiagno = primaryDiagno.replaceAll("\\\\", "");
        return primaryDiagno.split(";");
    }

    private List<ICDSearchNameResVO> icdSearchName(ICDSearchNameReqVO reqVo) {
        ArrayList<ICDSearchNameResVO> icdNames = new ArrayList();
        try {
            log.info("\u67e5\u8be2\u8bca\u65ad\u540d\u79f0URL:{},\u5165\u53c2{}, ", (Object)this.projProperties.getIcdSearchName(), (Object)JSON.toJSONString((Object)reqVo));
            String body = HttpKit.jsonPost((String)this.projProperties.getIcdSearchName(), (String)JSON.toJSONString((Object)reqVo));
            BaseResponse baseResponse = (BaseResponse)JSON.parseObject((String)body, BaseResponse.class);
            if (baseResponse.getData() == null) {
                return null;
            }
            icdNames = (List)JSON.parseObject((String)JSONObject.toJSONString((Object)baseResponse.getData()), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            log.info("\u67e5\u8be2\u8bca\u65ad\u540d\u79f0\u8fd4\u56de\u503c:{} ", icdNames);
            return icdNames;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u8bca\u65ad\u540d\u79f0\u8fd4\u8c03\u7528\u5931\u8d25{}", (Object)e.getMessage());
            return null;
        }
    }

    private void nczkSaveDiagnosToHis(PatientSignInfo orderEntity, String admissionId) {
        log.info("\u5357\u660c\u4f17\u5eb7\u8bca\u65ad\u4fe1\u606f\u5165\u53c2\u6570:orderEntity:{},admissionInfo:{}", (Object)orderEntity, (Object)admissionId);
        DiagnosticReqDTO diagnosticReqDTO = new DiagnosticReqDTO();
        PatientCaseDetail entityVo = this.getMedicalInfoByAdmId(admissionId);
        if (Objects.isNull(entityVo)) {
            log.error("\u672a\u67e5\u8be2\u5230\u75c5\u5386\u4fe1\u606f");
            return;
        }
        PatientDynamicMedicalVo medicalDetailVo = new PatientDynamicMedicalVo();
        if (StringUtils.isNotEmpty((CharSequence)entityVo.getMedicalDetail())) {
            medicalDetailVo = (PatientDynamicMedicalVo)JSON.parseObject((String)entityVo.getMedicalDetail(), PatientDynamicMedicalVo.class);
        }
        diagnosticReqDTO.setChiefComplaint(entityVo.getMainSuit());
        diagnosticReqDTO.setPresentMedicalHistory(medicalDetailVo.getPresentHistory());
        diagnosticReqDTO.setHandleOpinion(medicalDetailVo.getHandle());
        diagnosticReqDTO.setOutpatientNo(orderEntity.getClinicCode());
        diagnosticReqDTO.setPhysicalExam(medicalDetailVo.getPhysicalExamination());
        diagnosticReqDTO.setAuxiliaryInspection(medicalDetailVo.getAuxiliaryExamination());
        log.info("entityVo.getPrimaryDiagno:{}", (Object)entityVo.getPrimaryDiagno());
        String primaryDiagno = entityVo.getPrimaryDiagno();
        String[] primaryDiagnoArray = this.primaryDiagnoToArray(primaryDiagno);
        log.info("primaryDiagno:{},primaryDiagnoArray:{}", (Object)primaryDiagno, (Object)primaryDiagnoArray);
        if (Objects.isNull(primaryDiagnoArray)) {
            log.error("\u672a\u67e5\u8be2\u5230\u8bca\u65ad\u4fe1\u606f");
            return;
        }
        ArrayList<DiagnosticDetailReqDTO> detailReqDTOList = new ArrayList<DiagnosticDetailReqDTO>(primaryDiagno.length());
        for (String diagno : primaryDiagnoArray) {
            ICDSearchNameReqVO reVo = new ICDSearchNameReqVO();
            reVo.setKeyword(diagno);
            List icdNames = this.icdSearchName(reVo);
            if (CollectionUtils.isEmpty((Collection)icdNames)) continue;
            DiagnosticDetailReqDTO detailReqDTO = new DiagnosticDetailReqDTO();
            detailReqDTO.setDiagnosis(diagno);
            detailReqDTO.setIcdCode(((ICDSearchNameResVO)icdNames.get(0)).getCode());
            log.info("icd\u4fe1\u606f:param:{},result:{}", (Object)diagno, (Object)JSON.toJSONString((Object)icdNames));
            detailReqDTOList.add(detailReqDTO);
        }
        diagnosticReqDTO.setDiagnosis(detailReqDTOList);
        try {
            log.info("\u5357\u660c\u4f17\u5eb7\u8bca\u65ad\u4fdd\u5b58\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)diagnosticReqDTO));
            FrontResponse response = this.hisTemplateService.saveDiagnostic(diagnosticReqDTO);
            log.info("\u5357\u660c\u4f17\u65ad\u4fdd\u5b58\u8fd4\u56de\u503c:{}", (Object)JSONObject.toJSONString((Object)response));
        }
        catch (Exception e) {
            log.error("\u5357\u660c\u4f17\u5eb7\u8bca\u65ad\u4fdd\u5b58\u8fd4\u56de\u503c:{}", (Object)e.getMessage());
        }
    }

    public BaseResponse<Object> getBaseInfoByAdmId(String admId) {
        PatientCaseDetail medicalInfoByAdmId;
        log.info("\u6839\u636e\u5c31\u8bcaid\u67e5\u8be2\u60a3\u8005\u533b\u751f\u57fa\u7840\u4fe1\u606f\u5165\u53c2admId:{}", (Object)admId);
        if (StringUtils.isEmpty((CharSequence)admId)) {
            throw new BusinessException("amdId\u4e0d\u80fd\u672a\u7a7a");
        }
        BaseInfoByAdmIdVO baseInfoByAdmIdVO = new BaseInfoByAdmIdVO();
        PatientSignEntity patientSignEntity = this.patientSignMapper.queryByAdmId(admId);
        log.info("patientSignMapper.queryByAdmId\u8fd4\u56de\u503c:{} ", (Object)JSON.toJSONString((Object)patientSignEntity));
        PatientSignInfo patientSignInfo = this.getPatientSignInfo(admId);
        log.info("getPatientSignInfo\u8fd4\u56de\u503c:{} ", (Object)JSON.toJSONString((Object)patientSignInfo));
        BeanUtils.copyProperties((Object)patientSignInfo, (Object)baseInfoByAdmIdVO);
        if (patientSignEntity != null) {
            PatientEntity patientEntity;
            BeanUtils.copyProperties((Object)patientSignEntity, (Object)baseInfoByAdmIdVO);
            baseInfoByAdmIdVO.setDoctorId(String.valueOf(patientSignEntity.getDoctorId()));
            baseInfoByAdmIdVO.setDeptId(String.valueOf(patientSignEntity.getDeptId()));
            baseInfoByAdmIdVO.setOrderId(String.valueOf(patientSignEntity.getId()));
            baseInfoByAdmIdVO.setClinicCode(patientSignEntity.getClinicCode());
            HisDeptAndDocCodeVo hisDeptAndDocCode = this.hisTemplateService.getHisDeptAndDocCode(patientSignEntity.getDeptId().toString(), patientSignEntity.getDoctorId().toString());
            log.info("hisDeptAndDocCode\u8fd4\u56de\u503c:{} ", (Object)JSON.toJSONString((Object)hisDeptAndDocCode));
            if (hisDeptAndDocCode != null) {
                baseInfoByAdmIdVO.setHisDeptCode(hisDeptAndDocCode.getDeptCode());
                baseInfoByAdmIdVO.setHisDeptName(hisDeptAndDocCode.getDeptName());
                baseInfoByAdmIdVO.setHisDoctorCode(hisDeptAndDocCode.getDoctorCode());
                baseInfoByAdmIdVO.setHisDoctorName(hisDeptAndDocCode.getDoctorName());
            }
            if ((patientEntity = (PatientEntity)this.patientMapper.selectById((Serializable)((Object)patientSignEntity.getPatientId()))) != null) {
                BeanUtils.copyProperties((Object)patientEntity, (Object)baseInfoByAdmIdVO);
                baseInfoByAdmIdVO.setPatientGender(String.valueOf(patientEntity.getGender()));
            }
        }
        if ((medicalInfoByAdmId = this.getMedicalInfoByAdmId(admId)) != null && medicalInfoByAdmId.getPrimaryDiagno() != null) {
            baseInfoByAdmIdVO.setIcdNames(medicalInfoByAdmId.getPrimaryDiagno());
            baseInfoByAdmIdVO.setMainSuit(medicalInfoByAdmId.getMainSuit());
        }
        log.info("\u6839\u636e\u5c31\u8bcaid\u67e5\u8be2\u60a3\u8005\u533b\u751f\u57fa\u7840\u4fe1\u606f\u8fd4\u56de\u503c:{} ", (Object)JSON.toJSONString((Object)baseInfoByAdmIdVO));
        return BaseResponse.success((Object)baseInfoByAdmIdVO);
    }

    private <T> MessageInfo getInformCustomPersonDocParam(PatientSignInfo admissionInfo, T content, String businessCode) {
        String doctorUserId = admissionInfo.getDoctorUserId();
        if (StringUtils.isEmpty((CharSequence)doctorUserId)) {
            log.error("IM INFORM ERROR : \u65e0\u6cd5\u67e5\u8be2\u5230\u63a5\u6536\u4eba\u4fe1\u606f");
            return new MessageInfo();
        }
        MessageInfo messageInfo = new MessageInfo();
        Message message = new Message();
        message.setMessageType(IMInformConstants.SERVICE_SYSTEM_FREE_TYPE);
        message.setBusinessCode(businessCode);
        message.setApplicationCode("jtys");
        message.setAdmissionId(admissionInfo.getAdmId());
        message.setData(content);
        message.setApplicationCode("jtys");
        messageInfo.setSingleAccount(this.newAccount("EHOS_DOCTOR", doctorUserId));
        messageInfo.setSelfAccount(this.newAccount("EHOS_PATIENT", admissionInfo.getPatientUserId()));
        messageInfo.setMessage(message);
        return messageInfo;
    }

    private AccountVO newAccount(String appCode, String userId) {
        AccountVO accountVO = new AccountVO();
        accountVO.setAppCode(appCode);
        accountVO.setUserId(userId);
        return accountVO;
    }

    private <T> MessageInfo getInformCustomPerPatientParam(PatientSignInfo admissionInfo, T content, String businessCode) {
        String patientUserId = admissionInfo.getPatientUserId();
        if (StringUtils.isEmpty((CharSequence)patientUserId)) {
            log.error("IM INFORM ERROR : \u65e0\u6cd5\u67e5\u8be2\u5230\u63a5\u6536\u4eba\u4fe1\u606f");
            return new MessageInfo();
        }
        MessageInfo messageInfo = new MessageInfo();
        Message message = new Message();
        message.setMessageType(IMInformConstants.SERVICE_SYSTEM_FREE_TYPE);
        message.setBusinessCode(businessCode);
        message.setAdmissionId(admissionInfo.getAdmId());
        message.setApplicationCode("jtys");
        message.setData(content);
        message.setApplicationCode("jtys");
        messageInfo.setSingleAccount(this.newAccount("EHOS_PATIENT", patientUserId));
        messageInfo.setSelfAccount(this.newAccount("EHOS_DOCTOR", admissionInfo.getDoctorUserId()));
        messageInfo.setMessage(message);
        return messageInfo;
    }

    private TreatmentCard getTreatmentCard(String admissionId) {
        TreatmentCard treatmentCard = new TreatmentCard();
        PatientCaseDetail medicalInfoByAdmId = this.getMedicalInfoByAdmId(admissionId);
        if (null == medicalInfoByAdmId) {
            log.info("\u75c5\u4f8b\u8be6\u60c5\u67e5\u8be2\u9519\u8bef,\u67e5\u8be2\u4e3a\u7a7a");
            return null;
        }
        List list = new ArrayList();
        list = this.getMedicalUserFills(medicalInfoByAdmId.getServType(), medicalInfoByAdmId.getMedicalDetail(), medicalInfoByAdmId.getHospitalId(), medicalInfoByAdmId.getDeptId());
        log.info("list:{}", (Object)JSON.toJSONString(list));
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        treatmentCard.setMedicalRecordId(medicalInfoByAdmId.getXId());
        treatmentCard.setMedicalUserFills(list);
        log.info("caseHistory:{}", (Object)treatmentCard);
        return treatmentCard;
    }

    private PatientSignInfo getPatientSignInfo(String admId) {
        QueryWrapper wrapper = new QueryWrapper();
        PatientSignEntity patientSign = new PatientSignEntity();
        patientSign.setAdmId(admId);
        wrapper.setEntity((Object)patientSign);
        PatientSignEntity patientSignEntity = (PatientSignEntity)this.patientSignMapper.selectOne((Wrapper)wrapper);
        if (patientSignEntity == null) {
            log.error("IM INFORM ERROR : \u6ca1\u6709\u67e5\u8be2\u5230\u5c31\u8bca\u4fe1\u606f\uff0cadmId:{}", (Object)admId);
            return new PatientSignInfo();
        }
        PatientSignInfo patientSignInfo = new PatientSignInfo();
        BeanUtils.copyProperties((Object)patientSignEntity, (Object)patientSignInfo);
        patientSignInfo.setSignedId(patientSignEntity.getId());
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(String.valueOf(patientSignEntity.getDoctorId()));
        BaseResponse doctorInfo = this.doctorInfofeignClient.queryPersonnelInfo(queryPersonnelInfoReq);
        UserInfoByUserIdRespVO userInfoByUserIdRespVO = this.queryDocAccountInfo(String.valueOf(patientSignEntity.getDoctorId()));
        if (userInfoByUserIdRespVO == null) {
            log.error("IM INFORM ERROR : \u83b7\u53d6\u533b\u751f\u4fe1\u606f\u5931\u8d25 doctorId\uff1a{}", (Object)String.valueOf(patientSignEntity.getDoctorId()));
            return new PatientSignInfo();
        }
        if (null == doctorInfo && !doctorInfo.isSuccess()) {
            log.error("IM INFORM ERROR : \u83b7\u53d6\u533b\u751f\u4fe1\u606f\u5931\u8d25 doctorId\uff1a{}", (Object)String.valueOf(patientSignEntity.getDoctorId()));
            return new PatientSignInfo();
        }
        patientSignInfo.setDoctorUserId(userInfoByUserIdRespVO.getUserId());
        patientSignInfo.setDoctorHeadPortrait(((PersonnelInfo)doctorInfo.getData()).getPortrait());
        patientSignInfo.setDoctorProfessional(((PersonnelInfo)doctorInfo.getData()).getTitle());
        log.info("patientSignInfo:{}" + JSON.toJSONString((Object)patientSignInfo));
        return patientSignInfo;
    }

    private UserInfoByUserIdRespVO queryDocAccountInfo(String doctorId) {
        BaseResponse response = this.userApiFeignClient.getUserInfoByDoctorId(doctorId);
        log.info("response:{}", (Object)JsonUtil.convertObject((Object)response));
        UserInfoByUserIdRespVO userInfoByUserIdRespVO = new UserInfoByUserIdRespVO();
        if (response.isSuccess()) {
            userInfoByUserIdRespVO.setUserId(((UserInfoByDoctorIdRespVO)response.getData()).getUserId());
            log.info("UserInfoByUserIdRespVO===>{}", (Object)JSON.toJSONString((Object)userInfoByUserIdRespVO));
            return userInfoByUserIdRespVO;
        }
        return null;
    }

    private boolean pushImInform(List<MessageInfo> messageInfos, String admissionId) {
        boolean flag = true;
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admissionId);
        parameter.setBusiCode("jtys");
        flag = this.personImInform(parameter);
        return flag;
    }

    private boolean personImInform(PersonImInformReq param) {
        List messageInfos = param.getMessageInfos();
        if (messageInfos == null || messageInfos.isEmpty()) {
            log.error("IM INFORM ERROR : \u6ca1\u6709\u53ef\u53d1\u9001\u7684\u6d88\u606f");
            return false;
        }
        ArrayList msgSingleDatas = new ArrayList();
        messageInfos.forEach(e -> {
            PushSingleMsgDataVO msgsingleData = new PushSingleMsgDataVO();
            msgsingleData.setActionType("system");
            msgsingleData.setFromAccount(e.getSelfAccount());
            msgsingleData.setToAccount(e.getSingleAccount());
            msgsingleData.setMessage(JsonUtil.convertObject((Object)e.getMessage()));
            msgSingleDatas.add(msgsingleData);
        });
        PushSingleMsgReqVO parameter = new PushSingleMsgReqVO();
        parameter.setBusiCode(param.getBusiCode());
        parameter.setUniqueId(param.getAdmissionId());
        parameter.setMsgData(msgSingleDatas);
        log.info("\u63a8\u9001\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)parameter));
        boolean pushFlag = this.pushSingleIm(parameter);
        if (!pushFlag) {
            log.info("IM INFORM ERROR : im \u8c03\u7528im\u7cfb\u7edf\u63a8\u9001\u5931\u8d25");
            return false;
        }
        return true;
    }

    private boolean pushSingleIm(PushSingleMsgReqVO reqVO) {
        log.info("\u8c03\u7528IM\u7b2c\u4e09\u65b9reqVO:{}", (Object)JSON.toJSONString((Object)reqVO));
        BaseResponse response = this.imPushMsgFeignClient.pushSingleMsg(reqVO);
        log.info("\u53d1\u9001IM\u5355\u4eba\u63a8\u9001:{}", (Object)response.toString());
        return response.isSuccess();
    }

    public List<MedicalSortVo> getMedicalUserFills(Integer servType, String medicalDetail, String hospitalId, String deptId) {
        try {
            MedicalSortReqVo medicalSortReqVo = new MedicalSortReqVo();
            medicalSortReqVo.setMedicalUserFills(medicalDetail);
            medicalSortReqVo.setHospitalId(hospitalId);
            medicalSortReqVo.setServType(servType);
            if (servType == 5) {
                medicalSortReqVo.setDeptId(deptId);
            }
            log.info("\u83b7\u53d6\u60a3\u8005\u586b\u5199\u7684\u75c5\u4f8b\u5165\u53c2==>{}", (Object)JSON.toJSONString((Object)medicalSortReqVo));
            String body = HttpKit.jsonPost((String)this.projProperties.getGetMedicalUserFills(), (String)JSON.toJSONString((Object)medicalSortReqVo));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            List medicalSortVos = JSON.parseArray((String)JSON.toJSONString((Object)baseResponse.getData()), MedicalSortVo.class);
            log.info("\u83b7\u53d6\u60a3\u8005\u586b\u5199\u7684\u75c5\u4f8b\u8fd4\u56de\u503c: " + medicalSortVos.toString());
            return medicalSortVos;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u60a3\u8005\u586b\u5199\u7684\u75c5\u4f8b\u8c03\u7528\u5931\u8d25" + e.getMessage());
            return null;
        }
    }
}

