/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.task;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.family.doctor.server.common.enums.WhetherEnum;
import com.ebaiyihui.family.doctor.server.entity.ScheduleRecordEntity;
import com.ebaiyihui.family.doctor.server.mapper.ScheduleRecordMapper;
import com.ebaiyihui.family.doctor.server.util.DateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ScheduleTask {
    private static final Logger log = LoggerFactory.getLogger(ScheduleTask.class);
    private static final String MONDAY = "\u661f\u671f\u4e00";
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;

    @Scheduled(cron="0 0 0 * * ?")
    public void regularTimeExport() {
        String currentDateSimpleToString = DateUtils.getCurrentDateSimpleToString();
        log.info("\u5f53\u524d\u65f6\u95f4{}", (Object)JSON.toJSONString((Object)currentDateSimpleToString));
        String weekChinese = DateUtils.getWeekChinese((String)currentDateSimpleToString);
        log.info("\u5f53\u524d\u65f6\u95f4\u662f{}", (Object)JSON.toJSONString((Object)weekChinese));
        if (!MONDAY.equals(weekChinese)) {
            return;
        }
        String oneDayForWeekLast = DateUtils.getOneDayForWeekLast((String)currentDateSimpleToString);
        Date weekDateFirst = DateUtils.strToDateNoTry((String)currentDateSimpleToString);
        Date weekDateLast = DateUtils.strToDateNoTry((String)oneDayForWeekLast);
        List dateRange = DateUtils.getDateRange((Date)weekDateFirst, (Date)weekDateLast);
        log.info("\u4e00\u5468\u7684\u65e5\u671f{}", (Object)JSON.toJSONString((Object)dateRange));
        for (String schDate : dateRange) {
            QueryWrapper schWapper = new QueryWrapper();
            ScheduleRecordEntity scheduleRecordEntity = new ScheduleRecordEntity();
            scheduleRecordEntity.setIsCycleSchedule(WhetherEnum.ALLOW.getValue());
            scheduleRecordEntity.setScheduleDate(DateUtils.strToDateNoTry((String)schDate));
            schWapper.setEntity((Object)scheduleRecordEntity);
            log.info("\u67d0\u5929\u5f00\u901a\u5faa\u73af\u6392\u73ed\u5217\u8868\u5165\u53c2{}", (Object)JSON.toJSONString((Object)schWapper));
            List list = this.scheduleRecordMapper.selectList((Wrapper)schWapper);
            log.info("\u67d0\u5929\u5f00\u901a\u5faa\u73af\u6392\u73ed\u5217\u8868\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)list));
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            Map<Integer, List<ScheduleRecordEntity>> servTypeCollect = list.stream().collect(Collectors.groupingBy(ScheduleRecordEntity::getServType));
            for (Integer servType : servTypeCollect.keySet()) {
                List<ScheduleRecordEntity> servTypeList = servTypeCollect.get(servType);
                Map<String, List<ScheduleRecordEntity>> doctorCollect = servTypeList.stream().collect(Collectors.groupingBy(ScheduleRecordEntity::getDoctorId));
                for (String docId : doctorCollect.keySet()) {
                    List<ScheduleRecordEntity> scheduleDeptList = doctorCollect.get(docId);
                    Map<String, List<ScheduleRecordEntity>> deptCollect = scheduleDeptList.stream().collect(Collectors.groupingBy(ScheduleRecordEntity::getDeptId));
                    for (String deptId : deptCollect.keySet()) {
                        List<ScheduleRecordEntity> rangeList = deptCollect.get(deptId);
                        QueryWrapper nextWrapper = new QueryWrapper();
                        ScheduleRecordEntity nextSchedule = new ScheduleRecordEntity();
                        nextSchedule.setStatus(WhetherEnum.ALLOW.getValue());
                        nextSchedule.setDoctorId(docId);
                        nextSchedule.setDeptId(deptId);
                        nextSchedule.setServType(servType);
                        nextSchedule.setScheduleDate(DateUtils.getNextWeek((String)schDate, (Integer)3));
                        nextWrapper.setEntity((Object)nextSchedule);
                        log.info("\u7b2c5\u5468\u5f53\u5929\u6392\u73ed\u5165\u53c2{}", (Object)JSON.toJSONString((Object)schWapper));
                        List nextScheList = this.scheduleRecordMapper.selectList((Wrapper)nextWrapper);
                        log.info("\u7b2c5\u5468\u5f53\u5929\u6392\u73ed\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)nextScheList));
                        if (CollectionUtils.isEmpty((Collection)nextScheList)) {
                            rangeList.stream().forEach(rangeVo -> {
                                ScheduleRecordEntity schedule = new ScheduleRecordEntity();
                                BeanUtils.copyProperties((Object)rangeVo, (Object)schedule);
                                schedule.setStatus(WhetherEnum.ALLOW.getValue());
                                schedule.setScheduleDate(DateUtils.getNextWeek((String)schDate, (Integer)3));
                                log.info("\u6392\u73ed\u65b0\u589e\u5165\u53c2:" + schedule.toString());
                                this.scheduleRecordMapper.insert((Object)schedule);
                            });
                            continue;
                        }
                        ArrayList<ScheduleRecordEntity> rangeSch = new ArrayList<ScheduleRecordEntity>();
                        for (ScheduleRecordEntity rangeReq : rangeList) {
                            Boolean flag = false;
                            for (ScheduleRecordEntity rangeRes : nextScheList) {
                                Boolean aBoolean = DateUtils.rangeCompare((Date)DateUtils.strToDateNoTryForMinute((String)rangeReq.getStartTime()), (Date)DateUtils.strToDateNoTryForMinute((String)rangeReq.getEndTime()), (Date)DateUtils.strToDateNoTryForMinute((String)rangeRes.getStartTime()), (Date)DateUtils.strToDateNoTryForMinute((String)rangeRes.getEndTime()));
                                if (!aBoolean.booleanValue()) continue;
                                flag = true;
                                break;
                            }
                            if (flag.booleanValue()) continue;
                            rangeSch.add(rangeReq);
                        }
                        if (CollectionUtils.isEmpty(rangeSch)) continue;
                        log.info("rangeList{}", (Object)JSON.toJSONString(rangeSch));
                        rangeSch.stream().forEach(rangeVo -> {
                            ScheduleRecordEntity schedule = new ScheduleRecordEntity();
                            BeanUtils.copyProperties((Object)rangeVo, (Object)schedule);
                            schedule.setStatus(WhetherEnum.ALLOW.getValue());
                            schedule.setScheduleDate(DateUtils.getNextWeek((String)schDate, (Integer)3));
                            log.info("\u6392\u73ed\u65b0\u589e\u5165\u53c2:" + schedule.toString());
                            this.scheduleRecordMapper.insert((Object)schedule);
                        });
                    }
                }
            }
        }
    }
}

