/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.family.doctor.server.util;

import com.ebaiyihui.family.doctor.server.common.enums.ScheduleRecordEnum;
import com.ebaiyihui.family.doctor.server.common.enums.WhetherEnum;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtils {
    public static final String FULL_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String SIMPLE_FORMAT = "yyyy-MM-dd";
    public static final String FORMAT = "yyyyMMddHHmmss";
    public static final String SIMPLE_NOSPE_FORMAT = "yyyyMMdd";
    public static final String SIMPLE_TIME_FORMAT = "HH:mm:ss";
    public static final String SIMPLE_TIME_FORMAT_MINUTE = "mm:ss";
    public static final String YEAR = "yyyy";

    public static String toDayHourMinuteString(int minute) {
        if (0 == minute) {
            return "24\u5c0f\u65f6";
        }
        if (0 < minute && minute < 60) {
            return minute + "\u5206\u949f";
        }
        if (60 <= minute && minute < 1440) {
            if (minute % 60 == 0) {
                int h = minute / 60;
                return h + "\u5c0f\u65f6";
            }
            int h = minute / 60;
            int m = minute % 60;
            return h + "\u5c0f\u65f6" + m + "\u5206\u949f";
        }
        if (minute >= 1440) {
            int d = minute / 60 / 24;
            int h = minute / 60 % 24;
            int m = minute % 60;
            String s1 = null;
            if (d > 0) {
                s1 = d + "\u5929";
            }
            if (h >= 1) {
                s1 = s1 + h + "\u5c0f\u65f6";
            }
            if (m > 0) {
                s1 = s1 + m + "\u5206\u949f";
            }
            return s1;
        }
        return null;
    }

    public static String getDate(String date) {
        String[] s1 = date.split(" ");
        String dateStr = s1[0];
        String dateFormart = "yyyy-MM-dd";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String newDateStr = null;
        try {
            newDateStr = format.format(format.parse(dateStr));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return newDateStr;
    }

    public static String secondToDateTime(long second) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(second * 1000L);
        java.util.Date date = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = format.format(date);
        return dateString;
    }

    public static String tosecondString(String str) {
        Integer second = Integer.valueOf(str);
        String h1 = null;
        String m1 = null;
        String s1 = null;
        if (second < 60) {
            return "00:00:" + str;
        }
        if (60 <= second && second < 3600) {
            Integer m = second / 60;
            m1 = 0 <= m && m < 10 ? "0" + m : m.toString();
            Integer s = second % 60;
            s1 = 0 <= s && s < 10 ? "0" + s : s.toString();
            return "00:" + m1 + ":" + s1;
        }
        if (second >= 3600) {
            Integer h = second / 3600;
            h1 = 0 <= h && h < 10 ? "0" + h : h.toString();
            Integer m = second % 3600 / 60;
            m1 = 0 <= m && m < 10 ? "0" + m : m.toString();
            Integer s = second % 3600 % 60;
            s1 = 0 <= s && s < 10 ? "0" + s : s.toString();
            return h1 + ":" + m1 + ":" + s1;
        }
        return null;
    }

    public static String getCurrentTime() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        return df.format(calendar.getTime());
    }

    public static java.util.Date getDateBefore(java.util.Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) - day);
        return now.getTime();
    }

    public static java.util.Date getDateAfter(java.util.Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(5, now.get(5) + day);
        return now.getTime();
    }

    public static java.util.Date getAddMonth(java.util.Date date, int month) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(2, month);
        return now.getTime();
    }

    public static java.util.Date getSubtractMonth(java.util.Date date, int month) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(2, -month);
        return now.getTime();
    }

    public static java.util.Date getAddYear(java.util.Date date, int year) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(1, year);
        return now.getTime();
    }

    public static java.util.Date getSubtractYear(java.util.Date date, int year) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(1, -year);
        return now.getTime();
    }

    private static Calendar initCurrentDate() {
        java.util.Date date = new java.util.Date(System.currentTimeMillis());
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c;
    }

    public static int getCurrentYear() {
        Calendar c = DateUtils.initCurrentDate();
        return c.get(1);
    }

    public static int getCurrentMonth() {
        return DateUtils.initCurrentDate().get(2) + 1;
    }

    public static int getCurrentDay() {
        return DateUtils.initCurrentDate().get(5);
    }

    public static int getCurrentHour() {
        return DateUtils.initCurrentDate().get(11);
    }

    public static int getCurrentMinute() {
        return DateUtils.initCurrentDate().get(12);
    }

    public static int getCurrentSecond() {
        return DateUtils.initCurrentDate().get(13);
    }

    public static String getCurrentDate(String format) {
        SimpleDateFormat parse = new SimpleDateFormat(format);
        return parse.format(new java.util.Date());
    }

    public static java.util.Date parseDate(String str, String parsePatterns) throws ParseException {
        if (str == null || parsePatterns == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        SimpleDateFormat parser = null;
        ParsePosition pos = new ParsePosition(0);
        parser = new SimpleDateFormat(parsePatterns);
        pos.setIndex(0);
        java.util.Date date = parser.parse(str, pos);
        if (date != null && pos.getIndex() == str.length()) {
            return date;
        }
        throw new ParseException("Unable to parse the date: " + str, -1);
    }

    public static String dateToString(java.util.Date date, String par) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(par);
        return sdf.format(date);
    }

    public static long strToDateLong(String date) {
        long l = 0L;
        try {
            Calendar ca = Calendar.getInstance();
            ca.setTime(Date.valueOf(date));
            l = ca.getTimeInMillis();
        }
        catch (Exception e) {
            new Exception("\u65e5\u671f\u5b57\u7b26\u4e32\u8f6c\u957f\u6574\u5f62\u9519\u8bef", e);
        }
        return l;
    }

    public static String longToStrDate(String format, long time) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(new java.util.Date(time));
    }

    public static java.util.Date strToDate(String str, String parsePatterns) throws ParseException {
        return DateUtils.parseDate((String)str, (String)parsePatterns);
    }

    public static java.util.Date getAfterCurrentDay(int days) {
        java.util.Date result = null;
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.add(7, days);
            result = calendar.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getFormatDateString(java.util.Date date, String format) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static String getCurrentDateTimeString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        return df.format(calendar.getTime());
    }

    public static String getCurrentDateToString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(calendar.getTime());
    }

    public static String getCurrentDateSimpleToString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(calendar.getTime());
    }

    public static String getCurrentDateSimpleNoSpeToString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        return df.format(calendar.getTime());
    }

    public static java.util.Date getCurrentDate() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTime();
    }

    public static Timestamp getCurrentDateTimestamp() {
        Calendar calendar = Calendar.getInstance();
        return new Timestamp(calendar.getTime().getTime());
    }

    public static String getNextWeekToString() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(7, 6);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(calendar.getTime());
    }

    public static String getNextDayToString(String day) {
        String result = "";
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            calendar.setTime(df.parse(day));
            calendar.add(7, 1);
            result = df.format(calendar.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getLastWeekToString() {
        String result = "";
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            calendar.add(4, -1);
            result = df.format(calendar.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getYestarDayToString(String day) {
        String result = "";
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            calendar.setTime(df.parse(day));
            calendar.add(7, -1);
            result = df.format(calendar.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static java.util.Date stringToSimpleDate(String str) {
        if (str == null || "".equals(str)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return df.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static java.util.Date stringToFullDate(String str) {
        if (str == null || "".equals(str)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return df.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String dateToSimpleString(java.util.Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(date);
    }

    public static String dateToFullString(java.util.Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(date);
    }

    public static String getWeekChinese(String date) {
        String[] weekDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            cal.setTime(df.parse(date));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static String getForWeek(String date) {
        String[] weekDays = new String[]{"\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            cal.setTime(df.parse(date));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static boolean judgeDate(String startStr, String endStr) {
        java.util.Date endDate;
        java.util.Date startDate = DateUtils.stringToSimpleDate((String)startStr);
        return startDate.before(endDate = DateUtils.stringToSimpleDate((String)endStr));
    }

    public static boolean judgeDateEqual(String startStr, String endStr) {
        java.util.Date endDate;
        java.util.Date startDate = DateUtils.stringToSimpleDate((String)startStr);
        return startDate.before(endDate = DateUtils.stringToSimpleDate((String)endStr)) || startDate.compareTo(endDate) == 0;
    }

    public static boolean judgeFullDateEqual(String startStr, String endStr) {
        java.util.Date endDate;
        java.util.Date startDate = DateUtils.stringToSimpleDate((String)startStr);
        return startDate.before(endDate = DateUtils.stringToSimpleDate((String)endStr)) || startDate.compareTo(endDate) == 0;
    }

    public static String getNumAfterDate(String str, int day) {
        java.util.Date startDate = DateUtils.stringToSimpleDate((String)str);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        calendar.add(7, day);
        return DateUtils.dateToSimpleString((java.util.Date)calendar.getTime());
    }

    public static String unixTimeToString(String unixTime) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(Long.parseLong(unixTime));
        return DateUtils.dateToSimpleString((java.util.Date)c.getTime());
    }

    public static String stringToUnixTime(String date) {
        Calendar c = Calendar.getInstance();
        java.util.Date date2 = DateUtils.stringToSimpleDate((String)date);
        c.setTime(date2);
        return c.getTimeInMillis() + "";
    }

    public static Timestamp stringToTimestamp(String tsStr) {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        try {
            ts = Timestamp.valueOf(tsStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ts;
    }

    public static String getStrByTimestamp(Timestamp ccTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(ccTime);
    }

    public static Time strToTime(String strDate) {
        if ("".equals(strDate) || strDate == null) {
            return null;
        }
        String str = strDate;
        SimpleDateFormat format = new SimpleDateFormat("hh:mm:ss");
        java.util.Date d = null;
        try {
            d = format.parse(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Time.valueOf(str);
    }

    public static Time getTime() {
        java.util.Date d = new java.util.Date();
        Time time = new Time(d.getTime());
        return time;
    }

    public static int getBetweenDayNumber(java.util.Date dateA, java.util.Date dateB) {
        long dayNumber = 0L;
        long day = 86400000L;
        try {
            dayNumber = (dateB.getTime() - dateA.getTime()) / day;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (int)dayNumber;
    }

    public static int daysBetween(java.util.Date date1, java.util.Date date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        long time1 = cal.getTimeInMillis();
        cal.setTime(date2);
        long time2 = cal.getTimeInMillis();
        long betweenDays = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(betweenDays));
    }

    public static int secondsBetween(java.util.Date date1, java.util.Date date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        long time1 = cal.getTimeInMillis();
        cal.setTime(date2);
        long time2 = cal.getTimeInMillis();
        long betweenDays = (time2 - time1) / 1000L;
        return Integer.parseInt(String.valueOf(betweenDays));
    }

    public static Long secondsBetweenOneHour(java.util.Date date1, java.util.Date date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        long time1 = cal.getTimeInMillis();
        cal.setTime(date2);
        long time2 = cal.getTimeInMillis();
        long betweenSeconds = 0L;
        betweenSeconds = time2 - time1;
        betweenSeconds = betweenSeconds < 3600000L ? 0L : (betweenSeconds -= 3600000L);
        return betweenSeconds;
    }

    public static int hoursBetween(java.util.Date date1, java.util.Date date2) {
        if (date1.after(date2)) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        long time1 = cal.getTimeInMillis();
        cal.setTime(date2);
        long time2 = cal.getTimeInMillis();
        long betweenDays = (time2 - time1) / 1000L / 3600L;
        return Integer.parseInt(String.valueOf(betweenDays));
    }

    public static int minuteBetween(java.util.Date date1, java.util.Date date2) {
        if (date1.after(date2)) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        long time1 = cal.getTimeInMillis();
        cal.setTime(date2);
        long time2 = cal.getTimeInMillis();
        long betweenDays = (time2 - time1) / 1000L / 60L;
        return Integer.parseInt(String.valueOf(betweenDays));
    }

    public static java.util.Date dateAddDays(java.util.Date date, int addDays) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, addDays);
        return calendar.getTime();
    }

    public static java.util.Date dateAddHours(java.util.Date date, int addHours) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(11, addHours);
        return calendar.getTime();
    }

    public static java.util.Date addDateMinut(java.util.Date day, int hour) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(day);
        cal.add(10, hour);
        java.util.Date time = cal.getTime();
        return time;
    }

    public static java.util.Date dateAddMinutes(java.util.Date date, int addMinutes) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, addMinutes);
        return calendar.getTime();
    }

    public static String longToString(long currentTime, String formatType) throws ParseException {
        java.util.Date date = DateUtils.longToDate((long)currentTime, (String)formatType);
        String strTime = DateUtils.dateToString((java.util.Date)date, (String)formatType);
        return strTime;
    }

    public static long StringTolong(String strDateTime) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        long timeStamp = 0L;
        try {
            LocalDateTime localDateTime = LocalDateTime.parse(strDateTime, dtf);
            timeStamp = localDateTime.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        }
        catch (Exception e) {
            return timeStamp;
        }
        return timeStamp;
    }

    public static java.util.Date stringToDate(String strTime, String formatType) {
        SimpleDateFormat formatter = new SimpleDateFormat(formatType);
        java.util.Date date = null;
        try {
            date = formatter.parse(strTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static java.util.Date longToDate(long currentTime, String formatType) throws ParseException {
        java.util.Date dateOld = new java.util.Date(currentTime);
        String sDateTime = DateUtils.dateToString((java.util.Date)dateOld, (String)formatType);
        java.util.Date date = DateUtils.stringToDate((String)sDateTime, (String)formatType);
        return date;
    }

    public static long dateToLong(java.util.Date date) {
        return date.getTime();
    }

    public static java.util.Date setPrecise(java.util.Date d, int hour, int min, int second) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(d);
        calendar.set(11, hour);
        calendar.set(12, min);
        calendar.set(13, second);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static java.util.Date getNextDayStartTime() {
        java.util.Date date = new java.util.Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(6, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static java.util.Date getBeginDayOfWeek() {
        java.util.Date date = new java.util.Date();
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek);
        return DateUtils.getDayStartTime((java.util.Date)cal.getTime());
    }

    public static java.util.Date getEndDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getBeginDayOfWeek());
        cal.add(7, 6);
        java.util.Date weekEndSta = cal.getTime();
        return DateUtils.getDayEndTime((java.util.Date)weekEndSta);
    }

    public static java.util.Date getBeginDayOfLastWeek(Integer min) {
        java.util.Date date = new java.util.Date();
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek - min * 7);
        return DateUtils.getDayStartTime((java.util.Date)cal.getTime());
    }

    public static java.util.Date getEndDayOfLastWeek(Integer min) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getBeginDayOfLastWeek((Integer)min));
        cal.add(7, 6);
        java.util.Date weekEndSta = cal.getTime();
        return DateUtils.getDayEndTime((java.util.Date)weekEndSta);
    }

    public static java.util.Date getBeginDayLastWeek() {
        java.util.Date date = new java.util.Date();
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek - 28);
        return DateUtils.getDayStartTime((java.util.Date)cal.getTime());
    }

    public static java.util.Date getEndDayLastWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getBeginDayLastWeek());
        cal.add(7, 6);
        java.util.Date weekEndSta = cal.getTime();
        return DateUtils.getDayEndTime((java.util.Date)weekEndSta);
    }

    public static java.util.Date getBeginDayOfNextWeek() {
        java.util.Date date = new java.util.Date();
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek + 7);
        return DateUtils.getDayStartTime((java.util.Date)cal.getTime());
    }

    public static java.util.Date getEndDayOfNextWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getBeginDayOfNextWeek());
        cal.add(7, 6);
        java.util.Date weekEndSta = cal.getTime();
        return DateUtils.getDayEndTime((java.util.Date)weekEndSta);
    }

    public static Timestamp getDayStartTime(java.util.Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Timestamp getDayEndTime(java.util.Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static java.util.Date getWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.date());
        cal.add(7, 6);
        java.util.Date weekEndSta = cal.getTime();
        return DateUtils.getDayEndTime((java.util.Date)weekEndSta);
    }

    public static java.util.Date date() {
        SimpleDateFormat deTime = new SimpleDateFormat("yyyy-MM-dd");
        java.util.Date date = new java.util.Date();
        String format = deTime.format(date);
        java.util.Date parse = null;
        try {
            parse = deTime.parse(format);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return parse;
    }

    public static java.util.Date getBegNextWeek(Integer min) {
        java.util.Date date = new java.util.Date();
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek + min * 7);
        return DateUtils.getDayStartTime((java.util.Date)cal.getTime());
    }

    public static java.util.Date getEndNextWeek(Integer min) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getBegNextWeek((Integer)min));
        cal.add(7, 6);
        java.util.Date weekEndSta = cal.getTime();
        return DateUtils.getDayEndTime((java.util.Date)weekEndSta);
    }

    public static java.util.Date updateDate(java.util.Date scheduleDate, Integer scheduleRange) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String scheduledate = df.format(scheduleDate);
        String moStartTime = null;
        if (scheduleRange.equals(ScheduleRecordEnum.MORNING.getValue())) {
            moStartTime = scheduledate + " 09:00:00";
        }
        if (scheduleRange.equals(ScheduleRecordEnum.AFTERNOON.getValue())) {
            moStartTime = scheduledate + " 13:00:00";
        }
        if (scheduleRange.equals(ScheduleRecordEnum.EVENING.getValue())) {
            moStartTime = scheduledate + " 18:00:00";
        }
        java.util.Date parse = null;
        try {
            SimpleDateFormat dfs = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            parse = dfs.parse(moStartTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(scheduleDate);
        calendar.add(5, -2);
        return calendar.getTime();
    }

    public static Integer getExpirationTime(java.util.Date scheduleDate, Integer scheduleRange) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String scheduledate = df.format(scheduleDate);
        String moStartTime = null;
        if (scheduleRange.equals(ScheduleRecordEnum.MORNING.getValue())) {
            moStartTime = scheduledate + " 12:00:00";
        }
        if (scheduleRange.equals(ScheduleRecordEnum.AFTERNOON.getValue())) {
            moStartTime = scheduledate + " 18:00:00";
        }
        if (scheduleRange.equals(ScheduleRecordEnum.EVENING.getValue())) {
            moStartTime = scheduledate + " 21:00:00";
        }
        java.util.Date parse = null;
        try {
            SimpleDateFormat dfs = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            parse = dfs.parse(moStartTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        java.util.Date date = new java.util.Date();
        int after = parse.compareTo(date);
        if (after != 1) {
            return 1;
        }
        return 0;
    }

    public static java.util.Date dateToDateAsFormat(java.util.Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String sDate = simpleDateFormat.format(date);
        java.util.Date newDate = null;
        try {
            newDate = simpleDateFormat.parse(sDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return newDate;
    }

    public static java.util.Date stringToFullDateUtil(String str) {
        if (str == null || "".equals(str)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        try {
            return df.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static java.util.Date stringToFullDateUtil1(String str) {
        if (str == null || "".equals(str)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return df.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Integer timeCompare(String t1, String t2, String t3) {
        Integer a = 1;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        try {
            java.util.Date t4 = simpleDateFormat.parse(t1);
            java.util.Date t5 = simpleDateFormat.parse(t2);
            java.util.Date t6 = simpleDateFormat.parse(t3);
            if (t6.getTime() > t5.getTime() && t5.getTime() > t4.getTime()) {
                a = 0;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return a;
    }

    public static List<String> getDateRange(java.util.Date date1, java.util.Date date2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        int i = DateUtils.daysBetween((java.util.Date)date1, (java.util.Date)date2);
        System.out.println("i:" + i);
        int j = 0;
        ArrayList<String> scheduleDateList = new ArrayList<String>();
        for (j = 0; j <= i; ++j) {
            java.util.Date date = DateUtils.dateAddDays((java.util.Date)date1, (int)j);
            String format = simpleDateFormat.format(date);
            scheduleDateList.add(format);
        }
        System.out.println(scheduleDateList);
        return scheduleDateList;
    }

    public static boolean overlap(java.util.Date beginDate1, java.util.Date endDate1, java.util.Date beginDate2, java.util.Date endDate2) {
        if (!beginDate2.before(beginDate1) ? !beginDate2.after(endDate1) : !endDate2.before(beginDate1)) {
            return true;
        }
        System.out.println();
        return false;
    }

    public static String getHourAndSecond() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        return df.format(calendar.getTime());
    }

    public static Integer getTimeRange() {
        SimpleDateFormat df = new SimpleDateFormat("HH");
        java.util.Date date = new java.util.Date();
        String str = df.format(date);
        int a = Integer.parseInt(str);
        if (a >= 8 && a <= 12) {
            return 1;
        }
        if (a >= 13 && a <= 17) {
            return 2;
        }
        if (a >= 18 && a <= 22) {
            return 3;
        }
        return 0;
    }

    public static String getOneDayForWeekFirst(String oneDay) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            cal.setTime(sdf.parse(oneDay));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        cal.setFirstDayOfWeek(2);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        int day = cal.get(7);
        cal.add(5, cal.getFirstDayOfWeek() - day);
        String beginDate = sdf.format(cal.getTime());
        cal.add(5, 6);
        String endDate = sdf.format(cal.getTime());
        System.out.println("beginDate:" + beginDate);
        System.out.println("endDate:" + endDate);
        return beginDate;
    }

    public static String getOneDayForWeekLast(String oneDay) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            cal.setTime(sdf.parse(oneDay));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        cal.setFirstDayOfWeek(2);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        int day = cal.get(7);
        cal.add(5, cal.getFirstDayOfWeek() - day);
        String beginDate = sdf.format(cal.getTime());
        cal.add(5, 6);
        String endDate = sdf.format(cal.getTime());
        return endDate;
    }

    public static Long getWeekDayToDay(String start, String end) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        long l = 0L;
        try {
            long from = df.parse(start).getTime();
            long to = df.parse(end).getTime();
            l = (to - from) / 604800000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return l;
    }

    public static Integer getDifMonth(java.util.Date start, java.util.Date end) {
        if (start.after(end)) {
            java.util.Date t = start;
            start = end;
            end = t;
        }
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(start);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        Calendar temp = Calendar.getInstance();
        temp.setTime(end);
        temp.add(5, 1);
        int year = endCalendar.get(1) - startCalendar.get(1);
        int month = endCalendar.get(2) - startCalendar.get(2);
        if (startCalendar.get(5) == 1 && temp.get(5) == 1) {
            return year * 12 + month + 1;
        }
        if (startCalendar.get(5) != 1 && temp.get(5) == 1) {
            return year * 12 + month;
        }
        if (startCalendar.get(5) == 1 && temp.get(5) != 1) {
            return year * 12 + month;
        }
        return year * 12 + month - 1 < 0 ? 0 : year * 12 + month;
    }

    public static String getNextWeekFirst(String date, Integer min) {
        java.util.Date date1 = null;
        try {
            date1 = DateUtils.strToDate((String)date, (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek + min * 7);
        String s = DateUtils.dateToSimpleString((java.util.Date)DateUtils.getDayStartTime((java.util.Date)cal.getTime()));
        return s;
    }

    public static String getNextWeekLast(String date, Integer min) {
        java.util.Date date1 = null;
        try {
            date1 = DateUtils.strToDate((String)DateUtils.getNextWeekFirst((String)date, (Integer)min), (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        cal.add(7, 6);
        java.util.Date weekEndSta = cal.getTime();
        String s = DateUtils.dateToSimpleString((java.util.Date)DateUtils.getDayEndTime((java.util.Date)weekEndSta));
        return s;
    }

    public static List<Integer> getMonth(String startTime, String endTime) {
        Integer k;
        Integer i;
        ArrayList<Integer> time = new ArrayList<Integer>();
        String start = startTime.charAt(5) == '0' ? startTime.substring(6, 7) : startTime.substring(5, 7);
        String end = endTime.charAt(5) == '0' ? endTime.substring(6, 7) : endTime.substring(5, 7);
        for (int i2 = Integer.valueOf(start).intValue(); i2 <= Integer.valueOf(end); ++i2) {
            time.add(i2);
        }
        if (time.size() == 2 && (i = (Integer)time.get(0)).equals(k = (Integer)time.get(1))) {
            time.remove(1);
        }
        return time;
    }

    public static String getLastDayOfMonth(String yearMonth) {
        int year = Integer.parseInt(yearMonth.split("-")[0]);
        int month = Integer.parseInt(yearMonth.split("-")[1]);
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        int lastDay = cal.getMinimum(5);
        cal.set(5, lastDay - 1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(cal.getTime());
    }

    public static List<Map<String, String>> getBetweenWeeks(String startDate, String endDate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        java.util.Date start = sdf.parse(startDate);
        java.util.Date end = sdf.parse(endDate);
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(start);
        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(end);
        while (tempStart.before(tempEnd) || tempStart.equals(tempEnd)) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            int we = tempStart.get(7);
            if (we == 2) {
                map.put("mon", sdf.format(tempStart.getTime()));
            }
            if (map.isEmpty()) {
                tempStart.add(6, 1);
                continue;
            }
            tempStart.add(6, 6);
            map.put("week", sdf.format(tempStart.getTime()));
            result.add(map);
        }
        return result;
    }

    public static java.util.Date strToDateNoTry(String str) {
        java.util.Date date = null;
        try {
            date = DateUtils.strToDate((String)str, (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static java.util.Date strToDateNoTryForMinute(String str) {
        java.util.Date date = null;
        try {
            date = DateUtils.strToDate((String)str, (String)"mm:ss");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static java.util.Date getNextWeek(String date, Integer min) {
        java.util.Date date1 = null;
        try {
            date1 = DateUtils.strToDate((String)date, (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        cal.add(5, min * 7);
        java.util.Date week = cal.getTime();
        String s = DateUtils.dateToSimpleString((java.util.Date)week);
        java.util.Date date2 = null;
        try {
            date2 = DateUtils.strToDate((String)s, (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date2;
    }

    public static List<String> getOneDayNextWeek(List<String> range, Integer min) {
        ArrayList<String> dateRes = new ArrayList<String>();
        for (String str : range) {
            int i = 0;
            for (i = 1; i <= min; ++i) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(DateUtils.strToDateNoTry((String)str));
                cal.add(5, i * 7);
                java.util.Date week = cal.getTime();
                String s = DateUtils.dateToSimpleString((java.util.Date)week);
                dateRes.add(s);
            }
        }
        dateRes.addAll(range);
        return dateRes;
    }

    public static List<String> getOneDayNextWeekTwo(List<String> range, Integer min) {
        ArrayList<String> dateRes = new ArrayList<String>();
        for (String str : range) {
            int i = 0;
            for (i = 1; i <= min; ++i) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(DateUtils.strToDateNoTry((String)str));
                cal.add(5, i * 7);
                java.util.Date week = cal.getTime();
                String s = DateUtils.dateToSimpleString((java.util.Date)week);
                dateRes.add(s);
            }
        }
        return dateRes;
    }

    public static Boolean rangeCompare(java.util.Date date1, java.util.Date date2, java.util.Date date3, java.util.Date date4) {
        boolean b2;
        boolean b;
        Boolean flag = true;
        int f1 = date1.compareTo(date3);
        int f2 = date3.compareTo(date2);
        int f3 = date2.compareTo(date4);
        int f4 = date1.compareTo(date4);
        boolean b1 = WhetherEnum.FORBID.getValue().equals(f1);
        boolean bl = b = WhetherEnum.ALLOW.getValue().equals(f2) || WhetherEnum.EQU.getValue().equals(f2);
        if (b1 && b) {
            flag = false;
        }
        boolean bl2 = b2 = WhetherEnum.EQU.getValue().equals(f4) || WhetherEnum.ALLOW.getValue().equals(f4);
        if (WhetherEnum.ALLOW.getValue().equals(f3) && b2) {
            flag = false;
        }
        return flag;
    }

    public static boolean dateCompare(String startStr, String endStr) {
        java.util.Date startDate = null;
        java.util.Date endDate = null;
        try {
            startDate = DateUtils.strToDate((String)startStr, (String)"yyyy-MM-dd HH:mm:ss");
            endDate = DateUtils.strToDate((String)endStr, (String)"yyyy-MM-dd HH:mm:ss");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return startDate.before(endDate) || startDate.compareTo(endDate) == 0;
    }

    public static String formatTime(int minuteStr) {
        String resultStr = "";
        resultStr = !StringUtils.isEmpty((String)Integer.toString(minuteStr)) ? (minuteStr != 0 ? (minuteStr / 60 == 0 ? minuteStr % 60 + "\u5206" : (minuteStr % 60 == 0 ? minuteStr / 60 + "\u5c0f\u65f6" : minuteStr / 60 + "\u5c0f\u65f6" + minuteStr % 60 + "\u5206")) : "0\u65f60\u5206") : "0\u65f60\u5206";
        return resultStr;
    }

    public static long secondsBetween1(java.util.Date date1, java.util.Date date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        long time1 = cal.getTimeInMillis();
        cal.setTime(date2);
        long time2 = cal.getTimeInMillis();
        long betweenDays = (time2 - time1) / 1000L;
        return betweenDays;
    }

    public static int secondBetween(java.util.Date date1, java.util.Date date2) {
        if (date1.after(date2)) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        long time1 = cal.getTimeInMillis();
        cal.setTime(date2);
        long time2 = cal.getTimeInMillis();
        long betweenDays = (time2 - time1) / 1000L;
        return Integer.parseInt(String.valueOf(betweenDays));
    }

    public static String getStartDayOfMonth(String yearMonth) {
        int year = Integer.parseInt(yearMonth.split("-")[0]);
        int month = Integer.parseInt(yearMonth.split("-")[1]);
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int lastDay = cal.getMinimum(5);
        cal.set(5, lastDay);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(cal.getTime());
    }

    public static List<String> getMonthBeginAndEnd(String time) {
        String begin = "01";
        String end1 = "28";
        String end2 = "29";
        String end3 = "30";
        String end4 = "31";
        Integer[] bigMonth = new Integer[]{1, 3, 5, 7, 8, 10, 12};
        Integer[] smallMonth = new Integer[]{4, 6, 9, 11};
        ArrayList<Integer> bigMonthList = new ArrayList<Integer>();
        bigMonthList.addAll(Arrays.asList(bigMonth));
        ArrayList<Integer> smallMonthList = new ArrayList<Integer>();
        smallMonthList.addAll(Arrays.asList(smallMonth));
        int year = Integer.parseInt(time.substring(0, 4));
        int month = Integer.parseInt(time.substring(5, 7));
        ArrayList<String> result = new ArrayList<String>();
        if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
            StringBuffer monthBegin = new StringBuffer();
            StringBuffer monthEnd = new StringBuffer();
            if ("2".equals(month) && month < 10) {
                monthBegin.append(year).append("-").append(0).append(month).append("-").append(begin);
                monthEnd.append(year).append("-").append(0).append(month).append("-").append(end2);
            } else {
                monthBegin.append(year).append("-").append(month).append("-").append(begin);
                monthEnd.append(year).append("-").append(month).append("-").append(end2);
            }
        } else {
            StringBuffer monthBegin = new StringBuffer();
            StringBuffer monthEnd = new StringBuffer();
            if ("2".equals(month) && month < 10) {
                monthBegin.append(year).append("-").append(0).append(month).append("-").append(begin);
                monthEnd.append(year).append("-").append(0).append(month).append("-").append(end1);
            }
            if ("2".equals(month) && month >= 10) {
                monthBegin.append(year).append("-").append(month).append("-").append(begin);
                monthEnd.append(year).append("-").append(month).append("-").append(end1);
            }
            if (bigMonthList.contains(month) && month < 10) {
                monthBegin.append(year).append("-").append(0).append(month).append("-").append(begin);
                monthEnd.append(year).append("-").append(0).append(month).append("-").append(end4);
            }
            if (bigMonthList.contains(month) && month >= 10) {
                monthBegin.append(year).append("-").append(month).append("-").append(begin);
                monthEnd.append(year).append("-").append(month).append("-").append(end4);
            }
            if (smallMonthList.contains(month) && month < 10) {
                monthBegin.append(year).append("-").append(0).append(month).append("-").append(begin);
                monthEnd.append(year).append("-").append(0).append(month).append("-").append(end3);
            }
            if (bigMonthList.contains(month) && month >= 10) {
                monthBegin.append(year).append("-").append(month).append("-").append(begin);
                monthEnd.append(year).append("-").append(month).append("-").append(end3);
            }
            result.add(monthBegin.toString());
            result.add(monthEnd.toString());
        }
        return result;
    }

    public static int getAgeByBirth(java.util.Date birthDay) throws ParseException {
        int age = 0;
        Calendar cal = Calendar.getInstance();
        if (cal.before(birthDay)) {
            throw new IllegalArgumentException("The birthDay is before Now.It's unbelievable!");
        }
        int yearNow = cal.get(1);
        int monthNow = cal.get(2);
        int dayOfMonthNow = cal.get(5);
        cal.setTime(birthDay);
        int yearBirth = cal.get(1);
        int monthBirth = cal.get(2);
        int dayOfMonthBirth = cal.get(5);
        age = yearNow - yearBirth;
        if (monthNow <= monthBirth) {
            if (monthNow == monthBirth) {
                if (dayOfMonthNow < dayOfMonthBirth) {
                    --age;
                }
            } else {
                --age;
            }
        }
        return age;
    }

    public static java.util.Date getAfterDay(java.util.Date currentDate, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        calendar.add(5, day);
        java.util.Date futureDate = calendar.getTime();
        return futureDate;
    }

    public static java.util.Date getQingMingBeforeDay(java.util.Date currentDate) throws ParseException {
        String qingMingDateStr = DateUtils.getFormatDateString((java.util.Date)currentDate, (String)"yyyy") + "-04-04";
        java.util.Date qingMingDate = DateUtils.parseDate((String)qingMingDateStr, (String)"yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(qingMingDate);
        calendar.add(6, -1);
        java.util.Date qingMingEveDate = calendar.getTime();
        return qingMingEveDate;
    }

    public static java.util.Date getLaborBeforeDay(java.util.Date currentDate) throws ParseException {
        String laborDayStr = DateUtils.getFormatDateString((java.util.Date)currentDate, (String)"yyyy") + "-05-01";
        java.util.Date laborDay = DateUtils.parseDate((String)laborDayStr, (String)"yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(laborDay);
        calendar.add(6, -1);
        java.util.Date laborDayEve = calendar.getTime();
        return laborDayEve;
    }

    public static java.util.Date getDuanWuBeforeDay(java.util.Date currentDate) throws ParseException {
        String duanWuDayStr = DateUtils.getFormatDateString((java.util.Date)currentDate, (String)"yyyy") + "-06-08";
        java.util.Date duanWuDay = DateUtils.parseDate((String)duanWuDayStr, (String)"yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(duanWuDay);
        calendar.add(6, -1);
        java.util.Date duanwuDayEve = calendar.getTime();
        return duanwuDayEve;
    }

    public static java.util.Date getZhongQiuBeforeDay(java.util.Date currentDate) throws ParseException {
        String zhongQiuDayStr = DateUtils.getFormatDateString((java.util.Date)currentDate, (String)"yyyy") + "-09-14";
        java.util.Date zhongQiuDay = DateUtils.parseDate((String)zhongQiuDayStr, (String)"yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(zhongQiuDay);
        calendar.add(6, -1);
        java.util.Date zhongQiuDayEve = calendar.getTime();
        return zhongQiuDayEve;
    }

    public static java.util.Date getGuoQingBeforeDay(java.util.Date currentDate) throws ParseException {
        String guoQingDayStr = DateUtils.getFormatDateString((java.util.Date)currentDate, (String)"yyyy") + "-10-01";
        java.util.Date guoQingDay = DateUtils.parseDate((String)guoQingDayStr, (String)"yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(guoQingDay);
        calendar.add(6, -1);
        java.util.Date guoQingDayEve = calendar.getTime();
        return guoQingDayEve;
    }
}

