/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.hkdhisfront.payment.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.hkdhisfront.base.FrontRequest;
import com.ebaiyihui.hkdhisfront.base.FrontResponse;
import com.ebaiyihui.hkdhisfront.payment.AttachParams;
import com.ebaiyihui.hkdhisfront.payment.BusinessCallResponse;
import com.ebaiyihui.hkdhisfront.payment.CreateOrderRequest;
import com.ebaiyihui.hkdhisfront.payment.CreateOrderResponse;
import com.ebaiyihui.hkdhisfront.payment.CreateRefundOrderRequest;
import com.ebaiyihui.hkdhisfront.payment.CreateRefundOrderResponse;
import com.ebaiyihui.hkdhisfront.payment.DeliverApplyRequest;
import com.ebaiyihui.hkdhisfront.payment.DeliverApplyResponse;
import com.ebaiyihui.hkdhisfront.payment.DeliverNotifyRequest;
import com.ebaiyihui.hkdhisfront.payment.PayCallBackRequest;
import com.ebaiyihui.hkdhisfront.payment.PayCallBackResponse;
import com.ebaiyihui.hkdhisfront.payment.PayListEntity;
import com.ebaiyihui.hkdhisfront.payment.PrepayRequest;
import com.ebaiyihui.hkdhisfront.payment.PrepayResponse;
import com.ebaiyihui.hkdhisfront.payment.QueryPayRequest;
import com.ebaiyihui.hkdhisfront.payment.QueryPayResponse;
import com.ebaiyihui.hkdhisfront.payment.RefundNotifyRequest;
import com.ebaiyihui.hkdhisfront.payment.RefundRequest;
import com.ebaiyihui.hkdhisfront.payment.RefundResponse;
import com.ebaiyihui.hkdhisfront.payment.ResponseNotifyRestVo;
import com.ebaiyihui.hkdhisfront.payment.ResponseResult;
import com.ebaiyihui.hkdhisfront.payment.TradeCancelRequest;
import com.ebaiyihui.hkdhisfront.payment.TradeCancelResponse;
import com.ebaiyihui.hkdhisfront.payment.config.PayProperties;
import com.ebaiyihui.hkdhisfront.payment.model.BusinessCallRequest;
import com.ebaiyihui.hkdhisfront.payment.model.RequestHeader;
import com.ebaiyihui.hkdhisfront.payment.service.IPayService;
import com.ebaiyihui.hkdhisfront.payment.service.IPaymentApi;
import com.ebaiyihui.hkdhisfront.payment.utils.SignUtils;
import com.ebaiyihui.hkdhisfront.utils.HttpUtils;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import retrofit2.Call;

@Service
public class PayService
implements IPayService {
    private static final Logger log = LoggerFactory.getLogger(PayService.class);
    private static final String CALL_BACK_URL = "http://192.168.50.74:9098/pay/callBack";
    private final PayProperties payProperties;
    private final IPaymentApi paymentApi;

    public PayService(PayProperties payProperties, IPaymentApi paymentApi) {
        this.payProperties = payProperties;
        this.paymentApi = paymentApi;
    }

    public FrontResponse<PrepayResponse> prepay(FrontRequest<PrepayRequest> request) {
        PrepayRequest prepayRequest = (PrepayRequest)request.getBody();
        prepayRequest.setNotifyUrl(CALL_BACK_URL);
        RequestHeader header = this.createRequestHeader(request);
        header.setMethod("orgine.powermpp.pay.aggre.service.api.pay.prepay");
        BusinessCallRequest callRequest = new BusinessCallRequest(header, (Object)prepayRequest);
        try {
            header.setSign(SignUtils.createSignByObject((BusinessCallRequest)callRequest));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BusinessCallRequest callRequestBySign = new BusinessCallRequest(header, (Object)prepayRequest);
        Call call = this.paymentApi.payBussinessCall(callRequestBySign);
        try {
            BusinessCallResponse callResponse = (BusinessCallResponse)call.execute().body();
            assert (callResponse != null);
            ResponseResult result = callResponse.getResult();
            if (result.getCode().equals("10000")) {
                log.info("\u8bf7\u6c42\u9884\u652f\u4ed8\u4e0b\u5355\u6210\u529f\uff0c\u8fd4\u56de\u6570\u636e\uff1a{}", callResponse.getBody());
                return FrontResponse.success(null, (Object)callResponse.getBody());
            }
            return FrontResponse.error(null, (String)"0", (String)result.getMsg());
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u9884\u652f\u4ed8\u4e0b\u5355\u5f02\u5e38", (Throwable)e);
            return FrontResponse.error(null, (String)"0", (String)"\u8bf7\u6c42\u9884\u652f\u4ed8\u4e0b\u5355\u5f02\u5e38");
        }
    }

    public FrontResponse<CreateOrderResponse> createOrder(FrontRequest<CreateOrderRequest> request) {
        RequestHeader header = this.createRequestHeader(request);
        header.setMethod("orgine.powermpp.charge.order.service.api.trade.createTradeOrder");
        BusinessCallRequest callRequest = new BusinessCallRequest(header, request.getBody());
        try {
            header.setSign(SignUtils.createSignByObject((BusinessCallRequest)callRequest));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BusinessCallRequest callRequestBySign = new BusinessCallRequest(header, request.getBody());
        Call call = this.paymentApi.orderBussinessCall(callRequestBySign);
        try {
            BusinessCallResponse callResponse = (BusinessCallResponse)call.execute().body();
            assert (callResponse != null);
            ResponseResult result = callResponse.getResult();
            if (result.getCode().equals("10000")) {
                log.info("\u8bf7\u6c42\u521b\u5efa\u6536\u6b3e\u8ba2\u5355\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\uff1a{}", callResponse.getBody());
                return FrontResponse.success(null, (Object)callResponse.getBody());
            }
            return FrontResponse.error(null, (String)"0", (String)result.getMsg());
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u521b\u5efa\u6536\u6b3e\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
            return FrontResponse.error(null, (String)"0", (String)"\u8bf7\u6c42\u521b\u5efa\u6536\u6b3e\u8ba2\u5355\u5f02\u5e38");
        }
    }

    public FrontResponse<QueryPayResponse> queryPayOrder(FrontRequest<QueryPayRequest> request) {
        RequestHeader header = this.createRequestHeader(request);
        header.setMethod("orgine.powermpp.pay.aggre.service.api.pay.payQuery");
        BusinessCallRequest callRequest = new BusinessCallRequest(header, request.getBody());
        try {
            header.setSign(SignUtils.createSignByObject((BusinessCallRequest)callRequest));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BusinessCallRequest callRequestBySign = new BusinessCallRequest(header, request.getBody());
        Call call = this.paymentApi.payBussinessCall(callRequestBySign);
        try {
            BusinessCallResponse callResponse = (BusinessCallResponse)call.execute().body();
            assert (callResponse != null);
            ResponseResult result = callResponse.getResult();
            if (result.getCode().equals("10000")) {
                log.info("\u8bf7\u6c42\u67e5\u8be2\u652f\u4ed8\u7ed3\u679c\u63a5\u53e3\u6210\u529f\uff0c\u8fd4\u56de\u6570\u636e\uff1a{}", callResponse.getBody());
                return FrontResponse.success(null, (Object)callResponse.getBody());
            }
            return FrontResponse.error(null, (String)"0", (String)result.getMsg());
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u67e5\u8be2\u652f\u4ed8\u7ed3\u679c\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return FrontResponse.error(null, (String)"0", (String)"\u8bf7\u6c42\u67e5\u8be2\u652f\u4ed8\u7ed3\u679c\u63a5\u53e3\u5f02\u5e38");
        }
    }

    public FrontResponse<TradeCancelResponse> tradeCancel(FrontRequest<TradeCancelRequest> request) {
        RequestHeader header = this.createRequestHeader(request);
        header.setMethod("orgine.powermpp.pay.aggre.service.api.pay.tradeCancel");
        BusinessCallRequest callRequest = new BusinessCallRequest(header, request.getBody());
        try {
            header.setSign(SignUtils.createSignByObject((BusinessCallRequest)callRequest));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BusinessCallRequest callRequestBySign = new BusinessCallRequest(header, request.getBody());
        Call call = this.paymentApi.payBussinessCall(callRequestBySign);
        try {
            BusinessCallResponse callResponse = (BusinessCallResponse)call.execute().body();
            assert (callResponse != null);
            ResponseResult result = callResponse.getResult();
            if (result.getCode().equals("10000")) {
                log.info("\u8bf7\u6c42\u652f\u4ed8\u64a4\u9500\u63a5\u53e3\u6210\u529f\uff0c\u8fd4\u56de\u6570\u636e\uff1a{}", callResponse.getBody());
                return FrontResponse.success(null, (Object)callResponse.getBody());
            }
            return FrontResponse.error(null, (String)"0", (String)result.getMsg());
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u652f\u4ed8\u64a4\u9500\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return FrontResponse.error(null, (String)"0", (String)"\u8bf7\u6c42\u652f\u4ed8\u64a4\u9500\u63a5\u53e3\u5f02\u5e38");
        }
    }

    public FrontResponse<DeliverApplyResponse> deliverApply(FrontRequest<DeliverApplyRequest> request) {
        RequestHeader header = this.createRequestHeader(request);
        header.setMethod("orgine.powermpp.charge.order.service.api.trade.deliverApply");
        BusinessCallRequest callRequest = new BusinessCallRequest(header, request.getBody());
        System.out.println(callRequest);
        try {
            header.setSign(SignUtils.createSignByObject((BusinessCallRequest)callRequest));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BusinessCallRequest callRequestBySign = new BusinessCallRequest(header, request.getBody());
        Call call = this.paymentApi.orderBussinessCall(callRequestBySign);
        try {
            BusinessCallResponse callResponse = (BusinessCallResponse)call.execute().body();
            assert (callResponse != null);
            ResponseResult result = callResponse.getResult();
            if (result.getCode().equals("10000")) {
                log.info("\u8bf7\u6c42\u4ea4\u8d27\u7533\u8bf7\u63a5\u53e3\u6210\u529f\uff0c\u8fd4\u56de\u6570\u636e\uff1a{}", callResponse.getBody());
                return FrontResponse.success(null, (Object)callResponse.getBody());
            }
            return FrontResponse.error(null, (String)"0", (String)result.getMsg());
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u4ea4\u8d27\u7533\u8bf7\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return FrontResponse.error(null, (String)"0", (String)"\u8bf7\u6c42\u4ea4\u8d27\u7533\u8bf7\u63a5\u53e3\u5f02\u5e38");
        }
    }

    public FrontResponse deliverNotify(FrontRequest<DeliverNotifyRequest> request) {
        RequestHeader header = this.createRequestHeader(request);
        header.setMethod("orgine.powermpp.charge.order.service.api.trade.deliverSend");
        BusinessCallRequest callRequest = new BusinessCallRequest(header, request.getBody());
        try {
            header.setSign(SignUtils.createSignByObject((BusinessCallRequest)callRequest));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BusinessCallRequest callRequestBySign = new BusinessCallRequest(header, request.getBody());
        Call call = this.paymentApi.orderBussinessCall(callRequestBySign);
        try {
            BusinessCallResponse callResponse = (BusinessCallResponse)call.execute().body();
            assert (callResponse != null);
            ResponseResult result = callResponse.getResult();
            if (result.getCode().equals("10000")) {
                log.info("\u8bf7\u6c42\u4ea4\u8d27\u901a\u77e5\u63a5\u53e3\u6210\u529f\uff0c\u8fd4\u56de\u6570\u636e\uff1a{}", callResponse.getBody());
                return FrontResponse.success(null, (Object)callResponse.getResult());
            }
            return FrontResponse.error(null, (String)"0", (String)result.getMsg());
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u4ea4\u8d27\u901a\u77e5\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return FrontResponse.error(null, (String)"0", (String)"\u8bf7\u6c42\u4ea4\u8d27\u901a\u77e5\u63a5\u53e3\u5f02\u5e38");
        }
    }

    public BusinessCallResponse<Object> callBack(PayCallBackRequest request) {
        PayCallBackResponse.ResponseData responseData = PayCallBackResponse.ResponseData.builder().tranNo(request.getTranNo()).requestNo(request.getRequestNo()).notifyStatus("fail").build();
        String attachParamsStr = request.getAttachParams();
        AttachParams attachParams = (AttachParams)JSON.parseObject((String)attachParamsStr, AttachParams.class);
        if (StringUtils.isNotBlank((CharSequence)attachParams.getCallbackUrl())) {
            String url = attachParams.getCallbackUrl();
            try {
                ResponseNotifyRestVo requestNotify = new ResponseNotifyRestVo();
                PayListEntity payListEntity = (PayListEntity)request.getPayList().get(0);
                requestNotify.setReturnCode(request.getPayStatus());
                requestNotify.setReturnMsg(request.getPayStatus());
                requestNotify.setResultCode(request.getPayStatus());
                requestNotify.setPayChannel(payListEntity.getPayChannel());
                requestNotify.setDealTradeNo(request.getTranNo());
                requestNotify.setOutTradeNo(request.getRequestNo());
                requestNotify.setTotalAmount(payListEntity.getPayAmount());
                String tranTime = payListEntity.getTranTime();
                requestNotify.setPayTime((Date)DateUtil.parse((CharSequence)tranTime, (String)"yyyy-MM-dd HH:mm:ss"));
                requestNotify.setMchId(payListEntity.getMerchantNum());
                requestNotify.setTradeNo(payListEntity.getPayFlowNo());
                requestNotify.setMchCode(payListEntity.getMerchantNum());
                requestNotify.setMchName(payListEntity.getPayAgentCode());
                requestNotify.setAttach(JSON.toJSONString((Object)request));
                log.info("\u56de\u8c03\u4e1a\u52a1\u8bf7\u6c42\u5730\u5740->{},\u56de\u8c03\u53c2\u6570->{}", (Object)url, (Object)JSON.toJSONString((Object)request, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                String result = HttpUtils.doPost((String)url, (String)JSON.toJSONString((Object)requestNotify), (String)"UTF-8", (String)"application/json");
                log.info("\u56de\u8c03\u4e1a\u52a1\u8fd4\u56de\u7ed3\u679c->{}", (Object)result);
                BaseResponse baseResponse = (BaseResponse)JSON.parseObject((String)result, BaseResponse.class);
                if (!baseResponse.isSuccess()) {
                    return BusinessCallResponse.builder().body((Object)JSON.toJSONString((Object)responseData)).result(ResponseResult.builder().code("fail").msg("\u56de\u8c03\u4e1a\u52a1\u5904\u7406\u8fd4\u56de\u5931\u8d25").build()).build();
                }
                responseData.setNotifyStatus("success");
                return BusinessCallResponse.builder().body((Object)JSON.toJSONString((Object)responseData)).result(ResponseResult.builder().code("success").msg("\u56de\u8c03\u4e1a\u52a1\u8bf7\u6c42\u6210\u529f").build()).build();
            }
            catch (Exception e) {
                log.error("\u56de\u8c03\u4e1a\u52a1\u8bf7\u6c42\u5f02\u5e38  \u8bf7\u6c42\u5730\u5740->{},\u8bf7\u6c42\u53c2\u6570->{},\u5f02\u5e38\u4fe1\u606f->{}", new Object[]{url, JSON.toJSONString((Object)request), e});
                return BusinessCallResponse.builder().body((Object)JSON.toJSONString((Object)responseData)).result(ResponseResult.builder().code("fail").msg("\u56de\u8c03\u4e1a\u52a1\u8bf7\u6c42\u5f02\u5e38").build()).build();
            }
        }
        return BusinessCallResponse.builder().body((Object)PayCallBackResponse.builder().responseData(JSON.toJSONString((Object)responseData)).build()).result(ResponseResult.builder().code("fail").msg("\u900f\u4f20\u56de\u8c03\u5730\u5740\u4e3a\u7a7a\uff0c\u56de\u8c03\u5931\u8d25").build()).build();
    }

    public FrontResponse<RefundResponse> refund(FrontRequest<RefundRequest> request) {
        RequestHeader header = this.createRequestHeader(request);
        header.setMethod("orgine.powermpp.refund.service.api.core.orderRefund");
        BusinessCallRequest callRequest = new BusinessCallRequest(header, request.getBody());
        try {
            header.setSign(SignUtils.createSignByObject((BusinessCallRequest)callRequest));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BusinessCallRequest callRequestBySign = new BusinessCallRequest(header, request.getBody());
        Call call = this.paymentApi.immediatelyRefundBussinessCall(callRequestBySign);
        try {
            BusinessCallResponse callResponse = (BusinessCallResponse)call.execute().body();
            assert (callResponse != null);
            ResponseResult result = callResponse.getResult();
            if (result.getCode().equals("10000")) {
                log.info("\u8bf7\u6c42\u5b9e\u65f6\u9000\u6b3e\u63a5\u53e3\u6210\u529f\uff0c\u8fd4\u56de\u6570\u636e\uff1a{}", callResponse.getBody());
                return FrontResponse.success((String)request.getTransactionId(), (Object)callResponse.getBody());
            }
            return FrontResponse.error((String)request.getTransactionId(), (String)"0", (String)result.getMsg());
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u5b9e\u65f6\u9000\u6b3e\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return FrontResponse.error((String)request.getTransactionId(), (String)"0", (String)"\u8bf7\u6c42\u5b9e\u65f6\u9000\u6b3e\u63a5\u53e3\u5f02\u5e38");
        }
    }

    public FrontResponse<CreateRefundOrderResponse> createRefundOrder(FrontRequest<CreateRefundOrderRequest> request) {
        RequestHeader header = this.createRequestHeader(request);
        header.setMethod("orgine.powermpp.refund.order.service.api.refund.createRefundOrder");
        BusinessCallRequest callRequest = new BusinessCallRequest(header, request.getBody());
        try {
            header.setSign(SignUtils.createSignByObject((BusinessCallRequest)callRequest));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BusinessCallRequest callRequestBySign = new BusinessCallRequest(header, request.getBody());
        Call call = this.paymentApi.refundBussinessCall(callRequestBySign);
        try {
            BusinessCallResponse callResponse = (BusinessCallResponse)call.execute().body();
            assert (callResponse != null);
            ResponseResult result = callResponse.getResult();
            if (result.getCode().equals("10000")) {
                log.info("\u8bf7\u6c42\u521b\u5efa\u9000\u6b3e\u8ba2\u5355\u63a5\u53e3\u6210\u529f\uff0c\u8fd4\u56de\u6570\u636e\uff1a{}", callResponse.getBody());
                return FrontResponse.success((String)request.getTransactionId(), (Object)callResponse.getBody());
            }
            return FrontResponse.error((String)request.getTransactionId(), (String)"0", (String)result.getMsg());
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u521b\u5efa\u9000\u6b3e\u8ba2\u5355\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return FrontResponse.error((String)request.getTransactionId(), (String)"0", (String)"\u8bf7\u6c42\u521b\u5efa\u9000\u6b3e\u8ba2\u5355\u63a5\u53e3\u5f02\u5e38");
        }
    }

    public FrontResponse<ResponseResult> refundNotify(FrontRequest<RefundNotifyRequest> request) {
        RequestHeader header = this.createRequestHeader(request);
        header.setMethod("orgine.powermpp.refund.order.service.api.refund.goodsRefundConfirm");
        BusinessCallRequest callRequest = new BusinessCallRequest(header, request.getBody());
        try {
            header.setSign(SignUtils.createSignByObject((BusinessCallRequest)callRequest));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BusinessCallRequest callRequestBySign = new BusinessCallRequest(header, request.getBody());
        Call call = this.paymentApi.refundBussinessCall(callRequestBySign);
        try {
            BusinessCallResponse callResponse = (BusinessCallResponse)call.execute().body();
            assert (callResponse != null);
            ResponseResult result = callResponse.getResult();
            if (result.getCode().equals("10000")) {
                log.info("\u8bf7\u6c42\u9000\u8d27\u901a\u77e5\u63a5\u53e3\u6210\u529f\uff0c\u8fd4\u56de\u6570\u636e\uff1a{}", callResponse.getBody());
                return FrontResponse.success((String)request.getTransactionId(), (Object)callResponse.getResult());
            }
            return FrontResponse.error((String)request.getTransactionId(), (String)"0", (String)result.getMsg());
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u9000\u8d27\u901a\u77e5\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return FrontResponse.error((String)request.getTransactionId(), (String)"0", (String)"\u8bf7\u6c42\u9000\u8d27\u901a\u77e5\u63a5\u53e3\u5f02\u5e38");
        }
    }

    private RequestHeader createRequestHeader(FrontRequest request) {
        RequestHeader requestHeader = RequestHeader.builder().encryptType("AES").charset("utf-8").language("zh_CN").signType("md5").sysTrackCode(IdUtil.fastSimpleUUID()).timestamp(System.currentTimeMillis() + "").version("1.0").sign("").build();
        if (Objects.equals("YBB", request.getOrganCode())) {
            requestHeader.setAppId(this.payProperties.getYbbPay().getAppId());
            requestHeader.setEnterpriseId(this.payProperties.getYbbPay().getMerchantId());
            requestHeader.setResourceCode("wxxcx");
        }
        if (Objects.equals("LLYQ", request.getOrganCode())) {
            requestHeader.setAppId(this.payProperties.getLlyqPay().getAppId());
            requestHeader.setEnterpriseId(this.payProperties.getLlyqPay().getMerchantId());
            requestHeader.setResourceCode("llwxxcx");
        }
        if (Objects.equals("UNHIS", request.getOrganCode())) {
            requestHeader.setAppId("1f28b157bf5f46a894c4cc1f274871b7");
            requestHeader.setEnterpriseId("hnkjdxdefsyy");
            requestHeader.setResourceCode("hlwwxxcx");
        }
        return requestHeader;
    }
}

