/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.hkdhisfront.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.hkdhisfront.appoint.GetDeptScheduleResVO;
import com.ebaiyihui.hkdhisfront.appoint.GetRegDoctInfoVo;
import com.ebaiyihui.hkdhisfront.appoint.GetScheduleResVO;
import com.ebaiyihui.hkdhisfront.appoint.RequestRegDeptVo;
import com.ebaiyihui.hkdhisfront.appoint.RequestRegDoctInfoVo;
import com.ebaiyihui.hkdhisfront.appoint.RequestRegDoctVo;
import com.ebaiyihui.hkdhisfront.base.FrontRequest;
import com.ebaiyihui.hkdhisfront.base.FrontResponse;
import com.ebaiyihui.hkdhisfront.common.enums.EntityKeyEnum;
import com.ebaiyihui.hkdhisfront.common.enums.MethodCodeEnum;
import com.ebaiyihui.hkdhisfront.pojo.dto.ReponseRegDeptDTO;
import com.ebaiyihui.hkdhisfront.pojo.dto.ReponseRegDoctDTO;
import com.ebaiyihui.hkdhisfront.pojo.vo.DeptVo;
import com.ebaiyihui.hkdhisfront.pojo.vo.DoctorVo;
import com.ebaiyihui.hkdhisfront.service.HisRemoteService;
import com.ebaiyihui.hkdhisfront.service.ScheduleService;
import com.ebaiyihui.hkdhisfront.utils.CxfClientUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ScheduleServiceImpl
implements ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    @Autowired
    private HisRemoteService hisRemoteService;
    @Resource
    private CxfClientUtil cxfClientUtil;
    private static final Logger logger = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    @Value(value="${xy.wsdlUrl}")
    public String hisWsdlUrl;

    public FrontResponse<GetDeptScheduleResVO> getDeptSchedule(FrontRequest<RequestRegDeptVo> param) {
        RequestRegDeptVo requestRegDept = (RequestRegDeptVo)param.getBody();
        HashMap<String, RequestRegDeptVo> map = new HashMap<String, RequestRegDeptVo>(1);
        map.put(EntityKeyEnum.DEPT_INFO_LIST.getValue(), requestRegDept);
        FrontResponse frontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.DEPT_INFO_LIST.getValue(), map, ReponseRegDeptDTO.class);
        if (Objects.isNull(frontResponse)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-008\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38");
        }
        ReponseRegDeptDTO body = (ReponseRegDeptDTO)frontResponse.getBody();
        if (Objects.isNull(body)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-008\u63a5\u53e3\u8fd4\u56de\u5b9e\u4f53\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (!Objects.equals(body.getResult(), "1")) {
            return FrontResponse.error((String)param.getTransactionId(), (String)frontResponse.getErrCode(), (String)body.getErr());
        }
        List deptList = body.getDeptList();
        if (CollectionUtils.isEmpty((Collection)deptList)) {
            return FrontResponse.success((String)param.getTransactionId(), null);
        }
        GetDeptScheduleResVO deptListVO = ScheduleServiceImpl.getGetDeptScheduleResVO((List)deptList);
        return FrontResponse.success((String)param.getTransactionId(), (Object)deptListVO);
    }

    private static GetDeptScheduleResVO getGetDeptScheduleResVO(List<DeptVo> deptList) {
        GetDeptScheduleResVO deptListVO = new GetDeptScheduleResVO();
        ArrayList<GetDeptScheduleResVO.GetDeptScheduleResItems> items = new ArrayList<GetDeptScheduleResVO.GetDeptScheduleResItems>();
        for (DeptVo deptVo : deptList) {
            GetDeptScheduleResVO.GetDeptScheduleResItems getDeptScheduleResItems = GetDeptScheduleResVO.GetDeptScheduleResItems.builder().deptCode(deptVo.getDeptCode()).deptName(deptVo.getDeptName()).deptAddress(deptVo.getAddress()).build();
            items.add(getDeptScheduleResItems);
        }
        deptListVO.setItems(items);
        return deptListVO;
    }

    public FrontResponse<GetScheduleResVO> getDoctorSchdule(FrontRequest<RequestRegDoctVo> param) {
        RequestRegDoctVo requestRegDoctVo = (RequestRegDoctVo)param.getBody();
        HashMap<String, RequestRegDoctVo> map = new HashMap<String, RequestRegDoctVo>(1);
        map.put(EntityKeyEnum.DEPT_INFO_LIST.getValue(), requestRegDoctVo);
        FrontResponse reponseRegDoctDTO = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.DOCTOR_INFO_LIST.getValue(), map, ReponseRegDoctDTO.class);
        if (Objects.isNull(reponseRegDoctDTO)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", null);
        }
        ReponseRegDoctDTO body = (ReponseRegDoctDTO)reponseRegDoctDTO.getBody();
        if (Objects.isNull(body)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-009\u63a5\u53e3\u8fd4\u56de\u5b9e\u4f53\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (!Objects.equals(body.getResult(), "1")) {
            return FrontResponse.error((String)param.getTransactionId(), (String)reponseRegDoctDTO.getErrCode(), (String)body.getErr());
        }
        List doctorVoList = body.getDoctor();
        if (CollectionUtils.isEmpty((Collection)doctorVoList)) {
            return FrontResponse.success((String)param.getTransactionId(), null);
        }
        GetScheduleResVO scheduleResVO = new GetScheduleResVO();
        ArrayList<GetScheduleResVO.GetScheduleResItems> items = new ArrayList<GetScheduleResVO.GetScheduleResItems>();
        for (DoctorVo doctorVo : doctorVoList) {
            GetScheduleResVO.GetScheduleResItems scheduleResItems = new GetScheduleResVO.GetScheduleResItems();
            scheduleResItems.setDocCode(doctorVo.getDoctorCode());
            scheduleResItems.setDocName(doctorVo.getDoctorName());
            scheduleResItems.setLocCode(doctorVo.getDeptCode());
            scheduleResItems.setLocName(doctorVo.getDeptName());
            scheduleResItems.setScheduleId(doctorVo.getSchemaID());
            scheduleResItems.setAdmDate(doctorVo.changeDate());
            scheduleResItems.setAdmTimeRange(doctorVo.changeNoon());
            scheduleResItems.setRegTitleCode(doctorVo.getReglevelCode());
            scheduleResItems.setRegTitleName(doctorVo.getReglevelName());
            scheduleResItems.setScheduleLevelCode(doctorVo.getReglevelCode());
            scheduleResItems.setScheduleLevelName(doctorVo.getReglevelName());
            scheduleResItems.setRegFee(doctorVo.getRegFee());
            scheduleResItems.setDiagFee(doctorVo.getDiagFee());
            scheduleResItems.setReplaceScheduleId(doctorVo.getSchemaID());
            scheduleResItems.setRegAvailable(Integer.valueOf(Integer.valueOf(doctorVo.getRegLimit()) - Integer.valueOf(doctorVo.getReged())));
            scheduleResItems.setRegTotal(Integer.valueOf(doctorVo.getRegLimit()));
            List timeArrange = doctorVo.getTimeArrange();
            if (CollectionUtils.isEmpty((Collection)timeArrange)) {
                scheduleResItems.setTimeArrangeItems(null);
            } else {
                List timeArrangeItems = BeanUtil.copyToList((Collection)timeArrange, GetScheduleResVO.TimeArrangeItems.class);
                scheduleResItems.setTimeArrangeItems(timeArrangeItems);
            }
            items.add(scheduleResItems);
        }
        scheduleResVO.setItems(items);
        return FrontResponse.success((String)param.getTransactionId(), (Object)scheduleResVO);
    }

    public FrontResponse<List<GetRegDoctInfoVo>> getDoctorInfo(FrontRequest<RequestRegDoctInfoVo> param) {
        String url = this.hisWsdlUrl;
        String responseHisXml = null;
        String jsonString = null;
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            jsonString = objectMapper.writeValueAsString(param.getBody());
            logger.info("\u76f4\u63a5\u8c03\u7528\u533b\u751f\u4fe1\u606f\u67e5\u8be2\u7684\u5165\u53c2:{}", (Object)jsonString);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        try {
            logger.info("\u76f4\u63a5\u8c03\u7528\u533b\u751f\u4fe1\u606f\u67e5\u8be2\u7684\u63a5\u53e3----------");
            responseHisXml = this.cxfClientUtil.send(url, "service", "038", jsonString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.info("\u76f4\u63a5\u8c03\u7528\u533b\u751f\u4fe1\u606f\u67e5\u8be2\u7684\u63a5\u53e3:{}", responseHisXml);
        JSONObject jsonObject = JSONObject.parseObject(responseHisXml);
        if (jsonObject.get((Object)"errorCode").equals("0")) {
            List list = JSONObject.parseArray((String)jsonObject.get((Object)"result").toString()).toJavaList(GetRegDoctInfoVo.class);
            logger.info("\u76f4\u63a5\u8c03\u7528\u533b\u751f\u4fe1\u606f\u67e5\u8be2\u7684\u63a5\u53e3:{}", (Object)list);
            return FrontResponse.success((String)param.getTransactionId(), (Object)list);
        }
        return FrontResponse.error(null, (String)"0", (String)jsonObject.get((Object)"errorMessage").toString());
    }
}

