/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.hkdhisfront.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.hkdhisfront.appoint.InHospitalNumByIdCardReq;
import com.ebaiyihui.hkdhisfront.appoint.InHospitalNumByIdCardVo;
import com.ebaiyihui.hkdhisfront.appoint.LisReportDetailReq;
import com.ebaiyihui.hkdhisfront.appoint.LisReportDetailVo;
import com.ebaiyihui.hkdhisfront.base.FrontRequest;
import com.ebaiyihui.hkdhisfront.base.FrontResponse;
import com.ebaiyihui.hkdhisfront.common.enums.EntityKeyEnum;
import com.ebaiyihui.hkdhisfront.common.enums.MethodCodeEnum;
import com.ebaiyihui.hkdhisfront.pojo.dto.Content;
import com.ebaiyihui.hkdhisfront.pojo.dto.LisContent;
import com.ebaiyihui.hkdhisfront.pojo.dto.ReponseLisListDTO;
import com.ebaiyihui.hkdhisfront.pojo.dto.ReponseLisResultDTO;
import com.ebaiyihui.hkdhisfront.pojo.dto.ReponsePacsListDTO;
import com.ebaiyihui.hkdhisfront.pojo.dto.ReponsePacsResultDTO;
import com.ebaiyihui.hkdhisfront.pojo.vo.ContentPacsList;
import com.ebaiyihui.hkdhisfront.pojo.vo.RequestLisListVo;
import com.ebaiyihui.hkdhisfront.pojo.vo.RequestLisResultVo;
import com.ebaiyihui.hkdhisfront.pojo.vo.RequestPacsListVo;
import com.ebaiyihui.hkdhisfront.pojo.vo.RequestPacsResultVo;
import com.ebaiyihui.hkdhisfront.report.GetReportListsReq;
import com.ebaiyihui.hkdhisfront.report.GetReportListsRes;
import com.ebaiyihui.hkdhisfront.report.LisReportDetailRes;
import com.ebaiyihui.hkdhisfront.report.PacsReportDetailRes;
import com.ebaiyihui.hkdhisfront.report.ReportDetailReq;
import com.ebaiyihui.hkdhisfront.service.ElectronicReportService;
import com.ebaiyihui.hkdhisfront.service.HisRemoteService;
import com.ebaiyihui.hkdhisfront.service.impl.ScheduleServiceImpl;
import com.ebaiyihui.hkdhisfront.utils.CxfClientUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ElectronicReportServiceImpl
implements ElectronicReportService {
    private static final Logger log = LoggerFactory.getLogger(ElectronicReportServiceImpl.class);
    @Resource
    private HisRemoteService hisRemoteService;
    @Resource
    private CxfClientUtil cxfClientUtil;
    private static final Logger logger = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    @Value(value="${xy.wsdlUrl}")
    public String hisWsdlUrl;

    public FrontResponse<List<GetReportListsRes>> getReportList(FrontRequest<GetReportListsReq> param) {
        GetReportListsReq getReportListsReq = (GetReportListsReq)param.getBody();
        if (Objects.equals(getReportListsReq.getReportType(), "1")) {
            return this.getLisReportList(param);
        }
        if (Objects.equals(getReportListsReq.getReportType(), "2")) {
            return this.getPacsReportList(param);
        }
        return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u7c7b\u578b\u9519\u8bef");
    }

    public FrontResponse<List<LisReportDetailRes>> lisReportDetail(FrontRequest<ReportDetailReq> param) {
        ReportDetailReq reportDetailReq = (ReportDetailReq)param.getBody();
        HashMap<String, RequestLisResultVo> map = new HashMap<String, RequestLisResultVo>(1);
        RequestLisResultVo requestLisResult = RequestLisResultVo.builder().idno(reportDetailReq.getIdNo()).name(reportDetailReq.getName()).LIS_NO(reportDetailReq.getLisNo()).APPLY_NO(reportDetailReq.getReportNo()).build();
        map.put(EntityKeyEnum.INSPECTION_RESULTS.getValue(), requestLisResult);
        FrontResponse frontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.INSPECTION_RESULTS.getValue(), map, ReponseLisResultDTO.class);
        if (Objects.isNull(frontResponse)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-091\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38");
        }
        ReponseLisResultDTO body = (ReponseLisResultDTO)frontResponse.getBody();
        if (Objects.isNull(body)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-091\u63a5\u53e3\u8fd4\u56de\u5b9e\u4f53\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (!Objects.equals(body.getResult(), "0")) {
            return FrontResponse.error((String)param.getTransactionId(), (String)frontResponse.getErrCode(), (String)body.getErr());
        }
        List contentList = body.getContent();
        if (CollectionUtils.isEmpty((Collection)contentList)) {
            return FrontResponse.success((String)param.getTransactionId(), null);
        }
        ArrayList<LisReportDetailRes> lisReportDetailResList = new ArrayList<LisReportDetailRes>();
        for (Content content : contentList) {
            lisReportDetailResList.add(LisReportDetailRes.builder().itmCode(content.getCode()).itmName(content.getItemName()).itmRes(content.getResult()).itmRanges(content.getRange()).itmUnit(content.getUnit()).itmCrises(content.getNormalFlag()).decision(content.getDecision()).build());
        }
        return FrontResponse.success((String)param.getTransactionId(), lisReportDetailResList);
    }

    public FrontResponse<PacsReportDetailRes> pacsReportDetail(FrontRequest<ReportDetailReq> param) {
        ReportDetailReq reportDetailReq = (ReportDetailReq)param.getBody();
        HashMap<String, RequestPacsResultVo> map = new HashMap<String, RequestPacsResultVo>(1);
        RequestPacsResultVo requestLisResult = RequestPacsResultVo.builder().reportId(reportDetailReq.getReportNo()).build();
        map.put(EntityKeyEnum.INSPECTION_CHECK_RESULTS.getValue(), requestLisResult);
        FrontResponse frontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.INSPECTION_CHECK_RESULTS.getValue(), map, ReponsePacsResultDTO.class);
        if (Objects.isNull(frontResponse)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-093\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38");
        }
        ReponsePacsResultDTO body = (ReponsePacsResultDTO)frontResponse.getBody();
        if (Objects.isNull(body)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-093\u63a5\u53e3\u8fd4\u56de\u5b9e\u4f53\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (!Objects.equals(body.getResult(), "0")) {
            return FrontResponse.error((String)param.getTransactionId(), (String)frontResponse.getErrCode(), (String)body.getErr());
        }
        PacsReportDetailRes pacsReportDetailRes = (PacsReportDetailRes)BeanUtil.copyProperties((Object)body.getContent(), PacsReportDetailRes.class, (String[])new String[0]);
        return FrontResponse.success((String)param.getTransactionId(), (Object)pacsReportDetailRes);
    }

    public FrontResponse<LisReportDetailVo> lisReportDetailBase(FrontRequest<LisReportDetailReq> param) {
        String url = this.hisWsdlUrl;
        String responseHisXml = null;
        String jsonString = null;
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            jsonString = objectMapper.writeValueAsString(param.getBody());
            logger.info("\u76f4\u63a5\u8c03\u7528\u533b\u751f\u4fe1\u606f\u67e5\u8be2\u7684\u5165\u53c2:{}", (Object)jsonString);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        try {
            logger.info("\u76f4\u63a5\u8c03\u7528\u533b\u751f\u4fe1\u606f\u67e5\u8be2\u7684\u63a5\u53e3----------");
            responseHisXml = this.cxfClientUtil.send(url, "service", "041", jsonString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.info("\u76f4\u63a5\u8c03\u7528\u533b\u751f\u4fe1\u606f\u67e5\u8be2\u7684\u63a5\u53e3:{}", responseHisXml);
        JSONObject jsonObject = JSONObject.parseObject(responseHisXml);
        if (jsonObject.get((Object)"errorCode").equals("0")) {
            List lisReportDetailVo = JSONObject.parseArray((String)jsonObject.get((Object)"result").toString()).toJavaList(LisReportDetailVo.class);
            logger.info("\u76f4\u63a5\u8c03\u7528\u533b\u751f\u4fe1\u606f\u67e5\u8be2\u7684\u63a5\u53e3:{}", (Object)lisReportDetailVo);
            if (lisReportDetailVo != null && lisReportDetailVo.size() > 0) {
                return FrontResponse.success((String)param.getTransactionId(), lisReportDetailVo.get(0));
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)new LisReportDetailVo());
        }
        return FrontResponse.error(null, (String)"0", (String)jsonObject.get((Object)"errorMessage").toString());
    }

    public FrontResponse<List<InHospitalNumByIdCardVo>> getInHospitalNumByIdCard(FrontRequest<InHospitalNumByIdCardReq> param) {
        String url = this.hisWsdlUrl;
        String responseHisXml = null;
        String jsonString = null;
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            jsonString = objectMapper.writeValueAsString(param.getBody());
            logger.info("\u76f4\u63a5\u8c03\u7528\u533b\u751f\u4fe1\u606f\u67e5\u8be2\u7684\u5165\u53c2:{}", (Object)jsonString);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        try {
            logger.info("\u76f4\u63a5\u8c03\u7528\u533b\u751f\u4fe1\u606f\u67e5\u8be2\u7684\u63a5\u53e3----------");
            responseHisXml = this.cxfClientUtil.send(url, "service", "042", jsonString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.info("\u76f4\u63a5\u8c03\u7528\u533b\u751f\u4fe1\u606f\u67e5\u8be2\u7684\u63a5\u53e3:{}", responseHisXml);
        JSONObject jsonObject = JSONObject.parseObject(responseHisXml);
        if (jsonObject.get((Object)"errorCode").equals("0")) {
            List list = JSONObject.parseArray((String)jsonObject.get((Object)"result").toString()).toJavaList(InHospitalNumByIdCardVo.class);
            logger.info("\u76f4\u63a5\u8c03\u7528\u533b\u751f\u4fe1\u606f\u67e5\u8be2\u7684\u63a5\u53e3:{}", (Object)list);
            if (list != null && list.size() > 0) {
                return FrontResponse.success((String)param.getTransactionId(), (Object)list);
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)list);
        }
        return FrontResponse.error(null, (String)"0", (String)jsonObject.get((Object)"errorMessage").toString());
    }

    private FrontResponse<List<GetReportListsRes>> getLisReportList(FrontRequest<GetReportListsReq> param) {
        GetReportListsReq getReportListsReq = (GetReportListsReq)param.getBody();
        HashMap<String, RequestLisListVo> map = new HashMap<String, RequestLisListVo>(1);
        RequestLisListVo requestLisList = RequestLisListVo.builder().idno(getReportListsReq.getIdNo()).cardNo(getReportListsReq.getCardNo()).name(getReportListsReq.getName()).timeStart(getReportListsReq.getBeginTime()).timeEnd(getReportListsReq.getEndTime()).build();
        map.put(EntityKeyEnum.INSPECTION_LIST.getValue(), requestLisList);
        FrontResponse frontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.INSPECTION_LIST.getValue(), map, ReponseLisListDTO.class);
        if (Objects.isNull(frontResponse)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-090\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38");
        }
        ReponseLisListDTO body = (ReponseLisListDTO)frontResponse.getBody();
        if (Objects.isNull(body)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-090\u63a5\u53e3\u8fd4\u56de\u5b9e\u4f53\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (!Objects.equals(body.getResult(), "0")) {
            return FrontResponse.error((String)param.getTransactionId(), (String)frontResponse.getErrCode(), (String)body.getErr());
        }
        List lisContents = body.getContent();
        if (CollectionUtils.isEmpty((Collection)lisContents)) {
            return FrontResponse.success((String)param.getTransactionId(), null);
        }
        ArrayList<GetReportListsRes> getReportListsResList = new ArrayList<GetReportListsRes>();
        for (LisContent lisContent : lisContents) {
            getReportListsResList.add(GetReportListsRes.builder().reportNo(lisContent.getApplyNo()).lisNo(lisContent.getLisNo()).reportName(lisContent.getLisName()).reportType("1").reportDate(lisContent.getReportTime()).build());
        }
        return FrontResponse.success((String)param.getTransactionId(), getReportListsResList);
    }

    private FrontResponse<List<GetReportListsRes>> getPacsReportList(FrontRequest<GetReportListsReq> param) {
        GetReportListsReq reportListsReq = (GetReportListsReq)param.getBody();
        HashMap<String, RequestPacsListVo> map = new HashMap<String, RequestPacsListVo>(1);
        RequestPacsListVo requestLisList = RequestPacsListVo.builder().idno(reportListsReq.getIdNo()).name(reportListsReq.getName()).startDate(reportListsReq.getBeginTime()).endDate(reportListsReq.getEndTime()).cardNo(reportListsReq.getCardNo()).build();
        map.put(EntityKeyEnum.INSPECTION_CHECK_LIST.getValue(), requestLisList);
        FrontResponse frontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.INSPECTION_CHECK_LIST.getValue(), map, ReponsePacsListDTO.class);
        if (Objects.isNull(frontResponse)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-092\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38");
        }
        ReponsePacsListDTO body = (ReponsePacsListDTO)frontResponse.getBody();
        if (Objects.isNull(body)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his-092\u63a5\u53e3\u8fd4\u56de\u5b9e\u4f53\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (!Objects.equals(body.getResult(), "0")) {
            return FrontResponse.error((String)param.getTransactionId(), (String)frontResponse.getErrCode(), (String)body.getErr());
        }
        List lisContents = body.getContent();
        if (CollectionUtils.isEmpty((Collection)lisContents)) {
            return FrontResponse.success((String)param.getTransactionId(), null);
        }
        ArrayList<GetReportListsRes> getReportListsResList = new ArrayList<GetReportListsRes>();
        for (ContentPacsList lisContent : lisContents) {
            getReportListsResList.add(GetReportListsRes.builder().reportNo(lisContent.getReportId()).reportName(lisContent.getReportName()).reportType("2").reportDate(lisContent.getApplyDate()).build());
        }
        return FrontResponse.success((String)param.getTransactionId(), getReportListsResList);
    }
}

