/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.hkdhisfront.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Aspect
@Component
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    public static final String REQUEST_HEADER = "x-forwarded-for";

    @Pointcut(value="execution(public * com.ebaiyihui.hkdhisfront.controller.*.*(..))")
    public void logAspect() {
    }

    @Around(value="logAspect()")
    public Object deAround(ProceedingJoinPoint pjp) throws Throwable {
        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes sra = (ServletRequestAttributes)ra;
        HttpServletRequest request = sra.getRequest();
        String ipaddress = request.getHeader("x-forwarded-for") == null ? request.getRemoteAddr() : request.getHeader("x-forwarded-for");
        String url = request.getRequestURL().toString();
        String method = request.getMethod();
        String queryString = request.getQueryString();
        Object[] args = pjp.getArgs();
        String params = this.paramSplicing(args, method, queryString);
        log.info("\u8bf7\u6c42\u5730\u5740:{},\u8bf7\u6c42ip:{}", (Object)url, (Object)ipaddress);
        log.info("\u8bf7\u6c42\u7c7b\u578b:{},\u8bf7\u6c42\u53c2\u6570:{}", (Object)method, (Object)params);
        Object result = pjp.proceed();
        if (null == result) {
            log.info("\u8bf7\u6c42\u7ed3\u675f\u7684\u8fd4\u56de\u503c\u4e3a\u7a7a");
        }
        log.info("\u8bf7\u6c42\u7ed3\u675f\u7684\u8fd4\u56de\u503c:" + JSON.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return result;
    }

    public static Map<String, Object> getKeyAndValue(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        Class<?> userCla = obj.getClass();
        Field[] fs = userCla.getDeclaredFields();
        for (int i = 0; i < fs.length; ++i) {
            Field f = fs[i];
            f.setAccessible(true);
            try {
                Object val = f.get(obj);
                map.put(f.getName(), val);
                continue;
            }
            catch (IllegalArgumentException e) {
                log.error("IllegalArgumentException:", (Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                log.error("IllegalAccessException:", (Throwable)e);
            }
        }
        return map;
    }

    private String paramSplicing(Object[] args, String method, String queryString) {
        String params = null;
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] instanceof ServletRequest || args[i] instanceof ServletResponse || args[i] instanceof MultipartFile) continue;
                if ("POST".equals(method)) {
                    Object object = args[i];
                    Map map = LogAspect.getKeyAndValue((Object)object);
                    params = JSON.toJSONString((Object)map);
                    continue;
                }
                if (!"GET".equals(method)) continue;
                params = queryString;
            }
        }
        return params;
    }
}

