/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.hkdhisfront.service.waitingqueue;

import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.symmetric.SM4;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.hkdhisfront.base.FrontRequest;
import com.ebaiyihui.hkdhisfront.base.FrontResponse;
import com.ebaiyihui.hkdhisfront.config.WaitingQueueProperties;
import com.ebaiyihui.hkdhisfront.service.waitingqueue.IWaitingQueueApi;
import com.ebaiyihui.hkdhisfront.service.waitingqueue.IWaitingQueueService;
import com.ebaiyihui.hkdhisfront.waitingqueue.PatientQueueInfo;
import com.ebaiyihui.hkdhisfront.waitingqueue.PatientQueueReq;
import com.ebaiyihui.hkdhisfront.waitingqueue.QueueResponse;
import com.ebaiyihui.hkdhisfront.waitingqueue.QueueTokenReq;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import retrofit2.Call;

@Service
public class WaitingQueueServiceImpl
implements IWaitingQueueService {
    private static final Logger log = LoggerFactory.getLogger(WaitingQueueServiceImpl.class);
    private final IWaitingQueueApi waitingQueueApi;
    private final WaitingQueueProperties waitingQueueProperties;

    public FrontResponse<String> getToken() {
        String pwd = this.waitingQueueProperties.getPwd();
        String key = this.waitingQueueProperties.getKey();
        SM4 sm4 = SmUtil.sm4((byte[])HexUtil.decodeHex((String)key));
        String encryptHexPwd = sm4.encryptHex(pwd);
        QueueTokenReq req = QueueTokenReq.builder().user_name(this.waitingQueueProperties.getUser()).password(encryptHexPwd).build();
        try {
            Call call = this.waitingQueueApi.getToken(req);
            QueueResponse response = (QueueResponse)call.execute().body();
            if (response.isSuccess()) {
                return FrontResponse.success(null, (Object)response.getResponse());
            }
            return FrontResponse.error(null, (String)IError.DATA_ERROR.getErrCode(), (String)response.getMsg());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6token\u5931\u8d25", (Throwable)e);
            return FrontResponse.error(null, (String)IError.DATA_ERROR.getErrCode(), (String)e.getMessage());
        }
    }

    public FrontResponse<List<PatientQueueInfo>> getPatientQueueInfo(FrontRequest<PatientQueueReq> param) {
        PatientQueueReq queueReq = (PatientQueueReq)param.getBody();
        String authorization = "Bearer " + queueReq.getToken();
        JSONObject params = new JSONObject();
        params.put("SearchCode", (Object)queueReq.getPatientId());
        params.put("triage_IP", (Object)"");
        String jsonString = params.toJSONString();
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)jsonString);
        try {
            Call call = this.waitingQueueApi.queryPatientWaitQueue(authorization, body);
            QueueResponse response = (QueueResponse)call.execute().body();
            if (response.isSuccess()) {
                String json = response.getResponse();
                log.info("\u83b7\u53d6\u60a3\u8005\u6392\u961f\u4fe1\u606f\u6210\u529f\uff1a{}", (Object)json);
                List responseData = JSONObject.parseArray((String)json, PatientQueueInfo.class);
                return FrontResponse.success((String)param.getTransactionId(), (Object)responseData);
            }
            return FrontResponse.error((String)param.getTransactionId(), (String)IError.DATA_ERROR.getErrCode(), (String)response.getMsg());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u60a3\u8005\u6392\u961f\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return FrontResponse.error((String)param.getTransactionId(), (String)IError.DATA_ERROR.getErrCode(), (String)e.getMessage());
        }
    }

    public WaitingQueueServiceImpl(IWaitingQueueApi waitingQueueApi, WaitingQueueProperties waitingQueueProperties) {
        this.waitingQueueApi = waitingQueueApi;
        this.waitingQueueProperties = waitingQueueProperties;
    }
}

