/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.pojo.dto.AppointRecordItems;
import com.ebaiyihui.his.pojo.dto.AppointReqDTO;
import com.ebaiyihui.his.pojo.dto.AppointmentRegisterResDTO;
import com.ebaiyihui.his.pojo.dto.CancelRegistrationResDto;
import com.ebaiyihui.his.pojo.dto.DayPreSettlementResDTO;
import com.ebaiyihui.his.pojo.dto.DayRegisterResDTO;
import com.ebaiyihui.his.pojo.dto.GetAppointRecordReqDTO;
import com.ebaiyihui.his.pojo.dto.GetAppointRecordResDTO;
import com.ebaiyihui.his.pojo.dto.PayDetailsItem;
import com.ebaiyihui.his.pojo.dto.RegisterReqDTO;
import com.ebaiyihui.his.pojo.dto.ReturnRegisterReqDTO;
import com.ebaiyihui.his.pojo.dto.nucleicAcidAppointmentResDTO;
import com.ebaiyihui.his.pojo.vo.AppointmentRegisterReqVO;
import com.ebaiyihui.his.pojo.vo.DayRegisterReqVO;
import com.ebaiyihui.his.service.AppointService;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.utils.CxfClientUtil;
import com.ebaiyihui.his.utils.DateUtil;
import com.ebaiyihui.his.utils.SnowflakeIdWorker;
import his.pojo.vo.appoint.AppointRecordItem;
import his.pojo.vo.appoint.CancelRegisterReq;
import his.pojo.vo.appoint.CancelRegisterRes;
import his.pojo.vo.appoint.ConfirmRegisterReq;
import his.pojo.vo.appoint.ConfirmRegisterRes;
import his.pojo.vo.appoint.DayRegisterReq;
import his.pojo.vo.appoint.DayRegisterRes;
import his.pojo.vo.appoint.GetAppointRecordReq;
import his.pojo.vo.appoint.GetAppointRecords;
import his.pojo.vo.appoint.LockOrderReq;
import his.pojo.vo.appoint.LockOrderRes;
import his.pojo.vo.appoint.PayRegistrationReq;
import his.pojo.vo.appoint.PayRegistrationRes;
import his.pojo.vo.appoint.ReturnRegisterReq;
import his.pojo.vo.appoint.ReturnRegisterRes;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import his.pojo.vo.day.DayPreSettlementReqVO;
import his.pojo.vo.nucleic.nucleicAcidAppointmentReq;
import his.pojo.vo.nucleic.nucleicAcidAppointmentRes;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppointServiceImpl
implements AppointService {
    private static final Logger log = LoggerFactory.getLogger(AppointServiceImpl.class);
    public static final String CLINIC_TYPE_APPOINT = "0";
    public static final String CLINIC_TYPE_CANCEL = "1";
    private static final String PAY_SUCCESS = "Y";
    private static final String PAY_FAIL = "N";
    private static final String HIS_PAY_SUCCESS = "SUCCESS";
    private static final String HIS_PAY_FAIL = "FAIL";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private HisRemoteService hisRemoteService;
    @Autowired
    private CxfClientUtil cxfClientUtil;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;

    public FrontResponse<PayRegistrationRes> payRegistration(FrontRequest<PayRegistrationReq> param) {
        log.info("\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            PayRegistrationReq body = (PayRegistrationReq)param.getBody();
            AppointReqDTO appointReqDTO = new AppointReqDTO();
            appointReqDTO.setTransactionId(body.getAppointId());
            appointReqDTO.setScheduleItemCode(body.getScheduleId());
            appointReqDTO.setExtUserID("hlwyy");
            appointReqDTO.setPatientID(body.getPatientId());
            appointReqDTO.setPayFee(body.getRegFee());
            appointReqDTO.setPayModeCode(body.getPayChannel());
            appointReqDTO.setPatientCard(body.getPatientId());
            appointReqDTO.setCardType("01");
            appointReqDTO.setPayTradeNo(body.getFlowNo());
            ArrayList<PayDetailsItem> payDetails = new ArrayList<PayDetailsItem>();
            PayDetailsItem payDetailsItem = new PayDetailsItem();
            payDetailsItem.setPayModeCode(body.getPayChannel());
            payDetailsItem.setPayAmt(body.getRespMsg().getPayment());
            payDetailsItem.setPlatformNo(body.getRespMsg().getOrderid());
            payDetailsItem.setOutPayNo(body.getFlowNo());
            payDetailsItem.setPayDate(body.getRespMsg().getAccdate().substring(0, 10));
            payDetailsItem.setPayTime(body.getRespMsg().getAccdate().substring(11, 19));
            payDetails.add(payDetailsItem);
            appointReqDTO.setPayDetails(payDetails);
            log.info("his\u6302\u53f7\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString((Object)appointReqDTO));
            PayRegistrationRes payRegistrationRes = new PayRegistrationRes();
            return FrontResponse.success((String)param.getTransactionId(), (Object)payRegistrationRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<CancelRegisterRes> cancelRegister(FrontRequest<CancelRegisterReq> param) {
        log.info("\u53d6\u6d88\u6302\u53f7\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            DayRegisterReqVO dayRegisterReqVO = new DayRegisterReqVO();
            dayRegisterReqVO.setHosCardNo(((CancelRegisterReq)param.getBody()).getCardNo());
            dayRegisterReqVO.setOrdNum(((CancelRegisterReq)param.getBody()).getLockQueueNo());
            HashMap<String, DayRegisterReqVO> paramMap = new HashMap<String, DayRegisterReqVO>();
            paramMap.put(EntityKeyEnum.CANCEL_REGISTRATION.getValue(), dayRegisterReqVO);
            log.info("\u9884\u7ea6\u6302\u53f7\u9000\u53f7 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString(paramMap, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            FrontResponse cancelRegistrationResDto = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.CANCEL_REGISTRATION.getValue(), paramMap, CancelRegistrationResDto.class);
            log.info("\u9884\u7ea6\u6302\u53f7\u9000\u53f7 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString((Object)cancelRegistrationResDto, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            if (Objects.isNull(cancelRegistrationResDto.getBody())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (!"00".equals(((CancelRegistrationResDto)cancelRegistrationResDto.getBody()).getResponseHeadDTO().getRetCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)((CancelRegistrationResDto)cancelRegistrationResDto.getBody()).getResponseHeadDTO().getRetMsg());
            }
            CancelRegisterRes cancelRegisterRes = new CancelRegisterRes();
            return FrontResponse.success((String)param.getTransactionId(), (Object)cancelRegisterRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u53d6\u6d88\u6302\u53f7\u8bf7\u6c42\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u53d6\u6d88\u6302\u53f7\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<ReturnRegisterRes> returnRegister(FrontRequest<ReturnRegisterReq> param) {
        log.info("\u9000\u53f7\u9000\u8d39\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            ReturnRegisterReq body = (ReturnRegisterReq)param.getBody();
            ReturnRegisterReqDTO returnRegisterReqDTO = new ReturnRegisterReqDTO();
            ReturnRegisterRes returnRegisterRes = new ReturnRegisterRes();
            return FrontResponse.success((String)param.getTransactionId(), (Object)returnRegisterRes);
        }
        catch (Exception e) {
            log.info("\u9000\u53f7\u9000\u8d39\u8bf7\u6c42\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u9000\u53f7\u9000\u8d39\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<GetAppointRecords> getAppointRecord(FrontRequest<GetAppointRecordReq> param) {
        log.info("\u67e5\u8be2\u6302\u53f7\u8bb0\u5f55\uff1a" + JSON.toJSONString(param));
        try {
            GetAppointRecordReq body = (GetAppointRecordReq)param.getBody();
            GetAppointRecordReqDTO getAppointRecordReqDTO = new GetAppointRecordReqDTO();
            getAppointRecordReqDTO.setHosCardNo(body.getCardNo());
            getAppointRecordReqDTO.setHosCardType("66");
            if (!"".equals(body.getStartDate()) && !"".equals(body.getEndDate())) {
                getAppointRecordReqDTO.setDateStart(DateUtil.dateToStr((Date)DateUtil.strToDate((String)body.getStartDate(), (String)"yyyy-MM-dd")));
                getAppointRecordReqDTO.setDateEnd(DateUtil.dateToStr((Date)DateUtil.strToDate((String)body.getEndDate(), (String)"yyyy-MM-dd")));
            }
            HashMap<String, GetAppointRecordReqDTO> paramMap = new HashMap<String, GetAppointRecordReqDTO>();
            paramMap.put(EntityKeyEnum.GET_APPOINT_RECORD.getValue(), getAppointRecordReqDTO);
            log.info("\u67e5\u8be2\u6302\u53f7\u8bb0\u5f55\u8bf7\u6c42his\u5165\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString(paramMap, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            FrontResponse hisResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.GET_APPOINT_RECORD.getValue(), paramMap, GetAppointRecordResDTO.class);
            log.info("\u67e5\u8be2\u6302\u53f7\u8bb0\u5f55\u8bf7\u6c42his\u51fa\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString((Object)hisResponse, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            if (Objects.isNull(hisResponse)) {
                return FrontResponse.error((String)hisResponse.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (Objects.isNull(hisResponse.getBody())) {
                return FrontResponse.error((String)hisResponse.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (Objects.isNull(((GetAppointRecordResDTO)hisResponse.getBody()).getResponseHeadDTO())) {
                return FrontResponse.error((String)hisResponse.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (!"00".equals(((GetAppointRecordResDTO)hisResponse.getBody()).getResponseHeadDTO().getRetCode())) {
                return FrontResponse.error((String)hisResponse.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)((GetAppointRecordResDTO)hisResponse.getBody()).getResponseHeadDTO().getRetMsg());
            }
            GetAppointRecords GetAppointRecords2 = new GetAppointRecords();
            ArrayList<AppointRecordItem> appointRecordItem = new ArrayList<AppointRecordItem>();
            List registerInfoItems = ((GetAppointRecordResDTO)hisResponse.getBody()).getData().getOrderInfo().getRegisterInfoItem();
            for (AppointRecordItems date : registerInfoItems) {
                AppointRecordItem appointRecord = new AppointRecordItem();
                BeanUtils.copyProperties((Object)date, (Object)appointRecord);
                appointRecordItem.add(appointRecord);
            }
            GetAppointRecords2.setAppointRecordItem(appointRecordItem);
            return FrontResponse.success((String)param.getTransactionId(), (Object)GetAppointRecords2);
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u6302\u53f7\u8bb0\u5f55\u5f02\u5e38 - > {}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u67e5\u8be2\u6302\u53f7\u8bb0\u5f55\u5f02\u5e38");
        }
    }

    public FrontResponse<DayRegisterRes> dayRegister(FrontRequest<DayRegisterReq> param) {
        DayRegisterReq body = (DayRegisterReq)param.getBody();
        DayRegisterReqVO dayRegisterReqVO = new DayRegisterReqVO();
        dayRegisterReqVO.setHisTransNo(body.getAdmNo());
        dayRegisterReqVO.setHosCardNo(body.getCardNo());
        dayRegisterReqVO.setHosCardType("66");
        dayRegisterReqVO.setOrdNum(body.getRbasId());
        dayRegisterReqVO.setDeptId(body.getDeptNo());
        dayRegisterReqVO.setDoctorId(body.getDoctorNo());
        dayRegisterReqVO.setTypeId(body.getPayChannel());
        dayRegisterReqVO.setZlf(body.getMedicalFee());
        dayRegisterReqVO.setGhf(body.getRegFee());
        dayRegisterReqVO.setRegisterTotalFee(Convert.toStr((Object)(Convert.toInt((Object)body.getRegFee()) + Convert.toInt((Object)body.getMedicalFee()))));
        dayRegisterReqVO.setPayAmount(Convert.toStr((Object)(Convert.toInt((Object)body.getRegFee()) + Convert.toInt((Object)body.getMedicalFee()))));
        dayRegisterReqVO.setPayMethod("02");
        dayRegisterReqVO.setTrace(param.getTransactionId());
        dayRegisterReqVO.setStartTime(body.getTimeArrangeId());
        dayRegisterReqVO.setEndTime(body.getTimeFlag());
        HashMap<String, DayRegisterReqVO> paramMap = new HashMap<String, DayRegisterReqVO>();
        paramMap.put(EntityKeyEnum.DAY_REGISTER.getValue(), dayRegisterReqVO);
        log.info("\u5f53\u65e5\u6302\u53f7\u8bf7\u6c42his\u5165\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString(paramMap, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
        FrontResponse dayRegisterResDTOFrontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.DAY_REGISTER.getValue(), paramMap, DayRegisterResDTO.class);
        log.info("\u5f53\u65e5\u6302\u53f7\u8bf7\u6c42his\u51fa\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString((Object)dayRegisterResDTOFrontResponse, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
        if (Objects.isNull(dayRegisterResDTOFrontResponse)) {
            return FrontResponse.error((String)dayRegisterResDTOFrontResponse.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
        }
        if (Objects.isNull(dayRegisterResDTOFrontResponse.getBody())) {
            return FrontResponse.error((String)dayRegisterResDTOFrontResponse.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
        }
        if (Objects.isNull(((DayRegisterResDTO)dayRegisterResDTOFrontResponse.getBody()).getResponseHeadDTO())) {
            return FrontResponse.error((String)dayRegisterResDTOFrontResponse.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
        }
        if (!"00".equals(((DayRegisterResDTO)dayRegisterResDTOFrontResponse.getBody()).getResponseHeadDTO().getRetCode())) {
            return FrontResponse.error((String)dayRegisterResDTOFrontResponse.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)((DayRegisterResDTO)dayRegisterResDTOFrontResponse.getBody()).getResponseHeadDTO().getRetMsg());
        }
        DayRegisterRes dayRegisterRes = new DayRegisterRes();
        dayRegisterRes.setAppointId(((DayRegisterResDTO)dayRegisterResDTOFrontResponse.getBody()).getData().getHisTransNo());
        dayRegisterRes.setReceiptId(((DayRegisterResDTO)dayRegisterResDTOFrontResponse.getBody()).getData().getPatientId());
        dayRegisterRes.setNo(((DayRegisterResDTO)dayRegisterResDTOFrontResponse.getBody()).getData().getExtend1());
        return FrontResponse.success((String)dayRegisterResDTOFrontResponse.getTransactionId(), (Object)dayRegisterRes);
    }

    public FrontResponse<ConfirmRegisterRes> confirmRegister(FrontRequest<ConfirmRegisterReq> param) {
        ConfirmRegisterReq body = (ConfirmRegisterReq)param.getBody();
        AppointmentRegisterReqVO appointmentRegisterReqVO = new AppointmentRegisterReqVO();
        appointmentRegisterReqVO.setHosCardNo(body.getCardNo());
        appointmentRegisterReqVO.setHosCardType("66");
        appointmentRegisterReqVO.setHosCardName(body.getPayChannel());
        appointmentRegisterReqVO.setDeptId(body.getDeptNo());
        appointmentRegisterReqVO.setDoctorId(body.getDoctorNo());
        appointmentRegisterReqVO.setTypeId(body.getRbasId());
        appointmentRegisterReqVO.setTimeDesc(body.getTimeFlag());
        appointmentRegisterReqVO.setVisitDate(body.getClinicDate());
        appointmentRegisterReqVO.setClinicLabel(body.getFlowNo());
        appointmentRegisterReqVO.setOrdNum(body.getAdmNo());
        appointmentRegisterReqVO.setStartTime(body.getMedicalFee());
        appointmentRegisterReqVO.setEndTime(body.getRegFee());
        HashMap<String, AppointmentRegisterReqVO> paramMap = new HashMap<String, AppointmentRegisterReqVO>();
        paramMap.put(EntityKeyEnum.APPOINTMENT_REGISTER.getValue(), appointmentRegisterReqVO);
        log.info("\u9884\u7ea6\u6302\u53f7\u8bf7\u6c42his\u5165\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString(paramMap, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
        FrontResponse appointmentRegisterResDTOFrontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.APPOINTMENT_REGISTER.getValue(), paramMap, AppointmentRegisterResDTO.class);
        log.info("\u9884\u7ea6\u6302\u53f7\u8bf7\u6c42his\u51fa\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString((Object)appointmentRegisterResDTOFrontResponse, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
        if (Objects.isNull(appointmentRegisterResDTOFrontResponse)) {
            return FrontResponse.error((String)appointmentRegisterResDTOFrontResponse.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
        }
        if (Objects.isNull(appointmentRegisterResDTOFrontResponse.getBody())) {
            return FrontResponse.error((String)appointmentRegisterResDTOFrontResponse.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
        }
        if (Objects.isNull(((AppointmentRegisterResDTO)appointmentRegisterResDTOFrontResponse.getBody()).getResponseHeadDTO())) {
            return FrontResponse.error((String)appointmentRegisterResDTOFrontResponse.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
        }
        if (!"00".equals(((AppointmentRegisterResDTO)appointmentRegisterResDTOFrontResponse.getBody()).getResponseHeadDTO().getRetCode())) {
            return FrontResponse.error((String)appointmentRegisterResDTOFrontResponse.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)((AppointmentRegisterResDTO)appointmentRegisterResDTOFrontResponse.getBody()).getResponseHeadDTO().getRetMsg());
        }
        ConfirmRegisterRes confirmRegisterRes = new ConfirmRegisterRes();
        confirmRegisterRes.setAppointId(((AppointmentRegisterResDTO)appointmentRegisterResDTOFrontResponse.getBody()).getData().getPatientId());
        confirmRegisterRes.setNo(((AppointmentRegisterResDTO)appointmentRegisterResDTOFrontResponse.getBody()).getData().getHisTransNo());
        confirmRegisterRes.setAdmitTimeRange(((AppointmentRegisterResDTO)appointmentRegisterResDTOFrontResponse.getBody()).getData().getTransDate());
        return FrontResponse.success((String)appointmentRegisterResDTOFrontResponse.getTransactionId(), (Object)confirmRegisterRes);
    }

    public FrontResponse<LockOrderRes> lockOrder(FrontRequest<LockOrderReq> param) {
        log.info("\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            LockOrderReq body = (LockOrderReq)param.getBody();
            RegisterReqDTO registerReqDTO = new RegisterReqDTO();
            HashMap map = new HashMap();
            LockOrderRes lockOrderRes = new LockOrderRes();
            return FrontResponse.success((String)param.getTransactionId(), (Object)lockOrderRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<PayRegistrationRes> dayPayRegistration(FrontRequest<PayRegistrationReq> param) {
        PayRegistrationReq payRegistrationReq = (PayRegistrationReq)param.getBody();
        DayPreSettlementReqVO dayPreSettlementReqVO = new DayPreSettlementReqVO();
        dayPreSettlementReqVO.setHosCardType("66");
        dayPreSettlementReqVO.setHosCardNo(payRegistrationReq.getCardNo());
        dayPreSettlementReqVO.setDoctorId(payRegistrationReq.getPatientId());
        dayPreSettlementReqVO.setDeptId(payRegistrationReq.getAppointId());
        dayPreSettlementReqVO.setTypeId(payRegistrationReq.getScheduleId());
        HashMap<String, DayPreSettlementReqVO> paramMap = new HashMap<String, DayPreSettlementReqVO>();
        paramMap.put(EntityKeyEnum.DAY_PRE_SETTLEMENT.getValue(), dayPreSettlementReqVO);
        log.info("\u5f53\u65e5\u6302\u53f7\u9884\u7ed3\u7b97\u8bf7\u6c42his\u5165\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString(paramMap, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
        FrontResponse dayPreSettlementResDTOFrontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.DAY_PRE_SETTLEMENT.getValue(), paramMap, DayPreSettlementResDTO.class);
        log.info("\u5f53\u65e5\u6302\u53f7\u9884\u7ed3\u7b97\u8bf7\u6c42his\u51fa\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString((Object)dayPreSettlementResDTOFrontResponse, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
        if (Objects.isNull(dayPreSettlementResDTOFrontResponse)) {
            return FrontResponse.error((String)dayPreSettlementResDTOFrontResponse.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
        }
        if (Objects.isNull(dayPreSettlementResDTOFrontResponse.getBody())) {
            return FrontResponse.error((String)dayPreSettlementResDTOFrontResponse.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
        }
        if (Objects.isNull(((DayPreSettlementResDTO)dayPreSettlementResDTOFrontResponse.getBody()).getResponseHeadDTO())) {
            return FrontResponse.error((String)dayPreSettlementResDTOFrontResponse.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
        }
        if (!"00".equals(((DayPreSettlementResDTO)dayPreSettlementResDTOFrontResponse.getBody()).getResponseHeadDTO().getRetCode())) {
            return FrontResponse.error((String)dayPreSettlementResDTOFrontResponse.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)((DayPreSettlementResDTO)dayPreSettlementResDTOFrontResponse.getBody()).getResponseHeadDTO().getRetMsg());
        }
        PayRegistrationRes registrationRes = new PayRegistrationRes();
        registrationRes.setAdmId(((DayPreSettlementResDTO)dayPreSettlementResDTOFrontResponse.getBody()).getData().getSjh());
        registrationRes.setReceiptId(((DayPreSettlementResDTO)dayPreSettlementResDTOFrontResponse.getBody()).getData().getSjh());
        registrationRes.setTotalRegFee(((DayPreSettlementResDTO)dayPreSettlementResDTOFrontResponse.getBody()).getData().getRegisterTotalFee());
        registrationRes.setRegistFee(((DayPreSettlementResDTO)dayPreSettlementResDTOFrontResponse.getBody()).getData().getGhf());
        registrationRes.setInspectFee(((DayPreSettlementResDTO)dayPreSettlementResDTOFrontResponse.getBody()).getData().getZlf());
        registrationRes.setNo(((DayPreSettlementResDTO)dayPreSettlementResDTOFrontResponse.getBody()).getData().getPatientId());
        registrationRes.setAdmitAddress(((DayPreSettlementResDTO)dayPreSettlementResDTOFrontResponse.getBody()).getData().getExtend1());
        return FrontResponse.success((String)dayPreSettlementResDTOFrontResponse.getTransactionId(), (Object)registrationRes);
    }

    public FrontResponse<nucleicAcidAppointmentRes> nucleicAcidAppointment(nucleicAcidAppointmentReq param) {
        try {
            param.setTradeId("ZFBT");
            HashMap<String, nucleicAcidAppointmentReq> paramMap = new HashMap<String, nucleicAcidAppointmentReq>();
            paramMap.put(EntityKeyEnum.NUCLEIC_ACID_APPOINTMENT.getValue(), param);
            log.info("\u5f53\u65e5\u6302\u53f7\u6838\u9178\u9884\u7ea6\u8bf7\u6c42his\u5165\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString(paramMap, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            FrontResponse dayPreSettlementResDTOFrontResponse = this.hisRemoteService.requestHisUrlHzGh("http://61.178.141.148:57772//csp/jcjt/BS.WS.HMPTWS.CLS", null, Convert.toStr((Object)this.snowflakeIdWorker), MethodCodeEnum.NUCLEIC_ACID_APPOINTMENT.getValue(), paramMap, nucleicAcidAppointmentResDTO.class);
            if (null == dayPreSettlementResDTOFrontResponse) {
                return FrontResponse.error((String)dayPreSettlementResDTOFrontResponse.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"his\u63a5\u53e3\u8fd4\u56de\u9519\u8bef");
            }
            if (null == dayPreSettlementResDTOFrontResponse.getBody()) {
                return FrontResponse.error((String)dayPreSettlementResDTOFrontResponse.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"his\u63a5\u53e3\u8fd4\u56de\u9519\u8bef");
            }
            if (((nucleicAcidAppointmentResDTO)dayPreSettlementResDTOFrontResponse.getBody()).getResultCode().equals(CLINIC_TYPE_CANCEL)) {
                return FrontResponse.error((String)dayPreSettlementResDTOFrontResponse.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)((nucleicAcidAppointmentResDTO)dayPreSettlementResDTOFrontResponse.getBody()).getMsg());
            }
            if (null == ((nucleicAcidAppointmentResDTO)dayPreSettlementResDTOFrontResponse.getBody()).getOrderId()) {
                return FrontResponse.error((String)dayPreSettlementResDTOFrontResponse.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)((nucleicAcidAppointmentResDTO)dayPreSettlementResDTOFrontResponse.getBody()).getMsg());
            }
            nucleicAcidAppointmentRes nucleicAcidAppointmentRes2 = (nucleicAcidAppointmentRes)BeanUtil.copyProperties((Object)dayPreSettlementResDTOFrontResponse.getBody(), nucleicAcidAppointmentRes.class, (String[])new String[0]);
            return FrontResponse.success((String)dayPreSettlementResDTOFrontResponse.getTransactionId(), (Object)nucleicAcidAppointmentRes2);
        }
        catch (Exception e) {
            log.error("\u6838\u9178\u6302\u53f7\u63a5\u53e3\u4e0b\u5355\u51fa\u9519 \u9519\u8bef\u4fe1\u606f\u4e3a->{}", (Throwable)e);
            return FrontResponse.error(null, (String)CLINIC_TYPE_APPOINT, (String)e.toString());
        }
    }
}

