/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.pojo.dto.JCDetialResDTO;
import com.ebaiyihui.his.pojo.dto.JyReportQueryItemResDTO;
import com.ebaiyihui.his.pojo.dto.LisReportQueryItemResDTO;
import com.ebaiyihui.his.pojo.dto.LisReportQueryReqDTO;
import com.ebaiyihui.his.pojo.dto.QueryJcDetilResDTO;
import com.ebaiyihui.his.pojo.dto.QueryJcListResDTO;
import com.ebaiyihui.his.pojo.dto.QueryJyDetialResDTO;
import com.ebaiyihui.his.pojo.dto.QueryJyListResDTO;
import com.ebaiyihui.his.pojo.dto.ReportListDTO;
import com.ebaiyihui.his.service.ElectronicReportService;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.utils.CxfClientUtil;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import his.pojo.vo.report.GetReportListsReq;
import his.pojo.vo.report.GetReportListsRes;
import his.pojo.vo.report.LisReportListReq;
import his.pojo.vo.report.LisReportListRes;
import his.pojo.vo.report.PacsReportListReq;
import his.pojo.vo.report.PacsReportListRes;
import his.pojo.vo.report.datas.GetReportListsData;
import his.pojo.vo.report.datas.LisReportListResData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElectronicReportServiceImpl
implements ElectronicReportService {
    private static final Logger log = LoggerFactory.getLogger(ElectronicReportServiceImpl.class);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int MAP_SIZE = 1;
    public static final String SUCCESS_FLAG = "0";
    @Autowired
    private HisRemoteService hisRemoteService;
    @Autowired
    private CxfClientUtil cxfClientUtil;

    public FrontResponse<GetReportListsRes> getJYReportLists(FrontRequest<GetReportListsReq> param) {
        log.info("\u68c0\u9a8c\u62a5\u544a\u5217\u8868\u67e5\u8be2his\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetReportListsReq getReportListsReq = (GetReportListsReq)param.getBody();
            ReportListDTO jyReportDTO = new ReportListDTO();
            jyReportDTO.setHosCardNo(getReportListsReq.getCardNo());
            jyReportDTO.setHosCardType("66");
            HashMap<String, ReportListDTO> paramMap = new HashMap<String, ReportListDTO>();
            paramMap.put(EntityKeyEnum.GET_REPORT_LISTS.getValue(), jyReportDTO);
            log.info("\u68c0\u9a8c\u62a5\u544a\u5217\u8868\u67e5\u8be2\u8bf7\u6c42his\u5165\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString(paramMap, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            FrontResponse hisResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.GET_JY_REPORT_LISTS.getValue(), paramMap, QueryJyListResDTO.class);
            log.info("\u68c0\u9a8c\u62a5\u544a\u5217\u8868\u67e5\u8be2\u8bf7\u6c42his\u51fa\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString((Object)hisResponse, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            if (Objects.isNull(hisResponse)) {
                return FrontResponse.error((String)hisResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (Objects.isNull(hisResponse.getBody())) {
                return FrontResponse.error((String)hisResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (Objects.isNull(((QueryJyListResDTO)hisResponse.getBody()).getResponseHeadDTO())) {
                return FrontResponse.error((String)hisResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (!"00".equals(((QueryJyListResDTO)hisResponse.getBody()).getResponseHeadDTO().getRetCode())) {
                return FrontResponse.error((String)hisResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)((QueryJyListResDTO)hisResponse.getBody()).getResponseHeadDTO().getRetMsg());
            }
            GetReportListsRes getReportListsRes = new GetReportListsRes();
            ArrayList<GetReportListsData> GetReportListsDataItem = new ArrayList<GetReportListsData>();
            List lisReportQueryItemResDTOList = ((QueryJyListResDTO)hisResponse.getBody()).getData().getLisReportQueryItemResDTO().getLisReportQueryItemResDTOList();
            for (JyReportQueryItemResDTO date : lisReportQueryItemResDTOList) {
                GetReportListsData getReportListsData = new GetReportListsData();
                getReportListsData.setReportNo(date.getRepId());
                getReportListsData.setReportName(date.getRepName());
                getReportListsData.setReportDate(date.getRepTime());
                getReportListsData.setSpecName(date.getSpecimen());
                getReportListsData.setRecTime(date.getRegTime());
                getReportListsData.setAuthTime(date.getRepTime());
                getReportListsData.setAuthUser(date.getDocName());
                getReportListsData.setRecUser(date.getDocName());
                getReportListsData.setDoctorName(date.getDocName());
                getReportListsData.setDeptName(date.getDeptName());
                getReportListsData.setRelevantClinicDiag(date.getRelevantClinicDiag());
                GetReportListsDataItem.add(getReportListsData);
            }
            getReportListsRes.setDatas(GetReportListsDataItem);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getReportListsRes);
        }
        catch (Exception e) {
            log.info("\u68c0\u9a8c\u62a5\u544a\u5217\u8868\u67e5\u8be2\u5f02\u5e38- > {}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u68c0\u9a8c\u62a5\u544a\u5217\u8868\u67e5\u8be2\u5f02\u5e38");
        }
    }

    public FrontResponse<GetReportListsRes> getJCReportLists(FrontRequest<GetReportListsReq> param) {
        log.info("\u68c0\u67e5\u62a5\u544a\u5217\u8868\u67e5\u8be2his\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetReportListsReq getReportListsReq = (GetReportListsReq)param.getBody();
            ReportListDTO jyReportDTO = new ReportListDTO();
            jyReportDTO.setHosCardNo(getReportListsReq.getCardNo());
            jyReportDTO.setHosCardType("66");
            HashMap<String, ReportListDTO> paramMap = new HashMap<String, ReportListDTO>();
            paramMap.put(EntityKeyEnum.GET_REPORT_LISTS.getValue(), jyReportDTO);
            log.info("\u68c0\u67e5\u62a5\u544a\u5217\u8868\u67e5\u8be2\u8bf7\u6c42his\u5165\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString(paramMap, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            FrontResponse hisResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.GET_REPORT_LISTS.getValue(), paramMap, QueryJcListResDTO.class);
            log.info("\u68c0\u67e5\u62a5\u544a\u5217\u8868\u67e5\u8be2\u8bf7\u6c42his\u51fa\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString((Object)hisResponse, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            if (Objects.isNull(hisResponse)) {
                return FrontResponse.error((String)hisResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (Objects.isNull(hisResponse.getBody())) {
                return FrontResponse.error((String)hisResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (Objects.isNull(((QueryJcListResDTO)hisResponse.getBody()).getResponseHeadDTO())) {
                return FrontResponse.error((String)hisResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (!"00".equals(((QueryJcListResDTO)hisResponse.getBody()).getResponseHeadDTO().getRetCode())) {
                return FrontResponse.error((String)hisResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)((QueryJcListResDTO)hisResponse.getBody()).getResponseHeadDTO().getRetMsg());
            }
            GetReportListsRes getReportListsRes = new GetReportListsRes();
            ArrayList<GetReportListsData> GetReportListsDataItem = new ArrayList<GetReportListsData>();
            List item = ((QueryJcListResDTO)hisResponse.getBody()).getData().getLisReportQueryItemResDTOList().getItem();
            for (LisReportQueryItemResDTO date : item) {
                GetReportListsData getReportListsData = new GetReportListsData();
                getReportListsData.setReportNo(date.getRepId());
                getReportListsData.setReportName(date.getRepName());
                getReportListsData.setReportDate(date.getRepTime());
                GetReportListsDataItem.add(getReportListsData);
            }
            getReportListsRes.setDatas(GetReportListsDataItem);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getReportListsRes);
        }
        catch (Exception e) {
            log.info("\u68c0\u67e5\u62a5\u544a\u5217\u8868\u67e5\u8be2\u5f02\u5e38- > {}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u68c0\u67e5\u62a5\u544a\u5217\u8868\u67e5\u8be2\u5f02\u5e38");
        }
    }

    public FrontResponse<LisReportListRes> lisReportList(FrontRequest<LisReportListReq> param) {
        log.info("\u67e5\u8be2\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            LisReportListReq body = (LisReportListReq)param.getBody();
            LisReportQueryReqDTO lisReportQueryReqDTO = new LisReportQueryReqDTO();
            lisReportQueryReqDTO.setRepId(body.getReportNo());
            HashMap<String, LisReportQueryReqDTO> paramMap = new HashMap<String, LisReportQueryReqDTO>();
            paramMap.put(EntityKeyEnum.GET_REPORT_DETIAL.getValue(), lisReportQueryReqDTO);
            log.info("\u83b7\u53d6\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5 \u8bf7\u6c42his\u5165\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString(paramMap, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            FrontResponse hisResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.GET_JY_DETIAL.getValue(), paramMap, QueryJyDetialResDTO.class);
            log.info("\u83b7\u53d6\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5 \u8bf7\u6c42his\u51fa\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString((Object)hisResponse, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            if (Objects.isNull(hisResponse)) {
                return FrontResponse.error((String)hisResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (Objects.isNull(hisResponse.getBody())) {
                return FrontResponse.error((String)hisResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (Objects.isNull(((QueryJyDetialResDTO)hisResponse.getBody()).getResponseHeadDTO())) {
                return FrontResponse.error((String)hisResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (!"00".equals(((QueryJyDetialResDTO)hisResponse.getBody()).getResponseHeadDTO().getRetCode())) {
                return FrontResponse.error((String)hisResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)((QueryJyDetialResDTO)hisResponse.getBody()).getResponseHeadDTO().getRetMsg());
            }
            LisReportListRes lisReportListRes = new LisReportListRes();
            ArrayList datas = new ArrayList();
            List jyReportDetialList = ((QueryJyDetialResDTO)hisResponse.getBody()).getData().getJyReportDetialList().getJyReportDetialList();
            jyReportDetialList.stream().forEach(date -> {
                LisReportListResData lisReportListResData = new LisReportListResData();
                lisReportListResData.setItmCode(date.getItemCode());
                lisReportListResData.setItmName(date.getItemName());
                lisReportListResData.setItmUnit(date.getItemUnits());
                lisReportListResData.setItmRanges(date.getNormalVal());
                lisReportListResData.setItmRes(date.getItemVal());
                lisReportListResData.setItmCrises(date.getFlag());
                datas.add(lisReportListResData);
            });
            lisReportListRes.setDatas(datas);
            return FrontResponse.success((String)param.getTransactionId(), (Object)lisReportListRes);
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u5f02\u5e38- > {}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u5f02\u5e38");
        }
    }

    public FrontResponse<PacsReportListRes> pacsReportList(FrontRequest<PacsReportListReq> param) {
        log.info("\u67e5\u8be2\u68c0\u67e5\u62a5\u544a\u8be6\u60c5\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            PacsReportListReq body = (PacsReportListReq)param.getBody();
            LisReportQueryReqDTO lisReportQueryReqDTO = new LisReportQueryReqDTO();
            lisReportQueryReqDTO.setRepId(body.getReportNo());
            HashMap<String, LisReportQueryReqDTO> paramMap = new HashMap<String, LisReportQueryReqDTO>();
            paramMap.put(EntityKeyEnum.GET_REPORT_DETIAL.getValue(), lisReportQueryReqDTO);
            log.info("\u67e5\u8be2\u68c0\u67e5\u62a5\u544a\u8be6\u60c5\u6c42\u8bf7\u6c42his\u5165\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString(paramMap, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            FrontResponse hisResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.GET_JC_DETIAL.getValue(), paramMap, QueryJcDetilResDTO.class);
            log.info("\u67e5\u8be2\u68c0\u67e5\u62a5\u544a\u8be6\u60c5\u6c42\u8bf7\u6c42his\u51fa\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString((Object)hisResponse, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            if (Objects.isNull(hisResponse)) {
                return FrontResponse.error((String)hisResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (Objects.isNull(hisResponse.getBody())) {
                return FrontResponse.error((String)hisResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (Objects.isNull(((QueryJcDetilResDTO)hisResponse.getBody()).getResponseHeadDTO())) {
                return FrontResponse.error((String)hisResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (!"00".equals(((QueryJcDetilResDTO)hisResponse.getBody()).getResponseHeadDTO().getRetCode())) {
                return FrontResponse.error((String)hisResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)((QueryJcDetilResDTO)hisResponse.getBody()).getResponseHeadDTO().getRetMsg());
            }
            JCDetialResDTO jcDetialResDTO = (JCDetialResDTO)((QueryJcDetilResDTO)hisResponse.getBody()).getData().getJyReportDetial().getJyReportDetialList().get(0);
            PacsReportListRes pacsReportListRes = new PacsReportListRes();
            pacsReportListRes.setDeptName(jcDetialResDTO.getDeptName());
            pacsReportListRes.setDoctorName(jcDetialResDTO.getDocName());
            pacsReportListRes.setAuthTime(jcDetialResDTO.getRepTime());
            pacsReportListRes.setCheckResult(jcDetialResDTO.getDiagnosis());
            pacsReportListRes.setAuthUser(jcDetialResDTO.getApproveDoc());
            pacsReportListRes.setCheckDesc(jcDetialResDTO.getDescription());
            return FrontResponse.success((String)param.getTransactionId(), (Object)pacsReportListRes);
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u68c0\u67e5\u62a5\u544a\u8be6\u60c5\u5f02\u5e38- > {}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u68c0\u67e5\u62a5\u544a\u8be6\u60c5\u5f02\u5e38");
        }
    }
}

