/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.pojo.dto.GetInpAdmisssionReqDTO;
import com.ebaiyihui.his.pojo.dto.GetInpCostDetailReqDTO;
import com.ebaiyihui.his.pojo.dto.GetInpCostDetailResDTO;
import com.ebaiyihui.his.pojo.dto.GetInpCostDetailResItemsDTO;
import com.ebaiyihui.his.pojo.dto.HosDepositRecordReqDTO;
import com.ebaiyihui.his.pojo.dto.InpatientInmationResDTO;
import com.ebaiyihui.his.pojo.dto.PaymentHospitalizationResDTO;
import com.ebaiyihui.his.pojo.dto.paymentHospitalizationReqVO;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.HospitalizationService;
import com.ebaiyihui.his.utils.CxfClientUtil;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import his.pojo.vo.hospitalization.DepositReq;
import his.pojo.vo.hospitalization.DepositRes;
import his.pojo.vo.hospitalization.GetIPDepositRecordsReq;
import his.pojo.vo.hospitalization.GetIPDepositRecordsRes;
import his.pojo.vo.hospitalization.GetInpAdmissionReq;
import his.pojo.vo.hospitalization.GetInpAdmissionRes;
import his.pojo.vo.hospitalization.GetOrdItemsReq;
import his.pojo.vo.hospitalization.GetOrdItemsRes;
import his.pojo.vo.hospitalization.items.GetInpAdmissionResItems;
import his.pojo.vo.hospitalization.items.GetOrdItemsResItems;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HospitalizationServiceImpl
implements HospitalizationService {
    private static final Logger log = LoggerFactory.getLogger(HospitalizationServiceImpl.class);
    public static final String HIS_OUT_HOSP_STATUS = "1";
    public static final String BYH_OUT_HOSP_STATUS = "D";
    public static final String BYH_IN_HOSP_STATUS = "A";
    public static final int MAP_SIZE = 1;
    public static final String SUCCESS_FLAG = "0";
    private static final String PAY_SUCCESS = "Y";
    private static final String PAY_FAIL = "N";
    private static final String HIS_PAY_SUCCESS = "SUCCESS";
    private static final String HIS_PAY_FAIL = "FAIL";
    @Autowired
    private HisRemoteService hisRemoteService;
    @Autowired
    private CxfClientUtil cxfClientUtil;

    public FrontResponse<GetInpAdmissionRes> getInpAdmission(FrontRequest<GetInpAdmissionReq> param) {
        log.info("\u67e5\u8be2\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetInpAdmissionReq body = (GetInpAdmissionReq)param.getBody();
            GetInpAdmisssionReqDTO getInpAdmisssionReqDTO = new GetInpAdmisssionReqDTO();
            getInpAdmisssionReqDTO.setCardNo(body.getCardNo());
            getInpAdmisssionReqDTO.setCardType("66");
            HashMap<String, GetInpAdmisssionReqDTO> map = new HashMap<String, GetInpAdmisssionReqDTO>();
            map.put(EntityKeyEnum.HOSPITALIZATION.getValue(), getInpAdmisssionReqDTO);
            log.info("\u8bf7\u6c42his\u67e5\u8be2\u60a3\u8005\u4f4f\u9662\u4fe1\u606f\u5165\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString(map, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            FrontResponse timeInfoResDTOFrontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.HOSPITALIZATION.getValue(), map, InpatientInmationResDTO.class);
            log.info("\u8bf7\u6c42his\u67e5\u8be2\u60a3\u8005\u4f4f\u9662\u4fe1\u606f\u51fa\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString((Object)timeInfoResDTOFrontResponse.getBody(), (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            if (Objects.isNull(timeInfoResDTOFrontResponse)) {
                return FrontResponse.error((String)timeInfoResDTOFrontResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (Objects.isNull(timeInfoResDTOFrontResponse.getBody())) {
                return FrontResponse.error((String)timeInfoResDTOFrontResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (Objects.isNull(((InpatientInmationResDTO)timeInfoResDTOFrontResponse.getBody()).getResponseHeadDTO())) {
                return FrontResponse.error((String)timeInfoResDTOFrontResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (!"00".equals(((InpatientInmationResDTO)timeInfoResDTOFrontResponse.getBody()).getResponseHeadDTO().getRetCode())) {
                return FrontResponse.error((String)timeInfoResDTOFrontResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)((InpatientInmationResDTO)timeInfoResDTOFrontResponse.getBody()).getResponseHeadDTO().getRetMsg());
            }
            GetInpAdmissionRes getInpAdmissionRes = new GetInpAdmissionRes();
            ArrayList<GetInpAdmissionResItems> GetInpAdmissionResItemsItem = new ArrayList<GetInpAdmissionResItems>();
            GetInpAdmissionResItems getInpAdmissionResItems = new GetInpAdmissionResItems();
            getInpAdmissionResItems.setInHospNo(((InpatientInmationResDTO)timeInfoResDTOFrontResponse.getBody()).getData().getInHosNo());
            getInpAdmissionResItems.setHospStatus(((InpatientInmationResDTO)timeInfoResDTOFrontResponse.getBody()).getData().getExtend1().equals(HIS_OUT_HOSP_STATUS) ? BYH_OUT_HOSP_STATUS : BYH_IN_HOSP_STATUS);
            getInpAdmissionResItems.setStartDate(((InpatientInmationResDTO)timeInfoResDTOFrontResponse.getBody()).getData().getInHosDate());
            getInpAdmissionResItems.setDeptName(((InpatientInmationResDTO)timeInfoResDTOFrontResponse.getBody()).getData().getDeptName());
            getInpAdmissionResItems.setPatientId(((InpatientInmationResDTO)timeInfoResDTOFrontResponse.getBody()).getData().getCertNo());
            getInpAdmissionResItems.setPatientName(((InpatientInmationResDTO)timeInfoResDTOFrontResponse.getBody()).getData().getInHosPatientName());
            getInpAdmissionResItems.setBed(((InpatientInmationResDTO)timeInfoResDTOFrontResponse.getBody()).getData().getBed());
            getInpAdmissionResItems.setPatientSex(((InpatientInmationResDTO)timeInfoResDTOFrontResponse.getBody()).getData().getSex());
            getInpAdmissionResItems.setCardNo(((InpatientInmationResDTO)timeInfoResDTOFrontResponse.getBody()).getData().getHosCardNo());
            getInpAdmissionResItems.setTotalMoney(((InpatientInmationResDTO)timeInfoResDTOFrontResponse.getBody()).getData().getTotalFee());
            getInpAdmissionResItems.setCurrentMoney(((InpatientInmationResDTO)timeInfoResDTOFrontResponse.getBody()).getData().getPrePayTotalAmount());
            getInpAdmissionResItems.setDepost(Convert.toBigDecimal((Object)((InpatientInmationResDTO)timeInfoResDTOFrontResponse.getBody()).getData().getTotalFee()).add(Convert.toBigDecimal((Object)((InpatientInmationResDTO)timeInfoResDTOFrontResponse.getBody()).getData().getPrePayTotalAmount())).toString());
            GetInpAdmissionResItemsItem.add(getInpAdmissionResItems);
            getInpAdmissionRes.setItems(GetInpAdmissionResItemsItem);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getInpAdmissionRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u8bf7\u6c42\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<DepositRes> deposit(FrontRequest<DepositReq> param) {
        log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            DepositReq body = (DepositReq)param.getBody();
            paymentHospitalizationReqVO paymentHospitalizationReqVO2 = new paymentHospitalizationReqVO();
            paymentHospitalizationReqVO2.setHosCardNo(body.getAdmID());
            paymentHospitalizationReqVO2.setHosCardType("66");
            paymentHospitalizationReqVO2.setPayMethod("04");
            paymentHospitalizationReqVO2.setOrderNum(body.getFlowNo());
            paymentHospitalizationReqVO2.setMerchantOrderNum(body.getRespmsg().getOrderid());
            paymentHospitalizationReqVO2.setAmount(body.getAmount());
            paymentHospitalizationReqVO2.setRechargeAmount(body.getAmount());
            paymentHospitalizationReqVO2.setAppid(body.getInHospNo());
            paymentHospitalizationReqVO2.setPaymentDate(DateUtil.format((Date)DateUtil.parse((CharSequence)body.getRespmsg().getAccDate()), (String)"yyyyMMdd"));
            paymentHospitalizationReqVO2.setPaymentTime(DateUtil.format((Date)DateUtil.parse((CharSequence)body.getRespmsg().getAccDate()), (String)"HH:mm:ss"));
            HashMap<String, paymentHospitalizationReqVO> map = new HashMap<String, paymentHospitalizationReqVO>();
            map.put(EntityKeyEnum.PAYMENT_HOSPITALIZATION.getValue(), paymentHospitalizationReqVO2);
            log.info("\u8bf7\u6c42his\u4f4f\u9662\u9884\u7f34\u91d1\u5145\u503c\u5165\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString(map, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            FrontResponse timeInfoResDTOFrontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.PAYMENT_HOSPITALIZATION.getValue(), map, PaymentHospitalizationResDTO.class);
            log.info("\u8bf7\u6c42his\u4f4f\u9662\u9884\u7f34\u91d1\u5145\u503c\u51fa\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString((Object)timeInfoResDTOFrontResponse.getBody(), (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            if (Objects.isNull(timeInfoResDTOFrontResponse)) {
                return FrontResponse.error((String)timeInfoResDTOFrontResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (Objects.isNull(timeInfoResDTOFrontResponse.getBody())) {
                return FrontResponse.error((String)timeInfoResDTOFrontResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (Objects.isNull(((PaymentHospitalizationResDTO)timeInfoResDTOFrontResponse.getBody()).getResponseHeadDTO())) {
                return FrontResponse.error((String)timeInfoResDTOFrontResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (!"00".equals(((PaymentHospitalizationResDTO)timeInfoResDTOFrontResponse.getBody()).getResponseHeadDTO().getRetCode())) {
                return FrontResponse.error((String)timeInfoResDTOFrontResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)((PaymentHospitalizationResDTO)timeInfoResDTOFrontResponse.getBody()).getResponseHeadDTO().getRetMsg());
            }
            DepositRes depositRes = new DepositRes();
            depositRes.setReceiptId(((PaymentHospitalizationResDTO)timeInfoResDTOFrontResponse.getBody()).getData().getReceiptNo());
            return FrontResponse.success((String)param.getTransactionId(), (Object)depositRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u5f02\u5e38", (Throwable)e);
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u5f02\u5e38");
        }
    }

    public FrontResponse<GetIPDepositRecordsRes> getIPDepositRecords(FrontRequest<GetIPDepositRecordsReq> param) {
        log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u67e5\u8be2\u5145\u503c\u8bb0\u5f55\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetIPDepositRecordsReq body = (GetIPDepositRecordsReq)param.getBody();
            HosDepositRecordReqDTO hosDepositRecordReqDTO = new HosDepositRecordReqDTO();
            GetIPDepositRecordsRes getIPDepositRecordsRes = new GetIPDepositRecordsRes();
            ArrayList items = new ArrayList();
            getIPDepositRecordsRes.setItems(items);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getIPDepositRecordsRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u67e5\u8be2\u5145\u503c\u8bb0\u5f55\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u4f4f\u9662\u9884\u4ea4\u91d1\u67e5\u8be2\u5145\u503c\u8bb0\u5f55\u5f02\u5e38");
        }
    }

    public FrontResponse<GetOrdItemsRes> getOrdItems(FrontRequest<GetOrdItemsReq> param) {
        log.info("\u4f4f\u9662\u65e5\u6e05\u5355\u67e5\u8be2\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetOrdItemsReq body = (GetOrdItemsReq)param.getBody();
            GetInpCostDetailReqDTO getInpCostDetailReqDTO = new GetInpCostDetailReqDTO();
            getInpCostDetailReqDTO.setDateEnd(body.getEndDate());
            getInpCostDetailReqDTO.setDateStart(body.getStartDate());
            getInpCostDetailReqDTO.setHosCardNo(body.getInHospNo());
            getInpCostDetailReqDTO.setHosCardType("66");
            HashMap<String, GetInpCostDetailReqDTO> paramMap = new HashMap<String, GetInpCostDetailReqDTO>();
            paramMap.put(EntityKeyEnum.INHOS_ITEM.getValue(), getInpCostDetailReqDTO);
            log.info("\u4f4f\u9662\u65e5\u6e05\u5355\u8bf7\u6c42his\u5165\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString(paramMap, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            FrontResponse hisResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.INHOS_ITEM.getValue(), paramMap, GetInpCostDetailResDTO.class);
            log.info("\u4f4f\u9662\u65e5\u6e05\u5355\u8bf7\u6c42his\u51fa\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString((Object)hisResponse, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            if (Objects.isNull(hisResponse)) {
                return FrontResponse.error((String)hisResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (Objects.isNull(hisResponse.getBody())) {
                return FrontResponse.error((String)hisResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (Objects.isNull(((GetInpCostDetailResDTO)hisResponse.getBody()).getResponseHeadDTO())) {
                return FrontResponse.error((String)hisResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (!"00".equals(((GetInpCostDetailResDTO)hisResponse.getBody()).getResponseHeadDTO().getRetCode())) {
                return FrontResponse.error((String)hisResponse.getTransactionId(), (String)SUCCESS_FLAG, (String)((GetInpCostDetailResDTO)hisResponse.getBody()).getResponseHeadDTO().getRetMsg());
            }
            GetOrdItemsRes getOrdItemsRes = new GetOrdItemsRes();
            ArrayList<GetOrdItemsResItems> getOrdItemsResItemsList = new ArrayList<GetOrdItemsResItems>();
            List items = ((GetInpCostDetailResDTO)hisResponse.getBody()).getGetInpCostDetailResItems().getGetInpCostDetailResItem().getItems();
            for (GetInpCostDetailResItemsDTO itemResDTO : items) {
                GetOrdItemsResItems getOrdItemsResItems = new GetOrdItemsResItems();
                getOrdItemsResItems.setFeeType(itemResDTO.getItemType());
                getOrdItemsResItems.setItmMastName(itemResDTO.getItemName());
                getOrdItemsResItems.setQty(itemResDTO.getAmount());
                getOrdItemsResItems.setUomDesc(itemResDTO.getUnits());
                getOrdItemsResItems.setPrice(String.valueOf(new BigDecimal(itemResDTO.getItemPrice()).setScale(2, 1)));
                getOrdItemsResItems.setAmount(String.valueOf(new BigDecimal(itemResDTO.getTotalAmount()).setScale(2, 1)));
                getOrdItemsResItems.setFeeDate(com.ebaiyihui.his.utils.DateUtil.dateToStrTwo((Date)com.ebaiyihui.his.utils.DateUtil.strToDate((String)itemResDTO.getBillingDate().substring(0, 8), (String)"yyyyMMdd")));
                getOrdItemsResItemsList.add(getOrdItemsResItems);
                getOrdItemsRes.setAdmDep(itemResDTO.getBillingDept());
                getOrdItemsRes.setName(itemResDTO.getBillingMan());
            }
            getOrdItemsRes.setOrdItem(getOrdItemsResItemsList);
            getOrdItemsRes.setInHospNo(((GetOrdItemsReq)param.getBody()).getInHospNo());
            return FrontResponse.success((String)param.getTransactionId(), (Object)getOrdItemsRes);
        }
        catch (Exception e) {
            log.info("\u4f4f\u9662\u65e5\u6e05\u5355\u67e5\u8be2\u5f02\u5e38-> {}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u4f4f\u9662\u65e5\u6e05\u5355\u67e5\u8be2\u5f02\u5e38");
        }
    }
}

