/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.pojo.dto.GetTimeRangeReqDTO;
import com.ebaiyihui.his.pojo.dto.NucleicAcidScheduleDTO;
import com.ebaiyihui.his.pojo.dto.QueryRegistrationList;
import com.ebaiyihui.his.pojo.dto.QueryRegistrationResDTO;
import com.ebaiyihui.his.pojo.dto.SchedulingDocResDTO;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.ScheduleService;
import com.ebaiyihui.his.utils.SnowflakeIdWorker;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import his.pojo.vo.nucleic.NucleicAcidScheduleList;
import his.pojo.vo.nucleic.NucleicAcidScheduleRes;
import his.pojo.vo.nucleic.NucleicAcidScheduleVO;
import his.pojo.vo.schedule.GetDeptDoctorInfoReqVO;
import his.pojo.vo.schedule.GetDeptDoctorInfoResVO;
import his.pojo.vo.schedule.GetDeptScheduleReqVO;
import his.pojo.vo.schedule.GetDeptScheduleResVO;
import his.pojo.vo.schedule.GetScheduleReqVO;
import his.pojo.vo.schedule.GetScheduleResVO;
import his.pojo.vo.schedule.QueryRegistrationCategoryReqVo;
import his.pojo.vo.schedule.QueryRegistrationResVo;
import his.pojo.vo.schedule.QueryRegistrationResVoList;
import his.pojo.vo.schedule.SchedulingDeptReqVO;
import his.pojo.vo.schedule.SchedulingDeptResDTO;
import his.pojo.vo.schedule.TimeInfoResDTO;
import his.pojo.vo.schedule.items.GetDeptDoctorInfoResItems;
import his.pojo.vo.schedule.items.GetDeptScheduleResItems;
import his.pojo.vo.schedule.items.GetScheduleResItems;
import his.pojo.vo.schedule.items.TimeArrangeItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ScheduleServiceImpl
implements ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    @Value(value="${hosp.hospName}")
    private String hospName;
    @Value(value="${hosp.hospCode}")
    private String hospCode;
    @Autowired
    private HisRemoteService hisRemoteService;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;

    public FrontResponse<QueryRegistrationResVo> queryRegistrationCategory(FrontRequest<QueryRegistrationCategoryReqVo> param) {
        QueryRegistrationCategoryReqVo body = (QueryRegistrationCategoryReqVo)param.getBody();
        HashMap<String, QueryRegistrationCategoryReqVo> map = new HashMap<String, QueryRegistrationCategoryReqVo>();
        map.put(EntityKeyEnum.QUERY_REGISTRATION_CATEGORY.getValue(), body);
        log.info("\u8bf7\u6c42his\u83b7\u53d6\u53f7\u7c7b\u5165\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString(map, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
        FrontResponse queryRegistrationResDTOFrontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_REGISTRATION_CATEGORY.getValue(), map, QueryRegistrationResDTO.class);
        log.info("\u8bf7\u6c42his\u83b7\u53d6\u53f7\u7c7b\u51fa\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString((Object)queryRegistrationResDTOFrontResponse, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
        if (Objects.isNull(queryRegistrationResDTOFrontResponse)) {
            return FrontResponse.error((String)queryRegistrationResDTOFrontResponse.getTransactionId(), (String)"0", (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
        }
        if (Objects.isNull(queryRegistrationResDTOFrontResponse.getBody())) {
            return FrontResponse.error((String)queryRegistrationResDTOFrontResponse.getTransactionId(), (String)"0", (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
        }
        if (Objects.isNull(((QueryRegistrationResDTO)queryRegistrationResDTOFrontResponse.getBody()).getResponseHeadDTO())) {
            return FrontResponse.error((String)queryRegistrationResDTOFrontResponse.getTransactionId(), (String)"0", (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
        }
        if (!"00".equals(((QueryRegistrationResDTO)queryRegistrationResDTOFrontResponse.getBody()).getResponseHeadDTO().getRetCode())) {
            return FrontResponse.error((String)queryRegistrationResDTOFrontResponse.getTransactionId(), (String)"0", (String)((QueryRegistrationResDTO)queryRegistrationResDTOFrontResponse.getBody()).getResponseHeadDTO().getRetMsg());
        }
        QueryRegistrationResVo queryRegistrationResVo = new QueryRegistrationResVo();
        List collect = ((QueryRegistrationList)((QueryRegistrationResDTO)queryRegistrationResDTOFrontResponse.getBody()).getData().getTypeInfoList().get(0)).getTypeInfo().stream().map(item -> {
            QueryRegistrationResVoList queryRegistrationResVoList = new QueryRegistrationResVoList();
            queryRegistrationResVoList.setTypeId(item.getTypeId());
            queryRegistrationResVoList.setTypeName(item.getTypeName());
            return queryRegistrationResVoList;
        }).collect(Collectors.toList());
        queryRegistrationResVo.setTypeInfo(collect);
        return FrontResponse.success((String)queryRegistrationResDTOFrontResponse.getTransactionId(), (Object)queryRegistrationResVo);
    }

    public FrontResponse<GetScheduleResVO> getSchedule(FrontRequest<GetScheduleReqVO> param) {
        log.info("\u5206\u65f6\u53f7\u6e90\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetScheduleReqVO body = (GetScheduleReqVO)param.getBody();
            GetTimeRangeReqDTO getTimeRangeReqDTO = new GetTimeRangeReqDTO();
            getTimeRangeReqDTO.setSchedulingDate(body.getBgDate());
            getTimeRangeReqDTO.setSchedulingType("01");
            getTimeRangeReqDTO.setDeptId(body.getLocCode());
            getTimeRangeReqDTO.setTypeId(body.getTypeId());
            getTimeRangeReqDTO.setOrderId(body.getOrderId());
            getTimeRangeReqDTO.setClinicLabel(body.getClinicLabel());
            getTimeRangeReqDTO.setRequestPage(body.getRequestPage());
            getTimeRangeReqDTO.setPageSize(body.getPageSize());
            HashMap<String, GetTimeRangeReqDTO> map = new HashMap<String, GetTimeRangeReqDTO>();
            map.put(EntityKeyEnum.QUERY_SCHEDULING_DEPARTMENT.getValue(), getTimeRangeReqDTO);
            log.info("\u8bf7\u6c42his\u83b7\u53d6\u5206\u65f6\u6bb5\u53f7\u6e90\u5165\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString(map, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            FrontResponse timeInfoResDTOFrontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_SCHEDULING_DEPARTMENT.getValue(), map, TimeInfoResDTO.class);
            log.info("\u8bf7\u6c42his\u83b7\u53d6\u5206\u65f6\u6bb5\u53f7\u6e90\u51fa\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString((Object)timeInfoResDTOFrontResponse.getBody(), (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            if (Objects.isNull(timeInfoResDTOFrontResponse)) {
                return FrontResponse.error((String)timeInfoResDTOFrontResponse.getTransactionId(), (String)"0", (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (Objects.isNull(timeInfoResDTOFrontResponse.getBody())) {
                return FrontResponse.error((String)timeInfoResDTOFrontResponse.getTransactionId(), (String)"0", (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (Objects.isNull(((TimeInfoResDTO)timeInfoResDTOFrontResponse.getBody()).getResponseHeadDTO())) {
                return FrontResponse.error((String)timeInfoResDTOFrontResponse.getTransactionId(), (String)"0", (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (!"00".equals(((TimeInfoResDTO)timeInfoResDTOFrontResponse.getBody()).getResponseHeadDTO().getRetCode())) {
                return FrontResponse.error((String)timeInfoResDTOFrontResponse.getTransactionId(), (String)"0", (String)((TimeInfoResDTO)timeInfoResDTOFrontResponse.getBody()).getResponseHeadDTO().getRetMsg());
            }
            GetScheduleResVO getScheduleResVO = new GetScheduleResVO();
            ((TimeInfoResDTO)timeInfoResDTOFrontResponse.getBody()).getData().getDoctorInfoList().forEach(item -> {
                ArrayList getScheduleResItemsList = new ArrayList();
                item.getDoctorInfoRes().forEach(item1 -> {
                    GetScheduleResItems getScheduleResItems = new GetScheduleResItems();
                    getScheduleResItems.setScheduleType(Integer.valueOf(1));
                    getScheduleResItems.setAdmTimeRange(item1.getTimeDesc());
                    getScheduleResItems.setScheduleId(item1.getOrdNum());
                    getScheduleResItems.setDocCode(item1.getDoctorId());
                    getScheduleResItems.setDocName(item1.getDoctorName());
                    getScheduleResItems.setLocCode(item1.getDeptId());
                    getScheduleResItems.setLocName(item1.getDeptName());
                    getScheduleResItems.setRegTitleName(item1.getDoctorTitle());
                    getScheduleResItems.setRegAvailable(Integer.valueOf(Convert.toInt((Object)item1.getTotalSourceNum()) - Convert.toInt((Object)item1.getRegistedNum())));
                    getScheduleResItems.setRegTotal(Convert.toInt((Object)item1.getTotalSourceNum()));
                    getScheduleResItems.setScheduleStatus("1");
                    getScheduleResItems.setIsTimeArrange(Integer.valueOf(item.getDoctorInfoRes().size() == 0 ? 0 : 1));
                    TimeArrangeItems timeArrangeItems = new TimeArrangeItems();
                    timeArrangeItems.setStartTime(DateUtil.format((Date)DateUtil.parse((CharSequence)item1.getStartTime()), (String)"HH:mm:ss"));
                    timeArrangeItems.setEndTime(DateUtil.format((Date)DateUtil.parse((CharSequence)item1.getEndTime()), (String)"HH:mm:ss"));
                    timeArrangeItems.setAvailableTotalNum(item1.getTotalSourceNum());
                    timeArrangeItems.setAvailableLeftNum(Convert.toStr((Object)getScheduleResItems.getRegAvailable()));
                    item1.getFeeList().forEach(item2 -> item2.getFeeInfoRes().forEach(item3 -> {
                        if (item3.getFeeName().equals("\u8bca\u7597\u8d39")) {
                            getScheduleResItems.setDiagFee(item3.getFee());
                        } else {
                            getScheduleResItems.setRegFee(item3.getFee());
                        }
                    }));
                    getScheduleResItems.setTimeArrangeItems(Convert.toList(TimeArrangeItems.class, (Object)timeArrangeItems));
                    getScheduleResItemsList.add(getScheduleResItems);
                });
                getScheduleResVO.setItems(getScheduleResItemsList);
            });
            log.info("\u5206\u65f6\u6bb5\u53f7\u6e90\u6700\u7ec8\u8fd4\u56de\u7ed3\u679c->{}", (Object)com.alibaba.fastjson2.JSON.toJSONString((Object)getScheduleResVO, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            return FrontResponse.success((String)param.getTransactionId(), (Object)getScheduleResVO);
        }
        catch (Exception e) {
            log.info("\u5206\u65f6\u53f7\u6e90\u4fe1\u606f\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u5206\u65f6\u53f7\u6e90\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public FrontResponse<GetDeptScheduleResVO> getDeptSchedule(FrontRequest<GetDeptScheduleReqVO> param) {
        log.info("\u67e5\u8be2\u79d1\u5ba4\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetDeptScheduleReqVO body = (GetDeptScheduleReqVO)param.getBody();
            HashMap<String, SchedulingDeptReqVO> map = new HashMap<String, SchedulingDeptReqVO>();
            SchedulingDeptReqVO schedulingDeptReqVO = new SchedulingDeptReqVO();
            schedulingDeptReqVO.setSchedulingDate(body.getBgDate());
            schedulingDeptReqVO.setTypeId(body.getTypeId());
            schedulingDeptReqVO.setOrderId(body.getOrderId());
            schedulingDeptReqVO.setRequestPage(body.getRequestPage());
            schedulingDeptReqVO.setPageSize(body.getPageSize());
            map.put(EntityKeyEnum.SCHEDULING_DEPARTMENT.getValue(), schedulingDeptReqVO);
            log.info("\u8bf7\u6c42his\u83b7\u53d6\u79d1\u5ba4\u6392\u7248\u5165\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString(map, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            FrontResponse schedulingDeptResDTOFrontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.SCHEDULING_DEPARTMENT.getValue(), map, SchedulingDeptResDTO.class);
            log.info("\u8bf7\u6c42his\u83b7\u53d6\u79d1\u5ba4\u6392\u7248\u51fa\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString((Object)schedulingDeptResDTOFrontResponse.getBody(), (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            if (Objects.isNull(schedulingDeptResDTOFrontResponse)) {
                return FrontResponse.error((String)schedulingDeptResDTOFrontResponse.getTransactionId(), (String)"0", (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (Objects.isNull(schedulingDeptResDTOFrontResponse.getBody())) {
                return FrontResponse.error((String)schedulingDeptResDTOFrontResponse.getTransactionId(), (String)"0", (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (Objects.isNull(((SchedulingDeptResDTO)schedulingDeptResDTOFrontResponse.getBody()).getResponseHeadDTO())) {
                return FrontResponse.error((String)schedulingDeptResDTOFrontResponse.getTransactionId(), (String)"0", (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (!"00".equals(((SchedulingDeptResDTO)schedulingDeptResDTOFrontResponse.getBody()).getResponseHeadDTO().getRetCode())) {
                return FrontResponse.error((String)schedulingDeptResDTOFrontResponse.getTransactionId(), (String)"0", (String)((SchedulingDeptResDTO)schedulingDeptResDTOFrontResponse.getBody()).getResponseHeadDTO().getRetMsg());
            }
            GetDeptScheduleResVO getDeptScheduleResVO = new GetDeptScheduleResVO();
            List collect = ((SchedulingDeptResDTO)schedulingDeptResDTOFrontResponse.getBody()).getData().getDeptInfoList().getDeptInfo().stream().map(item -> {
                GetDeptScheduleResItems getDeptScheduleResItems1 = new GetDeptScheduleResItems();
                getDeptScheduleResItems1.setDeptName(item.getDeptName());
                getDeptScheduleResItems1.setDeptCode(item.getDeptId());
                getDeptScheduleResItems1.setDeptAddress(item.getDeptAddress());
                return getDeptScheduleResItems1;
            }).collect(Collectors.toList());
            getDeptScheduleResVO.setItems(collect);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getDeptScheduleResVO);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6392\u73ed\u4fe1\u606f\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u533b\u751f\u6392\u73ed\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public FrontResponse<GetDeptDoctorInfoResVO> getDeptDoctorInfo(FrontRequest<GetDeptDoctorInfoReqVO> param) {
        try {
            GetDeptDoctorInfoReqVO body = (GetDeptDoctorInfoReqVO)param.getBody();
            HashMap<String, SchedulingDeptReqVO> map = new HashMap<String, SchedulingDeptReqVO>();
            SchedulingDeptReqVO schedulingDeptReqVO = new SchedulingDeptReqVO();
            schedulingDeptReqVO.setSchedulingDate(body.getSchedulingDate());
            schedulingDeptReqVO.setTypeId(body.getTypeId());
            schedulingDeptReqVO.setSchedulingType("01");
            schedulingDeptReqVO.setDeptCode(body.getDeptCode());
            schedulingDeptReqVO.setOrderId(body.getOrderId());
            schedulingDeptReqVO.setRequestPage(body.getRequestPage());
            schedulingDeptReqVO.setPageSize(body.getPageSize());
            map.put(EntityKeyEnum.QUERY_DOCTOR.getValue(), schedulingDeptReqVO);
            log.info("\u8bf7\u6c42his\u533b\u751f\u83b7\u53d6\u79d1\u5ba4\u6392\u7248\u5165\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString(map, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            FrontResponse schedulingDeptResDTOFrontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_DOCTOR.getValue(), map, SchedulingDocResDTO.class);
            log.info("\u8bf7\u6c42his\u533b\u751f\u83b7\u53d6\u79d1\u5ba4\u6392\u7248\u51fa\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString((Object)schedulingDeptResDTOFrontResponse.getBody(), (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            if (Objects.isNull(schedulingDeptResDTOFrontResponse)) {
                return FrontResponse.error((String)schedulingDeptResDTOFrontResponse.getTransactionId(), (String)"0", (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (Objects.isNull(schedulingDeptResDTOFrontResponse.getBody())) {
                return FrontResponse.error((String)schedulingDeptResDTOFrontResponse.getTransactionId(), (String)"0", (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (Objects.isNull(((SchedulingDocResDTO)schedulingDeptResDTOFrontResponse.getBody()).getResponseHeadDTO())) {
                return FrontResponse.error((String)schedulingDeptResDTOFrontResponse.getTransactionId(), (String)"0", (String)"his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (!"00".equals(((SchedulingDocResDTO)schedulingDeptResDTOFrontResponse.getBody()).getResponseHeadDTO().getRetCode())) {
                return FrontResponse.error((String)schedulingDeptResDTOFrontResponse.getTransactionId(), (String)"0", (String)((SchedulingDocResDTO)schedulingDeptResDTOFrontResponse.getBody()).getResponseHeadDTO().getRetMsg());
            }
            GetDeptDoctorInfoResVO getDeptScheduleResVO = new GetDeptDoctorInfoResVO();
            ArrayList getDeptDoctorInfoResItemsArrayList = new ArrayList();
            ((SchedulingDocResDTO)schedulingDeptResDTOFrontResponse.getBody()).getData().getDoctorInfoList().forEach(item -> item.getDoctorInfo().forEach(item1 -> {
                GetDeptDoctorInfoResItems getDeptDoctorInfoResItems = new GetDeptDoctorInfoResItems();
                if (item1.getDoctorId().split("\\*").length == 2) {
                    getDeptDoctorInfoResItems.setDoctorCode(item1.getDoctorId().split("\\*")[0]);
                    getDeptDoctorInfoResItems.setDoctorDesc(item1.getDoctorId().split("\\*")[1]);
                } else {
                    getDeptDoctorInfoResItems.setDoctorDesc(item1.getDoctorId().split("\\*")[0]);
                }
                getDeptDoctorInfoResItems.setDoctorName(item1.getDoctorName());
                getDeptDoctorInfoResItems.setDoctorTitle(item1.getDoctorTitle());
                getDeptDoctorInfoResItems.setDeptCode(item1.getDeptId());
                getDeptDoctorInfoResItems.setDeptName(item1.getDeptName());
                getDeptDoctorInfoResItemsArrayList.add(getDeptDoctorInfoResItems);
            }));
            getDeptScheduleResVO.setItems(getDeptDoctorInfoResItemsArrayList);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getDeptScheduleResVO);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6392\u73ed\u533b\u751f\u4fe1\u606f\u5f02\u5e38{}", (Object[])e.getStackTrace());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u79d1\u5ba4\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public NucleicAcidScheduleRes GetNucleicAcidSchedule(NucleicAcidScheduleVO param) {
        try {
            HashMap<String, NucleicAcidScheduleVO> map = new HashMap<String, NucleicAcidScheduleVO>();
            map.put(EntityKeyEnum.NUCLEIC_ACID_SCHEDULE.getValue(), param);
            log.info("\u8bf7\u6c42his\u6838\u9178\u6392\u7248\u5165\u53c2 - > {}", (Object)com.alibaba.fastjson2.JSON.toJSONString(map, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue}));
            FrontResponse schedulingDeptResDTOFrontResponse = this.hisRemoteService.requestHisUrlHzPb("http://61.178.141.148:57772//csp/jcjt/BS.WS.HMPTWS.CLS", null, Convert.toStr((Object)this.snowflakeIdWorker.nextId()), MethodCodeEnum.NUCLEIC_ACID_SCHEDULE.getValue(), map, NucleicAcidScheduleDTO.class);
            if (null == schedulingDeptResDTOFrontResponse) {
                return new NucleicAcidScheduleRes();
            }
            if (null == schedulingDeptResDTOFrontResponse.getBody()) {
                return new NucleicAcidScheduleRes();
            }
            if (((NucleicAcidScheduleDTO)schedulingDeptResDTOFrontResponse.getBody()).getResultCode().equals("1")) {
                return new NucleicAcidScheduleRes();
            }
            if (null == ((NucleicAcidScheduleDTO)schedulingDeptResDTOFrontResponse.getBody()).getNucleinsRes()) {
                return new NucleicAcidScheduleRes();
            }
            List nucleicAcidScheduleLists = BeanUtil.copyToList((Collection)((NucleicAcidScheduleDTO)schedulingDeptResDTOFrontResponse.getBody()).getNucleinsRes().getNucleinRes(), NucleicAcidScheduleList.class);
            NucleicAcidScheduleRes nucleicAcidScheduleRes = new NucleicAcidScheduleRes();
            nucleicAcidScheduleRes.setNucleicAcidScheduleLists(nucleicAcidScheduleLists);
            return nucleicAcidScheduleRes;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6838\u9178\u6392\u7248\u4fe1\u606f\u51fa\u9519 \u9519\u8bef\u4fe1\u606f\u4e3a->{}", (Throwable)e);
            return new NucleicAcidScheduleRes();
        }
    }
}

