/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.config.data;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.stat.DruidDataSourceStatManager;
import com.ebaiyihui.his.config.data.DBContextHolder;
import com.ebaiyihui.his.config.data.DateSource;
import java.sql.DriverManager;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.util.Assert;

public class DynamicDataSource
extends AbstractRoutingDataSource {
    private static final Logger log = LoggerFactory.getLogger(DynamicDataSource.class);
    private Map<Object, Object> dynamicTargetDataSources;
    private Object dynamicDefaultTargetDataSource;

    protected Object determineCurrentLookupKey() {
        String datasource = DBContextHolder.getDataSource();
        if (!this.dynamicTargetDataSources.containsKey(datasource)) {
            // empty if block
        }
        return datasource;
    }

    public void setDefaultTargetDataSource(Object defaultTargetDataSource) {
        super.setDefaultTargetDataSource(defaultTargetDataSource);
        this.dynamicDefaultTargetDataSource = defaultTargetDataSource;
    }

    public void setTargetDataSources(Map<Object, Object> targetDataSources) {
        super.setTargetDataSources(targetDataSources);
        this.dynamicTargetDataSources = targetDataSources;
    }

    public boolean createDataSource(DateSource dateSource) {
        try {
            Assert.isTrue((boolean)this.testDatasource(dateSource), (String)"\u6570\u636e\u6e90\u8fde\u63a5\u65e0\u6548");
            DruidDataSource druidDataSource = new DruidDataSource();
            druidDataSource.setName(dateSource.getKey());
            druidDataSource.setDriverClassName(dateSource.getDriveClass());
            druidDataSource.setUrl(dateSource.getUrl());
            druidDataSource.setUsername(dateSource.getUsername());
            druidDataSource.setPassword(dateSource.getPassword());
            druidDataSource.setMaxWait((long)dateSource.getMaxWait());
            druidDataSource.setFilters("stat");
            Map map = this.dynamicTargetDataSources;
            if (map.containsKey(dateSource.getKey())) {
                Assert.isTrue((boolean)this.delDatasources(dateSource.getKey()), (String)"\u5220\u9664\u6570\u636e\u6e90\u5931\u8d25");
            }
            druidDataSource.init();
            map.put(dateSource.getKey(), druidDataSource);
            this.setTargetDataSources(map);
            super.afterPropertiesSet();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean delDatasources(String key) {
        Map targetDataSource = this.dynamicTargetDataSources;
        if (targetDataSource.containsKey(key)) {
            Set druidDataSourceInstances = DruidDataSourceStatManager.getDruidDataSourceInstances();
            for (DruidDataSource druidDataSource : druidDataSourceInstances) {
                if (!key.equals(druidDataSource.getName())) continue;
                System.out.println(druidDataSource);
                targetDataSource.remove(key);
                DruidDataSourceStatManager.removeDataSource((Object)druidDataSource);
                this.setTargetDataSources(targetDataSource);
                super.afterPropertiesSet();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean testDatasource(DateSource dateSource) {
        try {
            Class.forName(dateSource.getDriveClass());
            DriverManager.getConnection(dateSource.getUrl(), dateSource.getUsername(), dateSource.getPassword());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Map<Object, Object> getDynamicTargetDataSources() {
        return this.dynamicTargetDataSources;
    }

    public Object getDynamicDefaultTargetDataSource() {
        return this.dynamicDefaultTargetDataSource;
    }

    public void setDynamicTargetDataSources(Map<Object, Object> dynamicTargetDataSources) {
        this.dynamicTargetDataSources = dynamicTargetDataSources;
    }

    public void setDynamicDefaultTargetDataSource(Object dynamicDefaultTargetDataSource) {
        this.dynamicDefaultTargetDataSource = dynamicDefaultTargetDataSource;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicDataSource)) {
            return false;
        }
        DynamicDataSource other = (DynamicDataSource)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Map this$dynamicTargetDataSources = this.getDynamicTargetDataSources();
        Map other$dynamicTargetDataSources = other.getDynamicTargetDataSources();
        if (this$dynamicTargetDataSources == null ? other$dynamicTargetDataSources != null : !((Object)this$dynamicTargetDataSources).equals(other$dynamicTargetDataSources)) {
            return false;
        }
        Object this$dynamicDefaultTargetDataSource = this.getDynamicDefaultTargetDataSource();
        Object other$dynamicDefaultTargetDataSource = other.getDynamicDefaultTargetDataSource();
        return !(this$dynamicDefaultTargetDataSource == null ? other$dynamicDefaultTargetDataSource != null : !this$dynamicDefaultTargetDataSource.equals(other$dynamicDefaultTargetDataSource));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamicDataSource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map $dynamicTargetDataSources = this.getDynamicTargetDataSources();
        result = result * 59 + ($dynamicTargetDataSources == null ? 43 : ((Object)$dynamicTargetDataSources).hashCode());
        Object $dynamicDefaultTargetDataSource = this.getDynamicDefaultTargetDataSource();
        result = result * 59 + ($dynamicDefaultTargetDataSource == null ? 43 : $dynamicDefaultTargetDataSource.hashCode());
        return result;
    }

    public String toString() {
        return "DynamicDataSource(dynamicTargetDataSources=" + this.getDynamicTargetDataSources() + ", dynamicDefaultTargetDataSource=" + this.getDynamicDefaultTargetDataSource() + ")";
    }
}

