/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.his.common.enums.PayCodeEnum;
import com.ebaiyihui.his.service.AppointPaymentService;
import com.ebaiyihui.his.service.ICardService;
import com.ebaiyihui.his.utils.CxfClientUtil;
import com.ebaiyihui.his.utils.HttpKit;
import com.ebaiyihui.his.utils.SignUtil;
import his.pojo.vo.appoint.AppointRecordItem;
import his.pojo.vo.appoint.AppointRecordReq;
import his.pojo.vo.appoint.CancelRegisterReq;
import his.pojo.vo.appoint.CancelRegisterRes;
import his.pojo.vo.appoint.LockOrderReq;
import his.pojo.vo.appoint.LockOrderRes;
import his.pojo.vo.appoint.PayRegistrationReq;
import his.pojo.vo.appoint.PayRegistrationRes;
import his.pojo.vo.appoint.ReturnRegisterReq;
import his.pojo.vo.appoint.ReturnRegisterRes;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import his.pojo.vo.card.QueryCardInfoReqVO;
import his.pojo.vo.card.QueryCardInfoResVO;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppointPaymentServiceImpl
implements AppointPaymentService {
    private static final Logger log = LoggerFactory.getLogger(AppointPaymentServiceImpl.class);
    @Autowired
    private ICardService cardService;
    public static final String CLINIC_TYPE_APPOINT = "0";
    public static final String CLINIC_TYPE_CANCEL = "1";
    private static final String PAY_SUCCESS = "Y";
    private static final String PAY_FAIL = "N";
    private static final String HIS_PAY_SUCCESS = "SUCCESS";
    private static final String HIS_PAY_FAIL = "FAIL";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CxfClientUtil cxfClientUtil;

    public FrontResponse<PayRegistrationRes> payRegistration(FrontRequest<PayRegistrationReq> param) {
        log.info("\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            PayRegistrationReq body = (PayRegistrationReq)param.getBody();
            HashMap paramMap = new HashMap();
            String content = JSON.toJSONString(paramMap);
            String head = SignUtil.getHead((String)"orgine.powerrsp.service.overt.reserve.createOrder", (String)param.getTransactionId());
            log.info("IN===>" + head + content);
            String hisRes = HttpKit.get((String)("http://222.90.69.219:9000/test/createPatient?headJson=" + head + "&body=" + content));
            log.info("OUT===>" + hisRes);
            PayRegistrationRes payRegistrationRes = new PayRegistrationRes();
            return FrontResponse.success((String)param.getTransactionId(), (Object)payRegistrationRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<CancelRegisterRes> cancelRegister(FrontRequest<CancelRegisterReq> param) {
        log.info("\u53d6\u6d88\u6302\u53f7\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            CancelRegisterReq body = (CancelRegisterReq)param.getBody();
            HashMap paramMap = new HashMap();
            String content = JSON.toJSONString(paramMap);
            String head = SignUtil.getHead((String)"orgine.powerrsp.service.overt.reserve.createOrder", (String)param.getTransactionId());
            log.info("IN===>" + head + content);
            String hisRes = HttpKit.get((String)("http://222.90.69.219:9000/test/createPatient?headJson=" + head + "&body=" + content));
            log.info("OUT===>" + hisRes);
            CancelRegisterRes cancelRegisterRes = new CancelRegisterRes();
            return FrontResponse.success((String)param.getTransactionId(), (Object)cancelRegisterRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u53d6\u6d88\u6302\u53f7\u8bf7\u6c42\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u53d6\u6d88\u6302\u53f7\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<ReturnRegisterRes> returnRegister(FrontRequest<ReturnRegisterReq> param) {
        log.info("\u9000\u53f7\u9000\u8d39\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            ReturnRegisterReq body = (ReturnRegisterReq)param.getBody();
            HashMap paramMap = new HashMap();
            String content = JSON.toJSONString(paramMap);
            String head = SignUtil.getHead((String)"orgine.powerrsp.service.overt.reserve.createOrder", (String)param.getTransactionId());
            log.info("IN===>" + head + content);
            String hisRes = HttpKit.get((String)("http://222.90.69.219:9000/test/createPatient?headJson=" + head + "&body=" + content));
            log.info("OUT===>" + hisRes);
            ReturnRegisterRes returnRegisterRes = new ReturnRegisterRes();
            return FrontResponse.success((String)param.getTransactionId(), (Object)returnRegisterRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u9000\u53f7\u9000\u8d39\u8bf7\u6c42\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u9000\u53f7\u9000\u8d39\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<LockOrderRes> appointLockOrder(FrontRequest<LockOrderReq> param) {
        log.info("\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            LockOrderReq body = (LockOrderReq)param.getBody();
            HashMap paramMap = new HashMap();
            HashMap<String, String> ext_info = new HashMap<String, String>();
            ext_info.put("pass_through", "");
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("id_type", "01");
            info.put("patient_name", "\u9648\u601d\u654f");
            info.put("pay_choice", "after_pay");
            info.put("out_call_date", body.getTradeDate());
            info.put("id_number", body.getCardNo());
            info.put("mobile_number", "15180682656");
            info.put("start_time", body.getBeginTime());
            info.put("end_time", body.getEndTime());
            info.put("time_id", body.getOrderId());
            info.put("schedule_id", body.getScheduleCode());
            info.put("sex", String.valueOf(IdCardUtil.getGenderByIdCard((String)body.getCardNo())).equals("M") ? 1 : 2);
            paramMap.put("ext_info", ext_info);
            paramMap.put("info", info);
            String content = JSONObject.toJSONString(paramMap);
            String head = SignUtil.getHead((String)"orgine.powerrsp.service.overt.reserve.createOrder", (String)param.getTransactionId());
            log.info("IN===>" + head + content);
            String hisRes = HttpKit.get((String)("http://127.0.0.1:9000/test/testPayNew?headJson=" + head + "&body=" + content + "&url=" + "http://192.168.201.18:18118/orgine/powerrsp/service/overt"));
            log.info("OUT===>" + hisRes);
            LockOrderRes lockOrderRes = new LockOrderRes();
            return FrontResponse.success((String)param.getTransactionId(), (Object)lockOrderRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<LockOrderRes> dayLockOrder(FrontRequest<LockOrderReq> param) {
        log.info("\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            LockOrderReq body = (LockOrderReq)param.getBody();
            FrontRequest queryCardInfoParam = new FrontRequest();
            QueryCardInfoReqVO queryCardInfoReqVO = new QueryCardInfoReqVO();
            queryCardInfoReqVO.setCardNo(body.getPatientId());
            queryCardInfoParam.setBody((Object)queryCardInfoReqVO);
            FrontResponse queryCardInfoResVOFrontResponse = this.cardService.queryCardInfo(queryCardInfoParam);
            HashMap paramMap = new HashMap();
            HashMap<String, String> ext_info = new HashMap<String, String>();
            ext_info.put("pass_through", "");
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("schedule_id", body.getScheduleCode());
            info.put("pay_choice", "before_pay");
            info.put("patient_id", body.getPatientId());
            info.put("operator", "HLWYY");
            info.put("sex", ((QueryCardInfoResVO)queryCardInfoResVOFrontResponse.getBody()).getSex().equals("\u7537") ? 1 : 2);
            info.put("patient_name", ((QueryCardInfoResVO)queryCardInfoResVOFrontResponse.getBody()).getName());
            info.put("out_call_date", body.getTradeDate());
            info.put("registration_fee", body.getRegFee());
            info.put("treatment_fee", body.getDiagFee());
            info.put("time_interval", body.getTradeTime());
            paramMap.put("ext_info", ext_info);
            paramMap.put("info", info);
            String content = JSONObject.toJSONString(paramMap);
            String head = SignUtil.getHead((String)PayCodeEnum.CREATE_REG_ORDER.getDisplay(), (String)param.getTransactionId());
            log.info("IN===>head:" + head + "  body:" + content);
            String hisRes = HttpKit.get((String)("http://127.0.0.1:9000/test/testPayNew?headJson=" + head + "&body=" + content + "&url=" + "http://192.168.201.18:18118/orgine/powermsp/service/overt"));
            log.info("OUT===>" + hisRes);
            LockOrderRes lockOrderRes = new LockOrderRes();
            return FrontResponse.success((String)param.getTransactionId(), (Object)lockOrderRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<AppointRecordItem> getBusRegOrderList(FrontRequest<AppointRecordReq> param) {
        log.info("\u6302\u53f7\u8bb0\u5f55\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            AppointRecordReq body = (AppointRecordReq)param.getBody();
            HashMap paramMap = new HashMap();
            HashMap<String, String> ext_info = new HashMap<String, String>();
            ext_info.put("pass_through", "");
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("id_type", "01");
            info.put("patient_name", "\u9648\u601d\u654f");
            info.put("pay_choice", "after_pay");
            paramMap.put("info", info);
            String content = JSONObject.toJSONString(paramMap);
            String head = SignUtil.getHead((String)"orgine.powerrsp.service.overt.reserve.createOrder", (String)param.getTransactionId());
            log.info("IN===>" + head + content);
            String hisRes = HttpKit.get((String)("http://127.0.0.1:9000/test/testPayNew?headJson=" + head + "&body=" + content + "&url=" + "http://192.168.201.18:18118/orgine/powerrsp/service/overt"));
            log.info("OUT===>" + hisRes);
            AppointRecordItem sppointRecordItems = new AppointRecordItem();
            return FrontResponse.success((String)param.getTransactionId(), (Object)sppointRecordItems);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u6302\u53f7\u8bb0\u5f55\u8bf7\u6c42\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u6302\u53f7\u8bb0\u5f55\u8bf7\u6c42\u5f02\u5e38");
        }
    }
}

