/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.common.enums.MethodNameEnum;
import com.ebaiyihui.his.common.enums.PayCodeEnum;
import com.ebaiyihui.his.pojo.dto.AppointReqDTO;
import com.ebaiyihui.his.pojo.dto.AppointResDTO;
import com.ebaiyihui.his.pojo.dto.PayDetailsItem;
import com.ebaiyihui.his.pojo.dto.RegisterReqDTO;
import com.ebaiyihui.his.pojo.dto.RegisterResDTO;
import com.ebaiyihui.his.pojo.dto.ReturnRegisterReqDTO;
import com.ebaiyihui.his.pojo.dto.ReturnRegisterResDTO;
import com.ebaiyihui.his.pojo.dto.UnLockReqDTO;
import com.ebaiyihui.his.pojo.dto.UnLockResDTO;
import com.ebaiyihui.his.service.AppointService;
import com.ebaiyihui.his.utils.CxfClientUtil;
import com.ebaiyihui.his.utils.HttpKit;
import com.ebaiyihui.his.utils.NumberUtils;
import com.ebaiyihui.his.utils.SignUtil;
import com.ebaiyihui.his.utils.XmlTemplateKit;
import com.ebaiyihui.his.utils.XmlUtil;
import his.pojo.vo.appoint.AppointRecordItem;
import his.pojo.vo.appoint.CancelRegisterReq;
import his.pojo.vo.appoint.CancelRegisterRes;
import his.pojo.vo.appoint.GetAppointRecordReq;
import his.pojo.vo.appoint.GetAppointRecordRes;
import his.pojo.vo.appoint.LockOrderReq;
import his.pojo.vo.appoint.LockOrderRes;
import his.pojo.vo.appoint.PayRegistrationReq;
import his.pojo.vo.appoint.PayRegistrationRes;
import his.pojo.vo.appoint.ReconPlatRecord;
import his.pojo.vo.appoint.ReconPlatRecordList;
import his.pojo.vo.appoint.ReturnRegisterReq;
import his.pojo.vo.appoint.ReturnRegisterRes;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import his.pojo.vo.base.GeneralReconciliationRes;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppointServiceImpl
implements AppointService {
    private static final Logger log = LoggerFactory.getLogger(AppointServiceImpl.class);
    public static final String CLINIC_TYPE_APPOINT = "0";
    public static final String CLINIC_TYPE_CANCEL = "1";
    private static final String PAY_SUCCESS = "Y";
    private static final String PAY_FAIL = "N";
    private static final String HIS_PAY_SUCCESS = "SUCCESS";
    private static final String HIS_PAY_FAIL = "FAIL";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CxfClientUtil cxfClientUtil;

    public FrontResponse<PayRegistrationRes> payRegistration(FrontRequest<PayRegistrationReq> param) {
        log.info("\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            PayRegistrationReq body = (PayRegistrationReq)param.getBody();
            AppointReqDTO appointReqDTO = new AppointReqDTO();
            appointReqDTO.setTradeCode(MethodCodeEnum.APPOINTMENT_REGISTRATION.getDisplay());
            appointReqDTO.setAppOrderCode(body.getAppointId());
            appointReqDTO.setPatientCard(body.getCardNo());
            appointReqDTO.setExtUserID("HLWYY");
            appointReqDTO.setPatientID(body.getPatientId());
            appointReqDTO.setPayFee(NumberUtils.formatAmtY2F((String)body.getRegFee()));
            appointReqDTO.setPayModeCode(body.getPayChannel());
            appointReqDTO.setCardType("03");
            appointReqDTO.setPayTradeNo(body.getFlowNo());
            ArrayList<PayDetailsItem> payDetails = new ArrayList<PayDetailsItem>();
            PayDetailsItem payDetailsItem = new PayDetailsItem();
            payDetailsItem.setPayModeCode(body.getPayChannel());
            payDetailsItem.setPayAmt(body.getRespMsg().getPayment());
            payDetailsItem.setPlatformNo(body.getFlowNo());
            payDetailsItem.setOutPayNo(body.getFlowNo());
            payDetailsItem.setInvoieId(body.getRespMsg().getOrderid());
            payDetailsItem.setPayDate(body.getRespMsg().getAccdate().substring(0, 10));
            payDetailsItem.setPayTime(body.getRespMsg().getAccdate().substring(11, 19));
            payDetails.add(payDetailsItem);
            appointReqDTO.setPayDetails(payDetails);
            log.info("his\u6302\u53f7\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString((Object)appointReqDTO));
            HashMap<String, AppointReqDTO> map = new HashMap<String, AppointReqDTO>();
            map.put(EntityKeyEnum.APPOINTMENT_REGISTRATION.getValue(), appointReqDTO);
            String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.APPOINTMENT_REGISTRATION.getValue(), map);
            log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + requestHisXml);
            String hisRes = this.cxfClientUtil.send("http://192.168.201.18/csp/hsb/DHC.Published.PUB0009.BS.PUB0009.CLS?WSDL=1", MethodCodeEnum.APPOINTMENT_REGISTRATION.getDisplay(), requestHisXml);
            log.info("his\u6302\u53f7\u8bf7\u6c42\u76f4\u63a5\u51fa\u53c2" + hisRes);
            AppointResDTO response = (AppointResDTO)XmlUtil.convertToJavaBean((String)hisRes, AppointResDTO.class);
            log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            log.info("his\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)response.getResultContent());
            }
            if (!CLINIC_TYPE_APPOINT.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)response.getResultContent());
            }
            PayRegistrationRes payRegistrationRes = new PayRegistrationRes();
            payRegistrationRes.setAdmitAddress(response.getAdmitAddress());
            payRegistrationRes.setAdmId(response.getAdmNo());
            payRegistrationRes.setNo(response.getAppID());
            payRegistrationRes.setReceiptId(response.getTransactionId());
            return FrontResponse.success((String)param.getTransactionId(), (Object)payRegistrationRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<CancelRegisterRes> cancelRegister(FrontRequest<CancelRegisterReq> param) {
        log.info("\u53d6\u6d88\u6302\u53f7\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            CancelRegisterReq body = (CancelRegisterReq)param.getBody();
            UnLockReqDTO unLockReqDTO = new UnLockReqDTO();
            unLockReqDTO.setTradeCode(MethodCodeEnum.CANCEL_LOCK_ORDER.getDisplay());
            unLockReqDTO.setExtUserID("HLWYY");
            unLockReqDTO.setScheduleItemCode(body.getScheduleId());
            unLockReqDTO.setTransactionId(body.getAppointId());
            unLockReqDTO.setOrderCode(body.getAppointId());
            HashMap<String, UnLockReqDTO> map = new HashMap<String, UnLockReqDTO>();
            map.put(EntityKeyEnum.CANCEL_LOCK_ORDER.getValue(), unLockReqDTO);
            String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.CANCEL_LOCK_ORDER.getValue(), map);
            String hisRes = this.cxfClientUtil.send("http://192.168.201.18/csp/hsb/DHC.Published.PUB0009.BS.PUB0009.CLS?WSDL=1", MethodCodeEnum.CANCEL_LOCK_ORDER.getDisplay(), requestHisXml);
            log.info("his\u53d6\u6d88\u6302\u53f7\u8bf7\u6c42\u76f4\u63a5\u51fa\u53c2" + hisRes);
            UnLockResDTO response = (UnLockResDTO)XmlUtil.convertToJavaBean((String)hisRes, UnLockResDTO.class);
            log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)response.getResultContent());
            }
            if (!CLINIC_TYPE_APPOINT.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)response.getResultContent());
            }
            CancelRegisterRes cancelRegisterRes = new CancelRegisterRes();
            return FrontResponse.success((String)param.getTransactionId(), (Object)cancelRegisterRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u53d6\u6d88\u6302\u53f7\u8bf7\u6c42\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u53d6\u6d88\u6302\u53f7\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<CancelRegisterRes> dayUnLockOrder(FrontRequest<CancelRegisterReq> param) {
        log.info("\u53d6\u6d88\u6302\u53f7\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            CancelRegisterReq body = (CancelRegisterReq)param.getBody();
            UnLockReqDTO unLockReqDTO = new UnLockReqDTO();
            unLockReqDTO.setTradeCode(MethodCodeEnum.DAY_UNLOCK_ORDER.getDisplay());
            unLockReqDTO.setExtUserID("HLWYY");
            unLockReqDTO.setScheduleItemCode(body.getScheduleId());
            unLockReqDTO.setTransactionId(body.getAppointId());
            unLockReqDTO.setLockQueueNo(body.getLockQueueNo());
            unLockReqDTO.setCardNo(body.getCardNo());
            HashMap<String, UnLockReqDTO> map = new HashMap<String, UnLockReqDTO>();
            map.put(EntityKeyEnum.DAY_UNLOCK_ORDER.getValue(), unLockReqDTO);
            String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.DAY_UNLOCK_ORDER.getValue(), map);
            log.info("his\u53d6\u6d88\u6302\u53f7\u8bf7\u6c42\u76f4\u63a5\u5165\u53c2" + requestHisXml);
            String hisRes = this.cxfClientUtil.send("http://192.168.201.18/csp/hsb/DHC.Published.PUB0009.BS.PUB0009.CLS?WSDL=1", MethodCodeEnum.DAY_UNLOCK_ORDER.getDisplay(), requestHisXml);
            log.info("his\u53d6\u6d88\u6302\u53f7\u8bf7\u6c42\u76f4\u63a5\u51fa\u53c2" + hisRes);
            UnLockResDTO response = (UnLockResDTO)XmlUtil.convertToJavaBean((String)hisRes, UnLockResDTO.class);
            log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)response.getResultContent());
            }
            if (!CLINIC_TYPE_APPOINT.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)response.getResultContent());
            }
            CancelRegisterRes cancelRegisterRes = new CancelRegisterRes();
            return FrontResponse.success((String)param.getTransactionId(), (Object)cancelRegisterRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u53d6\u6d88\u6302\u53f7\u8bf7\u6c42\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u53d6\u6d88\u6302\u53f7\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<ReturnRegisterRes> returnRegister(FrontRequest<ReturnRegisterReq> param) {
        log.info("\u9000\u53f7\u9000\u8d39\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            ReturnRegisterReq body = (ReturnRegisterReq)param.getBody();
            ReturnRegisterReqDTO returnRegisterReqDTO = new ReturnRegisterReqDTO();
            returnRegisterReqDTO.setTradeCode(MethodCodeEnum.RETURN_REGISTERED.getValue());
            returnRegisterReqDTO.setHospitalId("");
            returnRegisterReqDTO.setExtUserID("HLWYY");
            returnRegisterReqDTO.setAdmNo(body.getAppointId());
            returnRegisterReqDTO.setRefundType("TF");
            HashMap<String, ReturnRegisterReqDTO> map = new HashMap<String, ReturnRegisterReqDTO>();
            map.put(EntityKeyEnum.RETURN_REGISTERED.getValue(), returnRegisterReqDTO);
            String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.RETURN_REGISTERED.getValue(), map);
            log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + requestHisXml);
            String hisRes = this.cxfClientUtil.send("http://192.168.201.18/csp/hsb/DHC.Published.PUB0009.BS.PUB0009.CLS?WSDL=1", MethodCodeEnum.RETURN_REGISTERED.getDisplay(), requestHisXml);
            log.info("his\u9000\u53f7\u9000\u8d39\u8bf7\u6c42\u76f4\u63a5\u51fa\u53c2" + hisRes);
            ReturnRegisterResDTO response = (ReturnRegisterResDTO)XmlUtil.convertToJavaBean((String)hisRes, ReturnRegisterResDTO.class);
            log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            log.info("his\u9000\u53f7\u9000\u8d39\u8bf7\u6c42\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)response.getResultContent());
            }
            if (!CLINIC_TYPE_APPOINT.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)response.getResultContent());
            }
            ReturnRegisterRes returnRegisterRes = new ReturnRegisterRes();
            returnRegisterRes.setTiketNo(response.getHisTradeNo());
            return FrontResponse.success((String)param.getTransactionId(), (Object)returnRegisterRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u9000\u53f7\u9000\u8d39\u8bf7\u6c42\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u9000\u53f7\u9000\u8d39\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<GetAppointRecordRes> getAppointRecord(FrontRequest<GetAppointRecordReq> param) {
        log.info("\u6302\u53f7\u8bb0\u5f55\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            HashMap paramMap = new HashMap();
            HashMap<String, String> ext_info = new HashMap<String, String>();
            HashMap<String, String> pagein = new HashMap<String, String>();
            ext_info.put("pass_through", "");
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("patient_id", StrUtil.isEmpty((CharSequence)((GetAppointRecordReq)param.getBody()).getPatientId()) ? ((GetAppointRecordReq)param.getBody()).getCardNo() : ((GetAppointRecordReq)param.getBody()).getPatientId());
            info.put("order_id", ((GetAppointRecordReq)param.getBody()).getOrderId());
            info.put("order_statue", ((GetAppointRecordReq)param.getBody()).getStatus());
            info.put("id_type", ((GetAppointRecordReq)param.getBody()).getIdType());
            info.put("id_number", ((GetAppointRecordReq)param.getBody()).getIdNumber());
            info.put("start_time", ((GetAppointRecordReq)param.getBody()).getStartDate());
            info.put("end_time", DateUtil.today());
            info.put("operator", "HLWYY");
            info.put("extend_params", "");
            pagein.put("topagenum", CLINIC_TYPE_CANCEL);
            pagein.put("rowsperpage", "200");
            pagein.put("pageaction", "Topage");
            pagein.put("currentpagenum", CLINIC_TYPE_CANCEL);
            paramMap.put("ext_info", ext_info);
            paramMap.put("info", info);
            paramMap.put("pagein", pagein);
            String content = JSONObject.toJSONString(paramMap);
            String head = SignUtil.getHead((String)PayCodeEnum.getDisplay((String)"GETBUSREGORDERLIST"), (String)param.getTransactionId());
            log.info("his\u6302\u53f7\u8bb0\u5f55\u8bf7\u6c42\u76f4\u63a5\u5165\u53c2head:" + head + "  body:" + JSON.toJSONString((Object)content));
            String hisRes = HttpKit.get((String)("http://127.0.0.1:9000/test/testPayNew?headJson=" + head + "&body=" + content + "&url=" + "http://192.168.201.18:18118/orgine/powermsp/service/overt"));
            log.info("his\u6302\u53f7\u8bb0\u5f55\u8bf7\u6c42\u76f4\u63a5\u51fa\u53c2" + hisRes);
            if (StrUtil.isBlank((CharSequence)hisRes)) {
                return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u5bf9\u8d26\u5e73\u53f0\u6302\u53f7\u8bb0\u5f55\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            GeneralReconciliationRes generalReconciliationRes = (GeneralReconciliationRes)JSON.parseObject((String)hisRes, GeneralReconciliationRes.class);
            if (BeanUtil.isEmpty((Object)generalReconciliationRes, (String[])new String[0])) {
                return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u5bf9\u8d26\u5e73\u53f0\u6302\u53f7\u8bb0\u5f55\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (BeanUtil.isEmpty((Object)generalReconciliationRes.getResult(), (String[])new String[0])) {
                return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u5bf9\u8d26\u5e73\u53f0\u6302\u53f7\u8bb0\u5f55\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            }
            if (StrUtil.isBlank((CharSequence)generalReconciliationRes.getBody())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)(generalReconciliationRes.getResult().getMsg() + generalReconciliationRes.getResult().getSub_code() + generalReconciliationRes.getResult().getSub_msg()));
            }
            if (!generalReconciliationRes.getResult().getCode().equals("10000")) {
                return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)(generalReconciliationRes.getResult().getMsg() + generalReconciliationRes.getResult().getSub_code() + generalReconciliationRes.getResult().getSub_msg()));
            }
            ReconPlatRecord reconPlatRecord = (ReconPlatRecord)JSON.parseObject((String)generalReconciliationRes.getBody(), ReconPlatRecord.class);
            GetAppointRecordRes getAppointRecordRes = new GetAppointRecordRes();
            getAppointRecordRes.setCardNo(StrUtil.isEmpty((CharSequence)((GetAppointRecordReq)param.getBody()).getPatientId()) ? ((GetAppointRecordReq)param.getBody()).getCardNo() : ((GetAppointRecordReq)param.getBody()).getPatientId());
            ArrayList<AppointRecordItem> items = new ArrayList<AppointRecordItem>();
            for (int i = 0; i < reconPlatRecord.getList().size(); ++i) {
                ReconPlatRecordList reconPlatRecordList = (ReconPlatRecordList)reconPlatRecord.getList().get(i);
                AppointRecordItem appointRecordItem = new AppointRecordItem();
                appointRecordItem.setReceiptNo(reconPlatRecordList.getInvoice_number());
                appointRecordItem.setAdmId(reconPlatRecordList.getVisiting_number());
                appointRecordItem.setAppointTime(reconPlatRecordList.getOut_call_date());
                appointRecordItem.setRegRecordId(reconPlatRecordList.getOrder_id());
                appointRecordItem.setAdmDate(reconPlatRecordList.getOut_call_date());
                appointRecordItem.setDeptCode(reconPlatRecordList.getDeptment_code());
                appointRecordItem.setDeptName(reconPlatRecordList.getDeptment_name());
                appointRecordItem.setDocCode(reconPlatRecordList.getDoctor_code());
                appointRecordItem.setDocName(reconPlatRecordList.getDoctor_name());
                appointRecordItem.setRegDocType(reconPlatRecordList.getPositional_titles());
                appointRecordItem.setNo(reconPlatRecordList.getQueue_number());
                appointRecordItem.setAdmitTimeRange(reconPlatRecordList.getStart_time() + "-" + reconPlatRecordList.getEnd_time());
                appointRecordItem.setAdmitAddress(reconPlatRecordList.getAddress());
                BigDecimal regFee = BigDecimal.valueOf(reconPlatRecordList.getRegistration_fee());
                BigDecimal treatFee = BigDecimal.valueOf(reconPlatRecordList.getTreatment_fee());
                BigDecimal otherFees = BigDecimal.valueOf(reconPlatRecordList.getOther_fees());
                BigDecimal total = regFee.add(treatFee).add(otherFees);
                appointRecordItem.setRegFee(total.toString());
                appointRecordItem.setChannel(reconPlatRecordList.getMac_number());
                appointRecordItem.setChannleName(reconPlatRecordList.getApp_name());
                items.add(appointRecordItem);
            }
            getAppointRecordRes.setItems(items);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getAppointRecordRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u6302\u53f7\u8bb0\u5f55\u8bf7\u6c42\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u6302\u53f7\u8bb0\u5f55\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<LockOrderRes> appointLockOrder(FrontRequest<LockOrderReq> param) {
        log.info("\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            LockOrderReq body = (LockOrderReq)param.getBody();
            RegisterReqDTO registerReqDTO = new RegisterReqDTO();
            registerReqDTO.setTradeCode(MethodCodeEnum.REGISTERED_NOWDAY.getDisplay());
            registerReqDTO.setExtUserID("HLWYY");
            registerReqDTO.setPatientID(body.getPatientId());
            registerReqDTO.setCardNo(body.getCardNo());
            registerReqDTO.setScheduleItemCode(body.getScheduleCode());
            registerReqDTO.setEndTime(body.getEndTime());
            registerReqDTO.setBeginTime(body.getBeginTime());
            HashMap<String, RegisterReqDTO> map = new HashMap<String, RegisterReqDTO>();
            map.put(EntityKeyEnum.REGISTERED_NOWDAY.getValue(), registerReqDTO);
            String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.REGISTERED_NOWDAY.getValue(), map);
            log.info("his\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u76f4\u63a5\u5165\u53c2" + requestHisXml);
            String hisRes = this.cxfClientUtil.send("http://192.168.201.18/csp/hsb/DHC.Published.PUB0009.BS.PUB0009.CLS?WSDL=1", MethodCodeEnum.REGISTERED_NOWDAY.getDisplay(), requestHisXml);
            log.info("his\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u76f4\u63a5\u51fa\u53c2" + hisRes);
            RegisterResDTO response = (RegisterResDTO)XmlUtil.convertToJavaBean((String)hisRes, RegisterResDTO.class);
            log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            log.info("his\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)response.getResultContent());
            }
            if (!CLINIC_TYPE_APPOINT.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)response.getResultContent());
            }
            LockOrderRes lockOrderRes = new LockOrderRes();
            lockOrderRes.setAppointId(response.getOrderCode());
            lockOrderRes.setLockQueueNo(response.getSeqCode());
            lockOrderRes.setRbasId(body.getScheduleCode());
            lockOrderRes.setTimeArrangeId(body.getScheduleCode());
            return FrontResponse.success((String)param.getTransactionId(), (Object)lockOrderRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<LockOrderRes> dayLockOrder(FrontRequest<LockOrderReq> param) {
        log.info("\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            LockOrderReq body = (LockOrderReq)param.getBody();
            RegisterReqDTO registerReqDTO = new RegisterReqDTO();
            registerReqDTO.setTradeCode(MethodCodeEnum.DAY_REGISTERED_NOWDAY.getDisplay());
            registerReqDTO.setExtUserID("HLWYY");
            registerReqDTO.setPatientID(body.getPatientId());
            registerReqDTO.setCardNo(body.getCardNo());
            registerReqDTO.setScheduleItemCode(body.getScheduleCode());
            registerReqDTO.setEndTime(body.getEndTime());
            registerReqDTO.setBeginTime(body.getBeginTime());
            HashMap<String, RegisterReqDTO> map = new HashMap<String, RegisterReqDTO>();
            map.put(EntityKeyEnum.REGISTERED_NOWDAY.getValue(), registerReqDTO);
            String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.DAY_REGISTERED_NOWDAY.getValue(), map);
            log.info("his\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u76f4\u63a5\u5165\u53c2" + requestHisXml);
            String hisRes = this.cxfClientUtil.send("http://192.168.201.18/csp/hsb/DHC.Published.PUB0009.BS.PUB0009.CLS?WSDL=1", MethodCodeEnum.DAY_REGISTERED_NOWDAY.getDisplay(), requestHisXml);
            log.info("his\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u76f4\u63a5\u51fa\u53c2" + hisRes);
            RegisterResDTO response = (RegisterResDTO)XmlUtil.convertToJavaBean((String)hisRes, RegisterResDTO.class);
            log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            log.info("his\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)response.getResultContent());
            }
            if (!CLINIC_TYPE_APPOINT.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)response.getResultContent());
            }
            LockOrderRes lockOrderRes = new LockOrderRes();
            lockOrderRes.setAppointId(response.getTransactionId());
            lockOrderRes.setLockQueueNo(response.getLockQueueNo());
            lockOrderRes.setRbasId(body.getScheduleCode());
            lockOrderRes.setTimeArrangeId(body.getScheduleCode());
            return FrontResponse.success((String)param.getTransactionId(), (Object)lockOrderRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)CLINIC_TYPE_APPOINT, (String)"\u6302\u53f7\u9501\u53f7\u8bf7\u6c42\u5f02\u5e38");
        }
    }
}

