/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.core.util.IdcardUtil;
import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.common.enums.MethodNameEnum;
import com.ebaiyihui.his.pojo.dto.CreatePatientInfoReqDTO;
import com.ebaiyihui.his.pojo.dto.CreatePatientInfoResDTO;
import com.ebaiyihui.his.pojo.dto.PatInfosDTO;
import com.ebaiyihui.his.pojo.dto.QueryCardInfoReqDTO;
import com.ebaiyihui.his.pojo.dto.QueryCardInfoResDTO;
import com.ebaiyihui.his.service.ICardService;
import com.ebaiyihui.his.utils.CxfClientUtil;
import com.ebaiyihui.his.utils.DobUtils;
import com.ebaiyihui.his.utils.XmlTemplateKit;
import com.ebaiyihui.his.utils.XmlUtil;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import his.pojo.vo.card.QueryCardInfoReqVO;
import his.pojo.vo.card.QueryCardInfoResVO;
import his.pojo.vo.card.RegisteredCardReqVO;
import his.pojo.vo.card.RegisteredCardResVO;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CardServiceImpl
implements ICardService {
    private static final Logger log = LoggerFactory.getLogger(CardServiceImpl.class);
    @Autowired
    private CxfClientUtil cxfClientUtil;

    public FrontResponse<QueryCardInfoResVO> queryCardInfo(FrontRequest<QueryCardInfoReqVO> param) {
        log.info("\u67e5\u8be2\u5c31\u8bca\u5361\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            QueryCardInfoReqVO body = (QueryCardInfoReqVO)param.getBody();
            QueryCardInfoReqDTO queryCardInfoReqDTO = new QueryCardInfoReqDTO();
            queryCardInfoReqDTO.setTradeCode(MethodCodeEnum.GET_PATIENT_INFO.getDisplay());
            queryCardInfoReqDTO.setPatientID(body.getCardNo());
            queryCardInfoReqDTO.setIdCardType("03");
            queryCardInfoReqDTO.setPatientCard(body.getCredNo());
            queryCardInfoReqDTO.setPatientName(body.getName());
            queryCardInfoReqDTO.setExtUserID("HLWYY");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(EntityKeyEnum.QUERY_CARD_INFO.getValue(), queryCardInfoReqDTO);
            String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.QUERY_INFO.getValue(), map);
            log.info("\u67e5\u8be2\u5c31\u8bca\u5361\u5165\u53c2\uff1a" + requestHisXml);
            map.put("method", MethodCodeEnum.GET_PATIENT_INFO.getDisplay());
            map.put("xml", requestHisXml);
            String hisRes = this.cxfClientUtil.send("http://192.168.201.18/csp/hsb/DHC.Published.PUB0009.BS.PUB0009.CLS?WSDL=1", MethodCodeEnum.GET_PATIENT_INFO.getDisplay(), requestHisXml);
            log.info("his\u51fa\u53c2\uff1a" + hisRes);
            QueryCardInfoResDTO response = (QueryCardInfoResDTO)XmlUtil.convertToJavaBean((String)hisRes, QueryCardInfoResDTO.class);
            log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getResultContent());
            }
            if (!"0".equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getResultContent());
            }
            PatInfosDTO patInfosDTO = (PatInfosDTO)response.getPatInfos().getPatInfo().get(0);
            QueryCardInfoResVO queryCardInfoResVO = new QueryCardInfoResVO();
            queryCardInfoResVO.setTelephone(patInfosDTO.getMobile());
            queryCardInfoResVO.setCardNo(patInfosDTO.getPatientCard());
            queryCardInfoResVO.setPatientId(patInfosDTO.getPatientID());
            queryCardInfoResVO.setDob(patInfosDTO.getDOB());
            queryCardInfoResVO.setAddress(patInfosDTO.getAddress());
            queryCardInfoResVO.setName(patInfosDTO.getPatientName());
            queryCardInfoResVO.setSex(patInfosDTO.getSexCode().equals("1") ? "\u7537" : "\u5973");
            queryCardInfoResVO.setCredNo(patInfosDTO.getIDNo());
            queryCardInfoResVO.setCredType("01");
            queryCardInfoResVO.setCardType("1702");
            return FrontResponse.success((String)param.getTransactionId(), (Object)queryCardInfoResVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u5c31\u8bca\u5361\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5c31\u8bca\u5361\u5f02\u5e38");
        }
    }

    public FrontResponse<RegisteredCardResVO> registerCard(FrontRequest<RegisteredCardReqVO> param) {
        log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            RegisteredCardReqVO body = (RegisteredCardReqVO)param.getBody();
            CreatePatientInfoReqDTO createPatientInfoReqDTO = new CreatePatientInfoReqDTO();
            createPatientInfoReqDTO.setTradeCode(MethodCodeEnum.SAVE_PATIENT_CARD.getDisplay());
            createPatientInfoReqDTO.setPatientCard(body.getCardNo());
            createPatientInfoReqDTO.setCardTypeCode("01");
            createPatientInfoReqDTO.setPatientType("01");
            createPatientInfoReqDTO.setPatientName(body.getName());
            createPatientInfoReqDTO.setSex(body.getSex().equals("M") ? "1" : "2");
            createPatientInfoReqDTO.setDOB(DobUtils.format((String)body.getCredNo().substring(6, 14)));
            createPatientInfoReqDTO.setIdType(body.getRegisterType());
            createPatientInfoReqDTO.setIdNo(body.getCredNo());
            createPatientInfoReqDTO.setMobile(body.getTelephone());
            createPatientInfoReqDTO.setUserID("HLWYY");
            createPatientInfoReqDTO.setAddress(IdcardUtil.getProvinceByIdCard((String)body.getCredNo()));
            HashMap<String, CreatePatientInfoReqDTO> map = new HashMap<String, CreatePatientInfoReqDTO>();
            map.put(EntityKeyEnum.CREATE_PATIENT_INFO.getValue(), createPatientInfoReqDTO);
            String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.PAT_INFO_CREATE.getValue(), map);
            log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u5165\u53c2\uff1a" + requestHisXml);
            String hisRes = this.cxfClientUtil.send("http://192.168.201.18/csp/hsb/DHC.Published.PUB0009.BS.PUB0009.CLS?WSDL=1", MethodCodeEnum.SAVE_PATIENT_CARD.getDisplay(), requestHisXml);
            CreatePatientInfoResDTO response = (CreatePatientInfoResDTO)XmlUtil.convertToJavaBean((String)hisRes, CreatePatientInfoResDTO.class);
            log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            log.info("his \u6ce8\u518c\u5c31\u8bca\u5361\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getResultContent());
            }
            if (!"0".equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getResultContent());
            }
            RegisteredCardResVO registeredCardResVO = new RegisteredCardResVO();
            registeredCardResVO.setCardNo(response.getPatientCard());
            registeredCardResVO.setPatientId(response.getPatientID());
            registeredCardResVO.setCardType("01");
            registeredCardResVO.setName(body.getName());
            registeredCardResVO.setTelephone(body.getTelephone());
            registeredCardResVO.setCredNo(body.getCredNo());
            registeredCardResVO.setAddress(IdcardUtil.getProvinceByIdCard((String)body.getCredNo()));
            registeredCardResVO.setDob(DobUtils.format((String)body.getCredNo().substring(6, 14)));
            registeredCardResVO.setSex(String.valueOf(IdcardUtil.getGenderByIdCard((String)body.getCredNo())).equals("1") ? "M" : "F");
            return FrontResponse.success((String)param.getTransactionId(), (Object)registeredCardResVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u6ce8\u518c\u5c31\u8bca\u5361\u5f02\u5e38");
        }
    }
}

