/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodNameEnum;
import com.ebaiyihui.his.config.data.DBContextHolder;
import com.ebaiyihui.his.mapper.ElectronicReportMapper;
import com.ebaiyihui.his.pojo.dto.LisReportQueryReqDTO;
import com.ebaiyihui.his.service.ElectronicReportService;
import com.ebaiyihui.his.utils.CxfClientUtil;
import com.ebaiyihui.his.utils.XmlTemplateKit;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import his.pojo.vo.report.GetReportListsReq;
import his.pojo.vo.report.GetReportListsRes;
import his.pojo.vo.report.GetReportUrlReq;
import his.pojo.vo.report.GetReportUrlRes;
import his.pojo.vo.report.PacsReportListReq;
import his.pojo.vo.report.PacsReportListRes;
import his.pojo.vo.report.datas.GetReportListsData;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElectronicReportServiceImpl
implements ElectronicReportService {
    private static final Logger log = LoggerFactory.getLogger(ElectronicReportServiceImpl.class);
    public static final String SUCCESS_FLAG = "0";
    @Autowired
    private ElectronicReportMapper electronicReportMapper;
    @Autowired
    private CxfClientUtil cxfClientUtil;

    public FrontResponse<GetReportListsRes> getReportLists(FrontRequest<GetReportListsReq> param) {
        log.info("\u67e5\u8be2\u7535\u5b50\u62a5\u544a\u5217\u8868\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetReportListsReq body = (GetReportListsReq)param.getBody();
            DBContextHolder.setDataSource((String)"1");
            List response = this.electronicReportMapper.selectByOutPatientId(body.getPatientId());
            log.info("his\u67e5\u8be2\u7535\u5b50\u62a5\u544a\u5217xml\u8f6cjavaBean\u8f6c\u6362\u51fa\u53c2" + response);
            if (response.size() <= 0) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e");
            }
            GetReportListsRes getReportListsRes = new GetReportListsRes();
            ArrayList<GetReportListsData> GetReportListsDataItem = new ArrayList<GetReportListsData>();
            for (JSONObject date : response) {
                GetReportListsData getReportListsData = new GetReportListsData();
                getReportListsData.setReportNo(date.getString("\u68c0\u67e5\u6d41\u6c34\u53f7"));
                getReportListsData.setReportName(date.getString("\u68c0\u67e5\u5b50\u7c7b"));
                getReportListsData.setReportDate(date.getString("\u62a5\u544a\u65f6\u95f4"));
                GetReportListsDataItem.add(getReportListsData);
            }
            getReportListsRes.setDatas(GetReportListsDataItem);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getReportListsRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u7535\u5b50\u62a5\u544a\u5217\u8868\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u7535\u5b50\u62a5\u544a\u5217\u8868\u5f02\u5e38");
        }
    }

    public static int convertToCents(BigDecimal amount) {
        BigDecimal cents = amount.multiply(new BigDecimal("100"));
        return cents.intValue();
    }

    public static boolean isZero(BigDecimal amount) {
        return amount.compareTo(BigDecimal.ZERO) == 0;
    }

    public static void main(String[] args) {
        BigDecimal add = new BigDecimal("4.13").add(new BigDecimal("5.15"));
        System.out.println(add);
    }

    public FrontResponse<GetReportListsRes> getInspectionList(GetReportListsReq getReportListsReq) {
        DBContextHolder.setDataSource((String)"2");
        log.info("\u67e5\u8be2\u68c0\u9a8c\u5217\u8868\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString((Object)getReportListsReq));
        List response = this.electronicReportMapper.selectSampleByOutPatientId(getReportListsReq.getPatientId(), getReportListsReq.getBeginTime(), getReportListsReq.getEndTime());
        log.info("\u67e5\u8be2\u68c0\u9a8c\u5217\u8868\u8bf7\u6c42\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)response));
        if (CollUtil.isEmpty((Collection)response)) {
            return FrontResponse.error((String)"", (String)SUCCESS_FLAG, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        GetReportListsRes getReportListsRes = new GetReportListsRes();
        getReportListsRes.setPatientNo(getReportListsReq.getPatientId());
        ArrayList<GetReportListsData> GetReportListsDataItem = new ArrayList<GetReportListsData>();
        for (JSONObject date : response) {
            GetReportListsData getReportListsData = new GetReportListsData();
            getReportListsData.setReportNo(date.getString("INSPECTION_ID"));
            getReportListsData.setReportName(date.getString("TEST_ORDER_NAME"));
            getReportListsData.setReportDate(date.getString("CHECK_TIME"));
            GetReportListsDataItem.add(getReportListsData);
        }
        getReportListsRes.setDatas(GetReportListsDataItem);
        return FrontResponse.success((String)"", (Object)getReportListsRes);
    }

    public byte[] lisReportList(String reportNo) {
        try {
            DBContextHolder.setDataSource((String)"4");
            log.info("\u83b7\u53d6\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u8bf7\u6c42\u5165\u53c2\uff1a" + reportNo);
            JSONObject response = this.electronicReportMapper.selectPdfByInspectionId(reportNo);
            log.info("\u83b7\u53d6\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u8bf7\u6c42\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)response));
            String url = response.getString("REPORT_FILE");
            url = url.replace("172.16.0.244:10087", "192.168.201.18:10087");
            if (StrUtil.isBlank((CharSequence)url)) {
                return null;
            }
            log.info("\u8bf7\u6c42lis\u83b7\u53d6\u68c0\u9a8c\u62a5\u544a\u5355PDF\u5165\u53c2->{}", (Object)url);
            byte[] bytes = HttpUtil.downloadBytes((String)url);
            log.info("\u8bf7\u6c42lis\u83b7\u53d6\u68c0\u9a8c\u62a5\u544a\u5355PDF\u6587\u4ef6\u5927\u5c0f\u51fa\u53c2->{}", (Object)bytes.length);
            return bytes;
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u5f02\u5e38- > {}", (Throwable)e);
            return null;
        }
    }

    public FrontResponse<GetReportUrlRes> getReportUrl(FrontRequest<GetReportUrlReq> param) {
        return null;
    }

    public FrontResponse<PacsReportListRes> pacsReportList(FrontRequest<PacsReportListReq> param) {
        log.info("\u67e5\u8be2\u68c0\u67e5\u62a5\u544a\u8be6\u60c5\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            PacsReportListReq body = (PacsReportListReq)param.getBody();
            LisReportQueryReqDTO lisReportQueryReqDTO = new LisReportQueryReqDTO();
            HashMap<String, LisReportQueryReqDTO> map = new HashMap<String, LisReportQueryReqDTO>();
            map.put(EntityKeyEnum.JY_REPORT_LIST.getValue(), lisReportQueryReqDTO);
            String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.JY_REPORT_DETIAL.getValue(), map);
            log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + requestHisXml);
            DBContextHolder.setDataSource((String)"1");
            List response = this.electronicReportMapper.selectByReportNo(body.getReportNo());
            log.info("his\u67e5\u8be2\u68c0\u67e5\u62a5\u544a\u8be6\u60c5\u8bf7\u6c42\u76f4\u63a5\u51fa\u53c2" + response);
            if (response.size() <= 0) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u672a\u67e5\u8be2\u5230\u6570\u636e");
            }
            JSONObject date = (JSONObject)response.get(0);
            PacsReportListRes pacsReportListRes = new PacsReportListRes();
            pacsReportListRes.setDeptName(date.getString("\u7533\u8bf7\u79d1\u5ba4"));
            pacsReportListRes.setPatientName(date.getString("\u59d3\u540d"));
            pacsReportListRes.setSex(date.getString("\u6027\u522b"));
            pacsReportListRes.setDiagnosis(date.getString("\u68c0\u67e5\u7ed3\u679c"));
            pacsReportListRes.setDoctorName(date.getString("\u7533\u8bf7\u533b\u751f"));
            pacsReportListRes.setAuthTime(date.getString("\u7533\u8bf7\u65e5\u671f"));
            pacsReportListRes.setCheckResult(date.getString("\u68c0\u67e5\u7ed3\u679c"));
            pacsReportListRes.setAuthUser(date.getString("\u5ba1\u6838\u533b\u751f"));
            pacsReportListRes.setCheckDesc(date.getString("\u68c0\u67e5\u6240\u89c1"));
            return FrontResponse.success((String)param.getTransactionId(), (Object)pacsReportListRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u68c0\u67e5\u62a5\u544a\u8be6\u60c5\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u68c0\u67e5\u62a5\u544a\u8be6\u60c5\u5f02\u5e38");
        }
    }
}

