/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.common.enums.MethodNameEnum;
import com.ebaiyihui.his.common.enums.PayCodeEnum;
import com.ebaiyihui.his.pojo.dto.GetInpAdmissionResDTO;
import com.ebaiyihui.his.pojo.dto.GetInpAdmisssionReqDTO;
import com.ebaiyihui.his.pojo.dto.GetInpCostDetailReqDTO;
import com.ebaiyihui.his.pojo.dto.GetInpCostDetailResDTO;
import com.ebaiyihui.his.pojo.dto.GetInpCostDetailResItemsDTO;
import com.ebaiyihui.his.pojo.dto.HosDepositRecordItemResDTO;
import com.ebaiyihui.his.pojo.dto.HosDepositRecordReqDTO;
import com.ebaiyihui.his.pojo.dto.HosDepositRecordResDTO;
import com.ebaiyihui.his.service.HospitalizationService;
import com.ebaiyihui.his.utils.CxfClientUtil;
import com.ebaiyihui.his.utils.DateUtil;
import com.ebaiyihui.his.utils.GetAgeUtils;
import com.ebaiyihui.his.utils.HttpKit;
import com.ebaiyihui.his.utils.SignUtil;
import com.ebaiyihui.his.utils.XmlTemplateKit;
import com.ebaiyihui.his.utils.XmlUtil;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import his.pojo.vo.hospitalization.CancelInHosOrderReq;
import his.pojo.vo.hospitalization.CancelInHosOrderRes;
import his.pojo.vo.hospitalization.DepositCreateOrderReq;
import his.pojo.vo.hospitalization.DepositCreateOrderRes;
import his.pojo.vo.hospitalization.DepositReq;
import his.pojo.vo.hospitalization.DepositRes;
import his.pojo.vo.hospitalization.DeptCreatOrderBodyDTO;
import his.pojo.vo.hospitalization.GetIPDepositRecordsReq;
import his.pojo.vo.hospitalization.GetIPDepositRecordsRes;
import his.pojo.vo.hospitalization.GetInpAdmissionReq;
import his.pojo.vo.hospitalization.GetInpAdmissionRes;
import his.pojo.vo.hospitalization.GetOrdItemsReq;
import his.pojo.vo.hospitalization.GetOrdItemsRes;
import his.pojo.vo.hospitalization.items.GetIPDepositRecordsItems;
import his.pojo.vo.hospitalization.items.GetInpAdmissionResItems;
import his.pojo.vo.hospitalization.items.GetOrdItemsResItems;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HospitalizationServiceImpl
implements HospitalizationService {
    private static final Logger log = LoggerFactory.getLogger(HospitalizationServiceImpl.class);
    public static final String HIS_OUT_HOSP_STATUS = "1";
    public static final String BYH_OUT_HOSP_STATUS = "D";
    public static final String BYH_IN_HOSP_STATUS = "A";
    public static final int MAP_SIZE = 1;
    public static final String SUCCESS_FLAG = "0";
    private static final String PAY_SUCCESS = "Y";
    private static final String PAY_FAIL = "N";
    private static final String HIS_PAY_SUCCESS = "SUCCESS";
    private static final String HIS_PAY_FAIL = "FAIL";
    @Autowired
    private CxfClientUtil cxfClientUtil;

    public FrontResponse<GetInpAdmissionRes> getInpAdmission(FrontRequest<GetInpAdmissionReq> param) {
        log.info("\u67e5\u8be2\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetInpAdmissionReq body = (GetInpAdmissionReq)param.getBody();
            GetInpAdmisssionReqDTO getInpAdmisssionReqDTO = new GetInpAdmisssionReqDTO();
            getInpAdmisssionReqDTO.setTradeCode(MethodCodeEnum.GET_INP_ADMISSION.getDisplay());
            getInpAdmisssionReqDTO.setUserCode("HLWYY");
            getInpAdmisssionReqDTO.setCardNo(body.getCardNo());
            getInpAdmisssionReqDTO.setCardType("03");
            HashMap<String, GetInpAdmisssionReqDTO> map = new HashMap<String, GetInpAdmisssionReqDTO>();
            map.put(EntityKeyEnum.GET_INP_ADMISSION.getValue(), getInpAdmisssionReqDTO);
            String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.GET_INP_ADMISSION.getValue(), map);
            log.info("his\u67e5\u8be2\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u76f4\u63a5\u51fa\u53c2" + requestHisXml);
            String hisRes = this.cxfClientUtil.send("http://192.168.201.18/csp/hsb/DHC.Published.PUB0009.BS.PUB0009.CLS?WSDL=1", MethodCodeEnum.GET_INP_ADMISSION.getDisplay(), requestHisXml);
            log.info("his\u67e5\u8be2\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u76f4\u63a5\u51fa\u53c2" + hisRes);
            GetInpAdmissionResDTO response = (GetInpAdmissionResDTO)XmlUtil.convertToJavaBean((String)hisRes, GetInpAdmissionResDTO.class);
            log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            log.info("his\u67e5\u8be2\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u8bf7\u6c42\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getResultMsg());
            }
            if (!SUCCESS_FLAG.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getResultMsg());
            }
            GetInpAdmissionRes getInpAdmissionRes = new GetInpAdmissionRes();
            ArrayList<GetInpAdmissionResItems> GetInpAdmissionResItemsItem = new ArrayList<GetInpAdmissionResItems>();
            List admInfoList = response.getAdmInfoList().getAdmInfoList();
            admInfoList.stream().forEach(dateItem -> {
                GetInpAdmissionResItems getInpAdmissionResItems = new GetInpAdmissionResItems();
                getInpAdmissionResItems.setDeptName(dateItem.getAdmDept());
                getInpAdmissionResItems.setBed(dateItem.getCurBed());
                getInpAdmissionResItems.setDeptCode(dateItem.getAdmDept());
                getInpAdmissionResItems.setDocName(dateItem.getCurDoc());
                getInpAdmissionResItems.setDocCode(dateItem.getCurDoc());
                getInpAdmissionResItems.setCardNo(body.getCardNo());
                getInpAdmissionResItems.setDiagnoseResult(dateItem.getCurDiag());
                getInpAdmissionResItems.setNursingUnit(dateItem.getCurWard());
                getInpAdmissionResItems.setPatientId(response.getPatientID());
                getInpAdmissionResItems.setCaseDesc(dateItem.getZhuSu());
                try {
                    getInpAdmissionResItems.setPatientAge(String.valueOf(GetAgeUtils.getAge((Date)DateUtil.strToDate((String)response.getDOB(), (String)"yyyy-MM-dd"))));
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
                getInpAdmissionResItems.setPatientName(response.getPatientName());
                getInpAdmissionResItems.setPatientSex(response.getSex());
                getInpAdmissionResItems.setStartDate(dateItem.getAdmDate());
                getInpAdmissionResItems.setInHospNo(dateItem.getAdmID());
                getInpAdmissionResItems.setTotalMoney(String.valueOf(new BigDecimal(dateItem.getTotalAmount()).setScale(2, 1)));
                getInpAdmissionResItems.setDepost(String.valueOf(new BigDecimal(dateItem.getDepositAmount()).setScale(2, 1)));
                getInpAdmissionResItems.setCurrentMoney(String.valueOf(new BigDecimal(dateItem.getDepositBalance()).setScale(2, 1)));
                GetInpAdmissionResItemsItem.add(getInpAdmissionResItems);
            });
            GetInpAdmissionResItemsItem.sort(Comparator.comparing(GetInpAdmissionResItems::getStartDate).reversed());
            GetInpAdmissionResItems getInpAdmissionResItems = (GetInpAdmissionResItems)GetInpAdmissionResItemsItem.get(0);
            GetInpAdmissionResItemsItem.removeIf(o -> !o.getStartDate().equals(getInpAdmissionResItems.getStartDate()));
            getInpAdmissionRes.setItems(GetInpAdmissionResItemsItem);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getInpAdmissionRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u8bf7\u6c42\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<DepositCreateOrderRes> createInHosOrder(FrontRequest<DepositCreateOrderReq> param) {
        log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u521b\u5efa\u8ba2\u5355\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            DepositCreateOrderReq body = (DepositCreateOrderReq)param.getBody();
            HashMap paramMap = new HashMap();
            HashMap<String, String> ext_info = new HashMap<String, String>();
            ext_info.put("pass_through", "");
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("inhospital_number", body.getInHospNo());
            info.put("patient_name", body.getPatientName());
            info.put("total_amount", body.getAmount());
            info.put("operator", "HLWYY");
            info.put("sex", body.getSex().equals("\u7537") ? 1 : 2);
            paramMap.put("ext_info", ext_info);
            paramMap.put("info", info);
            String content = JSONObject.toJSONString(paramMap);
            String head = SignUtil.getHead((String)PayCodeEnum.getDisplay((String)"CREATE_INHOS_ORDER"), (String)param.getTransactionId());
            log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u76f4\u63a5\u5165\u53c2head:" + head + "  body:" + content);
            String hisRes = HttpKit.get((String)("http://127.0.0.1:9000/test/testPayNew?headJson=" + head + "&body=" + content + "&url=" + "http://192.168.201.18:18118/orgine/powermsp/service/overt"));
            log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u76f4\u63a5\u51fa\u53c2" + hisRes);
            DepositCreateOrderRes depositCreateOrderRes = (DepositCreateOrderRes)JSON.parseObject((String)hisRes, DepositCreateOrderRes.class);
            if (null == depositCreateOrderRes) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
            }
            if (!"10000".equals(depositCreateOrderRes.getResult().getCode()) || !"success".equals(depositCreateOrderRes.getResult().getSub_code())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)depositCreateOrderRes.getResult().getMsg());
            }
            String bodyStr = depositCreateOrderRes.getBody();
            DeptCreatOrderBodyDTO deptCreatOrderBodyDTOS = (DeptCreatOrderBodyDTO)JSON.parseObject((String)bodyStr, DeptCreatOrderBodyDTO.class);
            depositCreateOrderRes.setBodyDTO(deptCreatOrderBodyDTOS);
            return FrontResponse.success((String)param.getTransactionId(), (Object)depositCreateOrderRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u5f02\u5e38");
        }
    }

    public FrontResponse<DepositRes> deposit(FrontRequest<DepositReq> param) {
        log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u786e\u8ba4\u8ba2\u5355\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            DepositReq body = (DepositReq)param.getBody();
            HashMap<String, Cloneable> paramMap = new HashMap<String, Cloneable>();
            HashMap<String, String> ext_info = new HashMap<String, String>();
            ext_info.put("pass_through", "");
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("order_id", body.getOrderId());
            info.put("trade_order_id", body.getTradeOrderId());
            info.put("pay_allamount", body.getRespmsg().getAmount());
            info.put("mac_number", "00:50:56:a4:0c:37");
            info.put("operator", "HLWYY");
            ArrayList list = new ArrayList();
            HashMap<String, String> paylist = new HashMap<String, String>();
            paylist.put("tran_no", body.getRespmsg().getTranNo());
            paylist.put("pay_amount", body.getRespmsg().getAmount());
            paylist.put("total_amount", body.getRespmsg().getAmount());
            paylist.put("pay_channel", body.getPayChannel());
            paylist.put("pay_type", "WeChatAppletPay");
            paylist.put("pay_nature", HIS_OUT_HOSP_STATUS);
            paylist.put("tran_time", body.getRespmsg().getAccDate());
            paylist.put("merchant_num", body.getRespmsg().getMerchantNum());
            paylist.put("pay_flowno", body.getRespmsg().getFlowNo());
            paylist.put("account_num", body.getRespmsg().getAccount());
            paylist.put("pay_agent_code", body.getRespmsg().getBusinessCode());
            list.add(paylist);
            paramMap.put("paylist", list);
            paramMap.put("ext_info", ext_info);
            paramMap.put("info", info);
            String content = JSONObject.toJSONString(paramMap);
            String head = SignUtil.getHead((String)PayCodeEnum.getDisplay((String)"CONFIRM_INHOS_ORDER"), (String)param.getTransactionId());
            log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u76f4\u63a5\u5165\u53c2head:" + head + "  body:" + content);
            String hisRes = HttpKit.get((String)("http://127.0.0.1:9000/test/testPayNew?headJson=" + head + "&body=" + content + "&url=" + "http://192.168.201.18:18118/orgine/powermsp/service/overt"));
            log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u76f4\u63a5\u51fa\u53c2" + hisRes);
            DepositRes depositRes = new DepositRes();
            return FrontResponse.success((String)param.getTransactionId(), (Object)depositRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u5f02\u5e38");
        }
    }

    public FrontResponse<CancelInHosOrderRes> cancelInHosOrder(FrontRequest<CancelInHosOrderReq> param) {
        log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            CancelInHosOrderReq body = (CancelInHosOrderReq)param.getBody();
            HashMap paramMap = new HashMap();
            HashMap<String, String> ext_info = new HashMap<String, String>();
            ext_info.put("pass_through", "");
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("order_id", body.getOrderId());
            paramMap.put("ext_info", ext_info);
            paramMap.put("info", info);
            String content = JSONObject.toJSONString(paramMap);
            String head = SignUtil.getHead((String)PayCodeEnum.CANCEL_INHOS_ORDER.getDisplay(), (String)param.getTransactionId());
            log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u76f4\u63a5\u5165\u53c2head:" + head + "  body:" + content);
            String hisRes = HttpKit.get((String)("http://127.0.0.1:9000/test/testPayNew?headJson=" + head + "&body=" + content + "&url=" + "http://192.168.201.18:18118/orgine/powermsp/service/overt"));
            log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u76f4\u63a5\u51fa\u53c2" + hisRes);
            CancelInHosOrderRes cancelInHosOrderRes = new CancelInHosOrderRes();
            return FrontResponse.success((String)param.getTransactionId(), (Object)cancelInHosOrderRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u5f02\u5e38");
        }
    }

    public FrontResponse<GetIPDepositRecordsRes> getIPDepositRecords(FrontRequest<GetIPDepositRecordsReq> param) {
        log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u67e5\u8be2\u5145\u503c\u8bb0\u5f55\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetIPDepositRecordsReq body = (GetIPDepositRecordsReq)param.getBody();
            HosDepositRecordReqDTO hosDepositRecordReqDTO = new HosDepositRecordReqDTO();
            hosDepositRecordReqDTO.setTradeCode(MethodCodeEnum.GET_INP_ADMISSION_PAY_RECORD.getDisplay());
            hosDepositRecordReqDTO.setUserCode("HLWYY");
            hosDepositRecordReqDTO.setPatientID(body.getPatientID());
            hosDepositRecordReqDTO.setAdmID(body.getInHospNo());
            HashMap<String, HosDepositRecordReqDTO> map = new HashMap<String, HosDepositRecordReqDTO>();
            map.put(EntityKeyEnum.GET_INP_ADMISSION_PAY_RECORD.getValue(), hosDepositRecordReqDTO);
            String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.GET_INP_ADMISSION_PAY_RECORD.getValue(), map);
            log.info("his\u4f4f\u9662\u9884\u4ea4\u91d1\u67e5\u8be2\u5145\u503c\u8bb0\u5f55\u76f4\u63a5\u5165\u53c2" + requestHisXml);
            String hisRes = this.cxfClientUtil.send("http://192.168.201.18/csp/hsb/DHC.Published.PUB0009.BS.PUB0009.CLS?WSDL=1", MethodCodeEnum.GET_INP_ADMISSION_PAY_RECORD.getDisplay(), requestHisXml);
            log.info("his\u4f4f\u9662\u9884\u4ea4\u91d1\u67e5\u8be2\u5145\u503c\u8bb0\u5f55\u76f4\u63a5\u51fa\u53c2" + hisRes);
            HosDepositRecordResDTO response = (HosDepositRecordResDTO)XmlUtil.convertToJavaBean((String)hisRes, HosDepositRecordResDTO.class);
            log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            log.info("his\u4f4f\u9662\u9884\u4ea4\u91d1\u67e5\u8be2\u5145\u503c\u8bb0\u5f55\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getResultMsg());
            }
            if (!SUCCESS_FLAG.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getResultMsg());
            }
            GetIPDepositRecordsRes getIPDepositRecordsRes = new GetIPDepositRecordsRes();
            ArrayList<GetIPDepositRecordsItems> items = new ArrayList<GetIPDepositRecordsItems>();
            List hosDepositRecord = response.getHosDepositRecordList().getHosDepositRecord();
            for (HosDepositRecordItemResDTO itemResDTO : hosDepositRecord) {
                GetIPDepositRecordsItems getIPDepositRecordsItems = new GetIPDepositRecordsItems();
                getIPDepositRecordsItems.setPrePayDateTime(itemResDTO.getPayDate() + " " + itemResDTO.getPayTime());
                getIPDepositRecordsItems.setAmout(itemResDTO.getPayAmout());
                getIPDepositRecordsItems.setPayChannel(itemResDTO.getPayMode());
                getIPDepositRecordsItems.setPayStatus(itemResDTO.getPayFlag());
                items.add(getIPDepositRecordsItems);
            }
            getIPDepositRecordsRes.setItems(items);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getIPDepositRecordsRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u67e5\u8be2\u5145\u503c\u8bb0\u5f55\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u4f4f\u9662\u9884\u4ea4\u91d1\u67e5\u8be2\u5145\u503c\u8bb0\u5f55\u5f02\u5e38");
        }
    }

    public FrontResponse<GetOrdItemsRes> getOrdItems(FrontRequest<GetOrdItemsReq> param) {
        log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6\u67e5\u8be2\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetOrdItemsReq body = (GetOrdItemsReq)param.getBody();
            GetInpCostDetailReqDTO getInpCostDetailReqDTO = new GetInpCostDetailReqDTO();
            getInpCostDetailReqDTO.setTradeCode(MethodCodeEnum.GET_INP_ADMISSION_DETIL.getDisplay());
            getInpCostDetailReqDTO.setCardTypeCode("03");
            getInpCostDetailReqDTO.setBillDate(body.getBillDate());
            getInpCostDetailReqDTO.setPatientID(body.getPatientID());
            getInpCostDetailReqDTO.setAdm(body.getInHospNo());
            getInpCostDetailReqDTO.setExtUserID("HLWYY");
            HashMap<String, GetInpCostDetailReqDTO> map = new HashMap<String, GetInpCostDetailReqDTO>();
            map.put(EntityKeyEnum.GET_INP_ADMISSION_DETIL.getValue(), getInpCostDetailReqDTO);
            String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.GET_INP_ADMISSION_DETIL.getValue(), map);
            log.info("his\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6\u67e5\u8be2\u76f4\u63a5\u5165\u53c2" + requestHisXml);
            String hisRes = this.cxfClientUtil.send("http://192.168.201.18/csp/hsb/DHC.Published.PUB0009.BS.PUB0009.CLS?WSDL=1", MethodCodeEnum.GET_INP_ADMISSION_DETIL.getDisplay(), requestHisXml);
            log.info("his\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6\u67e5\u8be2\u76f4\u63a5\u51fa\u53c2" + hisRes);
            GetInpCostDetailResDTO response = (GetInpCostDetailResDTO)XmlUtil.convertToJavaBean((String)hisRes, GetInpCostDetailResDTO.class);
            log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            log.info("his\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6\u67e5\u8be2\u8bf7\u6c42\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getErrorMsg());
            }
            if (!SUCCESS_FLAG.equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getErrorMsg());
            }
            GetOrdItemsRes getOrdItemsRes = new GetOrdItemsRes();
            ArrayList<GetOrdItemsResItems> getOrdItemsResItemsList = new ArrayList<GetOrdItemsResItems>();
            List items = response.getGetInpCostDetailResItems().getItems();
            for (GetInpCostDetailResItemsDTO itemResDTO : items) {
                GetOrdItemsResItems getOrdItemsResItems = new GetOrdItemsResItems();
                getOrdItemsResItems.setFeeType(itemResDTO.getCategory());
                getOrdItemsResItems.setItmMastName(itemResDTO.getItemName());
                getOrdItemsResItems.setQty(itemResDTO.getQty());
                getOrdItemsResItems.setPrice(String.valueOf(new BigDecimal(itemResDTO.getPrice()).setScale(2, 1)));
                getOrdItemsResItems.setAmount(itemResDTO.getTotalAmt());
                getOrdItemsResItems.setUomDesc(itemResDTO.getUOM());
                getOrdItemsResItems.setFeeDate(itemResDTO.getBillDate());
                getOrdItemsResItemsList.add(getOrdItemsResItems);
            }
            getOrdItemsRes.setOrdItem(getOrdItemsResItemsList);
            getOrdItemsRes.setSex(response.getPatSex());
            getOrdItemsRes.setName(response.getPatName());
            getOrdItemsRes.setInHospNo(((GetOrdItemsReq)param.getBody()).getInHospNo());
            getOrdItemsRes.setAdmDep(response.getDepartment());
            return FrontResponse.success((String)param.getTransactionId(), (Object)getOrdItemsRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6\u67e5\u8be2\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6\u67e5\u8be2\u5f02\u5e38");
        }
    }
}

