/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.common.enums.MethodNameEnum;
import com.ebaiyihui.his.pojo.dto.GetDeptListReqDTO;
import com.ebaiyihui.his.pojo.dto.GetDeptListResDTO;
import com.ebaiyihui.his.pojo.dto.GetScheduleReqDTO;
import com.ebaiyihui.his.pojo.dto.GetScheduleResDTO;
import com.ebaiyihui.his.pojo.dto.GetTimeRangeReqDTO;
import com.ebaiyihui.his.pojo.dto.GetTimeRangeResDTO;
import com.ebaiyihui.his.service.ScheduleService;
import com.ebaiyihui.his.utils.CxfClientUtil;
import com.ebaiyihui.his.utils.HttpKit;
import com.ebaiyihui.his.utils.XmlTemplateKit;
import com.ebaiyihui.his.utils.XmlUtil;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import his.pojo.vo.schedule.GetDeptScheduleReqVO;
import his.pojo.vo.schedule.GetDeptScheduleResVO;
import his.pojo.vo.schedule.GetScheduleReqVO;
import his.pojo.vo.schedule.GetScheduleResVO;
import his.pojo.vo.schedule.TimeArrangeReq;
import his.pojo.vo.schedule.TimeArrangeRes;
import his.pojo.vo.schedule.items.GetDeptScheduleResItems;
import his.pojo.vo.schedule.items.GetScheduleResItems;
import his.pojo.vo.schedule.items.TimeArrangeItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScheduleServiceImpl
implements ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    @Autowired
    private CxfClientUtil cxfClientUtil;

    public FrontResponse<GetScheduleResVO> getSchedule(FrontRequest<GetScheduleReqVO> param) {
        log.info("\u67e5\u8be2\u6392\u73ed\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetScheduleReqVO body = (GetScheduleReqVO)param.getBody();
            GetScheduleReqDTO getScheduleReqDTO = new GetScheduleReqDTO();
            getScheduleReqDTO.setExtUserID("HLWYY");
            getScheduleReqDTO.setTradeCode(MethodCodeEnum.SCHEDULE_SOURCE.getDisplay());
            getScheduleReqDTO.setEndDate(body.getEdDate());
            getScheduleReqDTO.setStartDate(body.getBgDate());
            getScheduleReqDTO.setDepartmentCode(body.getLocCode());
            getScheduleReqDTO.setDoctorCode(body.getDocCode());
            getScheduleReqDTO.setStopScheduleFlag("N");
            HashMap<String, GetScheduleReqDTO> map = new HashMap<String, GetScheduleReqDTO>();
            map.put(EntityKeyEnum.SCHEDULE_SOURCE.getValue(), getScheduleReqDTO);
            String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.SCHEDULE_SOURCE.getValue(), map);
            log.info("\u67e5\u8be2\u6392\u73edhis\u5165\u53c2\uff1a" + requestHisXml);
            String hisRes = this.cxfClientUtil.send("http://192.168.201.18/csp/hsb/DHC.Published.PUB0009.BS.PUB0009.CLS?WSDL=1", MethodCodeEnum.SCHEDULE_SOURCE.getDisplay(), requestHisXml);
            log.info("..." + hisRes);
            GetScheduleResDTO response = (GetScheduleResDTO)XmlUtil.convertToJavaBean((String)hisRes, GetScheduleResDTO.class);
            log.info("his\u67e5\u8be2\u6392\u73ed\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            GetScheduleResVO getScheduleResVO = new GetScheduleResVO();
            ArrayList GetScheduleItems = new ArrayList();
            log.info("his\u67e5\u8be2\u6392\u73ed\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)response));
            if (null == response.getGetScheduleItemsResDTOList()) {
                return FrontResponse.success((String)param.getTransactionId(), (Object)getScheduleResVO);
            }
            if (!"0".equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getResultMsg());
            }
            List getScheduleItemsResDTOList = response.getGetScheduleItemsResDTOList().getGetScheduleItemsResDTOList();
            getScheduleItemsResDTOList.stream().forEach(date -> {
                if (null == date.getAvailableLeftNum() || null == date.getAvailableLeftNum()) {
                    date.setAvailableLeftNum("0");
                    date.setAvailableTotalNum("0");
                }
                GetScheduleResItems getScheduleResItems = new GetScheduleResItems();
                getScheduleResItems.setScheduleId(date.getScheduleItemCode());
                getScheduleResItems.setAdmDate(date.getServiceDate());
                getScheduleResItems.setLocCode(date.getDepartmentCode());
                getScheduleResItems.setLocName(date.getDepartmentName());
                getScheduleResItems.setDocCode(date.getDoctorCode());
                getScheduleResItems.setDocName(date.getDoctorName());
                getScheduleResItems.setDiagFee(date.getCheckupFee());
                getScheduleResItems.setRegFee(date.getRegFee());
                getScheduleResItems.setRegAvailable(Integer.valueOf(date.getAvailableLeftNum()));
                getScheduleResItems.setRegTitleCode(date.getDoctorTitleCode());
                getScheduleResItems.setRegTitleName(date.getDoctorTitle());
                getScheduleResItems.setAdmLocation(date.getAdmitAddress());
                getScheduleResItems.setAdmTimeRange(date.getSessionName());
                getScheduleResItems.setRegTotal(Integer.valueOf(date.getAvailableTotalNum()));
                getScheduleResItems.setIsTimeArrange(Integer.valueOf(1));
                getScheduleResItems.setScheduleStatus(date.getScheduleStatus());
                GetScheduleItems.add(getScheduleResItems);
            });
            getScheduleResVO.setItems(GetScheduleItems);
            log.info("\u67e5\u8be2\u6392\u73ed\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)getScheduleResVO));
            return FrontResponse.success((String)param.getTransactionId(), (Object)getScheduleResVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u6392\u73ed\u4fe1\u606f\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u6392\u73ed\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public FrontResponse<GetDeptScheduleResVO> getDeptSchedule(FrontRequest<GetDeptScheduleReqVO> param) {
        log.info("\u67e5\u8be2\u79d1\u5ba4\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetDeptScheduleReqVO body = (GetDeptScheduleReqVO)param.getBody();
            GetDeptListReqDTO getDeptListReqDTO = new GetDeptListReqDTO();
            getDeptListReqDTO.setTradeCode(MethodCodeEnum.QUERY_DEPARTMENT.getDisplay());
            getDeptListReqDTO.setExtUserID("HLWYY");
            getDeptListReqDTO.setHospitalId("1");
            HashMap<String, GetDeptListReqDTO> map = new HashMap<String, GetDeptListReqDTO>();
            map.put(EntityKeyEnum.DEPT_INFO.getValue(), getDeptListReqDTO);
            String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.DEPT_SCHEDU.getValue(), map);
            log.info("\u67e5\u8be2\u79d1\u5ba4\u4fe1\u606fhis\u5165\u53c2" + requestHisXml);
            String hisRes = HttpKit.get((String)("http://192.168.201.18/csp/hsb/DHC.Published.PUB0009.BS.PUB0009.CLS?WSDL=1?method=" + MethodCodeEnum.QUERY_DEPARTMENT.getDisplay() + "&xml=" + requestHisXml));
            log.info("\u67e5\u8be2\u79d1\u5ba4\u4fe1\u606fhis\u51fa\u53c2" + hisRes);
            GetDeptListResDTO response = (GetDeptListResDTO)XmlUtil.convertToJavaBean((String)hisRes, GetDeptListResDTO.class);
            log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getResultContent());
            }
            if (!"0".equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getResultContent());
            }
            List getDeptItemsResDTOList = response.getDepartments().getGetDeptItemsResList();
            GetDeptScheduleResVO getDeptScheduleResVO = new GetDeptScheduleResVO();
            ArrayList getDeptScheduleResItems = new ArrayList();
            getDeptItemsResDTOList.stream().forEach(date -> {
                GetDeptScheduleResItems getDeptScheduleRes = new GetDeptScheduleResItems();
                getDeptScheduleRes.setDeptCode(date.getDepartmentCode());
                getDeptScheduleRes.setDeptName(date.getDepartmentName());
                getDeptScheduleRes.setDeptAddress(date.getDepartmentAddress());
                getDeptScheduleResItems.add(getDeptScheduleRes);
            });
            getDeptScheduleResVO.setItems(getDeptScheduleResItems);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getDeptScheduleResVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u79d1\u5ba4\u4fe1\u606f\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u79d1\u5ba4\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public FrontResponse<TimeArrangeRes> getTimeInfo(FrontRequest<TimeArrangeReq> param) {
        log.info("\u5206\u65f6\u53f7\u6e90\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            TimeArrangeReq body = (TimeArrangeReq)param.getBody();
            GetTimeRangeReqDTO getTimeRangeReqDTO = new GetTimeRangeReqDTO();
            getTimeRangeReqDTO.setTradeCode(MethodCodeEnum.TIMT_SCHEDULE_SOURCE.getDisplay());
            getTimeRangeReqDTO.setExtUserID("HLWYY");
            getTimeRangeReqDTO.setDepartmentCode(body.getDepartmentCode());
            getTimeRangeReqDTO.setServiceDate(body.getServiceDate());
            getTimeRangeReqDTO.setDoctorCode(body.getDoctorCode());
            getTimeRangeReqDTO.setHospitalId(body.getHospitalId());
            getTimeRangeReqDTO.setScheduleItemCode(body.getScheduleItemCode());
            HashMap<String, GetTimeRangeReqDTO> map = new HashMap<String, GetTimeRangeReqDTO>();
            map.put(EntityKeyEnum.TIMT_SCHEDULE_SOURCE.getValue(), getTimeRangeReqDTO);
            String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.TIMT_SCHEDULE_SOURCE.getValue(), map);
            log.info("xml" + requestHisXml);
            String hisRes = HttpKit.get((String)("http://222.90.69.219:9000/test/realhis?method=" + MethodCodeEnum.TIMT_SCHEDULE_SOURCE.getDisplay() + "&xml=" + requestHisXml));
            log.info("..." + hisRes);
            GetTimeRangeResDTO response = (GetTimeRangeResDTO)XmlUtil.convertToJavaBean((String)hisRes, GetTimeRangeResDTO.class);
            log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
            }
            log.info("his\u5206\u65f6\u53f7\u6e90\u4fe1\u606f\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)response));
            if (null == response) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getResultContent());
            }
            if (!"0".equals(response.getResultCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)response.getResultContent());
            }
            List timeRangesItem = response.getTimeRangesItem().getTimeRangesItem();
            TimeArrangeRes TimeArrangeRes2 = new TimeArrangeRes();
            ArrayList items = new ArrayList();
            timeRangesItem.stream().forEach(date -> {
                TimeArrangeItems timeArrangeItems = new TimeArrangeItems();
                timeArrangeItems.setEndTime(date.getEndTime().substring(0, 5));
                timeArrangeItems.setStartTime(date.getStartTime().substring(0, 5));
                timeArrangeItems.setAvailableLeftNum(date.getAvailableLeftNum());
                timeArrangeItems.setScheduleItemCode(date.getScheduleItemCode());
                timeArrangeItems.setAvailableTotalNum(date.getAvailableTotalNum());
                timeArrangeItems.setTimeRangeSeqNo(date.getAvailableNumStr());
                timeArrangeItems.setWeekDay(date.getWeekDay());
                items.add(timeArrangeItems);
            });
            TimeArrangeRes2.setItems(items);
            return FrontResponse.success((String)param.getTransactionId(), (Object)TimeArrangeRes2);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u5206\u65f6\u53f7\u6e90\u4fe1\u606f\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u5206\u65f6\u53f7\u6e90\u4fe1\u606f\u5f02\u5e38");
        }
    }
}

