/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.common.enums.MethodNameEnum;
import com.ebaiyihui.his.config.data.DBContextHolder;
import com.ebaiyihui.his.pojo.entity.TbbussinessEntity;
import com.ebaiyihui.his.service.TbbussinessService;
import com.ebaiyihui.his.service.WaitingService;
import com.ebaiyihui.his.utils.CxfClientUtil;
import com.ebaiyihui.his.utils.XmlTemplateKit;
import com.ebaiyihui.his.utils.XmlUtil;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import his.pojo.vo.wait.departmentalWaitingQueueReq;
import his.pojo.vo.wait.doctors.DoctorsChargeList;
import his.pojo.vo.wait.doctors.SupervisorPatientListDTO;
import his.pojo.vo.wait.doctors.doctorsInChargeResVo;
import his.pojo.vo.wait.doctorsInChargeReqVo;
import his.pojo.vo.wait.items.PatientWaitingQueueListResVO;
import his.pojo.vo.wait.items.PatientWaitingQueueResVO;
import his.pojo.vo.wait.items.departmentalWaitingQueueListResVO;
import his.pojo.vo.wait.items.departmentalWaitingQueueResVO;
import his.pojo.vo.wait.items.doctorsInChargeReq;
import his.pojo.vo.wait.supervisorPatientListReq;
import his.pojo.vo.wait.supervisorPatientListReqVo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WaitingServiceImpl
implements WaitingService {
    private static final Logger log = LoggerFactory.getLogger(WaitingServiceImpl.class);
    @Autowired
    private CxfClientUtil cxfClientUtil;
    @Autowired
    TbbussinessService tbbussinessService;

    public FrontResponse<doctorsInChargeResVo> doctorsInCharge(FrontRequest<doctorsInChargeReqVo> param) {
        doctorsInChargeReq hosDepositRecordReqDTO = new doctorsInChargeReq();
        hosDepositRecordReqDTO.setTradeCode(MethodCodeEnum.GET_LIST_DOCTORS_CHARGE.getDisplay());
        hosDepositRecordReqDTO.setUserCode("HLWYY");
        hosDepositRecordReqDTO.setDeptCode(((doctorsInChargeReqVo)param.getBody()).getDeptCode());
        HashMap<String, doctorsInChargeReq> map = new HashMap<String, doctorsInChargeReq>();
        map.put(EntityKeyEnum.GET_LIST_DOCTORS_CHARGE.getValue(), hosDepositRecordReqDTO);
        String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.GET_LIST_DOCTORS_CHARGE.getValue(), map);
        log.info("\u67e5\u8be2his\u4e3b\u7ba1\u533b\u751f\u5217\u8868\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)requestHisXml));
        String hisRes = this.cxfClientUtil.send("http://192.168.201.18/csp/hsb/DHC.Published.PUB0009.BS.PUB0009.CLS?WSDL=1", MethodCodeEnum.GET_LIST_DOCTORS_CHARGE.getDisplay(), requestHisXml);
        log.info("\u67e5\u8be2his\u4e3b\u7ba1\u533b\u751f\u5217\u8868\u51fa\u53c2->{}", (Object)JSON.toJSONString((Object)hisRes));
        if (StrUtil.isBlank((CharSequence)hisRes)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"his\u8fd4\u56de\u4e3a\u7a7a");
        }
        DoctorsChargeList doctorsChargeList = (DoctorsChargeList)XmlUtil.convertToJavaBean((String)hisRes, DoctorsChargeList.class);
        if (BeanUtil.isEmpty((Object)doctorsChargeList, (String[])new String[0])) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"his\u8fd4\u56de\u4e3a\u7a7a");
        }
        if (!"0".equals(doctorsChargeList.getResultCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)doctorsChargeList.getResultContent());
        }
        if (CollUtil.isEmpty((Collection)doctorsChargeList.getDoctors())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u5f53\u524d\u79d1\u5ba4\u4e0b\u6682\u65e0\u533b\u751f");
        }
        doctorsInChargeResVo doctorsInChargeResVo2 = new doctorsInChargeResVo();
        doctorsInChargeResVo2.setCount(doctorsChargeList.getRecordCount());
        doctorsInChargeResVo2.setDoctors(doctorsChargeList.getDoctors());
        return FrontResponse.success((String)param.getTransactionId(), (Object)doctorsInChargeResVo2);
    }

    public FrontResponse supervisorPatientList(FrontRequest<supervisorPatientListReqVo> param) {
        supervisorPatientListReq hosDepositRecordReqDTO = new supervisorPatientListReq();
        hosDepositRecordReqDTO.setTradeCode(MethodCodeEnum.SUPER_VISOR_PATIENT_LIST.getDisplay());
        hosDepositRecordReqDTO.setUserCode("HLWYY");
        hosDepositRecordReqDTO.setType(((supervisorPatientListReqVo)param.getBody()).getType());
        hosDepositRecordReqDTO.setBillData(((supervisorPatientListReqVo)param.getBody()).getBillData());
        hosDepositRecordReqDTO.setDoctorCode(((supervisorPatientListReqVo)param.getBody()).getDoctorCode());
        HashMap<String, supervisorPatientListReq> map = new HashMap<String, supervisorPatientListReq>();
        map.put(EntityKeyEnum.SUPER_VISOR_PATIENT_LIST.getValue(), hosDepositRecordReqDTO);
        String requestHisXml = XmlTemplateKit.process((String)MethodNameEnum.SUPER_VISOR_PATIENT_LIST.getValue(), map);
        log.info("\u67e5\u8be2his\u4e3b\u7ba1\u60a3\u8005\u5217\u8868\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)requestHisXml));
        String hisRes = this.cxfClientUtil.send("http://192.168.201.18/csp/hsb/DHC.Published.PUB0009.BS.PUB0009.CLS?WSDL=1", MethodCodeEnum.SUPER_VISOR_PATIENT_LIST.getDisplay(), requestHisXml);
        log.info("\u67e5\u8be2his\u4e3b\u7ba1\u60a3\u8005\u5217\u8868\u51fa\u53c2->{}", (Object)JSON.toJSONString((Object)hisRes));
        if (StrUtil.isBlank((CharSequence)hisRes)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"his\u8fd4\u56de\u4e3a\u7a7a");
        }
        SupervisorPatientListDTO doctorsChargeList = (SupervisorPatientListDTO)XmlUtil.convertToJavaBean((String)hisRes, SupervisorPatientListDTO.class);
        if (BeanUtil.isEmpty((Object)doctorsChargeList, (String[])new String[0])) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"his\u8fd4\u56de\u4e3a\u7a7a");
        }
        if (!"0".equals(doctorsChargeList.getResultCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)doctorsChargeList.getResultMsg());
        }
        if (CollUtil.isEmpty((Collection)doctorsChargeList.getItem())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u5f53\u524d\u4e3b\u7ba1\u533b\u751f\u540d\u4e0b\u6682\u65e0\u60a3\u8005\u5217\u8868");
        }
        return null;
    }

    public FrontResponse<PatientWaitingQueueResVO> patientWaitingQueue(String cardNo) {
        try {
            DBContextHolder.setDataSource((String)"3");
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"BrandNo", (Object)cardNo);
            queryWrapper.in((Object)"Status", new Object[]{"0", "1", "2", "3"});
            queryWrapper.like((Object)"EndTime", (Object)DateUtil.today());
            log.info("\u67e5\u8be2\u60a3\u8005\u6392\u961f\u5e8f\u53f7\u5165\u53c2->{}", (Object)cardNo);
            List list = this.tbbussinessService.list((Wrapper)queryWrapper);
            log.info("\u67e5\u8be2\u60a3\u8005\u6392\u961f\u5e8f\u53f7\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)list));
            if (CollectionUtil.isEmpty((Collection)list)) {
                return FrontResponse.error((String)"", (String)"0", (String)"his\u6ca1\u6709\u8fd4\u56de\u4fe1\u606f");
            }
            PatientWaitingQueueResVO patientWaitingQueueResVO = new PatientWaitingQueueResVO();
            List patientWaitingQueueListResVOS = BeanUtil.copyToList((Collection)list, PatientWaitingQueueListResVO.class);
            for (PatientWaitingQueueListResVO patientWaitingQueueListResVO : patientWaitingQueueListResVOS) {
                QueryWrapper queryWrapper1 = new QueryWrapper();
                queryWrapper1.eq((Object)"ServiceName", (Object)patientWaitingQueueListResVO.getServiceName());
                queryWrapper1.eq((Object)"DeskName", (Object)patientWaitingQueueListResVO.getDeskName());
                queryWrapper1.eq((Object)"Status", (Object)"1");
                queryWrapper1.like((Object)"EndTime", (Object)DateUtil.today());
                TbbussinessEntity one = (TbbussinessEntity)this.tbbussinessService.getOne((Wrapper)queryWrapper1);
                if (BeanUtil.isEmpty((Object)one, (String[])new String[0])) continue;
                patientWaitingQueueListResVO.setCurrentCallNumber(one.getPatientNo());
            }
            patientWaitingQueueResVO.setList(patientWaitingQueueListResVOS);
            return FrontResponse.success((String)"", (Object)patientWaitingQueueResVO);
        }
        catch (Exception e) {
            log.error("\u60a3\u8005\u5019\u8bca\u961f\u5217\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38 \u5f02\u5e38\u4fe1\u606f\u4e3a->{}", (Object)e.getMessage());
            e.printStackTrace();
            return FrontResponse.error((String)"", (String)"0", (String)e.getMessage());
        }
    }

    public FrontResponse<departmentalWaitingQueueResVO> departmentalWaitingQueue(FrontRequest<departmentalWaitingQueueReq> param) {
        try {
            DBContextHolder.setDataSource((String)"3");
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"Status", new Object[]{"0", "1"});
            queryWrapper.like((Object)"EndTime", (Object)DateUtil.today());
            List list = this.tbbussinessService.list((Wrapper)queryWrapper);
            log.info("\u67e5\u8be2\u79d1\u5ba4\u5019\u8bca\u961f\u5217\u51fa\u53c2->{}", (Object)JSON.toJSONString((Object)list));
            departmentalWaitingQueueResVO departmentalWaitingQueueResVO2 = new departmentalWaitingQueueResVO();
            List departmentalWaitingQueueListResVOS = BeanUtil.copyToList((Collection)list, departmentalWaitingQueueListResVO.class);
            departmentalWaitingQueueResVO2.setList(departmentalWaitingQueueListResVOS);
            return FrontResponse.success((String)"", (Object)departmentalWaitingQueueResVO2);
        }
        catch (Exception e) {
            log.error("\u79d1\u5ba4\u5019\u8bca\u961f\u5217\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38 \u5f02\u5e38\u4fe1\u606f\u4e3a->{}", (Object)e.getMessage());
            e.printStackTrace();
            return FrontResponse.error((String)"", (String)"0", (String)e.getMessage());
        }
    }
}

