/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.utils;

import java.nio.charset.Charset;
import java.security.Key;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EncryptionUtil {
    private static final Logger log = LoggerFactory.getLogger(EncryptionUtil.class);
    private static final String CIPHER_MODEL = "/CBC/NoPadding";

    public static String encrypt(String key, String content) throws Exception {
        try {
            log.info("\u52a0\u5bc6\u539f\u6587" + content);
            String CIPHER_MODEL = CIPHER_MODEL;
            String keyAlgorithm = "AES";
            byte[] contentBytes = content.getBytes(Charset.forName("utf-8"));
            byte[] keys = Base64.getDecoder().decode(key);
            Cipher cipher = Cipher.getInstance(keyAlgorithm + CIPHER_MODEL);
            int blockSize = cipher.getBlockSize();
            int plaintextLength = contentBytes.length;
            if (plaintextLength % blockSize != 0) {
                plaintextLength += blockSize - plaintextLength % blockSize;
            }
            byte[] plaintext = new byte[plaintextLength];
            System.arraycopy(contentBytes, 0, plaintext, 0, contentBytes.length);
            SecretKeySpec keyspec = new SecretKeySpec(keys, keyAlgorithm);
            IvParameterSpec ivspec = new IvParameterSpec(keys);
            cipher.init(1, (Key)keyspec, ivspec);
            byte[] encryped = cipher.doFinal(plaintext);
            String encryptContent = Base64.getEncoder().encodeToString(encryped);
            return encryptContent;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static byte[] encrypt(byte[] content, byte[] key, String keyAlgorithm) throws Exception {
        int plaintextLength = content.length;
        Cipher cipher = Cipher.getInstance(keyAlgorithm + CIPHER_MODEL);
        int blockSize = cipher.getBlockSize();
        if (plaintextLength % blockSize != 0) {
            plaintextLength += blockSize - plaintextLength % blockSize;
        }
        byte[] plaintext = new byte[plaintextLength];
        System.arraycopy(content, 0, plaintext, 0, content.length);
        SecretKeySpec keyspec = new SecretKeySpec(key, keyAlgorithm);
        IvParameterSpec ivspec = new IvParameterSpec(key);
        cipher.init(1, (Key)keyspec, ivspec);
        byte[] encrypted = cipher.doFinal(plaintext);
        return encrypted;
    }

    public static String decrypt(String key, String content) throws Exception {
        try {
            String CIPHER_MODEL = CIPHER_MODEL;
            String keyAlgorithm = "AES";
            byte[] keys = Base64.getDecoder().decode(key);
            byte[] contentBytes = Base64.getDecoder().decode(content);
            Cipher cipher = Cipher.getInstance(keyAlgorithm + CIPHER_MODEL);
            SecretKeySpec keyspec = new SecretKeySpec(keys, keyAlgorithm);
            IvParameterSpec ivspec = new IvParameterSpec(keys);
            cipher.init(2, (Key)keyspec, ivspec);
            byte[] result = cipher.doFinal(contentBytes);
            String decodeContent = new String(result, Charset.forName("utf-8")).trim();
            return decodeContent;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static byte[] decrypt(byte[] content, byte[] key, String keyAlgorithm) throws Exception {
        Cipher cipher = Cipher.getInstance(keyAlgorithm + CIPHER_MODEL);
        SecretKeySpec keyspec = new SecretKeySpec(key, keyAlgorithm);
        IvParameterSpec ivspec = new IvParameterSpec(key);
        cipher.init(2, (Key)keyspec, ivspec);
        byte[] original = cipher.doFinal(content);
        return original;
    }
}

