/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.utils;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UdpGetClientMacAddr {
    private static Log log = LogFactory.getLog(UdpGetClientMacAddr.class);
    private String remoteAddr;
    private int remotePort = 137;
    private byte[] buffer = new byte[1024];
    private DatagramSocket ds = null;

    public UdpGetClientMacAddr(String strAddr) throws Exception {
        this.remoteAddr = strAddr;
        this.ds = new DatagramSocket();
    }

    protected final DatagramPacket send(byte[] bytes) throws IOException {
        DatagramPacket dp = new DatagramPacket(bytes, bytes.length, InetAddress.getByName(this.remoteAddr), this.remotePort);
        this.ds.send(dp);
        return dp;
    }

    protected final DatagramPacket receive() {
        DatagramPacket dp = new DatagramPacket(this.buffer, this.buffer.length);
        try {
            this.ds.setSoTimeout(3000);
            this.ds.receive(dp);
        }
        catch (SocketTimeoutException ex) {
            log.info((Object)"\u63a5\u6536\u6570\u636e\u8d85\u65f6...,\u4e0d\u80fd\u83b7\u53d6\u5ba2\u6237\u7aefMAC\u5730\u5740");
        }
        catch (SocketException e1) {
            log.error((Object)("\u53d1\u751fSorcket\u5f02\u5e38..." + e1.getMessage()));
            e1.printStackTrace();
        }
        catch (IOException e2) {
            log.error((Object)("\u53d1\u751fIO\u5f02\u5e38..." + e2.getMessage()));
        }
        return dp;
    }

    protected byte[] getQueryCmd() throws Exception {
        byte[] t_ns = new byte[50];
        t_ns[0] = 0;
        t_ns[1] = 0;
        t_ns[2] = 0;
        t_ns[3] = 16;
        t_ns[4] = 0;
        t_ns[5] = 1;
        t_ns[6] = 0;
        t_ns[7] = 0;
        t_ns[8] = 0;
        t_ns[9] = 0;
        t_ns[10] = 0;
        t_ns[11] = 0;
        t_ns[12] = 32;
        t_ns[13] = 67;
        t_ns[14] = 75;
        for (int i = 15; i < 45; ++i) {
            t_ns[i] = 65;
        }
        t_ns[45] = 0;
        t_ns[46] = 0;
        t_ns[47] = 33;
        t_ns[48] = 0;
        t_ns[49] = 1;
        return t_ns;
    }

    protected final String getMacAddr(byte[] brevdata) throws Exception {
        int i = brevdata[56] * 18 + 56;
        String sAddr = "";
        StringBuffer sb = new StringBuffer(17);
        for (int j = 1; j < 7; ++j) {
            sAddr = Integer.toHexString(0xFF & brevdata[i + j]);
            if (sAddr.length() < 2) {
                sb.append(0);
            }
            sb.append(sAddr.toUpperCase());
            if (j >= 6) continue;
            sb.append('-');
        }
        return sb.toString();
    }

    public final void close() {
        try {
            this.ds.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public final String getRemoteMacAddr() throws Exception {
        byte[] bqcmd = this.getQueryCmd();
        this.send(bqcmd);
        DatagramPacket dp = this.receive();
        String smac = "";
        smac = this.getMacAddr(dp.getData());
        this.close();
        return smac;
    }

    public static void main(String[] args) throws Exception {
        UdpGetClientMacAddr add = new UdpGetClientMacAddr("222.90.69.219");
        System.out.println(add.getRemoteMacAddr());
    }
}

