/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.rabbitmq;

import java.util.HashMap;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.CustomExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RabbitMqConfig {
    public static final String EXCHANGE_NAME = "logistics.delayed_exchange_pre_new";
    public static final String ORDER_SYNC_DAY_HEARTBEAT_QUEUE_NAME = "order.sync.day.heartbeat.queue";
    public static final String ORDER_SYNC_EVERY_DAY_QUEUE_NAME = "order.sync.every.day.queue";
    public static final String ORDER_SYNC_DAY_HEARTBEAT_ROUTING_KEY = "order.sync.day.heartbeat.routing.key";
    public static final String ORDER_SYNC_EVERY_DAY_ROUTING_KEY = "order.sync.every.day.routing.key";

    @Bean
    public Queue orderSyncDayHeartbeat() {
        return new Queue(ORDER_SYNC_DAY_HEARTBEAT_QUEUE_NAME);
    }

    @Bean
    public Queue orderSyncEveryDay() {
        return new Queue(ORDER_SYNC_EVERY_DAY_QUEUE_NAME);
    }

    @Bean
    CustomExchange customExchange() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("x-delayed-type", "direct");
        return new CustomExchange(EXCHANGE_NAME, "x-delayed-message", true, false, args);
    }

    @Bean
    Binding syncOrderHeartbeat() {
        return BindingBuilder.bind((Queue)this.orderSyncDayHeartbeat()).to((Exchange)this.customExchange()).with(ORDER_SYNC_DAY_HEARTBEAT_ROUTING_KEY).noargs();
    }

    @Bean
    Binding syncEveryDaybeat() {
        return BindingBuilder.bind((Queue)this.orderSyncEveryDay()).to((Exchange)this.customExchange()).with(ORDER_SYNC_EVERY_DAY_ROUTING_KEY).noargs();
    }

    @Bean
    public TopicExchange shangRaoPushExchange() {
        return new TopicExchange("-node-push-topic-exchange");
    }
}

