/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.DateUtils;
import com.ebaiyihui.his.config.YkHyConfig;
import com.ebaiyihui.his.mapper.DrugSaleMapper;
import com.ebaiyihui.his.mapper.DrugShopMapper;
import com.ebaiyihui.his.mapper.DrugStqtyMapper;
import com.ebaiyihui.his.model.DrugSalePaytype;
import com.ebaiyihui.his.model.DrugShop;
import com.ebaiyihui.his.pojo.base.HyTransmission;
import com.ebaiyihui.his.pojo.dto.OrderDto;
import com.ebaiyihui.his.pojo.dto.Orders;
import com.ebaiyihui.his.pojo.vo.OrderVO;
import com.ebaiyihui.his.pojo.vo.SyncOrderDetailInfoRequestVO;
import com.ebaiyihui.his.pojo.vo.SyncOrderInfoRequestVO;
import com.ebaiyihui.his.pojo.vo.SyncOrderPatientInfoRequestVO;
import com.ebaiyihui.his.pojo.vo.SyncOrderPayTypeRequestVO;
import com.ebaiyihui.his.pojo.vo.SyncOrderPrescriptionRequestVO;
import com.ebaiyihui.his.pojo.vo.SyncOrderRequestVO;
import com.ebaiyihui.his.pojo.vo.SyncOrderStoreRequestVO;
import com.ebaiyihui.his.service.EmailService;
import com.ebaiyihui.his.service.YkTransferService;
import com.ebaiyihui.his.utils.DateUtil;
import com.ebaiyihui.his.utils.HttpUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class YkTransferServiceImpl
implements YkTransferService {
    private static final Logger log = LoggerFactory.getLogger(YkTransferServiceImpl.class);
    @Autowired
    private YkHyConfig ykHyConfig;
    @Autowired
    private EmailService emailService;
    @Autowired
    private DrugSaleMapper drugSaleMapper;
    @Autowired
    private DrugStqtyMapper drugStqtyMapper;
    @Autowired
    private DrugShopMapper drugShopMapper;
    public static List<Map<String, String>> failureMap = new ArrayList();
    public static List<Map<String, String>> dayMap = new ArrayList();

    public Map<String, String> heartbeat() {
        log.info("\u6267\u884c\u4e86\u5fc3\u8df3\u4e1a\u52a1=====>");
        String result = null;
        String url = this.ykHyConfig.getAddressUrl(this.ykHyConfig.heartbeat);
        try {
            result = HttpUtils.post((String)url, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (StringUtils.isEmpty((CharSequence)result)) {
            return null;
        }
        log.info("\u6267\u884c\u4e86\u5fc3\u8df3\u4e1a\u52a1=====>{}", (Object)JSON.toJSONString((Object)result));
        JSONObject jsonObject = JSON.parseObject((String)result);
        BaseResponse map = (BaseResponse)JSON.toJavaObject((JSON)jsonObject, BaseResponse.class);
        return (Map)map.getData();
    }

    /*
     * Unable to fully structure code
     */
    @Async(value="myThreadPoolTaskExecutor")
    public void historicalOrderService() {
        block2: while (true) {
            YkTransferServiceImpl.log.info("\u5386\u53f2\u8ba2\u5355\u670d\u52a1-\u83b7\u53d6\u6267\u884c\u65e5\u671f");
            dateStr = this.getExecutionDate();
            if (dateStr == null || "-1".equals(dateStr.get("planStart"))) {
                YkTransferServiceImpl.log.info("-1 \u7a0b\u5e8f\u505c\u6b62{}", (Object)dateStr);
                if (CollectionUtils.isEmpty((Collection)YkTransferServiceImpl.failureMap)) break;
                YkTransferServiceImpl.log.info("\u6709\u53d1\u9001\u5931\u8d25\u6570\u636e\uff0c\u53d1\u9001\u90ae\u4ef6\u63d0\u9192\uff01");
                this.emailService.sendMail("\u5357\u534e\u63a8\u9001\u6570\u636e\u63a5\u53d7\u5931\u8d25\uff0c\u8bf7\u53ca\u65f6\u5904\u7406", "\u6570\u636e\u8be6\u60c5\uff1a" + JSONObject.toJSONString((Object)YkTransferServiceImpl.failureMap));
                YkTransferServiceImpl.failureMap.clear();
                break;
            }
            startDate = (String)dateStr.get("planStart");
            endDate = DateUtil.getTimeAfterSecond((String)((String)dateStr.get("planEnd")), (int)1);
            orderVO = new OrderVO();
            orderVO.setStart(startDate);
            orderVO.setEnd(endDate);
            count = this.drugSaleMapper.selectSaleCountByDate(orderVO);
            if (count <= 0L) {
                YkTransferServiceImpl.log.info(dateStr + "\uff0c\u8be5\u65e5\u671f\u6ca1\u6709\u8ba2\u5355\uff0c\u76f4\u63a5\u8df3\u8fc7");
                continue;
            }
            intervalTimeList = DateUtil.getIntervalDateTimeList((String)startDate, (String)endDate, (int)10);
            i = 1;
            while (true) {
                if (i < intervalTimeList.size()) ** break;
                continue block2;
                orderVO.setStart((String)intervalTimeList.get(i - 1));
                orderVO.setEnd((String)intervalTimeList.get(i));
                orderVO.setType(Integer.valueOf(2));
                YkTransferServiceImpl.log.info("\u6267\u884c\u52a8\u6001\u8ba2\u5355\u63a8\u9001\u4efb\u52a1\u5386\u53f2\u8ba2\u5355\u6267\u884c\u65f6\u95f4\u6bb5:{}-{} ", (Object)orderVO.getStart(), (Object)orderVO.getEnd());
                this.getOrders(orderVO);
                YkTransferServiceImpl.log.info("\u6267\u884c\u5b8c\u6210\u5f00\u59cb\u7761\u7720");
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    YkTransferServiceImpl.log.error(e.toString());
                }
                ++i;
            }
            break;
        }
    }

    public void currentDrugPriceAndInventoryService() {
        String result = "";
        log.info("\u6267\u884c\u4e86\u540c\u6b65\u836f\u54c1\u4ef7\u683c\u548c\u5e93\u5b58\u63a5\u53e3=====");
        long startTime = System.currentTimeMillis();
        List allShop = this.drugShopMapper.queryAll();
        for (DrugShop shop : allShop) {
            List drugStqtyDtoList = this.drugStqtyMapper.queryDrugStqtyDtoByStoreCode(shop.getShopId());
            if (CollectionUtils.isEmpty((Collection)drugStqtyDtoList)) {
                log.info("{}\u6ca1\u6709\u6570\u636e", (Object)shop.getShopName());
                continue;
            }
            log.info("\u53d1\u9001\u6570\u636e");
            HyTransmission hyTransmission = HyTransmission.success((String)"\u6267\u884c\u5b8c\u6210", (Long)(System.currentTimeMillis() - startTime), (String)"1", (Object)drugStqtyDtoList, (String)this.ykHyConfig.getAction(), (String)this.ykHyConfig.getVersion());
            String url = this.ykHyConfig.getAddressUrl(this.ykHyConfig.getDrugStqtyPush());
            int num = 1;
            boolean retry = false;
            String message = null;
            while (true) {
                try {
                    result = HttpUtils.post((String)url, null, (String)JSON.toJSONString((Object)hyTransmission));
                    JSONObject jsonObject = JSON.parseObject((String)result);
                    BaseResponse response = (BaseResponse)JSON.toJavaObject((JSON)jsonObject, BaseResponse.class);
                    if (!"1".equals(response.getCode())) {
                        message = JSONObject.toJSONString((Object)response);
                        log.info("\u6570\u636e\u53d1\u9001\u5931\u8d25\uff0c\u7b49\u5f85\u91cd\u8bd5\uff01");
                        retry = true;
                    }
                }
                catch (Exception e) {
                    log.info("\u6570\u636e\u8bf7\u6c42\u670d\u52a1\u5668\u5931\u8d25\uff0c\u7b49\u5f85\u91cd\u8bd5\uff01\u9519\u8bef\u63d0\u793a:{}", (Object)e.getMessage());
                    message = JSONObject.toJSONString((Object)e);
                    retry = true;
                }
                if (retry && num > 3) {
                    log.info("\u91cd\u8bd5\u6b21\u6570\u4e0a\u9650\uff0c\u8bb0\u5f55\u5f02\u5e38\u6570\u636e");
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("day", DateUtils.formatDateDefault((Date)new Date()));
                    map.put("shop", shop.getShopName());
                    map.put("message", message);
                    log.info("\u6709\u53d1\u9001\u5931\u8d25\u6570\u636e\uff0c\u53d1\u9001\u90ae\u4ef6\u63d0\u9192\uff01");
                    this.emailService.sendMail("\u5357\u534e\u63a8\u9001\u6570\u636e\u63a5\u53d7\u5931\u8d25\uff0c\u8bf7\u53ca\u65f6\u5904\u7406", "\u6570\u636e\u8be6\u60c5\uff1a" + JSONObject.toJSONString(map));
                }
                if (!retry || num > 3) break;
                log.info("\u91cd\u65b0\u53d1\u9001\u6570\u636e-\u91cd\u8bd5\u6b21\u6570{}\uff01", (Object)num);
                try {
                    Thread.sleep(60000L * (long)num);
                }
                catch (Exception e) {
                    log.error(e.toString());
                }
                ++num;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                log.error(e.toString());
            }
            log.info("\u53d1\u9001\u6570\u636e\u7ed3\u675f=====>{}", (Object)JSON.toJSONString((Object)result));
        }
    }

    public Map<String, String> getExecutionDate() {
        String result = "";
        String url = this.ykHyConfig.getAddressUrl(this.ykHyConfig.getDateUrl);
        try {
            result = HttpUtils.post((String)url, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (StringUtils.isEmpty((CharSequence)result)) {
            return null;
        }
        log.info("\u6267\u884c\u65e5\u671f\u83b7\u53d6\u5230\u7ed3\u679c=====>{}", (Object)JSON.toJSONString((Object)result));
        JSONObject jsonObject = JSON.parseObject((String)result);
        BaseResponse map = (BaseResponse)JSON.toJavaObject((JSON)jsonObject, BaseResponse.class);
        return (Map)map.getData();
    }

    public void getOrders(OrderVO orderVO) {
        String result = "";
        log.info("\u6267\u884c\u4e86\u540c\u6b65\u8ba2\u5355\u63a5\u53e3=====");
        long startTime = System.currentTimeMillis();
        SyncOrderRequestVO orderList = this.getOrderList(orderVO);
        if (ObjectUtils.isEmpty((Object)orderList) || CollectionUtils.isEmpty((Collection)orderList.getOrderInfos())) {
            log.info("\u6ca1\u6709\u8ba2\u5355\u8df3\u8fc7");
            return;
        }
        log.info("\u53d1\u9001\u6570\u636e");
        HyTransmission hyTransmission = HyTransmission.success((String)"\u6267\u884c\u5b8c\u6210", (Long)(System.currentTimeMillis() - startTime), (String)"1", (Object)orderList, (String)this.ykHyConfig.getAction(), (String)this.ykHyConfig.getVersion());
        String url = this.ykHyConfig.getAddressUrl(this.ykHyConfig.getOrderPush());
        int num = 1;
        boolean retry = false;
        String message = null;
        while (true) {
            try {
                result = HttpUtils.post((String)url, null, (String)JSON.toJSONString((Object)hyTransmission));
                JSONObject jsonObject = JSON.parseObject((String)result);
                BaseResponse response = (BaseResponse)JSON.toJavaObject((JSON)jsonObject, BaseResponse.class);
                if (!"1".equals(response.getCode())) {
                    message = JSONObject.toJSONString((Object)response);
                    log.info("\u6570\u636e\u53d1\u9001\u5931\u8d25\uff0c\u7b49\u5f85\u91cd\u8bd5\uff01");
                    retry = true;
                }
            }
            catch (Exception e) {
                log.info("\u6570\u636e\u8bf7\u6c42\u670d\u52a1\u5668\u5931\u8d25\uff0c\u7b49\u5f85\u91cd\u8bd5\uff01\u9519\u8bef\u63d0\u793a:{}", (Object)e.getMessage());
                message = JSONObject.toJSONString((Object)e);
                retry = true;
            }
            if (retry && num > 3) {
                log.info("\u91cd\u8bd5\u6b21\u6570\u4e0a\u9650\uff0c\u8bb0\u5f55\u5f02\u5e38\u6570\u636e");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("start", orderVO.getStart());
                map.put("end", orderVO.getEnd());
                map.put("message", message);
                if (Integer.valueOf(1).equals(orderVO.getType())) {
                    dayMap.add(map);
                } else {
                    failureMap.add(map);
                }
            }
            if (!retry || num > 3) break;
            log.info("\u91cd\u65b0\u53d1\u9001\u6570\u636e-\u91cd\u8bd5\u6b21\u6570{}\uff01", (Object)num);
            try {
                Thread.sleep(60000L * (long)num);
            }
            catch (Exception e) {
                log.error(e.toString());
            }
            ++num;
        }
        log.info("\u53d1\u9001\u6570\u636e\u7ed3\u675f=====>{}", (Object)JSON.toJSONString((Object)result));
    }

    private SyncOrderRequestVO getOrderList(OrderVO orderVO) {
        List orders = this.drugSaleMapper.selectDrugSaleList(orderVO);
        log.info("\u8ba2\u5355\u6574\u6761\u6570=====>{}", (Object)orders.size());
        SyncOrderRequestVO syncOrderRequestVO = new SyncOrderRequestVO();
        syncOrderRequestVO.setPresChannelId("4");
        syncOrderRequestVO.setPresChannelName("\u5357\u534e\u82f1\u514b\u8ba2\u5355");
        ArrayList<SyncOrderInfoRequestVO> syncOrderInfoRequest = new ArrayList<SyncOrderInfoRequestVO>();
        for (OrderDto order : orders) {
            SyncOrderInfoRequestVO syncOrderInfo = new SyncOrderInfoRequestVO();
            if (!ObjectUtils.isEmpty((Object)order.getAccount())) {
                SyncOrderPatientInfoRequestVO patientInfo = new SyncOrderPatientInfoRequestVO();
                patientInfo.setPatientName(order.getAccount().getName());
                patientInfo.setPatientPhone(order.getAccount().getPhone());
                patientInfo.setPatientMemberNo(order.getAccount().getCardId());
                patientInfo.setPatientSex(order.getAccount().getSex() == null ? null : Integer.valueOf(order.getAccount().getSex().equals("\u7537") ? 1 : 2));
                patientInfo.setPatientIdCard(order.getAccount().getSfz());
                patientInfo.setPatientBirthday(StringUtils.isEmpty((CharSequence)order.getAccount().getBirthday()) ? null : DateUtil.parseY_M_DDate((String)String.valueOf(order.getAccount().getBirthday())));
                patientInfo.setArchivesCreateTime(StringUtils.isEmpty((CharSequence)order.getAccount().getCreatedate()) ? null : DateUtil.dateStrToDate((String)String.valueOf(order.getAccount().getCreatedate())));
                patientInfo.setArchivesModifyTime(order.getAccount().getAccountModifytime());
                patientInfo.setArchivesCreatePerson(order.getAccount().getOperator());
                syncOrderInfo.setPatientInfo(patientInfo);
            }
            if (!ObjectUtils.isEmpty((Object)order.getDrugShop()) && order.getDrugShop().getShopId() != null) {
                SyncOrderStoreRequestVO storeInfo = new SyncOrderStoreRequestVO();
                storeInfo.setStoreName(order.getDrugShop().getShopName());
                storeInfo.setStoreManager(order.getDrugShop().getPeople());
                storeInfo.setStoreContact(order.getDrugShop().getTel());
                storeInfo.setStoreCode(String.valueOf(order.getDrugShop().getShopId()));
                storeInfo.setDetailAddress(order.getDrugShop().getAddress());
                storeInfo.setPharmaceuticalCompanyId("1");
                syncOrderInfo.setStoreInfo(storeInfo);
            }
            if (!ObjectUtils.isEmpty((Object)order.getDrugSalePaytypeList())) {
                ArrayList<SyncOrderPayTypeRequestVO> payTypes = new ArrayList<SyncOrderPayTypeRequestVO>();
                for (DrugSalePaytype drugSalePaytype : order.getDrugSalePaytypeList()) {
                    SyncOrderPayTypeRequestVO syncOrderPayTypeRequestVO = new SyncOrderPayTypeRequestVO();
                    syncOrderPayTypeRequestVO.setPayTime(drugSalePaytype.getSaleTime());
                    syncOrderPayTypeRequestVO.setPayType(drugSalePaytype.getPaytype());
                    syncOrderPayTypeRequestVO.setPayAmount(Double.valueOf(drugSalePaytype.getAmount().doubleValue()));
                    payTypes.add(syncOrderPayTypeRequestVO);
                }
                syncOrderInfo.setPayTypes(payTypes);
            }
            boolean flag = false;
            ArrayList<SyncOrderDetailInfoRequestVO> detailInfos = new ArrayList<SyncOrderDetailInfoRequestVO>();
            for (Orders orderInformation : order.getOrders()) {
                SyncOrderDetailInfoRequestVO syncOrderDetailInfoRequestVO = new SyncOrderDetailInfoRequestVO();
                syncOrderDetailInfoRequestVO.setDrugName(orderInformation.getProductName());
                syncOrderDetailInfoRequestVO.setDrugSpec(orderInformation.getSpec());
                syncOrderDetailInfoRequestVO.setAmount(String.valueOf(orderInformation.getNum()));
                syncOrderDetailInfoRequestVO.setUnitPrice(String.valueOf(orderInformation.getPrice().doubleValue()));
                syncOrderDetailInfoRequestVO.setTotalPrice(String.valueOf(orderInformation.getAmount()));
                syncOrderDetailInfoRequestVO.setCreateTime(orderInformation.getSaleTime());
                if (!ObjectUtils.isEmpty((Object)orderInformation.getDrugStore())) {
                    syncOrderDetailInfoRequestVO.setDrugId(String.valueOf(orderInformation.getDrugStore().getDrugId()));
                    syncOrderDetailInfoRequestVO.setAmountUnit(orderInformation.getDrugStore().getUnit());
                    syncOrderDetailInfoRequestVO.setArcimCode(orderInformation.getDrugStore().getProductNum());
                }
                syncOrderDetailInfoRequestVO.setManufacturer(orderInformation.getFirmName());
                detailInfos.add(syncOrderDetailInfoRequestVO);
                if (flag) continue;
                syncOrderInfo.setCreateTime(orderInformation.getSaleTime());
                syncOrderInfo.setPresChannelOrderId(String.valueOf(orderInformation.getSaleNum()));
                syncOrderInfo.setStoreCode(String.valueOf(orderInformation.getShopId()));
                syncOrderInfo.setOrderMainType(Integer.valueOf(2));
                syncOrderInfo.setOrderSeq(String.valueOf(orderInformation.getSaleNum()));
                syncOrderInfo.setStatus(Integer.valueOf(orderInformation.getNum() < 0.0 ? 2 : 1));
                syncOrderInfo.setTotalDrugAmount(String.valueOf(orderInformation.getAmount()));
                syncOrderInfo.setOrderAmount(String.valueOf(orderInformation.getAmount()));
                syncOrderInfo.setPayAmount(String.valueOf(orderInformation.getAmount()));
                syncOrderInfo.setRefundTime(orderInformation.getNum() < 0.0 ? orderInformation.getSaleTime() : null);
                syncOrderInfo.setSalesmanId(ObjectUtils.isEmpty((Object)orderInformation.getSalesman()) ? null : String.valueOf(orderInformation.getSalesman()));
                syncOrderInfo.setGrossProfit(ObjectUtils.isEmpty((Object)orderInformation.getMaramount()) ? null : String.valueOf(orderInformation.getMaramount()));
                syncOrderInfo.setIdCardNo(orderInformation.getCertno());
                syncOrderInfo.setMemberNo(orderInformation.getPsnNo());
                syncOrderInfo.setMedicalType(orderInformation.getMedType());
                syncOrderInfo.setMemberName(orderInformation.getPsnName());
                syncOrderInfo.setMemberType(orderInformation.getPsnType());
                syncOrderInfo.setCoordinatedPay(ObjectUtils.isEmpty((Object)orderInformation.getHifpPay()) ? null : String.valueOf(orderInformation.getHifpPay()));
                if (StringUtils.isNotBlank((CharSequence)orderInformation.getRecipenno()) || StringUtils.isNotBlank((CharSequence)orderInformation.getRecipehospital()) || StringUtils.isNotBlank((CharSequence)orderInformation.getCfname())) {
                    syncOrderInfo.setOrderMainType(Integer.valueOf(1));
                    SyncOrderPrescriptionRequestVO prescriptionRequestVO = new SyncOrderPrescriptionRequestVO();
                    prescriptionRequestVO.setCreateTime(null);
                    prescriptionRequestVO.setCreatePerson(null);
                    prescriptionRequestVO.setUpdatePerson(null);
                    prescriptionRequestVO.setUpdateTime(null);
                    prescriptionRequestVO.setPresChannelId(String.valueOf(3));
                    prescriptionRequestVO.setPresChannelName("\u5357\u534e\u82f1\u514b\u8ba2\u5355");
                    prescriptionRequestVO.setCreateAccountPerson(null);
                    prescriptionRequestVO.setSalesOrder(String.valueOf(orderInformation.getSaleNum()));
                    prescriptionRequestVO.setPatientId(null);
                    prescriptionRequestVO.setPatientHisId(String.valueOf(orderInformation.getGukeid()));
                    if (!ObjectUtils.isEmpty((Object)order.getAccount())) {
                        prescriptionRequestVO.setPatientPhone(order.getAccount().getPhone());
                        prescriptionRequestVO.setPatientNo(order.getAccount().getCardId());
                        prescriptionRequestVO.setPatientSex(order.getAccount().getSex() == null ? null : Integer.valueOf(order.getAccount().getSex().equals("\u7537") ? 1 : 2));
                        prescriptionRequestVO.setPatientAge(null);
                        prescriptionRequestVO.setPatientIdCard(order.getAccount().getSfz());
                    }
                    prescriptionRequestVO.setPatientName(orderInformation.getCfname());
                    prescriptionRequestVO.setPresHospitalName(orderInformation.getRecipehospital());
                    prescriptionRequestVO.setPresDeptName(null);
                    prescriptionRequestVO.setPresDoctorName(orderInformation.getRecipedoctor());
                    prescriptionRequestVO.setPrescriptionOpenTime(orderInformation.getReciptdate());
                    prescriptionRequestVO.setPrescriptionInputTime(orderInformation.getReciptdate());
                    prescriptionRequestVO.setDiagnosis(orderInformation.getJbzl());
                    prescriptionRequestVO.setAllergicHistory(null);
                    prescriptionRequestVO.setPrescriptionData(null);
                    prescriptionRequestVO.setStatus(null);
                    prescriptionRequestVO.setRemark(null);
                    prescriptionRequestVO.setPresType(null);
                    prescriptionRequestVO.setDrugSpeciesNum(null);
                    prescriptionRequestVO.setPresPrice(null);
                    prescriptionRequestVO.setHtmlUrl(null);
                    prescriptionRequestVO.setOssUrl(null);
                    prescriptionRequestVO.setPrescriptionSource(Integer.valueOf(2));
                    prescriptionRequestVO.setHospitalId(null);
                    prescriptionRequestVO.setDepartmentId(null);
                    prescriptionRequestVO.setDoctorId(null);
                    prescriptionRequestVO.setThreeMainNo(orderInformation.getRecipenno());
                    syncOrderInfo.setPrescriptionRequestVO(prescriptionRequestVO);
                }
                flag = true;
            }
            syncOrderInfo.setDetailInfos(detailInfos);
            if (!ObjectUtils.isEmpty((Object)syncOrderInfo.getPrescriptionRequestVO())) {
                syncOrderInfo.getPrescriptionRequestVO().setDrugSpeciesNum(Integer.valueOf(detailInfos.size()));
            }
            syncOrderInfoRequest.add(syncOrderInfo);
        }
        syncOrderRequestVO.setOrderInfos(syncOrderInfoRequest);
        return syncOrderRequestVO;
    }
}

