/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.config;

import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import com.ebaiyihui.his.config.data.DynamicDataSource;
import java.util.HashMap;
import javax.sql.DataSource;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class DataSourceConfig {
    @Bean
    @ConfigurationProperties(prefix="spring.datasource.druid.first")
    public DataSource dataSourceFirst() {
        return DruidDataSourceBuilder.create().build();
    }

    @Bean
    @ConfigurationProperties(prefix="spring.datasource.druid.second")
    public DataSource dataSourceSecond() {
        return DruidDataSourceBuilder.create().build();
    }

    @Bean
    @ConfigurationProperties(prefix="spring.datasource.druid.third")
    public DataSource dataSourceThird() {
        return DruidDataSourceBuilder.create().build();
    }

    @Primary
    @Bean(value={"dynamicDataSource"})
    public DynamicDataSource dynamicDataSource() {
        HashMap<String, DataSource> targetDataSource = new HashMap<String, DataSource>();
        targetDataSource.put("1", this.dataSourceFirst());
        targetDataSource.put("2", this.dataSourceSecond());
        targetDataSource.put("3", this.dataSourceThird());
        DynamicDataSource dynamicDataSource = new DynamicDataSource();
        dynamicDataSource.setTargetDataSources(targetDataSource);
        dynamicDataSource.setDefaultTargetDataSource((Object)this.dataSourceFirst());
        return dynamicDataSource;
    }
}

