/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.controller;

import com.ebaiyihui.his.pojo.vo.appoint.CancelRegisterRes;
import com.ebaiyihui.his.pojo.vo.appoint.ConfirmRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.ConfirmRegisterRes;
import com.ebaiyihui.his.pojo.vo.appoint.DayRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.DayRegisterRes;
import com.ebaiyihui.his.pojo.vo.appoint.GetAppointRecordReq;
import com.ebaiyihui.his.pojo.vo.appoint.GetAppointRecordRes;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationReq;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationRes;
import com.ebaiyihui.his.pojo.vo.appoint.ReturnRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.ReturnRegisterRes;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.service.AppointService;
import com.ebaiyihui.his.service.JSReservationSystemService;
import com.ebaiyihui.his.service.ParapetCovers;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"appoint"})
@Api(tags={"\u9884\u7ea6\u6302\u53f7\u76f8\u5173\u63a5\u53e3"})
public class AppointController {
    @Resource
    private AppointService appointService;
    @Autowired
    private JSReservationSystemService jsReservationSystemService;
    @Autowired
    private ParapetCovers parapetCovers;

    @PostMapping(value={"register/confirm"})
    @ApiOperation(value="\u9884\u7ea6\u6302\u53f7\u9501\u53f7/\u9500\u53f7")
    public FrontResponse<ConfirmRegisterRes> confirmRegister(@RequestBody FrontRequest<ConfirmRegisterReq> param) {
        FrontRequest frontRequest = this.parapetCovers.confirmRegisterCovers(param);
        FrontResponse order = this.jsReservationSystemService.createOrder(frontRequest);
        return this.parapetCovers.confirmRegisterCoversOut(order);
    }

    @PostMapping(value={"pay/registration"})
    @ApiOperation(value="\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u786e\u8ba4\u63a5\u53e3")
    public FrontResponse<PayRegistrationRes> payRegistration(@RequestBody FrontRequest<PayRegistrationReq> param) {
        FrontRequest frontRequest = this.parapetCovers.payRegistrationCovers(param);
        FrontResponse frontResponse = this.jsReservationSystemService.registeredPay(frontRequest);
        return this.parapetCovers.payRegistrationCoversOut(frontResponse);
    }

    @PostMapping(value={"register/cancel"})
    @ApiOperation(value="\u5f53\u65e5/\u9884\u7ea6 \u6302\u53f7\u9000\u53f7\u63a5\u53e3")
    public FrontResponse<CancelRegisterRes> cancelRegister(@RequestBody FrontRequest<PayRegistrationReq> param) {
        return this.appointService.cancelRegister(param);
    }

    @PostMapping(value={"register/return"})
    @ApiOperation(value="\u9000\u53f7\u6d41\u6c34\u5199\u5165\u63a5\u53e3")
    public FrontResponse<ReturnRegisterRes> returnRegister(@RequestBody FrontRequest<ReturnRegisterReq> param) {
        return this.appointService.returnRegister(param);
    }

    @PostMapping(value={"back/record"})
    @ApiOperation(value="\u67e5\u8be2\u6302\u53f7\u8bb0\u5f55")
    public FrontResponse<GetAppointRecordRes> getAppointRecord(@RequestBody FrontRequest<GetAppointRecordReq> param) {
        return this.appointService.getAppointRecord(param);
    }

    @PostMapping(value={"register/current"})
    @ApiOperation(value="\u5f53\u65e5\u6302\u53f7\u9501\u53f7")
    public FrontResponse<DayRegisterRes> dayRegister(@RequestBody FrontRequest<DayRegisterReq> param) {
        return this.appointService.dayRegister(param);
    }

    @PostMapping(value={"pay/dayRegistration"})
    @ApiOperation(value="\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u786e\u8ba4\u63a5\u53e3")
    public FrontResponse<PayRegistrationRes> dayPayRegistration(@RequestBody FrontRequest<PayRegistrationReq> param) {
        return this.appointService.dayPayRegistration(param);
    }

    @PostMapping(value={"day/cancel"})
    @ApiOperation(value="\u5f53\u65e5\u6302\u53f7\u9000\u53f7")
    public FrontResponse<Object> withdrawalNumber(@RequestBody FrontRequest<PayRegistrationReq> param) {
        return this.appointService.withdrawalNumber(param);
    }

    @PostMapping(value={"pay/dayRegistrationPayRegistration"})
    @ApiOperation(value="\u9884\u7ea6\u53d6\u53f7\u652f\u4ed8")
    public FrontResponse<Object> dayRegistrationPayRegistration(@RequestBody FrontRequest<PayRegistrationReq> param) {
        return this.appointService.dayRegistrationPayRegistration(param);
    }
}

