/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.controller;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.config.data.DBContextHolder;
import com.ebaiyihui.his.mapper.InspectionModelMapper;
import com.ebaiyihui.his.model.InspectionModel;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsRes;
import com.ebaiyihui.his.pojo.vo.report.LisReportListRes;
import com.ebaiyihui.his.pojo.vo.report.datas.GetReportListsData;
import com.ebaiyihui.his.pojo.vo.report.datas.LisReportListResData;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.utils.HttpUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6d4b\u8bd5Api"})
@RequestMapping(value={"test/"})
public class TestController {
    private static final Logger log = LoggerFactory.getLogger(TestController.class);
    @Autowired
    private HisRemoteService hisRemoteService;
    @Autowired
    private InspectionModelMapper inspectionModelMapper;

    @ApiOperation(value="\u53d1\u8d77his\u8bf7\u6c42")
    @RequestMapping(value={"sendHisRequest"})
    public String sendHisRequest(@RequestParam(value="methodStr") String methodStr, @RequestParam(value="xml") String xml) {
        log.info("\u8bf7\u6c42\u5230\u63a5\u53e3\uff1amethodstr===" + methodStr + " xml===" + xml);
        String responseHisXml = HttpUtils.getContent((String)"http://196.20.2.79:80/WLPT/ZJService.asmx".concat(methodStr), (String)methodStr, (String)xml);
        log.info("his\u8fd4\u56de\u53c2\u6570\uff1a" + responseHisXml);
        responseHisXml = responseHisXml.replace("&lt;", "<");
        responseHisXml = responseHisXml.replace("&gt;", ">");
        responseHisXml = responseHisXml.replace("<?xml version=\"1.0\" encoding=\"utf-8\"?>", "");
        responseHisXml = responseHisXml.replace("<string xmlns=\"http://tempuri.org/\">", "");
        responseHisXml = responseHisXml.replace("</string>", "");
        responseHisXml = responseHisXml.replace("\r\n", "");
        return JSON.toJSONString((Object)responseHisXml);
    }

    @ApiOperation(value="\u76f4\u63a5\u8c03\u7528lis\u63a5\u53e3\u67e5\u68c0\u9a8c\u5305\u597d\u5217\u8868")
    @GetMapping(value={"testLisList"})
    public FrontResponse<GetReportListsRes> testLis(String cardNo, String idCard) {
        ArrayList datas = new ArrayList();
        GetReportListsRes getReportListsRes = new GetReportListsRes();
        getReportListsRes.setSuccess("1");
        getReportListsRes.setPatientID(cardNo);
        DBContextHolder.setDataSource((String)"2");
        List inspectionModels = this.inspectionModelMapper.selectInspectionListByIdCard(cardNo, idCard);
        if (!inspectionModels.isEmpty()) {
            Map<String, List<InspectionModel>> inspectionModelsMap = inspectionModels.stream().collect(Collectors.groupingBy(InspectionModel::getReportNo));
            inspectionModelsMap.forEach((s, inspectionModels1) -> {
                InspectionModel inspectionModel = (InspectionModel)inspectionModels1.get(0);
                GetReportListsData getReportListsData = new GetReportListsData();
                getReportListsData.setReportNo(inspectionModel.getReportNo());
                getReportListsData.setReportName(inspectionModel.getItemName1());
                getReportListsData.setReportType("1");
                getReportListsData.setReportDate(inspectionModel.getReportDate());
                datas.add(getReportListsData);
            });
            List collect = datas.stream().sorted(Comparator.comparing(GetReportListsData::getReportDate).reversed()).collect(Collectors.toList());
            getReportListsRes.setDatas(collect);
        }
        return FrontResponse.success((String)"", (Object)getReportListsRes);
    }

    @ApiOperation(value="\u76f4\u63a5\u8c03\u7528lis\u63a5\u53e3\u67e5\u68c0\u9a8c\u5305\u597d\u5217\u8868")
    @GetMapping(value={"testLisDetail"})
    public FrontResponse<LisReportListRes> testLisDetail(String cardNo, String idCard, String reportNo) {
        DBContextHolder.setDataSource((String)"2");
        List list = this.inspectionModelMapper.selectInspectionDetail(cardNo, idCard, reportNo);
        LisReportListRes lisReportListRes = new LisReportListRes();
        if (!list.isEmpty()) {
            InspectionModel inspectionModel = (InspectionModel)list.get(0);
            lisReportListRes.setPatientName(inspectionModel.getPatientName());
            lisReportListRes.setReportNo(inspectionModel.getReportNo());
            lisReportListRes.setReportName(inspectionModel.getItemName1());
            lisReportListRes.setPatientNo(inspectionModel.getPatientId());
            lisReportListRes.setSex(inspectionModel.getSex());
            lisReportListRes.setAge(inspectionModel.getAge().replaceAll("\u5c81", ""));
            lisReportListRes.setDeptName(inspectionModel.getApplyDeptName());
            lisReportListRes.setDoctorName(inspectionModel.getApplyDoctor());
            lisReportListRes.setWardName(inspectionModel.getNursingUnit());
            lisReportListRes.setBed(inspectionModel.getBed());
            lisReportListRes.setRoom(inspectionModel.getRoom());
            lisReportListRes.setSpecName(inspectionModel.getSample());
            lisReportListRes.setRecTime(inspectionModel.getReceiveDate());
            lisReportListRes.setRecUser(inspectionModel.getReceiveAutitor());
            lisReportListRes.setAuthUser(inspectionModel.getReportAutitor());
            lisReportListRes.setColTime(inspectionModel.getSampleDate());
            lisReportListRes.setPrint(String.valueOf(inspectionModel.getPrint()));
            lisReportListRes.setAdmType(inspectionModel.getAdmType());
            if (StringUtils.isNotBlank((CharSequence)inspectionModel.getDiagnosis())) {
                lisReportListRes.setDiagnosis(inspectionModel.getDiagnosis().replaceAll("\n", "").replaceAll("\r", ""));
            }
            ArrayList<LisReportListResData> datas = new ArrayList<LisReportListResData>();
            for (InspectionModel inspectionModels : list) {
                LisReportListResData lisReportListResData = new LisReportListResData();
                lisReportListResData.setItmName(inspectionModels.getItemName());
                lisReportListResData.setItmCode(inspectionModels.getItemCode());
                lisReportListResData.setItmUnit(inspectionModels.getItemUnit());
                if (StringUtils.isNotBlank((CharSequence)inspectionModels.getItemRes())) {
                    lisReportListResData.setItmRes(inspectionModels.getItemRes().replaceAll("\n", "").replaceAll("\r", ""));
                }
                lisReportListResData.setItmRanges(inspectionModels.getItemRanges());
                lisReportListResData.setItmCrises(inspectionModels.getItemCrises());
                datas.add(lisReportListResData);
            }
            lisReportListRes.setDatas(datas);
        }
        return FrontResponse.success((String)"", (Object)lisReportListRes);
    }
}

