/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.GanderTypeEnums;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.pojo.dto.IdentityDTO;
import com.ebaiyihui.his.pojo.dto.PatInfoCreateDTO;
import com.ebaiyihui.his.pojo.dto.PatInfoCreateResDTO;
import com.ebaiyihui.his.pojo.dto.PatInfoCreateResDataDTO;
import com.ebaiyihui.his.pojo.dto.PatMedCardCheckDTO;
import com.ebaiyihui.his.pojo.dto.PatMedCardCheckResDTO;
import com.ebaiyihui.his.pojo.dto.QueryInfoDTO;
import com.ebaiyihui.his.pojo.dto.QueryInfoResDTO;
import com.ebaiyihui.his.pojo.dto.ResponseModel;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.card.QueryCardInfoReqVO;
import com.ebaiyihui.his.pojo.vo.card.QueryCardInfoResVO;
import com.ebaiyihui.his.pojo.vo.card.RegisteredCardReqVO;
import com.ebaiyihui.his.pojo.vo.card.RegisteredCardResVO;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.ICardService;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CardServiceImpl
implements ICardService {
    private static final Logger log = LoggerFactory.getLogger(CardServiceImpl.class);
    @Autowired
    private HisRemoteService hisRemoteService;
    @Value(value="${his.hisOperNum}")
    public String hisOperNum;

    public FrontResponse<QueryCardInfoResVO> queryCardInfo(FrontRequest<QueryCardInfoReqVO> param) {
        QueryCardInfoResVO queryCardInfoResVO = new QueryCardInfoResVO();
        QueryInfoDTO queryInfoDTO = new QueryInfoDTO();
        new QueryInfoResDTO();
        QueryCardInfoReqVO paramBody = (QueryCardInfoReqVO)param.getBody();
        queryInfoDTO.setQueryCode(paramBody.getCredNo());
        queryInfoDTO.setQueryType(Integer.valueOf(Integer.parseInt(paramBody.getCredType())));
        HashMap<String, QueryInfoDTO> map = new HashMap<String, QueryInfoDTO>();
        map.put(EntityKeyEnum.QUERY_INFO.getValue(), queryInfoDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_INFO.getValue(), map, QueryInfoResDTO.class);
        QueryInfoResDTO responseBody = (QueryInfoResDTO)response.getBody();
        if (Objects.isNull(responseBody)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (1 != responseBody.getResponseModel().getReturnCode()) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responseBody.getResponseModel().getErrorMsg());
        }
        IdentityDTO item = responseBody.getData();
        if (Objects.isNull(item)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (StringUtils.isBlank((CharSequence)item.getName())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        queryCardInfoResVO.setName(item.getName());
        queryCardInfoResVO.setAddress(item.getAddress());
        queryCardInfoResVO.setTelephone(item.getTelephone());
        queryCardInfoResVO.setSex(GanderTypeEnums.getDisplay((String)item.getSex()));
        queryCardInfoResVO.setDob(item.getDob());
        queryCardInfoResVO.setPatientId(item.getPatientId());
        queryCardInfoResVO.setPatientNo(item.getPatientId());
        queryCardInfoResVO.setCredNo(item.getCredNo());
        queryCardInfoResVO.setCredType(item.getCredType());
        queryCardInfoResVO.setCardNo(item.getPatientId());
        queryCardInfoResVO.setCardType(paramBody.getCardType());
        return FrontResponse.success((String)param.getTransactionId(), (Object)queryCardInfoResVO);
    }

    public FrontResponse<RegisteredCardResVO> registerCard(FrontRequest<RegisteredCardReqVO> param) {
        RegisteredCardReqVO registeredCardReqVO = (RegisteredCardReqVO)param.getBody();
        RegisteredCardResVO registeredCardResVO = new RegisteredCardResVO();
        PatInfoCreateDTO patInfoCreateDTO = PatInfoCreateDTO.builder().patientName(registeredCardReqVO.getName()).patientSex(GanderTypeEnums.getValue((String)registeredCardReqVO.getSex())).birthday(registeredCardReqVO.getDob()).idType(registeredCardReqVO.getCredType()).idCardNum(registeredCardReqVO.getCredNo()).address(registeredCardReqVO.getAddress()).phoneNum(registeredCardReqVO.getTelephone()).hisOper(this.hisOperNum).build();
        new PatInfoCreateResDTO();
        HashMap<String, PatInfoCreateDTO> map = new HashMap<String, PatInfoCreateDTO>();
        map.put(EntityKeyEnum.PAT_INFO_CREATE.getValue(), patInfoCreateDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.PAT_INFO_CREATE.getValue(), map, PatInfoCreateResDTO.class);
        PatInfoCreateResDTO responseBody = (PatInfoCreateResDTO)response.getBody();
        if (Objects.isNull(responseBody)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        ResponseModel responseModel = responseBody.getResponseModel();
        if (1 != responseModel.getReturnCode()) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responseModel.getErrorMsg());
        }
        PatInfoCreateResDataDTO responseBodyData = responseBody.getData();
        registeredCardResVO.setPatientId(responseBodyData.getPatientId());
        registeredCardResVO.setCardNo(responseBodyData.getPatientId());
        registeredCardResVO.setTelephone(registeredCardReqVO.getTelephone());
        registeredCardResVO.setSex(registeredCardReqVO.getSex());
        registeredCardResVO.setCredNo(registeredCardReqVO.getCredNo());
        registeredCardResVO.setCardType(registeredCardReqVO.getCardType());
        registeredCardResVO.setDob(registeredCardReqVO.getDob());
        registeredCardResVO.setAddress(registeredCardReqVO.getAddress());
        registeredCardResVO.setName(registeredCardReqVO.getName());
        registeredCardResVO.setCredType(registeredCardReqVO.getCredType());
        registeredCardResVO.setPatientNo(responseBodyData.getPatientId());
        return FrontResponse.success((String)param.getTransactionId(), (Object)registeredCardResVO);
    }

    public FrontResponse<Object> patMedCardCheck(FrontRequest<QueryCardInfoReqVO> param) {
        QueryCardInfoReqVO paramBody = (QueryCardInfoReqVO)param.getBody();
        PatMedCardCheckDTO patMedCardCheckDTO = PatMedCardCheckDTO.builder().cardType(paramBody.getCredType()).idCardNO(paramBody.getCredNo()).build();
        new PatMedCardCheckResDTO();
        HashMap<String, PatMedCardCheckDTO> map = new HashMap<String, PatMedCardCheckDTO>();
        map.put(EntityKeyEnum.PAT_MED_CARD_CHECK.getValue(), patMedCardCheckDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.PAT_MED_CARD_CHECK.getValue(), map, PatInfoCreateResDTO.class);
        PatInfoCreateResDTO responseBody = (PatInfoCreateResDTO)response.getBody();
        if (Objects.isNull(responseBody)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        ResponseModel responseModel = responseBody.getResponseModel();
        if (1 != responseModel.getReturnCode()) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)responseModel.getErrorMsg());
        }
        return FrontResponse.success((String)param.getTransactionId(), null);
    }
}

