/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.config.data.DBContextHolder;
import com.ebaiyihui.his.mapper.EndoscopicReportMapper;
import com.ebaiyihui.his.mapper.InspectionModelMapper;
import com.ebaiyihui.his.mapper.VDzbgJcModelMapper;
import com.ebaiyihui.his.mapper.VhisCyjlModelMapper;
import com.ebaiyihui.his.model.EndoscopicModel;
import com.ebaiyihui.his.model.InspectionModel;
import com.ebaiyihui.his.model.VDzbgJcModel;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.report.GetEndoscopicReportListReqVo;
import com.ebaiyihui.his.pojo.vo.report.GetEndoscopicReportListRespVo;
import com.ebaiyihui.his.pojo.vo.report.GetEndoscopicReportReqVo;
import com.ebaiyihui.his.pojo.vo.report.GetEndoscopicReportRespVo;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsReq;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsRes;
import com.ebaiyihui.his.pojo.vo.report.LisReportListReq;
import com.ebaiyihui.his.pojo.vo.report.LisReportListRes;
import com.ebaiyihui.his.pojo.vo.report.PacsReportListReq;
import com.ebaiyihui.his.pojo.vo.report.PacsReportListRes;
import com.ebaiyihui.his.pojo.vo.report.QueryDischargeRecordRes;
import com.ebaiyihui.his.pojo.vo.report.VhisCyjlModel;
import com.ebaiyihui.his.pojo.vo.report.datas.GetReportListsData;
import com.ebaiyihui.his.pojo.vo.report.datas.LisReportListResData;
import com.ebaiyihui.his.service.ElectronicReportService;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.utils.DateUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElectronicReportServiceImpl
implements ElectronicReportService {
    private static final Logger log = LoggerFactory.getLogger(ElectronicReportServiceImpl.class);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int MAP_SIZE = 1;
    public static final String CHECK_TYPE = "1";
    public static final String INSPECTION_TYPE = "2";
    @Autowired
    private HisRemoteService hisRemoteService;
    @Autowired
    VDzbgJcModelMapper vDzbgJcModelMapper;
    @Autowired
    InspectionModelMapper inspectionModelMapper;
    @Autowired
    VhisCyjlModelMapper vhisCyjlModelMapper;
    @Autowired
    private EndoscopicReportMapper endoscopicReportMapper;

    public FrontResponse<GetReportListsRes> getReportLists(FrontRequest<GetReportListsReq> param) {
        GetReportListsReq paramBody = (GetReportListsReq)param.getBody();
        String reportType = paramBody.getReportType();
        GetReportListsRes getReportListsRes = new GetReportListsRes();
        getReportListsRes.setSuccess(CHECK_TYPE);
        getReportListsRes.setPatientID(paramBody.getPatientId());
        ArrayList<GetReportListsData> datas = new ArrayList<GetReportListsData>();
        if (Objects.equals(CHECK_TYPE, reportType)) {
            DBContextHolder.setDataSource((String)INSPECTION_TYPE);
            List inspectionModels = this.inspectionModelMapper.selectInspectionListByIdCard(paramBody.getPatientId(), paramBody.getIdCard());
            if (!inspectionModels.isEmpty()) {
                Map<String, List<InspectionModel>> inspectionModelsMap = inspectionModels.stream().collect(Collectors.groupingBy(InspectionModel::getReportNo));
                inspectionModelsMap.forEach((s, inspectionModels1) -> {
                    InspectionModel inspectionModel = (InspectionModel)inspectionModels1.get(0);
                    GetReportListsData getReportListsData = new GetReportListsData();
                    getReportListsData.setReportNo(inspectionModel.getReportNo());
                    getReportListsData.setReportName(inspectionModel.getItemName1());
                    getReportListsData.setReportType(CHECK_TYPE);
                    getReportListsData.setReportDate(inspectionModel.getReportDate());
                    datas.add(getReportListsData);
                });
                List collect = datas.stream().sorted(Comparator.comparing(GetReportListsData::getReportDate).reversed()).collect(Collectors.toList());
                getReportListsRes.setDatas(collect);
                return FrontResponse.success((String)param.getTransactionId(), (Object)getReportListsRes);
            }
            return FrontResponse.success((String)param.getTransactionId(), (Object)getReportListsRes);
        }
        DBContextHolder.setDataSource((String)CHECK_TYPE);
        List vDzbgJcModel = this.vDzbgJcModelMapper.selectCheckList(paramBody.getPatientId());
        for (VDzbgJcModel dzbgJcModel : vDzbgJcModel) {
            getReportListsRes.setPatientName(dzbgJcModel.getPatientname());
            GetReportListsData getReportListsData = new GetReportListsData();
            getReportListsData.setReportNo(dzbgJcModel.getReportno());
            getReportListsData.setReportName(dzbgJcModel.getItemname());
            getReportListsData.setReportType(INSPECTION_TYPE);
            getReportListsData.setReportDate(dzbgJcModel.getReportdate());
            datas.add(getReportListsData);
        }
        List collect = datas.stream().sorted(Comparator.comparing(GetReportListsData::getReportDate).reversed()).collect(Collectors.toList());
        getReportListsRes.setDatas(collect);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getReportListsRes);
    }

    public FrontResponse<LisReportListRes> queryInspectionInfo(FrontRequest<LisReportListReq> param) {
        DBContextHolder.setDataSource((String)INSPECTION_TYPE);
        LisReportListReq paramBody = (LisReportListReq)param.getBody();
        List list = this.inspectionModelMapper.selectInspectionDetail(paramBody.getPatientId(), paramBody.getIdCard(), paramBody.getReportNo());
        LisReportListRes lisReportListRes = new LisReportListRes();
        if (!list.isEmpty()) {
            InspectionModel inspectionModel = (InspectionModel)list.get(0);
            lisReportListRes.setPatientName(inspectionModel.getPatientName());
            lisReportListRes.setReportNo(inspectionModel.getReportNo());
            lisReportListRes.setReportName(inspectionModel.getItemName1());
            lisReportListRes.setPatientNo(inspectionModel.getPatientId());
            lisReportListRes.setSex(inspectionModel.getSex());
            lisReportListRes.setAge(inspectionModel.getAge().replaceAll("\u5c81", ""));
            lisReportListRes.setDeptName(inspectionModel.getApplyDeptName());
            lisReportListRes.setDoctorName(inspectionModel.getApplyDoctor());
            lisReportListRes.setWardName(inspectionModel.getNursingUnit());
            lisReportListRes.setBed(inspectionModel.getBed());
            lisReportListRes.setRoom(inspectionModel.getRoom());
            lisReportListRes.setSpecName(inspectionModel.getSample());
            lisReportListRes.setRecTime(inspectionModel.getReceiveDate());
            lisReportListRes.setRecUser(inspectionModel.getReceiveAutitor());
            lisReportListRes.setAuthUser(inspectionModel.getReportAutitor());
            lisReportListRes.setColTime(inspectionModel.getSampleDate());
            lisReportListRes.setPrint(String.valueOf(inspectionModel.getPrint()));
            lisReportListRes.setAdmType(inspectionModel.getAdmType());
            if (StringUtils.isNotBlank((CharSequence)inspectionModel.getDiagnosis())) {
                lisReportListRes.setDiagnosis(inspectionModel.getDiagnosis().replaceAll("\n", "").replaceAll("\r", ""));
            }
            ArrayList<LisReportListResData> datas = new ArrayList<LisReportListResData>();
            for (InspectionModel inspectionModels : list) {
                LisReportListResData lisReportListResData = new LisReportListResData();
                lisReportListResData.setItmName(inspectionModels.getItemName());
                lisReportListResData.setItmCode(inspectionModels.getItemCode());
                lisReportListResData.setItmUnit(inspectionModels.getItemUnit());
                if (StringUtils.isNotBlank((CharSequence)inspectionModels.getItemRes())) {
                    lisReportListResData.setItmRes(inspectionModels.getItemRes().replaceAll("\n", "").replaceAll("\r", ""));
                }
                lisReportListResData.setItmRanges(inspectionModels.getItemRanges());
                lisReportListResData.setItmCrises(inspectionModels.getItemCrises());
                datas.add(lisReportListResData);
            }
            lisReportListRes.setDatas(datas);
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)lisReportListRes);
    }

    public FrontResponse<PacsReportListRes> pacsReportList(FrontRequest<PacsReportListReq> param) {
        DBContextHolder.setDataSource((String)CHECK_TYPE);
        PacsReportListReq paramBody = (PacsReportListReq)param.getBody();
        VDzbgJcModel vDzbgJcModel = this.vDzbgJcModelMapper.selectCheck(paramBody.getPatientId(), paramBody.getReportNo());
        PacsReportListRes pacsReportListRes = new PacsReportListRes();
        if (Objects.nonNull(vDzbgJcModel)) {
            pacsReportListRes.setPatientName(vDzbgJcModel.getPatientname());
            pacsReportListRes.setReportName(vDzbgJcModel.getItemname());
            pacsReportListRes.setReportNo(vDzbgJcModel.getReportno());
            pacsReportListRes.setPatientNo(vDzbgJcModel.getPatientid());
            pacsReportListRes.setSex(vDzbgJcModel.getSex());
            pacsReportListRes.setAge(vDzbgJcModel.getAge().replaceAll("\u5c81", ""));
            pacsReportListRes.setDeptName(vDzbgJcModel.getApplydeptname());
            pacsReportListRes.setDoctorName(vDzbgJcModel.getApplydoctor());
            pacsReportListRes.setWardName(vDzbgJcModel.getNursingunit());
            pacsReportListRes.setBed(vDzbgJcModel.getBed());
            pacsReportListRes.setRoom(vDzbgJcModel.getRoom());
            pacsReportListRes.setAuthUser(vDzbgJcModel.getReportautitor());
            pacsReportListRes.setAuthTime(vDzbgJcModel.getReportdate());
            pacsReportListRes.setPrint(vDzbgJcModel.getPrint());
            pacsReportListRes.setAdmType(vDzbgJcModel.getAdmtype());
            if (StringUtils.isNotBlank((CharSequence)vDzbgJcModel.getMedicaladvice())) {
                pacsReportListRes.setCheckDesc(vDzbgJcModel.getMedicaladvice().replaceAll("\n", "").replaceAll("\r", ""));
            }
            if (StringUtils.isNotBlank((CharSequence)vDzbgJcModel.getCheckresult())) {
                pacsReportListRes.setCheckResult(vDzbgJcModel.getCheckresult().replaceAll("\n", "").replaceAll("\r", ""));
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(vDzbgJcModel.getCheckimages());
            pacsReportListRes.setCheckImages(list);
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)pacsReportListRes);
    }

    public FrontResponse<QueryDischargeRecordRes> queryDischargeRecord(FrontRequest<PacsReportListReq> param) {
        QueryDischargeRecordRes queryDischargeRecordRes = new QueryDischargeRecordRes();
        PacsReportListReq paramBody = (PacsReportListReq)param.getBody();
        DBContextHolder.setDataSource((String)CHECK_TYPE);
        List list = this.vhisCyjlModelMapper.selectCheckList(paramBody.getPatientId());
        String pastDate = DateUtil.getPastDate((int)7);
        ArrayList removeList = new ArrayList();
        list.stream().forEach(x -> {
            boolean bool;
            String ysname = x.getYsname();
            if (Objects.equals("\u51fa\u9662\u65e5\u671f", ysname) && !(bool = DateUtil.timeRange((String)pastDate, (String)x.getValue()))) {
                removeList.add(x.getInpatientNo());
            }
        });
        Map<String, List<VhisCyjlModel>> inspectionModelsMap = list.stream().collect(Collectors.groupingBy(VhisCyjlModel::getInpatientNo));
        for (String key : removeList) {
            inspectionModelsMap.remove(key);
        }
        queryDischargeRecordRes.setRes(inspectionModelsMap);
        return FrontResponse.success((String)param.getTransactionId(), (Object)queryDischargeRecordRes);
    }

    public FrontResponse<GetEndoscopicReportListRespVo> queryEndoscopicReportList(FrontRequest<GetEndoscopicReportListReqVo> param) {
        GetEndoscopicReportListReqVo body = (GetEndoscopicReportListReqVo)param.getBody();
        log.info("\u83b7\u53d6\u75c5\u7406\u4e36\u5185\u955c\u5217\u8868\u53c2\u6570\u4e3a:{}", (Object)body.toString());
        DBContextHolder.setDataSource((String)"3");
        List endoscopicModels = this.endoscopicReportMapper.selectList(body.getPatientCardId(), body.getStartTime(), body.getEndTime());
        log.info("\u83b7\u53d6\u75c5\u7406\u4e36\u5185\u955c\u5217\u8868\u8fd4\u56de\u503c\u4e3a:{}", (Object)JSON.toJSONString((Object)endoscopicModels));
        GetEndoscopicReportListRespVo getEndoscopicReportListRespVo = new GetEndoscopicReportListRespVo();
        ArrayList<GetEndoscopicReportRespVo> getEndoscopicReportRespVoList = new ArrayList<GetEndoscopicReportRespVo>();
        if (CHECK_TYPE.equals(body.getType())) {
            List endoscopicModelList = endoscopicModels.stream().filter(e -> e.getReportOffice().contains("\u5185\u955c")).collect(Collectors.toList());
            for (EndoscopicModel endoscopicModel : endoscopicModelList) {
                GetEndoscopicReportRespVo getEndoscopicReportRespVo = new GetEndoscopicReportRespVo();
                BeanUtils.copyProperties((Object)endoscopicModel, (Object)getEndoscopicReportRespVo);
                getEndoscopicReportRespVoList.add(getEndoscopicReportRespVo);
            }
        } else if (INSPECTION_TYPE.equals(body.getType())) {
            List endoscopicModelList = endoscopicModels.stream().filter(e -> e.getReportOffice().contains("\u75c5\u7406")).collect(Collectors.toList());
            for (EndoscopicModel endoscopicModel : endoscopicModelList) {
                GetEndoscopicReportRespVo getEndoscopicReportRespVo = new GetEndoscopicReportRespVo();
                BeanUtils.copyProperties((Object)endoscopicModel, (Object)getEndoscopicReportRespVo);
                getEndoscopicReportRespVoList.add(getEndoscopicReportRespVo);
            }
        }
        getEndoscopicReportListRespVo.setGetEndoscopicReportRespVoList(getEndoscopicReportRespVoList);
        log.info("\u8fc7\u6ee4\u540e\u7684\u75c5\u7406\u4e36\u5185\u955c\u5217\u8868\u7ed3\u679c\u4e3a:{}", (Object)JSON.toJSONString((Object)getEndoscopicReportListRespVo));
        return FrontResponse.success((String)param.getTransactionId(), (Object)getEndoscopicReportListRespVo);
    }

    public FrontResponse<GetEndoscopicReportRespVo> queryEndoscopicReport(FrontRequest<GetEndoscopicReportReqVo> param) {
        GetEndoscopicReportReqVo body = (GetEndoscopicReportReqVo)param.getBody();
        log.info("\u83b7\u53d6\u75c5\u7406\u4e36\u5185\u955c\u8be6\u60c5\u7684\u53c2\u6570\u4e3a:{}", (Object)body.toString());
        String reportOffice = "";
        if (CHECK_TYPE.equals(body.getType())) {
            reportOffice = "\u5185\u955c";
        } else if (INSPECTION_TYPE.equals(body.getType())) {
            reportOffice = "\u75c5\u7406";
        }
        DBContextHolder.setDataSource((String)"3");
        EndoscopicModel endoscopicModel = this.endoscopicReportMapper.selectByReportId(body.getReportId(), reportOffice);
        log.info("\u83b7\u53d6\u75c5\u7406\u4e36\u5185\u955c\u8be6\u60c5\u7684\u8fd4\u56de\u503c\u4e3a:{}", (Object)JSON.toJSONString((Object)endoscopicModel));
        GetEndoscopicReportRespVo getEndoscopicReportRespVo = new GetEndoscopicReportRespVo();
        if (Objects.nonNull(endoscopicModel)) {
            if (StringUtils.isNotBlank((CharSequence)endoscopicModel.getReportUrl())) {
                String reportUrl = endoscopicModel.getReportUrl().replace("http://196.20.1.83:85", "https://ihos.chinachdu.com/jingsan-oss");
                endoscopicModel.setReportUrl(reportUrl);
            }
            BeanUtils.copyProperties((Object)endoscopicModel, (Object)getEndoscopicReportRespVo);
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)getEndoscopicReportRespVo);
    }
}

