/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodEnum;
import com.ebaiyihui.his.pojo.dto.GetIPDepositRecordsReqDTO;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.utils.HttpUtils;
import com.ebaiyihui.his.utils.XmlTemplateKit;
import com.ebaiyihui.his.utils.XmlUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class HisRemoteServiceImpl
implements HisRemoteService {
    private static final Logger log = LoggerFactory.getLogger(HisRemoteServiceImpl.class);
    @Value(value="${his.wsdlUrl}")
    public String hisWsdlUrl;
    @Value(value="${his.method}")
    public String method;
    @Value(value="${his.debug}")
    public Boolean debug;
    @Value(value="${his.payUrl}")
    public String payUrl;

    public <T> FrontResponse<T> requestHis(String transactionId, String methodStr, Map map, Class<T> clazz) {
        String requestHisXml = XmlTemplateKit.process((String)methodStr, (Map)map);
        if (StringUtils.isEmpty((CharSequence)requestHisXml)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        log.info("requestHisXml\u6a21\u677f\uff1a" + JSON.toJSONString((Object)requestHisXml));
        String responseHisXml = "";
        String url = this.hisWsdlUrl.concat(MethodEnum.getDisplay((String)methodStr));
        log.info("url\uff1a" + url);
        try {
            responseHisXml = HttpUtils.getContent((String)url, (String)methodStr, (String)requestHisXml);
        }
        catch (Exception e) {
            e.printStackTrace();
            return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
        }
        if (StringUtils.isEmpty((CharSequence)responseHisXml)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"his\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
        }
        log.info("requestHisXml\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)responseHisXml));
        responseHisXml = responseHisXml.replace("&lt;", "<");
        responseHisXml = responseHisXml.replace("&gt;", ">");
        responseHisXml = responseHisXml.replace("<?xml version=\"1.0\" encoding=\"utf-8\"?>", "");
        responseHisXml = responseHisXml.replace("<string xmlns=\"http://tempuri.org/\">", "");
        responseHisXml = responseHisXml.replace("</string>", "");
        responseHisXml = responseHisXml.replace("\r\n", "");
        log.info("xml\u5904\u7406\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)responseHisXml));
        Object resHisDTO = XmlUtil.convertToJavaBean((String)responseHisXml, clazz);
        log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)resHisDTO));
        if (null == resHisDTO) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
        }
        return FrontResponse.success((String)transactionId, (Object)resHisDTO);
    }

    public <T> FrontResponse<T> requestPay(String transactionId, String methodStr, String xml, Class<T> c) {
        String responseHisXml = "";
        try {
            responseHisXml = HttpUtils.getPayContent((String)this.payUrl, (String)methodStr, (String)xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u652f\u4ed8\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
        }
        if (StringUtils.isEmpty((CharSequence)responseHisXml)) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"\u652f\u4ed8\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
        }
        log.info("requestPayXml\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)responseHisXml));
        responseHisXml = responseHisXml.replace("&lt;", "<");
        responseHisXml = responseHisXml.replace("&gt;", ">");
        responseHisXml = responseHisXml.replace("<?xml version=\"1.0\" encoding=\"utf-8\"?>", "");
        responseHisXml = responseHisXml.replace("<string xmlns=\"http://tempuri.org/\">", "");
        responseHisXml = responseHisXml.replace("</string>", "");
        responseHisXml = responseHisXml.replace("\r\n", "");
        log.info("xml\u5904\u7406\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)responseHisXml));
        Object resHisDTO = XmlUtil.convertToJavaBean((String)responseHisXml, c);
        log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)resHisDTO));
        if (null == resHisDTO) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
        }
        return FrontResponse.success((String)transactionId, (Object)resHisDTO);
    }

    public <T> FrontResponse<T> getToken(String transactionId, String methodStr, String xml, Class<T> c) {
        String res = "";
        try {
            res = HttpUtils.getContent((String)this.payUrl, (String)methodStr, (String)xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            return FrontResponse.error((String)"1", (String)"0", (String)"\u83b7\u53d6token\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
        }
        if (StringUtils.isEmpty((CharSequence)res)) {
            return FrontResponse.error((String)"1", (String)"0", (String)"\u83b7\u53d6token\u54cd\u5e94\u7ed3\u679c\u5931\u8d25");
        }
        log.info("\u83b7\u53d6token\u54cd\u5e94\u7ed3\u679c:{}", (Object)res);
        res = res.replace("&lt;", "<");
        res = res.replace("&gt;", ">");
        res = res.replace("<?xml version=\"1.0\" encoding=\"utf-8\"?>", "");
        res = res.replace("<string xmlns=\"http://tempuri.org/\">", "");
        res = res.replace("</string>", "");
        res = res.replace("\r\n", "");
        log.info("xml\u5904\u7406\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)res));
        Object resHisDTO = XmlUtil.convertToJavaBean((String)res, c);
        log.info("JAXB\u6267\u884c\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)resHisDTO));
        if (null == resHisDTO) {
            return FrontResponse.error((String)transactionId, (String)"0", (String)"JAXB\u6267\u884c\u5931\u8d25");
        }
        return FrontResponse.success((String)"1", (Object)resHisDTO);
    }

    public static void main(String[] args) {
        GetIPDepositRecordsReqDTO getIPDepositRecordsReqDTO = new GetIPDepositRecordsReqDTO();
        getIPDepositRecordsReqDTO.setQueryType("1");
        getIPDepositRecordsReqDTO.setQueryNum("2");
        getIPDepositRecordsReqDTO.setStartTime("3");
        getIPDepositRecordsReqDTO.setEndTime("4");
        HashMap<String, GetIPDepositRecordsReqDTO> map = new HashMap<String, GetIPDepositRecordsReqDTO>();
        map.put(EntityKeyEnum.GET_IP_DEPOSIT_RECORDS.getValue(), getIPDepositRecordsReqDTO);
        String process = XmlTemplateKit.process((String)"2507", map);
        System.out.println(JSON.toJSONString((Object)process));
    }

    static {
        XmlTemplateKit.init();
    }
}

