/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.pojo.dto.BaseReturnResultRepDTO;
import com.ebaiyihui.his.pojo.dto.GetPayRecordsReqDTO;
import com.ebaiyihui.his.pojo.dto.GetPayRecordsResDTO;
import com.ebaiyihui.his.pojo.dto.GetPayRecordsResItemDTO;
import com.ebaiyihui.his.pojo.dto.GetPayRecordsResItemDetailDTO;
import com.ebaiyihui.his.pojo.dto.PaymentConfirmationDTO;
import com.ebaiyihui.his.pojo.dto.PaymentConfirmationResDTO;
import com.ebaiyihui.his.pojo.dto.QueryChargeDetailsDTO;
import com.ebaiyihui.his.pojo.dto.QueryChargeDetailsItemDTO;
import com.ebaiyihui.his.pojo.dto.QueryChargeDetailsResDTO;
import com.ebaiyihui.his.pojo.dto.QueryMainInfoDTO;
import com.ebaiyihui.his.pojo.dto.QueryOutpatientInfoDTO;
import com.ebaiyihui.his.pojo.dto.QueryOutpatientInfoItemDTO;
import com.ebaiyihui.his.pojo.dto.QueryOutpatientInfoResDTO;
import com.ebaiyihui.his.pojo.dto.QueryOutpatientMainInfoItemDTO;
import com.ebaiyihui.his.pojo.dto.QueryOutpatientMainInfoResDTO;
import com.ebaiyihui.his.pojo.dto.QueryPaymentReceiptDTO;
import com.ebaiyihui.his.pojo.dto.QueryPaymentReceiptItem;
import com.ebaiyihui.his.pojo.dto.QueryPaymentReceiptResDTO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewReq;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewRes;
import com.ebaiyihui.his.pojo.vo.outpatient.GetAdmissionReq;
import com.ebaiyihui.his.pojo.vo.outpatient.GetAdmissionRes;
import com.ebaiyihui.his.pojo.vo.outpatient.GetPayRecordsReq;
import com.ebaiyihui.his.pojo.vo.outpatient.GetPayRecordsRes;
import com.ebaiyihui.his.pojo.vo.outpatient.PayItemReq;
import com.ebaiyihui.his.pojo.vo.outpatient.PayItemRes;
import com.ebaiyihui.his.pojo.vo.outpatient.datas.PayItemResDatas;
import com.ebaiyihui.his.pojo.vo.outpatient.items.GetAdmissionItems;
import com.ebaiyihui.his.pojo.vo.outpatient.items.GetPayRecordsResDetails;
import com.ebaiyihui.his.pojo.vo.outpatient.items.GetPayRecordsResItems;
import com.ebaiyihui.his.pojo.vo.outpatient.items.PayItemResItems;
import com.ebaiyihui.his.pojo.vo.outpatient.respmsg.ComfirmPayNewReqMsg;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.OutpatientPaymentService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OutpatientPaymentServiceImpl
implements OutpatientPaymentService {
    @Autowired
    private HisRemoteService hisRemoteService;
    @Value(value="${his.hisOperNum}")
    public String hisOperNum;

    public FrontResponse<GetAdmissionRes> queryPaymentReceipt(FrontRequest<GetAdmissionReq> param) {
        GetAdmissionReq body = (GetAdmissionReq)param.getBody();
        QueryPaymentReceiptDTO queryPaymentReceiptDTO = new QueryPaymentReceiptDTO();
        queryPaymentReceiptDTO.setPatientId(body.getCardNo());
        queryPaymentReceiptDTO.setQueryType("0");
        queryPaymentReceiptDTO.setDepartCode(body.getDeptCode());
        queryPaymentReceiptDTO.setRegisterdate(body.getBgDate());
        HashMap<String, QueryPaymentReceiptDTO> map = new HashMap<String, QueryPaymentReceiptDTO>();
        map.put(EntityKeyEnum.QUERY_PAYMENT_RECEIPT.getValue(), queryPaymentReceiptDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_PAYMENT_RECEIPT.getValue(), map, QueryPaymentReceiptResDTO.class);
        QueryPaymentReceiptResDTO getOutPatientAdmRes = (QueryPaymentReceiptResDTO)response.getBody();
        if (null == getOutPatientAdmRes) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        BaseReturnResultRepDTO baseReturnResultRepDTO = getOutPatientAdmRes.getBaseReturnResultRepDTO();
        if (!"1".equals(baseReturnResultRepDTO.getResultCode())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)baseReturnResultRepDTO.getResultMsg());
        }
        List getOutPatientAdmResItemDTOList = getOutPatientAdmRes.getQueryPaymentReceiptItemDataResDTO().getItems();
        GetAdmissionRes getAdmissionRes = new GetAdmissionRes();
        ArrayList<GetAdmissionItems> getAdmissionItemsList = new ArrayList<GetAdmissionItems>();
        for (QueryPaymentReceiptItem queryPaymentReceiptItem : getOutPatientAdmResItemDTOList) {
            GetAdmissionItems getAdmissionItems = new GetAdmissionItems();
            getAdmissionItems.setAdmId(queryPaymentReceiptItem.getFlowNo());
            getAdmissionItems.setAdmDate(queryPaymentReceiptItem.getVisitDate());
            getAdmissionItems.setAdmType("0");
            getAdmissionItems.setDeptName(queryPaymentReceiptItem.getDoDepartName());
            getAdmissionItems.setDeptCode(queryPaymentReceiptItem.getDoDepartCode());
            getAdmissionItems.setDocCode(queryPaymentReceiptItem.getDoctorCode());
            getAdmissionItems.setDocName(queryPaymentReceiptItem.getDoctorName());
            getAdmissionItemsList.add(getAdmissionItems);
        }
        ArrayList newList = getAdmissionItemsList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<GetAdmissionItems>(Comparator.comparing(GetAdmissionItems::getAdmId))), ArrayList::new));
        getAdmissionRes.setItems(newList);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getAdmissionRes);
    }

    public FrontResponse<PayItemRes> queryChargeDetails(FrontRequest<PayItemReq> param) {
        PayItemReq body = (PayItemReq)param.getBody();
        PayItemRes payItemRes = new PayItemRes();
        QueryChargeDetailsDTO queryChargeDetailsDTO = QueryChargeDetailsDTO.builder().flowNo(body.getAdmId()).build();
        HashMap<String, QueryChargeDetailsDTO> map = new HashMap<String, QueryChargeDetailsDTO>();
        map.put(EntityKeyEnum.QUERY_CHARGE_DETAILS.getValue(), queryChargeDetailsDTO);
        FrontResponse detailRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_CHARGE_DETAILS.getValue(), map, QueryChargeDetailsResDTO.class);
        if (null == detailRes) {
            return FrontResponse.error((String)detailRes.getTransactionId(), (String)"0", (String)detailRes.getMessage());
        }
        BaseReturnResultRepDTO respBody = ((QueryChargeDetailsResDTO)detailRes.getBody()).getBaseReturnResultRepDTO();
        if (!"1".equals(respBody.getResultCode())) {
            return FrontResponse.error((String)detailRes.getTransactionId(), (String)"0", (String)respBody.getResultMsg());
        }
        List payDetailResList = ((QueryChargeDetailsResDTO)detailRes.getBody()).getQueryChargeDetailsItemDataDTO().getItem();
        if (CollectionUtils.isEmpty((Collection)payDetailResList)) {
            return FrontResponse.error((String)detailRes.getTransactionId(), (String)"0", (String)respBody.getResultMsg());
        }
        ArrayList<PayItemResDatas> payItemResDatasArrayList = new ArrayList<PayItemResDatas>();
        for (QueryChargeDetailsItemDTO queryChargeDetailsItemDTO : payDetailResList) {
            PayItemResDatas payItemResDatas = new PayItemResDatas();
            PayItemResItems payItemResItems = new PayItemResItems();
            payItemResDatas.setAmount(queryChargeDetailsItemDTO.getCostAmount());
            payItemResDatas.setItemType("1");
            ArrayList<PayItemResItems> payItemResItemsArrayList = new ArrayList<PayItemResItems>();
            payItemResItems.setId(queryChargeDetailsItemDTO.getItemNum());
            payItemResItems.setDesc(queryChargeDetailsItemDTO.getCostName());
            payItemResItems.setInsuCode(queryChargeDetailsItemDTO.getYBCostCode());
            payItemResItems.setUnit(queryChargeDetailsItemDTO.getUnit());
            payItemResItems.setPrice(queryChargeDetailsItemDTO.getAmount());
            payItemResItems.setQty(queryChargeDetailsItemDTO.getCostSum());
            payItemResItems.setSum(queryChargeDetailsItemDTO.getCostAmount());
            payItemResItems.setPrescriptionNo(queryChargeDetailsItemDTO.getPrescriptionNum());
            payItemResItems.setItemType(queryChargeDetailsItemDTO.getCostName());
            payItemResItemsArrayList.add(payItemResItems);
            payItemResDatas.setFeeId(queryChargeDetailsItemDTO.getPrescriptionNum());
            payItemResDatas.setItems(payItemResItemsArrayList);
            payItemResDatasArrayList.add(payItemResDatas);
        }
        payItemRes.setDatas(payItemResDatasArrayList);
        return FrontResponse.success((String)param.getTransactionId(), (Object)payItemRes);
    }

    public FrontResponse<ComfirmPayNewRes> paymentConfirmation(FrontRequest<ComfirmPayNewReq> param) {
        ComfirmPayNewRes comfirmPayNewRes = new ComfirmPayNewRes();
        ComfirmPayNewReq comfirmPayNewReq = (ComfirmPayNewReq)param.getBody();
        ComfirmPayNewReqMsg comfirmPayNewReqMsg = comfirmPayNewReq.getRespmsg();
        PaymentConfirmationDTO paymentConfirmationDTO = new PaymentConfirmationDTO();
        paymentConfirmationDTO.setPatientId(comfirmPayNewReq.getPatientId());
        paymentConfirmationDTO.setBillsMsg(comfirmPayNewReq.getPrescriptionNos());
        paymentConfirmationDTO.setPayNature("1");
        paymentConfirmationDTO.setPayType("2");
        paymentConfirmationDTO.setPowerPayChannel("WX");
        paymentConfirmationDTO.setPowerTranID(comfirmPayNewReq.getFlowNo());
        paymentConfirmationDTO.setZfAmount(comfirmPayNewReq.getAmount());
        paymentConfirmationDTO.setHisOperNum(this.hisOperNum);
        HashMap<String, PaymentConfirmationDTO> map = new HashMap<String, PaymentConfirmationDTO>();
        map.put(EntityKeyEnum.PAYMENT_CONFIRMATION.getValue(), paymentConfirmationDTO);
        FrontResponse comfirePayResDTO = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.PAYMENT_CONFIRMATION.getValue(), map, PaymentConfirmationResDTO.class);
        if (null == comfirePayResDTO) {
            return FrontResponse.error((String)comfirePayResDTO.getTransactionId(), (String)"0", (String)comfirePayResDTO.getMessage());
        }
        BaseReturnResultRepDTO body = ((PaymentConfirmationResDTO)comfirePayResDTO.getBody()).getBaseReturnResultRepDTO();
        if (!"1".equals(body.getResultCode())) {
            return FrontResponse.error((String)comfirePayResDTO.getTransactionId(), (String)"0", (String)body.getResultMsg());
        }
        comfirmPayNewRes.setAdmId(comfirmPayNewReq.getId());
        comfirmPayNewRes.setCardNo(comfirmPayNewReq.getCardNo());
        comfirmPayNewRes.setAmount(comfirmPayNewReq.getAmount());
        comfirmPayNewRes.setReceiptId(((PaymentConfirmationResDTO)comfirePayResDTO.getBody()).getRcptNoRepDTO().getRcptNo());
        return FrontResponse.success((String)param.getTransactionId(), (Object)comfirmPayNewRes);
    }

    public FrontResponse<GetPayRecordsRes> getPayRecords(FrontRequest<GetPayRecordsReq> param) {
        GetPayRecordsRes getPayRecordsRes = new GetPayRecordsRes();
        GetPayRecordsReqDTO getPayRecordsReqDTO = new GetPayRecordsReqDTO();
        getPayRecordsReqDTO.setCardNo(((GetPayRecordsReq)param.getBody()).getCardNo());
        getPayRecordsReqDTO.setStartDate(((GetPayRecordsReq)param.getBody()).getStartDate());
        getPayRecordsReqDTO.setEndDate(((GetPayRecordsReq)param.getBody()).getEndDate());
        HashMap<String, GetPayRecordsReqDTO> recordsMap = new HashMap<String, GetPayRecordsReqDTO>();
        recordsMap.put(EntityKeyEnum.GET_PAY_RECORDS.getValue(), getPayRecordsReqDTO);
        FrontResponse recordsResDTO = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.OUTPATIENT_LIST_INQUIRY.getValue(), recordsMap, GetPayRecordsResDTO.class);
        if (null == recordsResDTO) {
            return FrontResponse.error((String)recordsResDTO.getTransactionId(), (String)"0", (String)recordsResDTO.getMessage());
        }
        if (!"1".equals(((GetPayRecordsResDTO)recordsResDTO.getBody()).getResultCode())) {
            return FrontResponse.error((String)recordsResDTO.getTransactionId(), (String)"0", (String)((GetPayRecordsResDTO)recordsResDTO.getBody()).getResultMsg());
        }
        List getPayRecordsResItemDTOList = ((GetPayRecordsResDTO)recordsResDTO.getBody()).getItem();
        if (CollectionUtils.isEmpty((Collection)getPayRecordsResItemDTOList)) {
            return FrontResponse.error((String)recordsResDTO.getTransactionId(), (String)"0", (String)((GetPayRecordsResDTO)recordsResDTO.getBody()).getResultMsg());
        }
        ArrayList<GetPayRecordsResDetails> details = new ArrayList<GetPayRecordsResDetails>();
        ArrayList<GetPayRecordsResItems> items = new ArrayList<GetPayRecordsResItems>();
        for (GetPayRecordsResItemDTO getPayRecordsResItemDTO : getPayRecordsResItemDTOList) {
            GetPayRecordsResItems getPayRecordsResItems = new GetPayRecordsResItems();
            BeanUtils.copyProperties((Object)getPayRecordsResItemDTO, (Object)getPayRecordsResItems);
            getPayRecordsResItems.setAdmType("O");
            getPayRecordsResItems.setAdmId(getPayRecordsResItemDTO.getClinicNo());
            List itemDetailDTOList = getPayRecordsResItemDTO.getPayRecordsResItemDetailDTOList();
            for (GetPayRecordsResItemDetailDTO itemDetailDTO : itemDetailDTOList) {
                GetPayRecordsResDetails getPayRecordsResDetails = new GetPayRecordsResDetails();
                BeanUtils.copyProperties((Object)itemDetailDTO, (Object)getPayRecordsResDetails);
                details.add(getPayRecordsResDetails);
            }
            getPayRecordsResItems.setDetails(details);
            items.add(getPayRecordsResItems);
        }
        getPayRecordsRes.setCardNo(((GetPayRecordsReq)param.getBody()).getCardNo());
        getPayRecordsRes.setName(((GetPayRecordsResItemDTO)getPayRecordsResItemDTOList.get(0)).getPatientname());
        getPayRecordsRes.setItems(items);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getPayRecordsRes);
    }

    public FrontResponse<GetPayRecordsRes> queryOutpatientMainInfo(FrontRequest<GetPayRecordsReq> param) {
        GetPayRecordsReq body = (GetPayRecordsReq)param.getBody();
        QueryMainInfoDTO queryMainInfoDTO = QueryMainInfoDTO.builder().queryNum(body.getCardNo()).queryType("1").startTime(body.getStartDate()).endTime(body.getEndDate()).build();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(EntityKeyEnum.QUERY_OUTPATIENT_MAIN_INFO.getValue(), queryMainInfoDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_OUTPATIENT_MAIN_INFO.getValue(), map, QueryOutpatientMainInfoResDTO.class);
        if (null == response) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (!"1".equals(((QueryOutpatientMainInfoResDTO)response.getBody()).getBaseReturnResultRepDTO().getResultCode())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)((QueryOutpatientMainInfoResDTO)response.getBody()).getBaseReturnResultRepDTO().getResultMsg());
        }
        List item = ((QueryOutpatientMainInfoResDTO)response.getBody()).getItem();
        if (CollectionUtils.isEmpty((Collection)item)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)((QueryOutpatientMainInfoResDTO)response.getBody()).getBaseReturnResultRepDTO().getResultMsg());
        }
        GetPayRecordsRes getPayRecordsRes = new GetPayRecordsRes();
        ArrayList<GetPayRecordsResItems> getPayRecordsResItemsArrayList = new ArrayList<GetPayRecordsResItems>();
        for (QueryOutpatientMainInfoItemDTO queryOutpatientMainInfoItemDTO : item) {
            getPayRecordsRes.setCardNo(queryOutpatientMainInfoItemDTO.getPatientID());
            getPayRecordsRes.setName(queryOutpatientMainInfoItemDTO.getPatientName());
            GetPayRecordsResItems getPayRecordsResItems = new GetPayRecordsResItems();
            getPayRecordsResItems.setId(queryOutpatientMainInfoItemDTO.getPatientID());
            getPayRecordsResItems.setPayDateTime(queryOutpatientMainInfoItemDTO.getPayTime());
            getPayRecordsResItems.setAmount(queryOutpatientMainInfoItemDTO.getTotalAmount());
            getPayRecordsResItems.setPayStatus("1");
            getPayRecordsResItems.setPayChannel("WECHA");
            getPayRecordsResItems.setAdmId(queryOutpatientMainInfoItemDTO.getFlowNo());
            getPayRecordsResItems.setAdmDate(queryOutpatientMainInfoItemDTO.getVisitDate());
            getPayRecordsResItems.setAdmType("0");
            getPayRecordsResItems.setDeptName(queryOutpatientMainInfoItemDTO.getDoDepartName());
            getPayRecordsResItems.setDeptCode(queryOutpatientMainInfoItemDTO.getDoDepartCode());
            getPayRecordsResItems.setDocCode(queryOutpatientMainInfoItemDTO.getDoctorCode());
            getPayRecordsResItems.setDocName(queryOutpatientMainInfoItemDTO.getDoctorName());
            QueryOutpatientInfoDTO queryOutpatientInfoDTO = QueryOutpatientInfoDTO.builder().patientID(body.getCardNo()).rcptNo(queryOutpatientMainInfoItemDTO.getRcptNo()).build();
            HashMap maoDb = new HashMap();
            map.put(EntityKeyEnum.QUERY_OUTPATIENT_INFO.getValue(), queryOutpatientInfoDTO);
            FrontResponse queryOutpatientInfoResDTOFrontResponse = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_OUTPATIENT_INFO.getValue(), maoDb, QueryOutpatientInfoResDTO.class);
            if (null == queryOutpatientInfoResDTOFrontResponse) {
                return FrontResponse.error((String)queryOutpatientInfoResDTOFrontResponse.getTransactionId(), (String)"0", (String)queryOutpatientInfoResDTOFrontResponse.getMessage());
            }
            if (!"1".equals(((QueryOutpatientInfoResDTO)queryOutpatientInfoResDTOFrontResponse.getBody()).getBaseReturnResultRepDTO().getResultCode())) {
                return FrontResponse.error((String)queryOutpatientInfoResDTOFrontResponse.getTransactionId(), (String)"0", (String)((QueryOutpatientInfoResDTO)queryOutpatientInfoResDTOFrontResponse.getBody()).getBaseReturnResultRepDTO().getResultMsg());
            }
            List queryOutpatientInfoItemDTOS = ((QueryOutpatientInfoResDTO)queryOutpatientInfoResDTOFrontResponse.getBody()).getItem();
            if (CollectionUtils.isEmpty((Collection)queryOutpatientInfoItemDTOS)) {
                return FrontResponse.error((String)queryOutpatientInfoResDTOFrontResponse.getTransactionId(), (String)"0", (String)((QueryOutpatientInfoResDTO)queryOutpatientInfoResDTOFrontResponse.getBody()).getBaseReturnResultRepDTO().getResultMsg());
            }
            ArrayList<GetPayRecordsResDetails> getPayRecordsResDetailsArrayList = new ArrayList<GetPayRecordsResDetails>();
            for (QueryOutpatientInfoItemDTO queryOutpatientInfoItemDTO : queryOutpatientInfoItemDTOS) {
                GetPayRecordsResDetails getPayRecordsResDetails = new GetPayRecordsResDetails();
                getPayRecordsResDetails.setId(queryOutpatientInfoItemDTO.getFlowNo());
                getPayRecordsResDetails.setDesc(queryOutpatientInfoItemDTO.getBillName());
                getPayRecordsResDetails.setInsuCode(queryOutpatientInfoItemDTO.getCode());
                getPayRecordsResDetails.setUnit(queryOutpatientInfoItemDTO.getBillUnit());
                getPayRecordsResDetails.setPrice(queryOutpatientInfoItemDTO.getBillPrice());
                getPayRecordsResDetails.setQty(queryOutpatientInfoItemDTO.getBillCount());
                getPayRecordsResDetails.setSum(queryOutpatientInfoItemDTO.getTotalCost());
                getPayRecordsResDetailsArrayList.add(getPayRecordsResDetails);
            }
            getPayRecordsResItems.setDetails(getPayRecordsResDetailsArrayList);
            getPayRecordsResItemsArrayList.add(getPayRecordsResItems);
        }
        getPayRecordsRes.setItems(getPayRecordsResItemsArrayList);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getPayRecordsRes);
    }

    public FrontResponse<GetPayRecordsRes> queryOutpatientInfo(FrontRequest<GetPayRecordsReq> param) {
        GetPayRecordsReq body = (GetPayRecordsReq)param.getBody();
        QueryOutpatientInfoDTO queryOutpatientInfoDTO = QueryOutpatientInfoDTO.builder().patientID(body.getCardNo()).build();
        HashMap<String, QueryOutpatientInfoDTO> map = new HashMap<String, QueryOutpatientInfoDTO>();
        map.put(EntityKeyEnum.QUERY_OUTPATIENT_INFO.getValue(), queryOutpatientInfoDTO);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_OUTPATIENT_INFO.getValue(), map, QueryOutpatientInfoResDTO.class);
        if (null == response) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)response.getMessage());
        }
        if (!"1".equals(((QueryOutpatientInfoResDTO)response.getBody()).getBaseReturnResultRepDTO().getResultCode())) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)((QueryOutpatientInfoResDTO)response.getBody()).getBaseReturnResultRepDTO().getResultMsg());
        }
        List item = ((QueryOutpatientInfoResDTO)response.getBody()).getItem();
        if (CollectionUtils.isEmpty((Collection)item)) {
            return FrontResponse.error((String)response.getTransactionId(), (String)"0", (String)((QueryOutpatientInfoResDTO)response.getBody()).getBaseReturnResultRepDTO().getResultMsg());
        }
        return null;
    }
}

