/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.pojo.dto.GetTokenResDto;
import com.ebaiyihui.his.pojo.dto.PayOrderReqDTO;
import com.ebaiyihui.his.pojo.dto.PayOrderResDTO;
import com.ebaiyihui.his.pojo.dto.QueryPaymentReqVO;
import com.ebaiyihui.his.pojo.dto.QueryPaymentResVO;
import com.ebaiyihui.his.pojo.dto.RefundPaymentResVo;
import com.ebaiyihui.his.pojo.vo.GetTokenReqVo;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.pay.PayOrderReqVo;
import com.ebaiyihui.his.pojo.vo.pay.PaymentResVo;
import com.ebaiyihui.his.pojo.vo.pay.QueryPaymentReqVo;
import com.ebaiyihui.his.pojo.vo.pay.QueryPaymentResVo;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.PayService;
import com.ebaiyihui.his.utils.CxfClientUtil;
import com.ebaiyihui.his.utils.XmlTemplateKit;
import com.ebaiyihui.his.utils.XmlUtil;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PayServiceImpl
implements PayService {
    private static final Logger log = LoggerFactory.getLogger(PayServiceImpl.class);
    @Autowired
    private HisRemoteService hisRemoteService;
    @Value(value="${his.payUrl}")
    public String payUrl;
    @Value(value="${his.payCallBlank}")
    private String payCallBlank;
    private CxfClientUtil cxfClientUtil = new CxfClientUtil();

    public FrontResponse<PaymentResVo> advancePayment(FrontRequest<PayOrderReqVo> param) {
        String token = this.getToken();
        PayOrderReqVo body = (PayOrderReqVo)param.getBody();
        PayOrderReqDTO payOrderReqDTO = new PayOrderReqDTO();
        BeanUtils.copyProperties((Object)body, (Object)payOrderReqDTO);
        payOrderReqDTO.setToken(token);
        payOrderReqDTO.setNotifyUrl(body.getNotifyUrl());
        HashMap<String, PayOrderReqDTO> map = new HashMap<String, PayOrderReqDTO>();
        map.put(EntityKeyEnum.PAY_ORDER.getValue(), payOrderReqDTO);
        String requestHisXml = XmlTemplateKit.process((String)"8888", map);
        if (StringUtils.isEmpty((CharSequence)requestHisXml)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        log.info("requestHisXml\u6a21\u677f\uff1a" + JSON.toJSONString((Object)requestHisXml));
        String responseHisXml = this.cxfClientUtil.send(this.payUrl, "Services", requestHisXml);
        if (StringUtils.isEmpty((CharSequence)responseHisXml)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8bf7\u6c42\u652f\u4ed8\u5931\u8d25");
        }
        responseHisXml = responseHisXml.replace("&lt;", "<");
        responseHisXml = responseHisXml.replace("&gt;", ">");
        responseHisXml = responseHisXml.replace("<?xml version=\"1.0\" encoding=\"utf-8\"?>", "");
        responseHisXml = responseHisXml.replace("<string xmlns=\"http://tempuri.org/\">", "");
        responseHisXml = responseHisXml.replace("</string>", "");
        responseHisXml = responseHisXml.replace("\r\n", "");
        log.info("xml\u5904\u7406\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)responseHisXml));
        PayOrderResDTO resHisDTO = (PayOrderResDTO)XmlUtil.convertToJavaBean((String)responseHisXml, PayOrderResDTO.class);
        log.info("JSON\u8f6c\u6362\u540e\u7684\u8fd4\u56de\u503c:{}", (Object)JSON.toJSONString((Object)resHisDTO));
        if (!"0".equals(resHisDTO.getResultCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)resHisDTO.getResultMessage());
        }
        PaymentResVo paymentResVo = new PaymentResVo();
        paymentResVo.setMsg(resHisDTO.getPayMsg());
        paymentResVo.setSourceOrderId(resHisDTO.getSourceOrderId());
        return FrontResponse.success((String)param.getTransactionId(), (Object)paymentResVo);
    }

    public FrontResponse<QueryPaymentResVo> queryPayment(FrontRequest<QueryPaymentReqVo> param) {
        String token = this.getToken();
        QueryPaymentReqVo body = (QueryPaymentReqVo)param.getBody();
        QueryPaymentReqVO queryPayMentReqVo = new QueryPaymentReqVO();
        queryPayMentReqVo.setSourceOrderId(body.getSourceOrderId());
        queryPayMentReqVo.setToken(token);
        HashMap<String, QueryPaymentReqVO> map = new HashMap<String, QueryPaymentReqVO>();
        map.put(EntityKeyEnum.QUERY_PAY_TYPE.getValue(), queryPayMentReqVo);
        String requestHisXml = XmlTemplateKit.process((String)"9999", map);
        if (StringUtils.isEmpty((CharSequence)requestHisXml)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        log.info("requestHisXml\u6a21\u677f\uff1a" + JSON.toJSONString((Object)requestHisXml));
        String responseHisXml = this.cxfClientUtil.send(this.payUrl, "Services", requestHisXml);
        if (StringUtils.isEmpty((CharSequence)responseHisXml)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u652f\u4ed8\u7ed3\u679c\u8bf7\u6c42\u5931\u8d25");
        }
        responseHisXml = responseHisXml.replace("&lt;", "<");
        responseHisXml = responseHisXml.replace("&gt;", ">");
        responseHisXml = responseHisXml.replace("<?xml version=\"1.0\" encoding=\"utf-8\"?>", "");
        responseHisXml = responseHisXml.replace("<string xmlns=\"http://tempuri.org/\">", "");
        responseHisXml = responseHisXml.replace("</string>", "");
        responseHisXml = responseHisXml.replace("\r\n", "");
        log.info("xml\u5904\u7406\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)responseHisXml));
        QueryPaymentResVO queryPaymentResVO = (QueryPaymentResVO)XmlUtil.convertToJavaBean((String)responseHisXml, QueryPaymentResVO.class);
        log.info("JSON\u8f6c\u6362\u540e\u7684\u8fd4\u56de\u503c:{}", (Object)JSON.toJSONString((Object)queryPaymentResVO));
        if (!"0".equals(queryPaymentResVO.getResultCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)queryPaymentResVO.getResultMessage());
        }
        QueryPaymentResVO queryPaymentResVo = new QueryPaymentResVO();
        BeanUtils.copyProperties((Object)queryPaymentResVO, (Object)queryPaymentResVo);
        return FrontResponse.success((String)param.getTransactionId(), (Object)queryPaymentResVo);
    }

    public FrontResponse<RefundPaymentResVo> refundPayment(FrontRequest<QueryPaymentReqVo> param) {
        String token = this.getToken();
        QueryPaymentReqVo body = (QueryPaymentReqVo)param.getBody();
        QueryPaymentReqVO queryPayMentReqVo = new QueryPaymentReqVO();
        queryPayMentReqVo.setSourceOrderId(body.getSourceOrderId());
        queryPayMentReqVo.setToken(token);
        queryPayMentReqVo.setSourceRefundOrderId(body.getSourceRefundOrderId());
        queryPayMentReqVo.setTotalFee(body.getTotalFee());
        queryPayMentReqVo.setRefundFee(body.getRefundFee());
        HashMap<String, QueryPaymentReqVO> map = new HashMap<String, QueryPaymentReqVO>();
        map.put(EntityKeyEnum.REFUND_PAYMENT.getValue(), queryPayMentReqVo);
        String requestHisXml = XmlTemplateKit.process((String)"8000", map);
        if (StringUtils.isEmpty((CharSequence)requestHisXml)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u53c2\u6570\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        log.info("requestHisXml\u6a21\u677f\uff1a" + JSON.toJSONString((Object)requestHisXml));
        String responseHisXml = this.cxfClientUtil.send(this.payUrl, "Services", requestHisXml);
        if (StringUtils.isEmpty((CharSequence)responseHisXml)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u652f\u4ed8\u7ed3\u679c\u8bf7\u6c42\u5931\u8d25");
        }
        responseHisXml = responseHisXml.replace("&lt;", "<");
        responseHisXml = responseHisXml.replace("&gt;", ">");
        responseHisXml = responseHisXml.replace("<?xml version=\"1.0\" encoding=\"utf-8\"?>", "");
        responseHisXml = responseHisXml.replace("<string xmlns=\"http://tempuri.org/\">", "");
        responseHisXml = responseHisXml.replace("</string>", "");
        responseHisXml = responseHisXml.replace("\r\n", "");
        log.info("xml\u5904\u7406\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)responseHisXml));
        RefundPaymentResVo refundPaymentResVo = (RefundPaymentResVo)XmlUtil.convertToJavaBean((String)responseHisXml, RefundPaymentResVo.class);
        log.info("JSON\u8f6c\u6362\u540e\u7684\u8fd4\u56de\u503c:{}", (Object)JSON.toJSONString((Object)refundPaymentResVo));
        if (!"0".equals(refundPaymentResVo.getResultCode())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)refundPaymentResVo.getResultMessage());
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)refundPaymentResVo);
    }

    private String getToken() {
        GetTokenReqVo getTokenReqVo = new GetTokenReqVo();
        getTokenReqVo.setKey("1dP/OvQeRUVLLq0NEOMIe7VHDW8hCOXDWV0/RyGpKfSO402goasBaE2PjN04zBRjq1JqjwUSniGWLka+n93ycSLckPf6qD+sEb1s38PDlH0qH0m8a9Tt7PF2xyABCa+loPX+t818mUJG0guWf4uDrA==");
        String param = JSON.toJSONString((Object)getTokenReqVo);
        HashMap<String, GetTokenReqVo> map = new HashMap<String, GetTokenReqVo>();
        map.put(EntityKeyEnum.PAY_ORDER.getValue(), getTokenReqVo);
        String getToken = this.cxfClientUtil.send(this.payUrl, "GetToken", param);
        log.info("\u83b7\u53d6token\u7684\u8fd4\u56de\u503c\u4e3a:{}", (Object)getToken);
        if (StringUtils.isEmpty((CharSequence)getToken)) {
            return null;
        }
        GetTokenResDto getTokenResDto = (GetTokenResDto)JSON.parseObject((String)getToken, GetTokenResDto.class);
        return getTokenResDto.getToken();
    }
}

