/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.model.GetReportListReq;
import com.ebaiyihui.his.model.GetReportListRes;
import com.ebaiyihui.his.model.PacsReportRes;
import com.ebaiyihui.his.model.QueryInspectionInfoRes;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsReq;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsRes;
import com.ebaiyihui.his.pojo.vo.report.LisReportListReq;
import com.ebaiyihui.his.pojo.vo.report.LisReportListRes;
import com.ebaiyihui.his.pojo.vo.report.PacsReportListReq;
import com.ebaiyihui.his.pojo.vo.report.PacsReportListRes;
import com.ebaiyihui.his.pojo.vo.report.QueryDischargeRecordRes;
import com.ebaiyihui.his.pojo.vo.report.VhisCyjlModel;
import com.ebaiyihui.his.pojo.vo.report.datas.GetReportListsData;
import com.ebaiyihui.his.pojo.vo.report.datas.LisReportListResData;
import com.ebaiyihui.his.service.ElectronicReportService;
import com.ebaiyihui.his.utils.DateUtil;
import com.ebaiyihui.his.utils.HeadUtil;
import com.ebaiyihui.his.utils.HttpUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ElectronicReportServiceImpl
implements ElectronicReportService {
    private static final Logger log = LoggerFactory.getLogger(ElectronicReportServiceImpl.class);
    @Value(value="${his.wsdlUrl}")
    public String hisWsdlUrl;

    public FrontResponse<GetReportListsRes> getReportLists(FrontRequest<GetReportListsReq> param) {
        GetReportListsReq paramBody = (GetReportListsReq)param.getBody();
        String reportType = paramBody.getReportType();
        GetReportListReq getReportListReq = new GetReportListReq();
        getReportListReq.setIdNo(paramBody.getCardNo());
        getReportListReq.setIDTypeCode("01");
        if (Objects.equals(reportType, "1")) {
            getReportListReq.setReportType("JY");
        }
        getReportListReq.setStartTime(DateUtil.getLastYear());
        getReportListReq.setEndTime(DateUtil.getCurrentDateToString());
        GetReportListsRes getReportListsRes = new GetReportListsRes();
        getReportListsRes.setSuccess("1");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Head", HeadUtil.getHead((String)""));
        map.put("Data", getReportListReq);
        String url = this.hisWsdlUrl.concat("/RECenter/GetReportList");
        log.info("\u67e5\u8be2\u60a3\u8005\u7535\u5b50\u62a5\u544a\u5217\u8868:{}", (Object)JSON.toJSONString(map));
        String responseBody = null;
        try {
            responseBody = HttpUtils.doPost((String)url, (String)JSON.toJSONString(map));
            log.info("\u8fd4\u56de\u60a3\u8005\u7535\u5b50\u62a5\u544a\u5217\u8868:{}", (Object)responseBody);
            GetReportListRes response = (GetReportListRes)JSON.parseObject((String)responseBody, GetReportListRes.class);
            if (Objects.nonNull(response)) {
                GetReportListRes.HeadDTO head = response.getHead();
                String responseCode = head.getResponseCode();
                if (Objects.equals("AA", responseCode)) {
                    List data = response.getData();
                    for (GetReportListRes.DataDTO datum : data) {
                        getReportListsRes.setPatientID(datum.getPatient().getPatientId());
                        getReportListsRes.setPatientName(datum.getPatient().getPatientName());
                        List reportInfo = datum.getReportInfo();
                        ArrayList<GetReportListsData> datas = new ArrayList<GetReportListsData>();
                        for (GetReportListRes.DataDTO.ReportInfoDTO reportInfoDTO : reportInfo) {
                            GetReportListsData getReportListsData = new GetReportListsData();
                            getReportListsData.setReportNo(reportInfoDTO.getReportNo());
                            getReportListsData.setReportName(reportInfoDTO.getReportName());
                            getReportListsData.setReportType(reportType);
                            getReportListsData.setReportDate(reportInfoDTO.getTSVerify());
                            datas.add(getReportListsData);
                        }
                        List collect = datas.stream().sorted(Comparator.comparing(GetReportListsData::getReportDate).reversed()).collect(Collectors.toList());
                        getReportListsRes.setDatas(collect);
                    }
                    return FrontResponse.success((String)param.getTransactionId(), (Object)getReportListsRes);
                }
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)head.getResponseDesc());
            }
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8bf7\u6c42his\u5931\u8d25");
        }
        catch (Exception e) {
            e.printStackTrace();
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8bf7\u6c42his\u5931\u8d25");
        }
    }

    public FrontResponse<LisReportListRes> queryInspectionInfo(FrontRequest<LisReportListReq> param) {
        LisReportListReq paramBody = (LisReportListReq)param.getBody();
        GetReportListReq getReportListReq = new GetReportListReq();
        getReportListReq.setIdentifierNo(paramBody.getReportNo());
        getReportListReq.setIdentifierNoType("YWID");
        getReportListReq.setReportType("JY");
        getReportListReq.setStartTime(DateUtil.getLastYear());
        getReportListReq.setEndTime(DateUtil.getCurrentDateToString());
        LisReportListRes lisReportListRes = new LisReportListRes();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Head", HeadUtil.getHead((String)""));
        map.put("Data", getReportListReq);
        String url = this.hisWsdlUrl.concat("/RECenter/GetLisReportInfo");
        log.info("\u67e5\u8be2\u60a3\u8005\u68c0\u9a8c\u62a5\u544a\u5217\u8868:{}", (Object)JSON.toJSONString(map));
        String responseBody = null;
        try {
            responseBody = HttpUtils.doPost((String)url, (String)JSON.toJSONString(map));
            log.info("\u8fd4\u56de\u60a3\u8005\u68c0\u9a8c\u5217\u8868:{}", (Object)responseBody);
            QueryInspectionInfoRes response = (QueryInspectionInfoRes)JSON.parseObject((String)responseBody, QueryInspectionInfoRes.class);
            if (Objects.nonNull(response)) {
                QueryInspectionInfoRes.HeadDTO head = response.getHead();
                if (Objects.equals("AA", head.getResponseCode())) {
                    List data = response.getData();
                    ArrayList<LisReportListResData> datas = new ArrayList<LisReportListResData>();
                    for (QueryInspectionInfoRes.DataDTO datum : data) {
                        lisReportListRes.setPatientName(datum.getPatient().getPatientName());
                        lisReportListRes.setPatientNo(datum.getPatient().getPatientId());
                        List reportInfo = datum.getReportInfo();
                        for (QueryInspectionInfoRes.DataDTO.ReportInfoDTO reportInfoDTO : reportInfo) {
                            if (!Objects.equals(reportInfoDTO.getReportNo(), paramBody.getReportNo())) continue;
                            lisReportListRes.setReportNo(reportInfoDTO.getReportNo());
                            lisReportListRes.setReportName(reportInfoDTO.getReportName());
                            lisReportListRes.setDeptName(reportInfoDTO.getExamDeptName());
                            lisReportListRes.setDoctorName(reportInfoDTO.getReportDocName());
                            lisReportListRes.setSpecName(reportInfoDTO.getSampleDesc());
                            lisReportListRes.setSpecNo(reportInfoDTO.getSampleNo());
                            lisReportListRes.setRecTime(reportInfoDTO.getReciveTime());
                            lisReportListRes.setRecUser(reportInfoDTO.getReciveDocName());
                            lisReportListRes.setAuthTime(reportInfoDTO.getVerifiTime());
                            lisReportListRes.setAuthUser(reportInfoDTO.getVerifiDocName());
                            lisReportListRes.setColTime(reportInfoDTO.getSampleTime());
                            lisReportListRes.setAdmType(datum.getVisitInfo().getVisitType());
                            List result = reportInfoDTO.getResult();
                            for (QueryInspectionInfoRes.DataDTO.ReportInfoDTO.ResultDTO resultDTO : result) {
                                LisReportListResData lisReportListResData = new LisReportListResData();
                                lisReportListResData.setItmCode(resultDTO.getItemCode());
                                lisReportListResData.setItmName(resultDTO.getItemName());
                                lisReportListResData.setItmType(resultDTO.getPrintValue());
                                lisReportListResData.setItmRes(resultDTO.getPrintValue());
                                lisReportListResData.setItmUnit(resultDTO.getResultUnit());
                                lisReportListResData.setItmRanges(resultDTO.getReferenceText());
                                lisReportListResData.setItmCrises(resultDTO.getAbnormalFlag());
                                datas.add(lisReportListResData);
                            }
                            lisReportListRes.setDatas(datas);
                        }
                    }
                    return FrontResponse.success((String)param.getTransactionId(), (Object)lisReportListRes);
                }
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)head.getResponseDesc());
            }
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8bf7\u6c42his\u5931\u8d25");
        }
        catch (Exception e) {
            e.printStackTrace();
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8bf7\u6c42his\u5931\u8d25");
        }
    }

    public FrontResponse<PacsReportListRes> pacsReportList(FrontRequest<PacsReportListReq> param) {
        PacsReportListReq paramBody = (PacsReportListReq)param.getBody();
        GetReportListReq getReportListReq = new GetReportListReq();
        getReportListReq.setIdentifierNo(paramBody.getReportNo());
        getReportListReq.setIdentifierNoType("YWID");
        getReportListReq.setStartTime(DateUtil.getLastYear());
        getReportListReq.setEndTime(DateUtil.getCurrentDateToString());
        PacsReportListRes pacsReportListRes = new PacsReportListRes();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Head", HeadUtil.getHead((String)""));
        map.put("Data", getReportListReq);
        String url = this.hisWsdlUrl.concat("/RECenter/GetRisReportInfo");
        log.info("\u67e5\u8be2\u60a3\u8005\u68c0\u67e5\u62a5\u544a\u5217\u8868:{}", (Object)JSON.toJSONString(map));
        String responseBody = null;
        try {
            responseBody = HttpUtils.doPost((String)url, (String)JSON.toJSONString(map));
            log.info("\u8fd4\u56de\u60a3\u8005\u68c0\u67e5\u5217\u8868:{}", (Object)responseBody);
            PacsReportRes response = (PacsReportRes)JSON.parseObject((String)responseBody, PacsReportRes.class);
            if (Objects.nonNull(response)) {
                PacsReportRes.HeadDTO head = response.getHead();
                if (Objects.equals(head.getResponseCode(), "AA")) {
                    List data = response.getData();
                    for (PacsReportRes.DataDTO datum : data) {
                        PacsReportRes.DataDTO.PatientDTO patient = datum.getPatient();
                        pacsReportListRes.setPatientName(patient.getPatientName());
                        pacsReportListRes.setPatientNo(patient.getPatientId());
                        pacsReportListRes.setSex(patient.getSex());
                        pacsReportListRes.setAge(patient.getAge());
                        pacsReportListRes.setReportNo(datum.getReportInfo().getReportNo());
                        pacsReportListRes.setReportName(datum.getReportInfo().getReportName());
                        pacsReportListRes.setDeptName(datum.getApplyOrderInfo().getApplyDeptName());
                        pacsReportListRes.setDoctorName(datum.getApplyOrderInfo().getApplyDocName());
                        pacsReportListRes.setAuthTime(datum.getReportInfo().getVerifiTime());
                        pacsReportListRes.setAuthUser(datum.getReportInfo().getVerifiDocName());
                        pacsReportListRes.setAdmType(datum.getVisitInfo().getVisitType());
                        pacsReportListRes.setCheckDesc(datum.getReportInfo().getExamFind());
                        pacsReportListRes.setCheckResult(datum.getReportInfo().getExamConclusion());
                    }
                    return FrontResponse.success((String)param.getTransactionId(), (Object)pacsReportListRes);
                }
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)head.getResponseDesc());
            }
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8bf7\u6c42his\u5931\u8d25");
        }
        catch (Exception e) {
            e.printStackTrace();
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8bf7\u6c42his\u5931\u8d25");
        }
    }

    public FrontResponse<QueryDischargeRecordRes> queryDischargeRecord(FrontRequest<PacsReportListReq> param) {
        QueryDischargeRecordRes queryDischargeRecordRes = new QueryDischargeRecordRes();
        PacsReportListReq paramBody = (PacsReportListReq)param.getBody();
        ArrayList list = new ArrayList();
        String pastDate = DateUtil.getPastDate((int)7);
        ArrayList removeList = new ArrayList();
        list.stream().forEach(x -> {
            boolean bool;
            String ysname = x.getYsname();
            if (Objects.equals("\u51fa\u9662\u65e5\u671f", ysname) && !(bool = DateUtil.timeRange((String)pastDate, (String)x.getValue()))) {
                removeList.add(x.getInpatientNo());
            }
        });
        Map<String, List<VhisCyjlModel>> inspectionModelsMap = list.stream().collect(Collectors.groupingBy(VhisCyjlModel::getInpatientNo));
        for (String key : removeList) {
            inspectionModelsMap.remove(key);
        }
        queryDischargeRecordRes.setRes(inspectionModelsMap);
        return FrontResponse.success((String)param.getTransactionId(), (Object)queryDischargeRecordRes);
    }

    public static void main(String[] args) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(1, -1);
        Date y = calendar.getTime();
        String year = format.format(y);
        System.out.println("\u8fc7\u53bb\u4e00\u5e74 \uff1a" + year);
        String now = format.format(new Date());
        System.out.println("\u73b0\u5728\u65e5\u671f \uff1a" + now);
        calendar.setTime(new Date());
        calendar.add(5, -7);
        Date d = calendar.getTime();
        String day = format.format(d);
        System.out.println("\u8fc7\u53bb\u4e03\u5929 \uff1a" + day);
        calendar.setTime(new Date());
        calendar.add(2, -1);
        Date m = calendar.getTime();
        String mon = format.format(m);
        System.out.println("\u8fc7\u53bb\u4e00\u4e2a\u6708\uff1a" + mon);
        calendar.setTime(new Date());
        calendar.add(2, -3);
        Date m3 = calendar.getTime();
        String mon3 = format.format(m3);
        System.out.println("\u8fc7\u53bb\u4e09\u4e2a\u6708\uff1a" + mon3);
    }
}

