/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.pojo.dto.GetBillResDTO;
import com.ebaiyihui.his.pojo.dto.GetRealTimeHisBillItemResDTO;
import com.ebaiyihui.his.pojo.dto.GetRealTimeHisBillReqDTO;
import com.ebaiyihui.his.pojo.dto.GetRealTimeHisBillResDTO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.bill.GetHisBillInfoReqVo;
import com.ebaiyihui.his.pojo.vo.bill.GetHisBillInfoRes;
import com.ebaiyihui.his.pojo.vo.bill.GetHisBillInfoResItem;
import com.ebaiyihui.his.pojo.vo.bill.GetRealTimeHisBillInfoRes;
import com.ebaiyihui.his.pojo.vo.bill.GetRealTimeHisBillReqVo;
import com.ebaiyihui.his.pojo.vo.bill.RefundCallBackReq;
import com.ebaiyihui.his.pojo.vo.bill.RefundCallBackRes;
import com.ebaiyihui.his.service.HisBillService;
import com.ebaiyihui.his.service.HisRemoteService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HisBillServiceImpl
implements HisBillService {
    public static final int MAP_SIZE = 1;
    public static final String SUCCESS_FLAG = "0";
    @Autowired
    private HisRemoteService hisRemoteService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public FrontResponse<GetHisBillInfoRes> getHisBillInfo(FrontRequest<GetHisBillInfoReqVo> param) {
        GetHisBillInfoRes getHisBillInfoRes = new GetHisBillInfoRes();
        ArrayList<GetHisBillInfoResItem> getHisBillInfoResItems = new ArrayList<GetHisBillInfoResItem>();
        GetHisBillInfoReqVo getHisBillInfoReqVo = (GetHisBillInfoReqVo)param.getBody();
        if (null == getHisBillInfoReqVo) {
            this.logger.error("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        GetRealTimeHisBillReqDTO getRealTimeHisBillReqDTO = GetRealTimeHisBillReqDTO.builder().build();
        HashMap<String, GetRealTimeHisBillReqDTO> map = new HashMap<String, GetRealTimeHisBillReqDTO>();
        map.put(EntityKeyEnum.BILL_DETAIL_INFO.getValue(), getRealTimeHisBillReqDTO);
        FrontResponse getRealTimeHisBillRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.BILLING_DETAIL_HIS_INQUIRY.getValue(), map, GetBillResDTO.class);
        GetBillResDTO hisBillResDTO = (GetBillResDTO)getRealTimeHisBillRes.getBody();
        if (null == hisBillResDTO) {
            return FrontResponse.error((String)getRealTimeHisBillRes.getTransactionId(), (String)"1", (String)hisBillResDTO.getResultMsg());
        }
        if (!SUCCESS_FLAG.equals(hisBillResDTO.getResultCode())) {
            return FrontResponse.error((String)getRealTimeHisBillRes.getTransactionId(), (String)SUCCESS_FLAG, (String)hisBillResDTO.getResultMsg());
        }
        List getRealTimeHisBillItemResDTOList = hisBillResDTO.getBillItemResDTO();
        if (CollectionUtils.isEmpty((Collection)getRealTimeHisBillItemResDTOList)) {
            return FrontResponse.error((String)getRealTimeHisBillRes.getTransactionId(), (String)SUCCESS_FLAG, (String)hisBillResDTO.getResultMsg());
        }
        for (GetRealTimeHisBillItemResDTO billItemResDTO : getRealTimeHisBillItemResDTOList) {
            GetHisBillInfoResItem infoResItem = new GetHisBillInfoResItem();
            BeanUtils.copyProperties((Object)billItemResDTO, (Object)infoResItem);
            getHisBillInfoResItems.add(infoResItem);
        }
        getHisBillInfoRes.setItems(getHisBillInfoResItems);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getHisBillInfoRes);
    }

    public FrontResponse<GetRealTimeHisBillInfoRes> getRealTimeHisBillInfo(FrontRequest<GetRealTimeHisBillReqVo> param) {
        ArrayList getRealTimeHisBillInfoResItems = new ArrayList();
        GetRealTimeHisBillReqVo getRealTimeHisBillReqVo = (GetRealTimeHisBillReqVo)param.getBody();
        if (null == getRealTimeHisBillReqVo) {
            this.logger.error("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        GetRealTimeHisBillReqDTO getRealTimeHisBillReqDTO = new GetRealTimeHisBillReqDTO();
        HashMap<String, GetRealTimeHisBillReqDTO> getRealTimeHisBillReqMap = new HashMap<String, GetRealTimeHisBillReqDTO>(1);
        getRealTimeHisBillReqMap.put(EntityKeyEnum.BILL_DETAIL_INFO.getValue(), getRealTimeHisBillReqDTO);
        FrontResponse getRealTimeHisBillRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.BILLING_REAL_TIME_HIS_INQUIRY.getValue(), getRealTimeHisBillReqMap, GetRealTimeHisBillResDTO.class);
        GetRealTimeHisBillResDTO hisBillResDTO = (GetRealTimeHisBillResDTO)getRealTimeHisBillRes.getBody();
        if (null == hisBillResDTO) {
            return FrontResponse.error((String)getRealTimeHisBillRes.getTransactionId(), (String)"1", (String)hisBillResDTO.getResultMsg());
        }
        if (!SUCCESS_FLAG.equals(hisBillResDTO.getResultCode())) {
            return FrontResponse.error((String)getRealTimeHisBillRes.getTransactionId(), (String)SUCCESS_FLAG, (String)hisBillResDTO.getResultMsg());
        }
        GetRealTimeHisBillInfoRes getRealTimeHisBillInfoRes = new GetRealTimeHisBillInfoRes();
        getRealTimeHisBillInfoRes.setItems(getRealTimeHisBillInfoResItems);
        return FrontResponse.success((String)getRealTimeHisBillRes.getTransactionId(), (Object)getRealTimeHisBillInfoRes);
    }

    public FrontResponse<RefundCallBackRes> refundCallBack(FrontRequest<RefundCallBackReq> param) {
        RefundCallBackRes refundCallBackRes = new RefundCallBackRes();
        refundCallBackRes.setState("1");
        return FrontResponse.success((String)param.getTransactionId(), (Object)refundCallBackRes);
    }
}

