/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.common.enums.EntityKeyEnum;
import com.ebaiyihui.his.common.enums.MethodCodeEnum;
import com.ebaiyihui.his.pojo.dto.QueryPrescriptionResDto;
import com.ebaiyihui.his.pojo.dto.ResponseDrugResDTO;
import com.ebaiyihui.his.pojo.vo.DrugListReqVo;
import com.ebaiyihui.his.pojo.vo.QueryPrescriptionReqVo;
import com.ebaiyihui.his.pojo.vo.QueryPrescriptionVo;
import com.ebaiyihui.his.pojo.vo.ResponseDrugResVo;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.service.HisRemoteService;
import com.ebaiyihui.his.service.MedicalCloudService;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MedicalCloudServiceImpl
implements MedicalCloudService {
    private static final Logger log = LoggerFactory.getLogger(MedicalCloudServiceImpl.class);
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<QueryPrescriptionVo> queryPrescription(FrontRequest<QueryPrescriptionReqVo> queryPrescriptionRequest) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(EntityKeyEnum.QUERY_PRESCRIPTION.getValue(), queryPrescriptionRequest.getBody());
        FrontResponse queryPrescriptionResponse = this.hisRemoteService.requestHis(queryPrescriptionRequest.getTransactionId(), MethodCodeEnum.QUERY_PRESCRIPTION.getValue(), map, QueryPrescriptionResDto.class);
        QueryPrescriptionResDto queryPrescriptionRes = (QueryPrescriptionResDto)queryPrescriptionResponse.getBody();
        if (null == queryPrescriptionRes) {
            FrontResponse.success((String)queryPrescriptionRequest.getTransactionId(), null);
        }
        if (!"1".equals(queryPrescriptionRes.getResultCode())) {
            return FrontResponse.success((String)queryPrescriptionRequest.getTransactionId(), null);
        }
        QueryPrescriptionVo queryPrescription = queryPrescriptionRes.getQueryPrescriptionVo();
        return FrontResponse.success((String)queryPrescriptionRequest.getTransactionId(), (Object)queryPrescription);
    }

    public FrontResponse<ResponseDrugResVo> getDrugList(FrontRequest<DrugListReqVo> frontRequest) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(EntityKeyEnum.GET_DRUG_LIST.getValue(), frontRequest.getBody());
        FrontResponse dtoFrontResponse = this.hisRemoteService.requestHis(frontRequest.getTransactionId(), MethodCodeEnum.GET_DRUG_LIST.getValue(), map, ResponseDrugResDTO.class);
        ResponseDrugResDTO responseDrug = (ResponseDrugResDTO)dtoFrontResponse.getBody();
        if (null == responseDrug) {
            return FrontResponse.error((String)frontRequest.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if (!"1".equals(responseDrug.getResult())) {
            return FrontResponse.error((String)frontRequest.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5931\u8d25");
        }
        ResponseDrugResVo responseDrugResVo = new ResponseDrugResVo();
        responseDrugResVo.setResult(responseDrug.getResult());
        responseDrugResVo.setErr(responseDrug.getErr());
        responseDrugResVo.setResponseDrugDetailList(responseDrug.getResponseDrugDetailList().getDrugDetailObjResDTO());
        return FrontResponse.success((String)frontRequest.getTransactionId(), (Object)responseDrugResVo);
    }
}

