/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medical.core.controller;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medical.core.exception.BillException;
import com.ebaiyihui.medical.core.service.BillService;
import com.ebaiyihui.medical.core.vo.repsvo.BillRespVo;
import com.ebaiyihui.medical.pojo.vo.DailyBillDetailItemsResVO;
import com.ebaiyihui.medical.pojo.vo.DailyBillDetailReqVO;
import com.ebaiyihui.medical.pojo.vo.TotalDailyBillDetailResVO;
import com.ebaiyihui.medical.pojo.vo.TotalDailyBillReqVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8d26\u5355api"})
@RequestMapping(value={"/api/v1/outpatient/bill/"})
public class BillController {
    private static final Logger log = LoggerFactory.getLogger(BillController.class);
    @Autowired
    private BillService billService;

    @ApiOperation(value="\u6839\u636ereceptId\u83b7\u53d6\u7b2c\u4e09\u65b9\u652f\u4ed8\u6d41\u6c34\u53f7", notes="\u6839\u636ereceptId\u83b7\u53d6\u7b2c\u4e09\u65b9\u652f\u4ed8\u6d41\u6c34\u53f7")
    @GetMapping(value={"getBillByReceptId"})
    public BaseResponse<List<BillRespVo>> getBillByReceptId(@RequestParam(value="receptIdList") List<String> receptIdList) {
        if (CollectionUtils.isEmpty(receptIdList)) {
            return BaseResponse.error((String)"\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        List billRespVoList = null;
        log.info("BillController.getBillByReceptId\u67e5\u8be2\u53c2\u6570\u4e3a->:{}", (Object)JSON.toJSONString(receptIdList));
        try {
            billRespVoList = this.billService.getBillByReceptId(receptIdList);
        }
        catch (BillException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)billRespVoList);
    }

    @ApiOperation(value="\u4f4f\u9662\u5bf9\u8d26", notes="\u8fd4\u56de\u4e09\u65b9\u6d41\u6c34\u53f7\u548c\u652f\u4ed8\u8d26\u5355\u53f7")
    @GetMapping(value={"hospitalReconciliation"})
    public BaseResponse<List<BillRespVo>> hospitalReconciliation(@RequestParam(value="receiptIdList") List<String> receiptIdList) {
        if (CollectionUtils.isEmpty(receiptIdList)) {
            return BaseResponse.error((String)"\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        return this.billService.hospitalReconciliation(receiptIdList);
    }

    @ApiOperation(value="\u95e8\u8bcahis\u5e73\u53f0\u5bf9\u8d26\u6c47\u603b\u63a5\u53e3", notes="\u95e8\u8bcahis\u5e73\u53f0\u5bf9\u8d26\u6c47\u603b\u63a5\u53e3")
    @PostMapping(value={"getOutPatientTotalBill"})
    public BaseResponse<TotalDailyBillDetailResVO> getOutPatientTotalDailyBill(@RequestBody TotalDailyBillReqVO req) {
        TotalDailyBillDetailResVO response = null;
        try {
            response = this.billService.getOutPatientTotalBill(req);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)response);
    }

    @ApiOperation(value="\u4f4f\u9662his\u5e73\u53f0\u5bf9\u8d26\u6c47\u603b\u63a5\u53e3", notes="\u4f4f\u9662his\u5e73\u53f0\u5bf9\u8d26\u6c47\u603b\u63a5\u53e3")
    @PostMapping(value={"getInHospTotalBill"})
    public BaseResponse<TotalDailyBillDetailResVO> getInHospTotalDailyBill(@RequestBody TotalDailyBillReqVO req) {
        TotalDailyBillDetailResVO response = null;
        try {
            response = this.billService.getInHospTotalBill(req);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)response);
    }

    @ApiOperation(value="\u95e8\u8bcahis\u5e73\u53f0\u5bf9\u8d26\u660e\u7ec6\u63a5\u53e3", notes="\u95e8\u8bcahis\u5e73\u53f0\u5bf9\u8d26\u660e\u7ec6\u63a5\u53e3")
    @PostMapping(value={"getOutPatientDetailBill"})
    public BaseResponse<List<DailyBillDetailItemsResVO>> getOutPatientDetailBill(@RequestBody DailyBillDetailReqVO req) {
        List response = null;
        try {
            response = this.billService.getOutPatientDetailBill(req);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)response);
    }

    @ApiOperation(value="\u4f4f\u9662his\u5e73\u53f0\u5bf9\u8d26\u660e\u7ec6\u63a5\u53e3", notes="\u4f4f\u9662his\u5e73\u53f0\u5bf9\u8d26\u660e\u7ec6\u63a5\u53e3")
    @PostMapping(value={"getInHospDetailBill"})
    public BaseResponse<List<DailyBillDetailItemsResVO>> getInHospDetailBill(@RequestBody DailyBillDetailReqVO req) {
        List response = null;
        try {
            response = this.billService.getInHospDetailBill(req);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)response);
    }
}

