/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medical.core.controller;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medical.core.exception.InHospitalException;
import com.ebaiyihui.medical.core.service.InHospitalService;
import com.ebaiyihui.medical.core.utils.StringUtil;
import com.ebaiyihui.medical.core.vo.repsvo.GetIhHospitalOrderItemsResVo;
import com.ebaiyihui.medical.core.vo.repsvo.GetInpAdmissionItemsResVO;
import com.ebaiyihui.medical.core.vo.repsvo.InHospDepositCreateOrderResVO;
import com.ebaiyihui.medical.core.vo.repsvo.InHospitalRechargeDetailResVO;
import com.ebaiyihui.medical.core.vo.reqvo.GetIhHospitalOrderItemsReqVo;
import com.ebaiyihui.medical.core.vo.reqvo.GetInpAdmissionReqVO;
import com.ebaiyihui.medical.core.vo.reqvo.InHospDepositCreateOrderReqVO;
import com.ebaiyihui.medical.core.vo.reqvo.InHospDepositPayReqVO;
import com.ebaiyihui.medical.core.vo.reqvo.InHospitalRechargeDetailReqVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u4f4f\u9662\u4e1a\u52a1api"})
@RequestMapping(value={"/api/v1/inHospital"})
public class InHospitalController {
    private static final Logger log = LoggerFactory.getLogger(InHospitalController.class);
    @Autowired
    private InHospitalService inHospitalService;

    @ApiOperation(value="\u4f4f\u9662\u9884\u4ea4\u91d1\u53ef\u9009\u91d1\u989d\u5217\u8868", notes="\u4f4f\u9662\u9884\u4ea4\u91d1\u53ef\u9009\u91d1\u989d\u5217\u8868")
    @GetMapping(value={"/getMoneysList"})
    public BaseResponse<List<String>> getMoneysList(@RequestParam(value="hospitalCode") String hospitalCode) {
        log.info("InHospitalController.getMoneysList\u8bf7\u6c42\u5165\u53c2hospitalCode\u4e3a:{}", (Object)hospitalCode);
        if (StringUtil.isBlank((String)hospitalCode)) {
            BaseResponse.error((String)"\u8bf7\u6c42\u53c2\u6570hospitalCode\u4e3a\u7a7a");
        }
        return BaseResponse.success((Object)this.inHospitalService.getMoneyList(hospitalCode));
    }

    @ApiOperation(value="\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55", notes="\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55")
    @PostMapping(value={"getInpAdmissionList"})
    public BaseResponse<List<GetInpAdmissionItemsResVO>> getInpAdmissionList(@Valid @RequestBody GetInpAdmissionReqVO getInpAdmissionReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        log.info("InHospitalController.getInpAdmissionList\u8bf7\u6c42\u5165\u53c2getInpAdmissionReqVO\u4e3a:{}", (Object)getInpAdmissionReqVO);
        List InpAdmissionList = null;
        try {
            InpAdmissionList = this.inHospitalService.getInpAdmissionItems(getInpAdmissionReqVO);
        }
        catch (InHospitalException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)InpAdmissionList);
    }

    @ApiOperation(value="\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6", notes="\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6")
    @PostMapping(value={"getInHospRechargeDetail"})
    public BaseResponse<InHospitalRechargeDetailResVO> getInHospRechargeDetail(@Valid @RequestBody InHospitalRechargeDetailReqVO inHospitalRechargeDetailReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        log.info("InHospitalController.getInHospRechargeDetail\u8bf7\u6c42\u5165\u53c2inHospitalRechargeDetailReqVO\u4e3a:{}", (Object)inHospitalRechargeDetailReqVO);
        InHospitalRechargeDetailResVO rechargeDetailResVO = null;
        try {
            rechargeDetailResVO = this.inHospitalService.getRechargeDetail(inHospitalRechargeDetailReqVO);
        }
        catch (InHospitalException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)rechargeDetailResVO);
    }

    @ApiOperation(value="\u4f4f\u9662\u9884\u4ea4\u91d1\u521b\u5efa\u8ba2\u5355", notes="\u4f4f\u9662\u9884\u4ea4\u91d1\u521b\u5efa\u8ba2\u5355")
    @PostMapping(value={"inHospDepositCreateOrder"})
    public BaseResponse<InHospDepositCreateOrderResVO> inHospDepositCreateOrder(@Valid @RequestBody InHospDepositCreateOrderReqVO inHospDepositCreateOrderReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        log.info("InHospitalController.inHospDepositCreateOrder\u8bf7\u6c42\u5165\u53c2inHospDepositCreateOrderReqVO\u4e3a:{}", (Object)inHospDepositCreateOrderReqVO);
        InHospDepositCreateOrderResVO inHospDepositCreateOrderResVO = null;
        try {
            inHospDepositCreateOrderResVO = this.inHospitalService.inHospDepositCreateOrder(inHospDepositCreateOrderReqVO);
        }
        catch (InHospitalException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)inHospDepositCreateOrderResVO);
    }

    @ApiOperation(value="\u4f4f\u9662\u9884\u4ea4\u91d1\u652f\u4ed8", notes="\u4f4f\u9662\u9884\u4ea4\u91d1\u652f\u4ed8")
    @PostMapping(value={"inHospDepositPay"})
    public BaseResponse<String> inHospDepositPay(@Valid @RequestBody InHospDepositPayReqVO inHospDepositPayReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        log.info("InHospitalController.inHospDepositPay\u8bf7\u6c42\u5165\u53c2inHospDepositPayReqVO\u4e3a:{}", (Object)inHospDepositPayReqVO);
        BaseResponse baseResponse = this.inHospitalService.InHospDepositPay(inHospDepositPayReqVO);
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355", notes="\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355")
    @PostMapping(value={"getHospitalOrderItems"})
    public BaseResponse<GetIhHospitalOrderItemsResVo> getHospitalOrderItems(@Valid @RequestBody GetIhHospitalOrderItemsReqVo getHospitalOrderItemsReqVo, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        log.info("InHospitalController.getHospitalOrderItems\u8bf7\u6c42\u5165\u53c2getHospitalOrderItemsReqVo\u4e3a:{}", (Object)getHospitalOrderItemsReqVo);
        GetIhHospitalOrderItemsResVo getIhHospitalOrderItemsResVo = null;
        try {
            getIhHospitalOrderItemsResVo = this.inHospitalService.getIhHospitalOrderItems(getHospitalOrderItemsReqVo);
        }
        catch (InHospitalException e) {
            BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)getIhHospitalOrderItemsResVo);
    }

    @ApiOperation(value="\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f", notes="\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f")
    @GetMapping(value={"/getOrderDetail"})
    public BaseResponse<InHospDepositCreateOrderResVO> getOrderDetail(@RequestParam(value="orderSeq") String orderSeq) {
        log.info("InHospitalController.getOrderDetail\u8bf7\u6c42\u5165\u53c2orderSeq\u4e3a:{}", (Object)orderSeq);
        InHospDepositCreateOrderResVO inHospDepositCreateOrderResVO = null;
        try {
            inHospDepositCreateOrderResVO = this.inHospitalService.getInHospDepositCreateOrderRes(orderSeq);
        }
        catch (Exception e) {
            BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)inHospDepositCreateOrderResVO);
    }
}

