/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medical.core.controller;

import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medical.core.service.OrderService;
import com.ebaiyihui.medical.core.vo.repsvo.CheckOrderResVo;
import com.ebaiyihui.medical.core.vo.repsvo.OrderRecordResVo;
import com.ebaiyihui.medical.core.vo.reqvo.CheckOrderReqVo;
import com.ebaiyihui.medical.core.vo.reqvo.OrderRecordReqVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8ba2\u5355api"})
@RequestMapping(value={"/api/v1/orderRecord"})
public class OrderRecordController {
    private static final Logger log = LoggerFactory.getLogger(OrderRecordController.class);
    @Autowired
    private OrderService orderService;

    @ApiOperation(value="\u95e8\u8bca\u7f34\u8d39\u5206\u9875\u83b7\u53d6\u7ba1\u7406\u7aef\u8ba2\u5355\u5217\u8868", notes="\u95e8\u8bca\u7f34\u8d39\u5206\u9875\u83b7\u53d6\u7ba1\u7406\u7aef\u8ba2\u5355\u5217\u8868")
    @GetMapping(value={"/getOrderList"})
    public BaseResponse<PageResult<OrderRecordResVo>> getOrderList(@Valid OrderRecordReqVo orderRecordReqVo, BindingResult bindingResult) {
        if (bindingResult.hasFieldErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        PageResult pageResult = null;
        try {
            pageResult = this.orderService.getOutPatientOrderList(orderRecordReqVo);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)pageResult);
    }

    @ApiOperation(value="\u95e8\u8bca\u7f34\u8d39\u8be6\u60c5\u5217\u8868", notes="\u95e8\u8bca\u7f34\u8d39\u8be6\u60c5\u5217\u8868")
    @GetMapping(value={"/getOrderListDetail"})
    public BaseResponse<CheckOrderResVo> getOrderListDetail(@Valid CheckOrderReqVo checkOrderReqVo, BindingResult bindingResult) {
        if (bindingResult.hasFieldErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        CheckOrderResVo checkOrderResVo = null;
        try {
            checkOrderResVo = this.orderService.checkOrderWhetherRefund(checkOrderReqVo);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)checkOrderResVo);
    }
}

