/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.medical.core.controller;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.medical.api.OutReachApi;
import com.ebaiyihui.medical.core.exception.OutreachException;
import com.ebaiyihui.medical.core.service.BillService;
import com.ebaiyihui.medical.core.service.OrderService;
import com.ebaiyihui.medical.core.service.RefundService;
import com.ebaiyihui.medical.pojo.vo.DailyBillDetailItemsResVO;
import com.ebaiyihui.medical.pojo.vo.DailyBillDetailReqVO;
import com.ebaiyihui.medical.pojo.vo.OutreachRequest;
import com.ebaiyihui.medical.pojo.vo.OutreachResponse;
import com.ebaiyihui.medical.pojo.vo.QueryOrderReqVO;
import com.ebaiyihui.medical.pojo.vo.QueryOrderResVO;
import com.ebaiyihui.medical.pojo.vo.RefundReqVO;
import com.ebaiyihui.medical.pojo.vo.TotalDailyBillDetailResVO;
import com.ebaiyihui.medical.pojo.vo.TotalDailyBillReqVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5916\u8054api"})
public class OutReachController
implements OutReachApi {
    @Autowired
    private RefundService refundService;
    @Autowired
    private BillService billService;
    @Autowired
    private OrderService orderService;

    @ApiOperation(value="\u5411his\u5e73\u53f0\u63d0\u4f9b\u7684\u95e8\u8bca\u7f34\u8d39\u9000\u6b3e", notes="\u5411his\u5e73\u53f0\u63d0\u4f9b\u7684\u95e8\u8bca\u7f34\u8d39\u9000\u6b3e")
    public OutreachResponse<String> outpatientRefundForHis(@RequestBody OutreachRequest<RefundReqVO> refundRequest) {
        OutreachResponse refundResponse = null;
        try {
            refundResponse = this.refundService.outpatientRefundForHis(refundRequest);
        }
        catch (OutreachException e) {
            return OutreachResponse.error((String)e.getMessage());
        }
        return refundResponse;
    }

    @ApiOperation(value="\u5411his\u5e73\u53f0\u63d0\u4f9b\u7684\u4f4f\u9662\u9884\u7f34\u91d1\u9000\u6b3e", notes="\u5411his\u5e73\u53f0\u63d0\u4f9b\u7684\u4f4f\u9662\u9884\u7f34\u91d1\u9000\u6b3e")
    public OutreachResponse<String> inHospitalRefundForHis(@RequestBody OutreachRequest<RefundReqVO> refundRequest) {
        OutreachResponse refundResponse = null;
        try {
            refundResponse = this.refundService.inHospitalRefundForHis(refundRequest);
        }
        catch (OutreachException e) {
            return OutreachResponse.error((String)e.getMessage());
        }
        return refundResponse;
    }

    @ApiOperation(value="\u95e8\u8bcahis\u5e73\u53f0\u5bf9\u8d26\u6c47\u603b\u63a5\u53e3", notes="\u95e8\u8bcahis\u5e73\u53f0\u5bf9\u8d26\u6c47\u603b\u63a5\u53e3")
    public BaseResponse<TotalDailyBillDetailResVO> getOutPatientTotalDailyBill(@RequestBody TotalDailyBillReqVO req) {
        TotalDailyBillDetailResVO response = null;
        try {
            response = this.billService.getOutPatientTotalBill(req);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)response);
    }

    @ApiOperation(value="\u4f4f\u9662his\u5e73\u53f0\u5bf9\u8d26\u6c47\u603b\u63a5\u53e3", notes="\u4f4f\u9662his\u5e73\u53f0\u5bf9\u8d26\u6c47\u603b\u63a5\u53e3")
    public BaseResponse<TotalDailyBillDetailResVO> getInHospTotalDailyBill(@RequestBody TotalDailyBillReqVO req) {
        TotalDailyBillDetailResVO response = null;
        try {
            response = this.billService.getInHospTotalBill(req);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)response);
    }

    @ApiOperation(value="\u95e8\u8bcahis\u5e73\u53f0\u5bf9\u8d26\u660e\u7ec6\u63a5\u53e3", notes="\u95e8\u8bcahis\u5e73\u53f0\u5bf9\u8d26\u660e\u7ec6\u63a5\u53e3")
    public BaseResponse<List<DailyBillDetailItemsResVO>> getOutPatientDetailBill(@RequestBody DailyBillDetailReqVO req) {
        List response = null;
        try {
            response = this.billService.getOutPatientDetailBill(req);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)response);
    }

    @ApiOperation(value="\u4f4f\u9662his\u5e73\u53f0\u5bf9\u8d26\u660e\u7ec6\u63a5\u53e3", notes="\u4f4f\u9662his\u5e73\u53f0\u5bf9\u8d26\u660e\u7ec6\u63a5\u53e3")
    public BaseResponse<List<DailyBillDetailItemsResVO>> getInHospDetailBill(@RequestBody DailyBillDetailReqVO req) {
        List response = null;
        try {
            response = this.billService.getInHospDetailBill(req);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)response);
    }

    @ApiOperation(value="\u5411his\u5e73\u53f0\u63d0\u4f9b\u95e8\u8bca\u7f34\u8d39\u8ba2\u5355\u72b6\u6001\u4fe1\u606f")
    public OutreachResponse<QueryOrderResVO> outpatientOrderForHis(@RequestBody OutreachRequest<QueryOrderReqVO> orderRequest) {
        OutreachResponse orderResponse = null;
        try {
            orderResponse = this.orderService.outpatientOrderForHis(orderRequest);
        }
        catch (OutreachException e) {
            return OutreachResponse.error((String)e.getMessage());
        }
        return orderResponse;
    }

    @ApiOperation(value="\u5411his\u5e73\u53f0\u63d0\u4f9b\u4f4f\u9662\u9884\u4ea4\u91d1\u8ba2\u5355\u72b6\u6001\u4fe1\u606f")
    public OutreachResponse<QueryOrderResVO> inpatientDepositOrderForHis(@RequestBody OutreachRequest<QueryOrderReqVO> orderRequest) {
        OutreachResponse orderResponse = null;
        try {
            orderResponse = this.orderService.inPatientDepositOrderForHis(orderRequest);
        }
        catch (OutreachException e) {
            return OutreachResponse.error((String)e.getMessage());
        }
        return orderResponse;
    }
}

